PROGRAM SPELLUPD;  { SPELL CHECKER DICTIONARY UPDATE }
{
Update the file SPELLER.LIS (spelling dictionary) by adding words 
contained in an alphabetical file "filename.MIS".  SPELLUPD.COM and
SPELLER.LIS should be in the current directory. The prior file SPELLER.LIS
is renamed to SPELLER.LI$ and a new SPELLER.LIS is created.
}
TYPE
    FILES = text;
    WORDTYP = string[24];

VAR
    SRCNAME : string[36]; { DOS drive, path and filename of list to add.}
    I : integer;
    OLDWORD, UPWORD : WORDTYP;
    OLDSPELL, NEWSPELL, SPELLUP : FILES;
    OLDLAST : boolean;

PROCEDURE FINISH (var FILNAME : FILES);
{ GLOBAL file NEWSPELL is finished by adding the remaining
words from FILENAME after adding the word from global variable
OLDWORD.}

var
    WORD : string[16];

begin
    if OLDLAST then Writeln (NEWSPELL, UPWORD) else
       Writeln (NEWSPELL, OLDWORD);
    while not Eof (FILNAME) do begin
       Readln (FILNAME, WORD);
       Writeln (NEWSPELL, WORD);
    end;
end; { FINNISH }

begin {*************** MAIN PROGRAM *******************}

ClrScr;
if ParamCount = 0 then begin
    GotoXY (1,10);
    Writeln ('Enter the fully qualified name of the file');
    Writeln ('where the list of words to be added to SPELLER.LIS');
    Writeln ('is located (eg: d:path\name.MIS)');
    Writeln;
    Readln (SRCNAME);
    ClrScr;
    end
else SRCNAME := ParamStr (1);
GotoXY (10,12);
Write ('Opening file :  ');
GotoXY (26,12);
Write (SRCNAME);
Assign (SPELLUP, SRCNAME);
Reset (SPELLUP);
Assign (OLDSPELL, 'SPELLER.LI$');
{$I-} Erase (OLDSPELL) {$I+};
I := IOResult;
if (I<>1) and (I<>0) then begin
   writeln;
   writeln ('Something is wrong, I can''t write the new file.');
   writeln ('The disk is probably write protected or else the');
   writeln ('file SPELLER.LI$ is locked.');
   writeln ('I/O Error number is ',I,'.  Aborting.');
   exit;
   end;
Assign (OLDSPELL, 'SPELLER.LIS');
Rename (OLDSPELL, 'SPELLER.LI$');
GotoXY (26,12);
Write ('SPELLER.LI$                         ');
Reset (OLDSPELL);
GotoXY (26,12);
Write ('SPELLER.LIS                        ');
Assign (NEWSPELL, 'SPELLER.LIS');
ReWrite (NEWSPELL);
GotoXY (37,16);
Write ('UPDATING');
Readln (OLDSPELL, OLDWORD);
OLDLAST := false;
repeat
    if OLDLAST then Readln (OLDSPELL, OLDWORD)
       else Readln (SPELLUP, UPWORD);
    if OLDWORD < UPWORD then begin
       Writeln (NEWSPELL, OLDWORD);
       OLDLAST := true;
    end
    else begin
       if OLDWORD <> UPWORD then Writeln (NEWSPELL, UPWORD);
       OLDLAST := false;
    end;
until Eof (OLDSPELL) or (Eof (SPELLUP) and not OLDLAST);
if Eof (OLDSPELL) then FINISH (SPELLUP) else FINISH (OLDSPELL);
Close (NEWSPELL);
Close (SPELLUP);
Close (OLDSPELL);
End.  

