/* curses.c 4-20-86 GDM
This is a set of utility routines to accompany battle.c; it emulates
the ccurses calls that battle actually needs, plus whatever else
is missing in the MSDOS environment. 
See "curses" docs on Unix(tm) for detailed information; the general plan
is that there is a screen image buffer in memory which the caller modifies
as much as he likes via the supplied calls, then calls "refresh" which 
puts that buffer on the visible monitor.  Waiting til the refresh call
makes a lot more sense in the CPU/slow serial line/terminal environment, 
but it's certainly easy to emulate on the PC, and is quite fast anyway.
*/
/* COMPILE NOTE: with the Microsoft C compiler, the "/Ze" option is needed
to allow compilation of the "far" construct in the videocpy function. */

#include <stdio.h>

#define NEWLINE 0x0A
#define CR 0x0D
#define TAB 0x09
#define BELL 0x07
					/* DEF_ATTR is the default attribute
					byte value: foreground and background
					color, blink or not, inverse or not.
					0 is black-on-black,
					1 is blue on black,
					2 is green on black, etc. */
#define DEF_ATTR 2

int	cur_x=0;			/* current window x-value of cursor */
int	cur_y=0;			/* current window y-value of cursor */
int	cur_attr=0;			/* current attribute at cursor */
int	set_attr=0;			/* user-set attribute (in battle) */
					/* define screen size: Y is vertical*/
#define MAXY  25
					/* x is twice the actual column width
					becuz an attribute byte must be stored
					along with each printable character */
#define MAXX  160
					/* The screen buffer.  Equivalent to
					"curscr" in Unix curses. */
char	scr[MAXY][MAXX] = {0};

initscr()
{
					/* init screens routine: PC version
					only has one screen. */

					/* set attribute (color) either
					from user input or default value. */
	if (set_attr == 0) set_attr = DEF_ATTR;
	clear();			/* nothing else to do on PC */
}

ch_attr(val)
char	val;
{
					/* change current attribute */
	cur_attr = val;
}

resetattr()
{
					/* reset attribute to default */
	cur_attr = set_attr;
}

endwin()
{
					/* nothing useful to do in PC? */
	return;
}

clear()
{
					/* clear window */
	int xx,yy;
	
	cur_x = 0;
	cur_y = 0;
	cur_attr = set_attr;
					/* write zip into each cell to clear
					the screen - chars and attributes */
	for (xx = 0 ; xx < MAXX ; xx++) {
		for (yy = 0 ; yy < MAXY ; yy++) {
			scr[yy][xx] = 0;
		}
	}
}

echo()
{
					/* nothing useful to do in PC? */
	return;
}

noecho()
{
					/* nothing useful to do in PC? */
	return;
}

resetty()
{
					/* nothing useful to do in PC? */
	return;
}

savetty()
{
					/* nothing useful to do in PC? */
	return;
}

move(y,x)
int	y,x;
{
					/* move cursor to new position */
	cur_y = y;
	cur_x = x;
}

addch(ch)
char	ch;
{
					/* The basic add characters routine:
					add a char at the current position,
					and (I think) adjust the current
					position accordingly.  Also do
					the right thing for \n, \r, and \t.
					*/
	switch (ch) {
	case NEWLINE:
		if (cur_y < MAXY) {
			clrtoeol();		/* clear rest of this line */
			cur_y++;
			cur_x = 0;
		}
		break;
	case CR:
		cur_x = 0;		/* move to beginning of this line */
		break;
	case TAB:
		cur_x = ( (cur_x - 1) / 8 ) * 8 + 9;   /* magic tab formula */
		break;
	default:
					/* normal case - insert the char into
					screen buffer.  Note that each screen
					position is really a (text, attribute)
					pair, so each character store is 
					really two writes.  */
		scr[cur_y][ 2 * cur_x] = ch;
		scr[cur_y][ 2 * cur_x + 1] = cur_attr;
		if (2 * cur_x < MAXX) cur_x++;
		break;
	}
}


mvaddch(y, x, ch)
int	y,x;
char	ch;
{
					/* a composite function */
	move(y,x);
	addch(ch);
}

addstr(str)
char	*str;
{
					/* add a string at current position.
					Checking on border violations is
					done by addch. */
	while (*str) addch(*str++);
}


mvaddstr(y, x, str)
int	y,x;
char	*str;
{
					/* another composite function */
	move(y,x); 
	addstr(str);
}

clrtoeol()
{
					/* clear window to end-of-line */
					/* leave cursor at current position.
					(???) */
	int	xx;
	for (xx = 2 * cur_x ; xx < MAXX ; xx+=2) {
		scr[cur_y][xx] = 0;	/* clear text and attribute bytes */
	}
}

refresh()
{
					/* This routine makes the contents
					of the window we have been 
					manipulating all along appear on the
					screen.  Hacker alert: we do this
					by copying the screen buffer
					straight into video buffer memory
					which is at 0xB8000 in PC's. */
	videocpy(scr, MAXX*MAXY);
}

videocpy(src, n)
int	*src;
int	n;
{
#define VIDEOBASE 0xB8000000
	register int	far *p;
	register int	i;
	p = (int far *)VIDEOBASE;
	for (i=0 ; i < n ; i+=2) {
		*p++ = *src++;
	}
}
beep()
{
	putchar(BELL);
}
sleep(secs)
int	secs;
{
					/* routine to wait a few seconds */
	long	long_secs, start;

	long_secs = secs;
	start = time (0);
	while ( (time(0) - start) < long_secs) {};
}
