;
; The missing 'HELP' facility for ZCPRKPII
; 24 June 1983 
; Gary K. Berkheiser
; Ergo Software, Inc.
;
; This helps compensate for a lack of  on-line
; documentation that came with my copy of ZCPRKPII
; which was obtained via the Kaypro Users Group of N.J.
; My thanks guys, so here's a little bit in return.
;........................GKB
;
;
; My source of information for CP/M is:
;  "CP/M PROGRAMMER'S REFERENCE GUIDE"
;   revised edition, by Sol Libes,
;   Editor of 'MICROSYSTEMS'
;
; Information on ZCPR came from an article in the June 1983
; 'MICROSYSTEMS' pp 90-98
;		-and-
; 'DOCTOR DOBB'S JOURNAL' #81 July 1983, pp 86-90
;
;
;
;	equates
cr	equ	0dh		;carriage return
lf	equ	0ah		;linefeed
ctlz	equ	1ah		;control-z(clear screen)
ctrlc	equ	3		;control-c(exit)
;
;	bdos equates
;
bdos	equ	0005h		;address to call for access
conin	equ	1		;get a character from console
conout	equ	2		;display a character on the console
msgout	equ	9		;send string to console
const	equ	11		;console ready status
				;00=not rdy, ff=ready
;
;
	org	0100h		;start of it all
;
begin:	lxi	h,0		;save system sp
	dad	sp		;
	shld	oldsp		;saved
	lxi	sp,stack	;set our stack
	lxi	d,screen1	;bring up first screen
	mvi	c,msgout
	call	bdos
	call	getres		;wait for user done with this one
	lxi	d,screen2	;bring up the second screen
	mvi	c,msgout
	call	bdos
done:	lhld	oldsp		;restore cp/m stack
	sphl			;
	ret			;no reboot as no files used
; get user keystroke
; if its a control-c exit, otherwise return
;
getres:	mvi	c,const		;look for character ready
	call	bdos
	ora	a		;check result
	jz	getres		;loop on no character
	mvi	c,conin		;get input character
	call	bdos
	cpi	ctrlc		;is it abort character?
	jz	done		;exit if so
	ret			;return with character
;
;
; messages
;
screen1:	db	1ah	;screen clear
	db	'                             '
	db	'ZCPR BUILT-IN COMMANDS'
	db	'                   Page 1',cr,lf,cr,lf
	db	'DIR (d:)		Display files on selected '
	db	'drive.',cr,lf
	db	'DIR (d:)filename.typ	Search for named file '
	db	'on specified drive.',cr,lf
	db	'DIR (d:)*.typ		Display all files of '
	db	'"typ" on specified drive.',cr,lf
	db	'DIR (d:)filename.*	Display all types of '
	db	'"filename" on specified drive.',cr,lf,cr,lf
	db	'TYPE (d:)filename.typ	Display ascii file on '
	db	'console.',cr,lf
	db	'LIST (d:)filename.typ	Copy ascii file to '
	db	'listing device. No paging.',cr,lf,cr,lf
	db	'ERA (d:)filename.typ	Erase specified file.',cr,lf
	db	'ERA (d:)*.*		Erase all files on selected '
	db	'drive and current user.',cr,lf
	db	'ERA (d:)*.typ		Erase all files of "typ".'
	db	cr,lf
	db	'ERA (d:)filename.*	Erase all files of "filename".'
	db	cr,lf,cr,lf
	db	'REN (d:)newname.type=oldname.typ '
	db	'   Rename  a file.',cr,lf,cr,lf
	db	'SAVE n (d:)filename.typ'
	db	' Save "n" 256 byte pages of memory to disk.',cr,lf
	db	cr,lf
	db	'USER n			Change to a new user area. '
	db	'(n=0 to 15)',cr,lf
	db	'DFU n			Change default user.'
	db	' (n=0 to 15)',cr,lf,cr,lf
	db	'd:			Log in specified drive.',cr,lf
	db	'[more]$'
screen2:db	1ah,'                             '
	db	'ZCPR BUILT-IN COMMANDS                   '
	db	'Page 2',cr,lf,cr,lf
	db	'GO			Start program execution '
	db	'at 100H.',cr,lf,cr,lf
	db	'GET			Load a file anywhere in '
	db	'memory. Will not allow',cr,lf
	db	'                        overwrite of BDOS or BIOS.'
	db	cr,lf
	db	'JUMP xxxx		Start program execution '
	db	'at "xxxx" - address in HEX.',cr,lf,cr,lf
	db	'                              '
	db	'ADDITIONAL UTILITIES',cr,lf,cr,lf
	db	'FF			Send a formfeed to the '
	db	'listing device.',cr,lf
	db	'PRT96			Set OKI92 to print at '
	db	'12 cpi.',cr,lf
	db	'PRT144			Set OKI92 to print at '
	db	'17.5 cpi.',cr,lf
	db	'PRT80			Set OKI92 to print at '
	db	'10 cpi.',cr,lf,cr,lf
	db	'CLS			Clear KAYPRO II screen.'
	db	cr,lf,'$'
;
oldsp:	ds	2			;save stack
	ds	22			;our stack
stack:	ds	2
;
	end
