This is a simple modification to xmodem 7.4 that allows the sysop
to set the maximun file transmission time. (useful when an RCPM system
has very large .LBR files and users who try to download the entire 
.LBR rather than its members)


part 1 ------------------------------------------------------------------------
;
;=======================================================================
;
; Incidental equates
;
NOCOMS:	  EQU	TRUE	;TRUE, NO .COM FILES SENT
NOLBS:	  EQU	TRUE	;TRUE, NO .??# FILES SENT
NOCOMR:	  EQU	TRUE	;TRUE, CHANGE .COM TO .OBJ ON RECEIVE
;--->
maxmin:	  equ   50      ;maximum transmission time allowed
                        ;set to 0 if not wanted
;--->
;
MHZ: 	  EQU	6	;CLOCK SPEED, USE INTEGER (2,4,5,8, ETC.)
-------------------------------------------------------------------------------
-
-
part 2 ------------------------------------------------------------------------
OPENOK4:
	CALL	DECOUT		;PRINT DECIMAL NUMBER OF RECORDS
	CALL	ILPRT
;
	 IF	SHOWHEX		;IF TRUE SHOWS BOTH DECIMAL AND HEX
	DB	' (',0
	CALL	DHXOUT
	CALL	ILPRT
	DB	'H)'
	 ENDIF
;
	DB	' records',CR,LF
	DB	'Send time: ',0
	CALL	SPEED		;GET SPEED INDICATOR
	LXI	D,0
	MOV	E,A		;SET UP FOR TABLE ACCESS
	LXI	H,BTABLE	;POINT TO BAUD FACTOR TABLE
	DAD	D		;INDEX TO PROPER FACTOR
	MOV	A,M		;FACTOR IN 'A'
	LHLD	RCNT		;GET NUMBER OF RECORDS
	CALL	DIVHLA		;DIVIDE HL BY VALUE IN A (RECORDS/MIN)
	PUSH	H
;
	 IF	LOGCAL
	SHLD	PGSIZE
	 ENDIF
;	
	MVI	H,0
;--->
	if	maxmin
	mov	a,l
	sta	minute
	endif	;maxmin
;--->
	CALL	DECOUT		;PRINT DECIMAL NUMBER OF MINUTES
	CALL	ILPRT
	DB	' mins, ',0
	LXI	H,RECTBL	;POINT TO DIVISORS FOR SECONDS CALC.
	LXI	D,0
	CALL	SPEED		;GET SPEED INDICATOR
	MOV	E,A
	DAD	D		;INDEX INTO TABLE
	MOV	A,M		;GET MULTIPLIER
	POP	H		;GET REMAINDER
	CALL	MULHA		;MULTIPLY 'H' BY 'A'
	CALL	SHFTHL
	CALL	SHFTHL
	CALL	SHFTHL
	CALL	SHFTHL
	MVI	H,0
	CALL	DECOUT		;PRINT THE SECONDS PORTION
	CALL	ILPRT
	DB	' secs at ',0
	LXI	H,SPTBL		;START OF BAUD RATE SPEEDS
	MVI	D,0		;ZERO THE 'D' REGISTER
	CALL	SPEED		;GET SPEED INDICATOR
	ADD	A		;INDEX INTO THE BAUD RATE TABLE
	ADD	A
	MOV	E,A		;NOW HAVE THE INDEX FACTOR IN 'DE'
	DAD	D		;ADD TO 'HL'
	XCHG			;PUT ADDRESS IN 'DE' REGS.
	MVI	C,PRINT		;SHOW THE BAUD
	CALL	BDOS
	CALL	ILPRT
	DB	' baud',CR,LF,0
;
;--->	if	maxmin
	lda	minute		; get minute counter
	cpi	maxmin		; compare to max time
	jz	openok5		; if equal to max
	jnc	overtm		; if exceeded max

openok5:
;--->	endif	;maxmin
	CALL	ILPRT
	DB	'To cancel: use CTL-X',CR,LF,0
	RET
;
;--->	if	maxmin
overtm:	call	erxit
	db	'++ Send time exceeds maximum allowed ++',13,10
	db	'++ XMODEM ABORTED ++',13,10,'$'
;--->	endif	;maxmin
-------------------------------------------------------------------------------
-
-
part 3 ------------------------------------------------------------------------
;
; Temporary storage area
;
;--->
minute:	db	0
;--->
MEMFCB: DB	'                '  ;LIBRARY NAME (16 BYTES REQUIRED)
CONONL:	DB	0		;CTYPE CONSOLE-ONLY FLAG
CRCFLG:	DB	0		;SETS TO 'C' IF CHECKSUM REQUESTED
CRCVAL:	DB	0,0		;CURRENT CRC VALUE
-------------------------------------------------------------------------------
