;
; GO: Autility command under CP/M by Anthony Skjellum
;
; September 14, 1979
;
;
; This command performs the following function:
;
;  GO (hex address) executes the address specified
;
;
;
	org	100h	;tpa start
;
tbuff	equ	80h
fcb	equ	5ch
;
;
	lxi	d,0	; initial hex value to zero
	lxi	h,fcb+1	; point to fcb created by
			; the CCP (i.e. has hex address)
;
;
	mvi	b,4	; digit count
go:	mov	a,m	; get digit
	cpi	20h	; check for space
	jnz	go1	; if not then use data fetched
	mvi	a,30h	; equate a space with an entry of zero
go1:	call	hexin	; accumulate value
	rc		; return to CCP if error
	inx	h	; look at next location
	dcr	b	; decrement digit count
	jnz	go	; if non-zero then continue
	xchg		; get address value in HL
	pchl		; after accumulation, execute address
;
;
; support routines:
;
hexin:	xchg
	call	check
	rc
	dad	h
	dad	h
	dad	h
	dad	h
	ora	l
	mov	l,a
	xchg
	ret
;
;
;
check:	sui	30h	; check for valid hex digit
			; return with carry set if invalid
	rc
	cpi	0Ah
	cmc
	rnc
	sui	7H
	cpi	0AH
	rc
	cpi	10H
	cmc
	ret
;
;
;
;
	end
