;***********************************
;*                                 *
;* AUTOLOAD.ASM BY JAMES UNDERWOD  *
;*            (N6CFI)              *
;*                                 *
;*            11/4/81              *
;*                                 *
;***********************************
;
; This file allows you to execute any
; command upon cold boot of CP/M.
; 
; This is very handy if you have have
; to execute a system initalization
; program every time you bring the system
; up.  This is accomplished by using
; the fact that if there is text in
; the CCP's buffer upon cold boot, that
; text is executed as a command.
;
; Note: this patch is independent of
;       memory size, and only needs to
;       be changed if your CP/M memory
;       image (for a sysgen) starts at
;       other than the standard 0980H
;       Put your auto-command in the
;       TEXT db.  The length is auto-
;       maticaly computed.
;
;
IMAGE   EQU     0980H           ;Start of CP/M memory image
;
        ORG     IMAGE+7         ;Origin is start of buffer-1
;
LENGTH  DB      CRIGHT-TEXT     ;This is the number of
                                ;characters in your autoload command
;
TEXT    DB      'your command goes here'
;
LINEND  DB      0       ;This 0 terminates your command
;
; Here is the copyright notice that is normaly in the buffer,
; it is in this db so that your command does not overwrite it.
;
CRIGHT  DB      '       COPYRIGHT (C) 1979, DIGITAL RESEARCH '
;
; The inclusion of the copyright notice will have no effect on the
; autoload command, and is required by your software license agreement.
;
; The length of your command can be up to 128 bytes less that taken by
; the copyright notice; or about 83 characters.  If you need a little
; more space, you can remove the leading and  trailing spaces from the
; copyright notice (8 total).
;
; To impliment, simply assemble this file with ASM.  After you have
; created your new system image with DDT, just read in the hex file
; with no offset.  It will correctly locate itself into the CCP.
;
; WARNING:
;
; One of the first things your autoload program MUST do is reset
; the length value to zero.  If this is not done, then CP/M can
; go into an infinite loop.  Here is a short set of 6 instructions
; that are independent of memory size, which will accomplish this.
; It is strongly reccomended that they be put in your initalization
; program.
;
;       ORG     0100h
;
;       LHLD    1       ;load BIOS entry point into HL
;       MOV     A,H     ;move top 8 bits to A reg.
;       SBI     16h     ;sub 16h so that we now point to ccp
;       MOV     H,A     ;restore to H reg.
;       MVI     L,7     ;point to length of buffer
;       MVI     M,0     ;turn off auto boot
;
; NOTE: if your BIOS is at a non-standard offset from the ccp,
; use the start of the ccp (as given in the documentation you
; recieved with your system) and add 7 to it to obtain the
; location of the length db that needs to be reset.
;
;
; If you want to do it the easy way, a command of 'BASIC SYSINI'
; is totaly acceptable as long as the program 'SYSINI.BAS'
; contains a poke instruction to reset the length db, like this,
;
; POKE (CCP+7),0
;
;
; This has only been tested with CP/M 2.2, but should work on all 2.X
; and proabably on 1.4 also.
;
;
        END
