; Display cpm memory locations
;
	org	100h
	mvi	c,12		;check 1.4 or 2.2
	call	5
	mov	a,l
	ora	a
	lxi	h,3328-6	;length of 1.4 bdos
	jz	mmp1		;if version 1.4
;
	lxi	h,3584-6	;length of 2.2 bdos
	mvi	a,'2'		;change message
	sta	mmpk
	sta	mmpk+2
mmp1:	shld	mmpa
;
	lhld	6		;get bdos entry address
	shld	bdose
	lxi	b,-806h		;calculate ccp fwa
	dad	b
	shld	ccpfwa
;
	dcx	h		;calculate tpa lwa
	shld	tpalwa
	inx	h
;
	lxi	b,800h		;calculate bdos fwa
	dad	b
	shld	bdfwa
	lxi	b,6		;calculate bdos entry address
	dad	b
	shld	bdose
;
	lxi	b,0		;calculate cbios fwa
mmpa:	equ	$-2
	dad	b
	shld	cbfwa
;
	lxi	b,3		;calculate cbios "warmboot" entry 
	dad	b
	shld	wrmbt
;
; display memory locations
;
	lxi	d,mmpb		;display line of dashes
	call	msg
	lxi	d,mmpj		;display system version number
	call	msg
	lxi	d,mmpc		;"warmboot", etc.
	call	msg
;
	lxi	h,0		;display tpa lwa
tpalwa	equ	$-2
	call	dhw
	lxi	d,mmpd
	call	msg
;
	lxi	h,0		;display ccp fwa
ccpfwa	equ	$-2
	call	dhw
	lxi	d,mmpe
	call	msg
;
	lxi	h,0		;display bdos fwa
bdfwa	equ	$-2
	call	dhw
	lxi	d,mmpf
	call	msg
;
	lxi	h,0		;display bdos entry address
bdose	equ	$-2
	call	dhw
	lxi	d,mmpg
	call	msg
;
	lxi	h,0		;display cbios fwa
cbfwa	equ	$-2
	call	dhw
	lxi	d,mmph
	call	msg
;
	lxi	h,0		;display cbios warmboot entry
wrmbt	equ	$-2
	call	dhw
	lxi	d,mmpi
	call	msg
;
	lxi	d,mmpb		;display a line of dashes
	call	msg
	jmp	0000		;exit
;
cr	equ	0dh
lf	equ	0ah
;
mmpb:	db	cr,lf,'---------------------------------------'
	db	cr,lf,'$'
mmpc:	db	'0000 "warmboot" vector',cr,lf
	db	'0005 BDOS vector',cr,lf
	db	'005C default file control block (FCB)',cr,lf
	db	'0080 CP/M record buffer',cr,lf
	db	'0100 first word address (fwa) of user area',cr,lf,'$'
mmpd:	db	' last word address (lwa) of user area',cr,lf,'$'
mmpe:	db	' CCP fwa',cr,lf,'$'
mmpf:	db	' BDOS fwa',cr,lf,'$'
mmpg:	db	' BDOS entry point',cr,lf,'$'
mmph:	db	' CBIOS fwa',cr,lf,'$'
mmpi:	db	' CBIOS warmboot entry point',cr,lf,'$'
mmpj: 	db	'System:   CP/M version '
mmpk:	db	'1.4',cr,lf,'$'
;
msg:	mvi	c,9
	call	5
	ret
;
; display hex word
;
; hl= word to display
;
dhw:	push	h
	mov	a,h
	call	dhb
	pop	h
	mov	a,l
;
; display hex byte in a
;
dhb:	push	psw
	rrc !rrc !rrc !rrc
	call	dhd
	pop	psw
;
; display hex digit
;
; digit in a.low
;
dhd:	ani	0fh
	cpi	10
	jnc	dhd1
	adi	'0'
	jmp	dch
;
dhd1:	adi	'A'-10
;
; display one character
;
; a= character
;
dch:	mov	e,a
	mvi	c,2
	call	5
	ret
;
	end
;
