PROGRAM Weed;  { V 2.0 }

{
  Ŀ
    Pinnacle  Software's  File  Cleaner-Upper  Program         WEED       
  Ĵ
    C O P Y R I G H T  (C)  1989  BY   P I N N A C L E    S O F T W A R E  
    P.O. Box  386, Town of Mount Royal, Montreal, Quebec, Canada  H3P 3C6  
  Ĵ
    Permission is  hereby given to distribute this Pinnacle product, pro-  
    vided that  it is distributed in its  complete  and  unaltered  form,  
    including all  programs, text and data.                                
  

  PROGRAM PURPOSE:  Keep or delete, from text files, lines with given text.

}

USES CRT;  { Tested under Turbo Pascal V4.00 }

CONST
  MaxDelText = 100;  { Heck, it's only 25K }

TYPE
  String80  =  STRING[80];
  InRecord  =  STRING[255];
  OtRecord  =  STRING[255];

VAR
  Casing      : CHAR;
  CompData    : InRecord;
  DelCount    : INTEGER;
  DelText     : ARRAY[1..MaxDelText] OF InRecord;
  Finished    : BOOLEAN;
  InChar      : CHAR;
  InData      : InRecord;
  InFileName  : String80;
  InFile      : TEXT;
  Method      : CHAR;
  OutData     : OtRecord;
  OutFile     : TEXT;
  OutFileName : String80;

PROCEDURE TextInverseOn;
BEGIN TEXTCOLOR(BLACK); TEXTBACKGROUND(LIGHTGRAY); END;

PROCEDURE TextInverseOff;
BEGIN TEXTCOLOR(CYAN); TEXTBACKGROUND(BLACK); END;

PROCEDURE Ce(LineIn : String80);
BEGIN GOTOXY(TRUNC((80-LENGTH(LineIn))/2),WHEREY); WRITE(LineIn); END;

PROCEDURE CeLn(LineIn : String80);
BEGIN GOTOXY(TRUNC((80-LENGTH(LineIn))/2),WHEREY); WRITELN(LineIn); END;

FUNCTION Upper(UStr : String80) : String80;
VAR
  UCntr : INTEGER;
BEGIN
  FOR UCntr := 1 TO LENGTH(UStr) DO UStr[UCntr] := UPCASE(UStr[UCntr]);
  Upper := UStr;
END; { Function Upper }

PROCEDURE StartUp;
BEGIN
  Finished := FALSE;
END;

PROCEDURE Pinnacle;
BEGIN
  CLRSCR;
  TextInverseOff;
  WRITELN('۲۲۲۲۲۲۲');
  TextInverseOn;
  WRITELN('ͻ  ͻ  ͻ  ͻ ͻ    ͻ   ͻ ͻ ͻ ͻ     ͻ ͻ ͻ');
  WRITELN('ͼ        ͹             ͻ               ͹ ˼   ');
  WRITELN('      ͼ  ͼ   ͼ ͼ ͼ   ͼ ͼ          ͼ    ȼ ͼ');
  WRITELN('Post Office Box 386,  Town of Mount Royal,  Montreal, Quebec,  Canada,  H3P 3C6');
  TextInverseOff;
  WRITELN('۲۲۲۲۲۲۲');
  WRITELN; WRITELN;
  TextInverseOn;
  CeLn('               ');
  CeLn('  FILE WEEDER  ');
  CeLn('  Version 2.0  ');
  CeLn('               ');
  TEXTCOLOR(LIGHTGRAY); TEXTBACKGROUND(BLACK);
  WINDOW(1,15,80,25);
END; { Procedure PINNACLE }

PROCEDURE OpenFiles;
VAR
  InOkay   : BOOLEAN;
  OutOkay  : BOOLEAN;
BEGIN
  InOkay  := FALSE;
  OutOkay := FALSE;
  REPEAT
    Pinnacle;
    CeLn(' ESC to Quit ');
    WRITELN;
    CeLn('Press  D  to  delete  lines containing specified text');
    WRITELN;
    CeLn('Press  C  to   copy   lines containing specified text');
    WRITELN;
    WRITELN;
    Ce('');
    Method := UPCASE(READKEY);
  UNTIL Method IN [#27, 'D', 'C'];
  CLRSCR;
  IF Method = #27 THEN HALT;
  REPEAT
    WRITELN;
    CeLn(' ESC to Quit ');
    WRITELN;
    CeLn('Press  Y  if the text must match exactly (i.e. "CAT" doesn''t match "cat")');
    WRITELN;
    CeLn('Press  N  if the text doesn''t have to match exactly  (i.e. "CAT" = "cat")');
    WRITELN;
    WRITELN;
    Ce('');
    Casing := UPCASE(READKEY);
  UNTIL Casing IN [#27, 'Y', 'N'];
  CLRSCR;
  IF Casing = #27 THEN HALT;
  WRITELN; WRITELN;
  {$I-}
  REPEAT
    WRITELN;
    WRITE('Enter the  Input  file name ..... ');
    READLN(InFileName);
    IF LENGTH(InFileName) = 0
    THEN Finished := TRUE
    ELSE
    BEGIN
      InFileName := Upper(InFileName);
      ASSIGN(InFile,InFileName);
      RESET(InFile);
      IF IOresult = 0
      THEN InOkay := TRUE
      ELSE
      BEGIN
        WRITELN;
        WRITELN(InFileName,' can not be found.');
      END;
    END;
  UNTIL InOkay OR Finished;
  IF InOkay AND (NOT Finished) THEN
  REPEAT
    WRITELN;
    WRITE('Enter the  Output file name ..... ');
    READLN(OutFileName);
    IF LENGTH(OutFileName) = 0
    THEN Finished := TRUE
    ELSE
    BEGIN
      OutFileName := Upper(OutFileName);
      ASSIGN(OutFile,OutFileName);
      RESET(OutFile);
      IF IOresult > 0
      THEN
      BEGIN
        REWRITE(OutFile);
        OutOkay := TRUE;
      END
      ELSE
      BEGIN
        WRITELN;
        WRITE(OutFileName,' already exists.  Use it?  (Press Y or N)  ');
        InChar := READKEY;
        InChar := UPCASE(InChar);
        IF InChar = 'Y' THEN
        BEGIN
          OutOkay := TRUE;
          REWRITE(OutFile);
        END;
      END;
    END;
  UNTIL OutOkay OR Finished;
  {$I+}
END;

PROCEDURE GetDelText;
BEGIN
  CLRSCR;
  WRITELN('You can specify up to ',MaxDelText,' bits of text.');
  WRITE  ('Lines containing that ');
  IF Casing = 'Y' THEN WRITE('precise ');
  WRITE('text will be ');
  IF Method = 'C'
  THEN WRITELN('copied.')
  ELSE WRITELN('deleted.');
  WRITELN;
  WRITELN('Enter an empty line to start processing.');
  WRITELN;
  DelCount := 0;
  REPEAT
    DelCount := DelCount + 1;
    WRITE('#',DelCount,' >  ');
    READLN(DelText[DelCount]);
    IF Casing = 'N' THEN DelText[DelCount] := Upper(DelText[DelCount]);
  UNTIL (DelCount = MaxDelText) OR (DelText[DelCount] = '');
  IF DelText[DelCount] = '' THEN DelCount := DelCount - 1;
  CLRSCR;
  IF DelCount = 0 THEN HALT;
END;

PROCEDURE WeedOut;
VAR
  Counter  : INTEGER;
  DelTally : INTEGER;
  DTCntr   : INTEGER;
  FoundIt  : BOOLEAN;
BEGIN
  Counter := 0;
  DelTally := 0;
  WINDOW(1,1,80,25);
  TEXTCOLOR(WHITE); TEXTBACKGROUND(BLACK);
  GOTOXY(1,1);
  CLRSCR;
  WRITE('Press the spacebar to abort ');
  IF Method = 'D'
  THEN WRITELN('weeding.')
  ELSE WRITELN('copying.');
  WRITELN;
  REPEAT
    READLN(InFile,InData);
    IF Casing = 'N'
    THEN CompData := Upper(InData)
    ELSE CompData := InData;
    Counter := Counter + 1;
    IF Counter DIV 100 * 100 = Counter THEN WRITE(' ',Counter,' lines',^M);
    DTCntr := 0;
    FoundIt := FALSE;
    REPEAT
      DTCntr := DTCntr + 1;
      IF POS(DelText[DTCntr],CompData) > 0 THEN FoundIt := TRUE;
    UNTIL FoundIt OR (DTCntr = DelCount);
    IF Method = 'D' THEN
    BEGIN
      IF FoundIt
      THEN DelTally := DelTally + 1
      ELSE WRITELN(OutFile,InData);
    END
    ELSE
    BEGIN
      IF FoundIt
      THEN
      BEGIN
        WRITELN(OutFile,InData);
        DelTally := DelTally + 1;
      END;
    END;
    IF KEYPRESSED THEN
    BEGIN
      WRITELN; WRITELN;
      WRITE('Stop?  (Press Y or N)  ');
      InChar := UPCASE(READKEY);
      WRITELN; WRITELN;
      IF InChar = 'Y' THEN Finished := TRUE;
    END;
  UNTIL EOF(InFile) OR Finished;
  CLRSCR;
  WRITELN;
  WRITELN;
  WRITELN;
  WRITE(Counter,' lines read.  ',DelTally,' lines ');
  IF Method = 'D'
  THEN WRITELN('deleted.')
  ELSE WRITELN('copied.');
END;

PROCEDURE CloseFiles;
BEGIN
  CLOSE(InFile);
  CLOSE(OutFile);
END;

BEGIN
  StartUp;
  OpenFiles;
  IF NOT Finished THEN
  BEGIN
    GetDelText;
    WeedOut;
    CloseFiles;
  END;
END.
