#include <stdio.h>
#define CHDIR	0x3b
#define RMDIR	0x3a
#define MKDIR	0x39
int cd(argc,argv)
char *argv[];
{
	static char *usage = "usage : cd newdir\r\n";
	if (argc == 1)
		write(2,usage,strlen(usage));
	return dirfunc("chdir",*(++argv),CHDIR);
}

int md(argc,argv)
	char *argv[];
{
	static char *usage = "usage : md newdir\r\n";

	if (argc == 1)
		write(2,usage,strlen(usage));
	return dirfunc("mkdir",*(++argv),MKDIR);
}

int rd(argc,argv)
char *argv[];
{
	static char *usage = "usage : rmdir directory";
	if (argc == 1)
		write(2,usage,strlen(usage));
	return dirfunc("rmdir",*(++argv),RMDIR);
}

static int dirfunc(name,string,function)
char *name, *string;
{
	struct { int ax,bx,cx,dx,si,di,ds,es; } regs;
	extern int _dsval;
#define CARRY 1
	regs.ax = (int)((unsigned)function << 8);
	regs.dx = (int)string;
	regs.ds = _dsval;
	if(sysint(0x21,&regs,&regs) & CARRY)
	{
		print_error(name,regs.ax);
		return -1;
	}
	return 0;
}

static char *dirstack[10];
static int dsp = -1;

int pushd(argc,argv)
char *argv[];
{
	char *getcwd(), *savestr();
	static char *usage = "usage : pushd newdir";
	static char *pusherr = "pushd : dir stack overflow";
	char dirbuf[64];
	if (argc == 1)
	{
		write(2,usage,strlen(usage));
		crlf();
		return -1;
	}
	if (NULL ==  getcwd(&dirbuf[1],64))
	{
		perror("pushd");
		return -1;
	}
	if (++dsp == 10)
	{
		write(2,pusherr,strlen(pusherr));
		crlf();
		return -1;
	}
	dirbuf[0] = '\\';
	if (-1 == dirfunc("pushd",*(++argv),CHDIR))
	{
		--dsp;
		return -1;
	}
	dirstack[dsp] = savestr(dirbuf);
	return 0;
}

int popd()
{
	register int returnval = 0;
	static char *poperr = "popd : dir stack underflow";
	if (dsp == -1)
	{
		write(2,poperr,strlen(poperr));
		crlf();
		return -1;
	}
	if (-1 == dirfunc("popd",dirstack[dsp],CHDIR))
	{
		returnval = -1;
	}
	free(dirstack[dsp--]);
	return returnval;
}
