
               (* ******************************* *)
               (*                                 *)
               (*       NewFonts.pas Demo2        *)
               (*                                 *)
               (*  This Demo Shows You How to Use *)
               (*  Font Files That Have Been Con- *)
               (*  verted to Include Files That   *)
               (*  can be Included Directly into  *)
               (*  Your Code.                     *)
               (*                                 *)
               (*  (c) Donald L. Pavia            *)
               (*  Department of Chemistry        *)
               (*  Western Washington University  *)
               (*  Bellingham, WA    98225        *)
               (*                                 *)
               (*              February 1, 1986   *)
               (*                                 *)
               (* ******************************* *)


program FontDemo;

{$I HIASCII.INC}
{$I CHEMMATH.INC}

var  i,j,k,m : integer;

{----------------------------------------------------------------------------}
procedure ChemMathFonts;

begin
     memw[$0000:$007E] := seg(ChemMath);
     memw[$0000:$007C] := ofs(ChemMath);

end; { procedure ChangeFont }
{----------------------------------------------------------------------------}
procedure HiAsciiFonts;

begin
     memw[$0000:$007E] := seg(HiAscii);
     memw[$0000:$007C] := ofs(HiAscii);

end; { procedure HiAscii }
{----------------------------------------------------------------------------}

BEGIN

     (* *********************** MED RES MODE *************************** *)

     GraphColorMode; GraphBackGround (1); Palette (0);

     ChemMathFonts;

     TextColor (1);
     gotoxy (5,2);   write ('CH',#133,'CH',#132,'CO',#132,'H');
     TextColor (2);
     gotoxy (10,5);  write ('x',#143,' + y',#146,' = z',#142);
     TextColor (3);
     gotoxy (15,8);  write ('Na',#150,' HCO',#133,#151);

     HiAsciiFonts;

     TextColor (1); i := 11; m := 0;
     for j := 1 to 4 do begin
         gotoxy (1,i); for K := 0 to 35 do
         if ((128+k+m) < 256) then write (chr(128 + k + m));
         i := i + 2; m := m + 36;
     end;

     ChemMathFonts;

     TextColor (3);
     gotoxy (5,20); write ('CH',#133,'CH',#132,'(CH',#132,')',#138,'COOH');
     TextColor (2);
     gotoxy (10,22); write ('x',#142,' + y',#142,' = a',#143,' x b',#144);

     TextColor (1);
     gotoxy (25,25); write ('Press Enter');
     readln;

     (* ************************ HI RES MODE *************************** *)

     HiRes; HiResColor (1);                 { still redefined fonts }

     gotoxy (1,7); write ('CH',#133,'CH',#132,'(CH',#132,')',#138,'COOH');

     HiAsciiFonts;

     i := 12; m := 0;
     for j := 1 to 2 do begin
          gotoxy (1,i); for k := 0 to 71 do
          if ((128+k+m) < 256) then write (chr(128+k+m));
          i := i + 2; M := m + 72;
     end;

     ChemMathFonts;

     gotoxy (25,20); write ('x',#142,' + y',#142,' = a',#143,' x b',#144);

     HiAsciiFonts;

     gotoxy (50,25); write ('Press <ENTER> to Continue');
     readln; TextMode (c80);
END.
