
#define	XORG		8
#define	YORG		23
#define	XMAX		639
#define	YMAX		318

#define	MAXCOLOR	5
#define	MAXPATTCOLOR	10
#define	MAXPATTERN	3	
#define	MAXWALLS	10
#define	MAXBUGS		10
#define	MAXPITS		10
#define	MAXTELEPORTS	6
#define	MAXGOODIES	20
#define	MAXOBJECTS	MAXPITS+MAXTELEPORTS+MAXGOODIES

#define	MAXDIS		9
#define	BUGJMP		4
#define	MANJMP		4
#define	SHOTJMP		8

#define	MICROBEEP	2
#define	SHORTBEEP	4
#define	MEDIUMBEEP	6


/****************************************************************
 * IF IF IF IF IF IF IF IF IF IF IF IF IF IF IF IF IF IF IF IF 	*
 ****************************************************************/

#ifdef	INMAIN

/****************************************************************
 * GLOBAL static variables					*
 ****************************************************************/

struct	hightype {
	long	score;
	char	name[12];
	} highlist[64];

int	tagcount;
int	tagflg;

int	curscreen;
int	dead;

int	beep_dead[] = {
		10000, 18,
		0,0
	};

int	beep_ill_key[] = {
		10000, 1,
		 8000, 1,
		 6000, 1,
		    0,0
	};

int	beep_lock[] = {
		15000,1,
		12000,1,
		 9000,1,
		 7000,1,
		 3000,1,
		 1000,1,
		  300,1,
		  100,1,
		  0,0
	};

int	beep_tag[] = {
		500,1,
		8000,1,
		750,1,
		8000,1,
		1000,1,
		0,0
	};

int	beep_click[] = {
		1000,1,
		8000,1,
		0,0
	};

int	beep_goodies[] = {
		5000,1,
		10000,1,
		4000,1,
		1000,1,
		500,1,
		0,0
	};

int	beep_kill[] = {
		500,1,
		0,0
	};

int	beep_teleport[] = {
		2000,4,
		200,1,
		0,0
	};

struct	pltype {
	int	x;
	int	y;
	} pitlist[MAXPITS];

int	okbugmake = 0;
int	bugmaketime = 256;

long	score = 0;
int	score_color = 3;
int	scorex;
int	scorey = YMAX+19;
int	scoreflg = 1;
char	scorebuf[32] = "";
int	scoreptr = 0;
long	highscore = 0L;
long	sscore = 0L;

long	points = 0;
int	point_color = 3;
int	pointx;
int	pointflg = 1;
char	pointbuf[32] = "";
int	pointptr = 0;

unsigned char	keys[128] = {
		0,0,0,192,0,48,0,48,1,224,0,192,0,128,0,128,
		0,224,0,128,0,192,0,128,0,0,0,240,0,128,0,0,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0,0,3,192,12,48,12,48,7,224,3,192,1,128,1,128,
		1,224,1,128,1,192,1,128,1,240,1,240,1,128,0,0,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	};

unsigned char	keylock[128] = {
		120,30,243,207,231,231,207,243,207,243,207,243,199,227,195,195,
		231,231,231,231,207,243,207,243,223,251,223,251,192,3,127,254,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		119,238,239,247,220,59,184,29,184,29,184,29,188,61,190,125,
		220,59,220,59,184,29,184,29,176,13,191,253,191,253,127,254,
		0,0,0,0,3,192,7,224,7,224,7,224,3,192,1,128,
		3,192,3,192,7,224,7,224,15,240,0,0,0,0,0,0
	};

unsigned char	teleport[128] = {
		128,1,128,1,192,3,132,33,160,5,129,129,145,137,129,129,
		137,145,132,33,135,225,64,2,32,4,16,8,8,16,7,224,
		128,1,0,0,64,2,68,34,100,38,69,162,85,170,85,170,
		93,186,83,202,80,10,40,20,23,232,8,16,7,224,0,0,
		128,1,0,0,64,2,4,32,36,36,37,164,53,172,37,164,
		45,180,47,244,47,244,23,232,8,16,7,224,0,0,0,0,
		128,1,128,1,192,3,196,35,228,39,229,167,245,175,229,167,
		237,183,224,7,224,7,112,14,56,28,31,248,15,240,7,224

/*	{
		0,0,0,96,0,111,0,8,0,224,1,128,3,0,6,0,
		12,0,24,0,48,0,48,0,32,0,96,0,96,0,96,0,
		0,0,5,0,42,128,21,0,42,0,84,0,40,0,80,0,
		32,0,64,0,0,0,64,0,0,0,0,0,0,0,0,0,
		0,0,0,4,0,15,0,8,0,226,1,132,3,5,6,6,
		12,9,24,16,48,33,48,66,32,130,97,197,102,56,120,0,
		31,255,122,255,85,112,234,240,213,0,170,0,212,0,168,0,
		208,0,160,0,192,0,128,0,192,0,128,0,128,0,128,0
	},{
		0,0,6,0,246,0,16,0,7,0,1,128,0,192,0,96,
		0,48,0,24,0,12,0,12,0,4,0,6,0,6,0,6,
		0,0,0,160,1,84,0,168,0,84,0,42,0,20,0,10,
		0,4,0,2,0,0,0,2,0,0,0,0,0,0,0,0,
		0,0,32,0,240,0,16,0,71,0,33,128,160,192,96,96,
		144,48,8,24,132,12,66,12,65,4,163,134,28,102,0,30,
		255,248,255,94,14,170,15,87,0,171,0,85,0,43,0,21,
		0,11,0,5,0,3,0,1,0,3,0,1,0,1,0,1
	},{
		96,0,96,0,96,0,32,0,48,0,48,0,24,0,12,0,
		6,0,3,0,1,128,0,224,0,8,0,111,0,96,0,0,
		0,0,0,0,0,0,0,0,64,0,0,0,64,0,32,0,
		80,0,40,0,84,0,42,0,21,0,42,128,5,0,0,0,
		120,0,102,56,97,197,32,130,48,66,48,33,24,16,12,9,
		6,6,3,5,1,132,0,226,0,8,0,15,0,4,0,0,
		128,0,128,0,128,0,192,0,128,0,192,0,160,0,208,0,
		168,0,212,0,170,0,213,0,234,240,85,112,122,255,31,255
	},{
		0,6,0,6,0,6,0,4,0,12,0,12,0,24,0,48,
		0,96,0,192,1,128,7,0,16,0,246,0,6,0,0,0,
		0,0,0,0,0,0,0,0,0,2,0,0,0,2,0,4,
		0,10,0,20,0,42,0,84,0,168,1,84,0,160,0,0,
		0,30,28,102,163,134,65,4,66,12,132,12,8,24,144,48,
		96,96,160,192,33,128,71,0,16,0,240,0,32,0,0,0,
		0,1,0,1,0,1,0,3,0,1,0,3,0,5,0,11,
		0,21,0,43,0,85,0,171,15,87,14,170,255,94,255,248
	}
*/
   };

unsigned char	bang[4][128] = {
	{
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,0,0,7,128,7,128,
		7,128,7,128,0,0,0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,
		3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	},{
		0,0,0,0,0,0,0,0,16,64,0,0,0,4,0,0,
		0,0,34,0,0,0,0,0,0,128,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,5,0,4,128,11,32,
		5,0,4,64,1,0,0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,16,64,4,0,0,132,10,0,
		1,0,38,64,0,0,0,0,0,128,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	},{
		0,0,0,0,1,0,36,0,0,16,64,0,0,8,32,0,
		0,0,32,64,2,0,16,64,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,15,64,24,192,8,96,20,64,
		8,80,15,32,0,0,0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,1,0,36,0,6,16,72,128,8,72,36,64,
		0,64,37,64,2,0,16,64,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	},{
		0,0,0,0,32,8,1,0,4,32,0,4,64,128,0,0,
		0,4,18,16,0,128,32,0,0,128,0,0,0,0,0,0,
		8,0,0,128,0,64,0,0,0,0,32,0,9,80,0,0,
		8,64,0,0,8,0,0,16,0,0,0,4,16,0,0,0,
		8,0,0,128,32,8,1,0,4,32,0,4,73,144,0,0,
		0,68,18,16,8,128,32,16,0,128,0,4,16,0,0,0,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	}
    };

unsigned char	digits[11][28] = {
		{
			0x03, 0x00, 0x00, 0xc0, 0x1e, 0x20, 0x31, 0x30,
			0x60, 0x30, 0x40, 0x30, 0xc0, 0x30, 0xc0, 0x30,
			0xc0, 0x20, 0xc0, 0x60, 0xc0, 0xc0, 0x41, 0x80,
			0x3f, 0x00, 0x00, 0x00
		},{
			0x00, 0xe0, 0x01, 0xc0, 0x03, 0xc0, 0x04, 0x80,
			0x0b, 0x80, 0x03, 0x80, 0x03, 0x00, 0x03, 0x00,
			0x07, 0x00, 0x06, 0x00, 0x06, 0x00, 0x0e, 0x20,
			0x3f, 0xc0, 0x40, 0x00
		},{
			0x00, 0x00, 0x03, 0xe0, 0x0c, 0x30, 0x10, 0x30,
			0x20, 0x30, 0x00, 0x60, 0x00, 0xc0, 0x01, 0x80,
			0x03, 0x00, 0x06, 0x00, 0x0c, 0x10, 0x3f, 0xe0,
			0x7f, 0xc0, 0x80, 0x00
		},{
			0x07, 0xc0, 0x18, 0x60, 0x20, 0x20, 0x00, 0x60,
			0x01, 0xc0, 0x07, 0x80, 0x08, 0xc0, 0x00, 0x60,
			0x00, 0x60, 0x00, 0xc0, 0x03, 0x80, 0x0e, 0x00,
			0x38, 0x00, 0x40, 0x00
		},{
			0x00, 0x10, 0x00, 0x20, 0x00, 0x20, 0x00, 0x60,
			0x04, 0x40, 0x04, 0xc0, 0x08, 0xc0, 0x18, 0x80,
			0x31, 0x80, 0x61, 0x80, 0xff, 0xe0, 0x01, 0x10,
			0x01, 0x00, 0x01, 0x00
		},{
			0x00, 0x20, 0x0f, 0xc0, 0x10, 0x00, 0x10, 0x00,
			0x23, 0xc0, 0x3c, 0x60, 0x60, 0x20, 0x00, 0x60,
			0x00, 0xc0, 0x03, 0x80, 0x0e, 0x00, 0x30, 0x00,
			0x40, 0x00, 0x80, 0x00
		},{
			0x00, 0x20, 0x00, 0x80, 0x03, 0x00, 0x04, 0x00,
			0x18, 0x00, 0x70, 0x00, 0xe0, 0x00, 0xc3, 0xc0,
			0xcc, 0x60, 0xd0, 0x20, 0xc0, 0x20, 0xc0, 0x40,
			0x60, 0x80, 0x3f, 0x00
		},{
			0x03, 0xe0, 0x3c, 0x60, 0x40, 0x60, 0x00, 0x60,
			0x00, 0xc0, 0x01, 0x80, 0x03, 0x00, 0x06, 0x00,
			0x0c, 0x00, 0x08, 0x00, 0x18, 0x00, 0x10, 0x00,
			0x10, 0x00, 0x10, 0x00
		},{
			0x0e, 0x00, 0x1b, 0x20, 0x11, 0x20, 0x10, 0x40,
			0x11, 0x80, 0x0b, 0x00, 0x0e, 0x00, 0x1a, 0x00,
			0x31, 0x00, 0x61, 0x00, 0x61, 0x00, 0x63, 0x00,
			0x36, 0x00, 0x1c, 0x00
		},{
			0x0f, 0xc0, 0x10, 0x60, 0x20, 0x30, 0x40, 0x30,
			0x40, 0xb0, 0x63, 0x30, 0x3c, 0x30, 0x00, 0x60,
			0x00, 0xc0, 0x01, 0x80, 0x02, 0x00, 0x0c, 0x00,
			0x10, 0x00, 0x40, 0x00
		},{
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00
		}
	};

unsigned char	digbits[11][128];

unsigned int	palette[16] = {	0,20,36,52,38,54,18,10,27,9,13,47,37,39,7,63 };

unsigned char	field[820];

unsigned char	hold1[256];
unsigned char	hold2[256];

unsigned char	shot[4][32] = {
	{
		0,6,9,177,9,6,0,0,
		0,0,6,174,6,0,0,0,
		0,0,6,174,6,0,0,0,
		0,6,9,177,9,6,0,0
	},{
		56,68,68,40,16,16,0,16,
		0,56,56,16,0,16,0,16,
		0,56,56,16,0,16,0,16,
		56,68,68,40,16,16,0,16
	},{
		0,96,144,141,144,96,0,0,
		0,0,96,117,96,0,0,0,
		0,0,96,117,96,0,0,0,
		0,96,144,141,144,96,0,0
	},{
		16,0,16,16,40,68,68,56,
		16,0,16,0,16,56,56,0,
		16,0,16,0,16,56,56,0,
		16,0,16,16,40,68,68,56
	}
};

unsigned char	man[8][128] = {
	    {
		7,128,15,192,31,192,23,192,63,192,15,0,0,0,0,0,
		0,0,224,0,0,0,0,0,0,0,0,0,113,128,243,128,
		0,0,0,0,0,0,0,0,0,0,0,128,15,0,9,0,
		17,0,147,0,31,0,10,0,27,0,49,0,0,0,0,0,
		0,0,8,0,30,0,23,0,63,128,15,0,0,0,0,0,
		0,0,224,0,0,0,10,0,27,0,49,0,0,0,0,0,
		0,0,8,0,30,0,23,0,63,128,15,0,0,0,0,0,
		0,0,224,0,0,0,0,0,0,0,0,0,0,0,0,0
	},{
		7,128,15,192,31,192,23,192,63,192,15,0,0,0,0,0,
		0,0,224,0,0,0,0,0,0,0,0,0,28,96,60,224,
		0,0,0,0,0,0,0,0,0,0,0,128,15,0,9,0,
		17,0,147,0,31,0,11,0,9,128,12,192,0,0,0,0,
		0,0,8,0,30,0,23,0,63,128,15,0,0,0,0,0,
		0,0,224,0,0,0,11,0,9,128,12,192,0,0,0,0,
		0,0,8,0,30,0,23,0,63,128,15,0,0,0,0,0,
		0,0,224,0,0,0,0,0,0,0,0,0,0,0,0,0
	},{
		7,128,15,192,31,192,23,192,15,192,119,0,80,0,120,64,
		12,128,231,32,1,224,1,128,0,192,0,0,113,128,243,128,
		0,0,0,0,0,0,0,0,0,0,0,128,7,0,1,0,
		1,0,144,0,30,0,8,0,26,0,49,0,0,0,0,0,
		0,0,8,0,30,0,23,0,15,128,119,0,80,0,120,64,
		12,128,231,32,1,224,9,128,26,192,49,0,0,0,0,0,
		0,0,8,0,30,0,23,0,15,128,7,0,0,0,0,0,
		0,0,224,0,0,0,0,0,0,0,0,0,0,0,0,0
	},{
		7,128,15,192,31,192,23,192,15,192,119,0,80,0,120,64,
		12,128,231,32,1,224,1,128,0,192,0,0,28,96,60,224,
		0,0,0,0,0,0,0,0,0,0,0,128,7,0,1,0,
		1,0,144,0,30,0,8,0,26,0,12,0,0,0,0,0,
		0,0,8,0,30,0,23,0,15,128,119,0,80,0,120,64,
		12,128,231,32,1,224,9,128,26,192,12,0,0,0,0,0,
		0,0,8,0,30,0,23,0,15,128,7,0,0,0,0,0,
		0,0,224,0,0,0,0,0,0,0,0,0,0,0,0,0
	},{
		60,0,126,0,127,0,125,0,127,128,30,0,0,0,0,0,
		0,0,0,224,0,0,0,0,0,0,0,0,49,192,57,224,
		0,0,0,0,0,0,0,0,0,0,32,0,30,0,18,0,
		17,0,25,32,31,0,10,0,27,0,17,128,0,0,0,0,
		0,0,2,0,15,0,29,0,63,128,30,0,0,0,0,0,
		0,0,0,224,0,0,10,0,27,0,17,128,0,0,0,0,
		0,0,2,0,15,0,29,0,63,128,30,0,0,0,0,0,
		0,0,0,224,0,0,0,0,0,0,0,0,0,0,0,0
	},{
		60,0,126,0,127,0,125,0,127,128,30,0,0,0,0,0,
		0,0,0,224,0,0,0,0,0,0,0,0,199,0,231,128,
		0,0,0,0,0,0,0,0,0,0,32,0,30,0,18,0,
		17,0,25,32,31,0,26,0,50,0,102,0,0,0,0,0,
		0,0,2,0,15,0,29,0,63,128,30,0,0,0,0,0,
		0,0,0,224,0,0,26,0,50,0,102,0,0,0,0,0,
		0,0,2,0,15,0,29,0,63,128,30,0,0,0,0,0,
		0,0,0,224,0,0,0,0,0,0,0,0,0,0,0,0
	},{
		60,0,126,0,127,0,125,0,126,0,29,192,1,64,67,192,
		38,0,156,224,240,0,48,0,96,0,0,0,49,192,57,224,
		0,0,0,0,0,0,0,0,0,0,32,0,28,0,16,0,
		16,0,1,32,15,0,2,0,11,0,17,128,0,0,0,0,
		0,0,2,0,15,0,29,0,62,0,29,192,1,64,67,192,
		38,0,156,224,240,0,50,0,107,0,17,128,0,0,0,0,
		0,0,2,0,15,0,29,0,62,0,28,0,0,0,0,0,
		0,0,0,224,0,0,0,0,0,0,0,0,0,0,0,0
	},{
		60,0,126,0,127,0,125,0,126,0,29,192,1,64,67,192,
		38,0,156,224,240,0,48,0,96,0,0,0,199,0,231,128,
		0,0,0,0,0,0,0,0,0,0,32,0,28,0,16,0,
		16,0,1,32,15,0,2,0,11,0,6,0,0,0,0,0,
		0,0,2,0,15,0,29,0,62,0,29,192,1,64,67,192,
		38,0,156,224,240,0,50,0,107,0,6,0,0,0,0,0,
		0,0,2,0,15,0,29,0,62,0,28,0,0,0,0,0,
		0,0,0,224,0,0,0,0,0,0,0,0,0,0,0,0
	    }
	   };

unsigned char	bug1[8][256] = {
	    {
		0,0,0,0,32,192,96,192,14,0,15,8,3,188,0,92,
		3,188,15,8,14,0,96,192,32,192,0,0,0,0,0,0,
		0,0,0,0,0,0,14,0,49,0,62,128,127,72,255,162,
		127,72,62,128,49,0,14,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,14,0,49,0,62,128,99,72,193,160,
		99,72,62,128,49,0,14,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,14,0,15,0,3,136,0,64,
		3,136,15,0,14,0,0,0,0,0,0,0,0,0,0,0
	},{
		0,0,3,128,7,192,3,128,2,128,49,24,50,152,6,192,
		14,224,12,96,12,96,0,0,48,24,16,16,0,0,0,0,
		1,0,0,0,2,128,0,0,1,0,2,128,5,64,11,160,
		23,208,23,208,23,208,15,224,15,224,3,128,1,0,0,0,
		0,0,0,0,2,128,0,0,1,0,2,128,5,64,11,160,
		22,208,20,80,20,80,12,96,14,224,3,128,1,0,0,0,
		0,0,0,0,2,128,0,0,0,0,1,0,2,128,6,192,
		14,224,12,96,12,96,0,0,0,0,0,0,0,0,0,0
	},{
		0,0,0,0,6,8,6,12,0,224,33,224,123,128,116,0,
		123,128,33,224,0,224,6,12,6,8,0,0,0,0,0,0,
		0,0,0,0,0,0,0,224,1,24,2,248,37,252,139,254,
		37,252,2,248,1,24,0,224,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,224,1,24,2,248,37,140,11,6,
		37,140,2,248,1,24,0,224,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,224,1,224,35,128,4,0,
		35,128,1,224,0,224,0,0,0,0,0,0,0,0,0,0
	},{
		0,0,16,16,48,24,0,0,12,96,12,96,14,224,6,192,
		50,152,49,24,2,128,3,128,7,192,3,128,0,0,0,0,
		1,0,3,128,15,224,15,224,23,208,23,208,23,208,11,160,
		5,64,2,128,1,0,0,0,2,128,0,0,1,0,0,0,
		1,0,3,128,14,224,12,96,20,80,20,80,22,208,11,160,
		5,64,2,128,1,0,0,0,2,128,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,12,96,12,96,14,224,6,192,
		2,128,1,0,0,0,0,0,2,128,0,0,0,0,0,0
	},{
		0,0,0,128,7,0,8,0,16,0,19,224,20,16,37,128,
		35,136,16,136,30,8,0,16,0,32,15,192,0,0,0,0,
		0,0,0,128,7,0,8,0,16,0,19,224,20,16,37,128,
		35,136,16,136,30,8,0,16,0,32,15,192,0,0,0,0,
		0,0,0,128,7,0,8,0,16,0,19,224,20,16,37,128,
		35,136,16,136,30,8,0,16,0,32,15,192,0,0,0,0,
		0,0,0,128,7,0,8,0,16,0,19,224,20,16,37,128,
		35,136,16,136,30,8,0,16,0,32,15,192,0,0,0,0
	},{
		0,0,0,0,0,0,0,0,7,192,8,32,19,128,16,64,
		19,64,9,32,7,16,0,8,0,240,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,7,192,8,32,19,128,16,64,
		19,64,9,32,7,16,0,8,0,240,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,7,192,8,32,19,128,16,64,
		19,64,9,32,7,16,0,8,0,240,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,7,192,8,32,19,128,16,64,
		19,64,9,32,7,16,0,8,0,240,0,0,0,0,0,0
	},{
		0,0,0,0,0,0,0,0,0,64,2,160,2,144,2,80,
		1,80,0,128,0,0,0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,64,2,160,2,144,2,80,
		1,80,0,128,0,0,0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,64,2,160,2,144,2,80,
		1,80,0,128,0,0,0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,64,2,160,2,144,2,80,
		1,80,0,128,0,0,0,0,0,0,0,0,0,0,0,0
	},{
		0,0,0,0,0,0,0,0,0,0,0,0,2,0,5,0,
		2,128,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,0,0,2,0,5,0,
		2,128,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,0,0,2,0,5,0,
		2,128,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,0,0,2,0,5,0,
		2,128,1,0,0,0,0,0,0,0,0,0,0,0,0,0
	}
	};

unsigned char	goodies[4][256] = {
	    {
		0,0,0,0,1,128,2,64,2,64,1,128,32,4,80,10,
		81,138,34,68,26,88,37,164,3,164,4,88,3,128,0,0,
		0,0,0,0,1,128,2,64,2,64,1,128,32,4,112,14,
		113,142,35,196,27,216,61,188,27,188,7,216,3,128,0,0,
		0,0,1,128,1,128,14,112,6,96,25,152,35,196,83,202,
		95,250,122,94,126,126,127,254,63,252,31,248,7,192,0,0,
		0,0,0,0,1,128,3,192,3,192,1,128,32,4,80,10,
		81,138,34,68,26,88,37,164,3,164,4,88,3,128,0,0
	},{
		0,0,1,128,0,64,0,32,0,64,0,128,0,0,4,32,
		0,16,0,8,0,8,0,8,0,8,0,0,0,0,0,0,
		0,0,1,128,3,192,4,224,2,192,1,128,0,0,4,32,
		0,16,0,8,0,8,0,8,0,8,0,0,0,0,0,0,
		0,0,1,128,3,192,4,224,2,192,1,128,6,96,15,176,
		24,56,16,24,16,24,16,24,24,24,12,32,7,224,0,0,
		0,0,1,128,0,64,0,32,0,64,0,128,0,0,4,32,
		0,16,0,8,0,8,0,8,0,8,0,0,0,0,0,0
	},{
		0,0,1,128,0,64,0,32,0,64,0,128,0,0,4,32,
		0,16,0,8,0,8,0,8,0,8,0,0,0,0,0,0,
		0,0,1,128,3,192,4,224,2,192,1,128,0,0,4,32,
		0,16,0,8,0,8,0,8,0,8,0,0,0,0,0,0,
		0,0,1,128,0,64,0,32,0,64,0,128,6,96,15,176,
		24,56,16,24,16,24,16,24,24,24,12,32,7,224,0,0,
		0,0,1,128,0,64,0,32,0,64,0,128,0,0,4,32,
		0,16,0,8,0,8,0,8,0,8,0,0,0,0,0,0
	},{
		0,0,1,128,0,64,0,32,0,64,0,128,0,0,4,32,
		0,16,0,8,0,8,0,8,0,8,0,0,0,0,0,0,
		0,0,1,128,0,64,0,32,0,64,0,128,0,0,4,32,
		0,16,0,8,0,8,0,8,0,8,0,0,0,0,0,0,
		0,0,1,128,0,64,0,32,0,64,0,128,6,96,15,176,
		24,56,16,24,16,24,16,24,24,24,12,32,7,224,0,0,
		0,0,1,128,3,192,4,224,2,192,1,128,0,0,4,32,
		0,16,0,8,0,8,0,8,0,8,0,0,0,0,0,0
	    }
	};

unsigned char	pits[256] = {
		0,0,0,0,0,0,0,0,0,0,0,0,64,2,0,0,
		64,2,0,0,96,6,0,0,112,14,0,0,124,62,0,0,
		0,0,0,0,0,0,0,0,128,1,192,3,192,3,192,3,
		192,3,224,7,224,7,248,31,240,15,254,127,252,63,255,255,
		0,0,0,0,0,0,0,0,0,0,0,0,64,2,0,0,
		64,2,0,0,96,6,0,0,112,14,0,0,124,62,0,0,
		0,0,0,0,0,0,0,0,0,0,0,0,64,2,0,0,
		64,2,0,0,96,6,0,0,112,14,0,0,124,62,0,0,

/*		{
		248,0,248,0,248,0,254,0,255,128,255,224,255,248,243,254,
		242,127,255,255,242,79,242,79,255,255,255,255,255,255,255,255,
		168,0,168,0,168,0,174,0,179,128,188,224,191,56,191,206,
		191,243,191,253,191,253,191,253,191,253,191,253,128,1,255,255,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		80,0,80,0,80,0,80,0,76,0,67,0,80,192,64,48,
		64,12,82,66,64,2,64,2,82,74,64,2,127,254,0,0
	},{
		248,0,248,0,248,0,248,0,248,0,248,0,248,0,248,0,
		248,0,248,0,248,0,248,0,248,0,248,0,248,0,248,0,
		168,0,168,0,168,0,168,0,168,0,168,0,168,0,168,0,
		168,0,168,0,168,0,168,0,168,0,168,0,168,0,168,0,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		80,0,80,0,80,0,80,0,80,0,80,0,80,0,80,0,
		80,0,80,0,80,0,80,0,80,0,80,0,80,0,80,0
	}
*/
	};

int	pattcolors[MAXWALLS][2] = {
		4, 6,
		2, 8,
		3, 7,
		4, 9,
		6, 1,
		12, 15,
		15, 5,
		10, 2,
		5, 12,
		13, 7
	};

int	colors[MAXCOLOR] = {
		10,6,10,4,6
	};

struct	bugtype	{
		int	x;
		int	y;
		int	dir;
		int	kind;
		int	lost;
	} bugs[MAXBUGS];

struct	mantype {
		int	x;
		int	y;
		int	dir;
		int	key;
	} mans;

struct	shottype {
		int	x;
		int	y;
		int	dir;
	} shots;

int	newmandir = -1;

char	newwall[128];

char	wallpatt[64] = {
		0x04, 0x04, 0x19, 0xf4, 0xf6, 0x0b, 0x08, 0x08,
		0xc8, 0x0b, 0x24, 0x14, 0x13, 0xe8, 0x10, 0x08,
		0x13, 0xc8, 0x2c, 0x24, 0xd0, 0x13, 0x10, 0x18,
		0x90, 0x17, 0x6c, 0x28, 0x12, 0x28, 0x09, 0xc4,

		0xf8, 0x03, 0xe0, 0x03, 0x01, 0xf0, 0x07, 0xf0,
		0x07, 0xf0, 0xc3, 0xe3, 0xe0, 0x07, 0xe0, 0x07,
		0xe0, 0x07, 0xc3, 0xc3, 0x0f, 0xe0, 0x0f, 0xe0,
		0x0f, 0xe0, 0x83, 0xc7, 0xe1, 0xc7, 0xf0, 0x03
/*
		1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
		1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,
		1,0,1,1,1,1,1,1,1,1,1,1,1,1,0,1,
		1,0,1,0,1,0,1,0,1,0,1,0,1,1,0,1,
		1,0,1,1,0,1,0,1,0,1,0,1,0,1,0,1,
		1,0,1,0,1,0,1,0,1,0,1,0,1,1,0,1,
		1,0,1,1,1,1,1,1,1,1,1,1,1,1,0,1,
		1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,
		1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
		0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,
		1,1,1,1,1,1,0,1,0,1,1,1,1,1,1,1,
		0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,
		1,0,1,0,1,1,0,1,0,1,1,0,1,0,1,0,
		0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,
		1,1,1,1,1,1,0,1,0,1,1,1,1,1,1,1,
		0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0
*/
	};

int	curwall = 0;
unsigned char	walls[MAXWALLS][90] = {		/* 0 */
	  {
		0xff, 0xff, 0xff, 0xff, 0xfe, 
		0x80, 0x40, 0x08, 0x00, 0x02, 
		0xaa, 0x0f, 0xe8, 0x38, 0x42, 
		0xaf, 0x48, 0x2b, 0x0b, 0xca, 
		0xa1, 0x6c, 0x21, 0x08, 0x0a, 
		0xa4, 0x06, 0x2f, 0x28, 0xfa, 
		0xa5, 0xf3, 0x68, 0x20, 0x02, 
		0x84, 0x51, 0xc3, 0x2f, 0x82, 
		0xbf, 0x10, 0x02, 0x20, 0x12, 
		0x82, 0x3b, 0x4a, 0xf8, 0x90, 
		0xfa, 0x8e, 0x4a, 0x18, 0x92, 
		0x80, 0xeb, 0xc8, 0x08, 0x82, 
		0xbf, 0x8b, 0x0f, 0xd8, 0x02, 
		0x91, 0x28, 0x20, 0x1b, 0xe2, 
		0x94, 0x03, 0xee, 0x00, 0x02, 
		0xbd, 0x6f, 0x63, 0x9e, 0x22, 
		0x81, 0x00, 0x08, 0x00, 0x02, 
		0xff, 0xff, 0xff, 0xff, 0xfe
	   },{					/* 1 */
		0xff, 0xff, 0xff, 0xff, 0xfe, 
		0x8e, 0xf0, 0x00, 0x1e, 0xe2, 
		0xe8, 0x35, 0x55, 0x50, 0x02, 
		0x8e, 0xf5, 0x45, 0x57, 0xe2, 
		0x80, 0x15, 0x01, 0x57, 0x22, 
		0x80, 0x04, 0x00, 0x56, 0x22, 
		0x8f, 0xf5, 0xff, 0x54, 0x22, 
		0x81, 0x10, 0x00, 0x16, 0x26, 
		0x88, 0x10, 0xdf, 0x9f, 0x20, 
		0x89, 0xf0, 0xfd, 0x90, 0x26, 
		0xc8, 0xd0, 0x00, 0x11, 0x02, 
		0x08, 0x55, 0xff, 0x5f, 0xe2, 
		0xc8, 0xd4, 0x00, 0x40, 0x02, 
		0x89, 0xd5, 0x01, 0x50, 0x02, 
		0x8f, 0xd5, 0x45, 0x5e, 0xe2, 
		0x80, 0x15, 0x55, 0x58, 0x2e, 
		0x8e, 0xf0, 0x00, 0x1e, 0xe2, 
		0xff, 0xff, 0xff, 0xff, 0xfe
	   },{					/* 2 */
		0xff, 0xff, 0xff, 0xff, 0xfe, 
		0xf7, 0xff, 0xff, 0x03, 0x02, 
		0xc0, 0x00, 0x01, 0x7a, 0x02, 
		0xc0, 0x00, 0x01, 0x0b, 0x02, 
		0xc0, 0x00, 0x01, 0xe8, 0x02, 
		0xc0, 0x00, 0x01, 0x0b, 0x82, 
		0xc0, 0x00, 0x01, 0x48, 0xba, 
		0xc0, 0x03, 0x79, 0x7e, 0xa2, 
		0x17, 0xff, 0xfb, 0x02, 0xbe, 
		0xd7, 0xff, 0xf8, 0x3a, 0x20, 
		0xc0, 0x03, 0x7b, 0x0a, 0xae, 
		0xc0, 0x00, 0x01, 0xe8, 0xaa, 
		0xc0, 0x00, 0x01, 0x0f, 0xaa, 
		0xc0, 0x00, 0x01, 0x78, 0xa2, 
		0xc0, 0x00, 0x01, 0x2a, 0x8a, 
		0xc0, 0x00, 0x01, 0x8a, 0xaa, 
		0xf7, 0xff, 0xff, 0x22, 0x2a, 
		0xff, 0xff, 0xff, 0xff, 0xfe
	   },{					/* 3 */
		0xff, 0xff, 0xff, 0xff, 0xfe, 
		0x80, 0x38, 0x88, 0x8f, 0xbe, 
		0x80, 0x0a, 0x22, 0x24, 0x00, 
		0x8e, 0x28, 0x88, 0x8c, 0x42, 
		0x8c, 0x3a, 0x22, 0x24, 0x02, 
		0x88, 0x20, 0x88, 0x0c, 0x42, 
		0x8c, 0x3e, 0xff, 0x7d, 0x12, 
		0x8e, 0x20, 0x02, 0x44, 0x46, 
		0x8a, 0x20, 0x03, 0x11, 0x12, 
		0x08, 0x27, 0xfa, 0x44, 0x46, 
		0xfe, 0x20, 0x03, 0x11, 0x12, 
		0x80, 0x20, 0x02, 0x44, 0x46, 
		0x80, 0x37, 0xbf, 0x11, 0x12, 
		0x8f, 0xe1, 0x82, 0x44, 0x46, 
		0x8f, 0xe1, 0x8b, 0x11, 0x12, 
		0x80, 0x00, 0xa6, 0x44, 0x46, 
		0x80, 0x01, 0x93, 0x11, 0x12, 
		0xff, 0xff, 0xff, 0xff, 0xfe
	   },{					/* 4 */
		0xff, 0xff, 0xff, 0xff, 0xfe, 
		0xe0, 0x10, 0x04, 0x00, 0x42, 
		0x39, 0xff, 0x15, 0x01, 0x12, 
		0x89, 0x6d, 0xb5, 0xff, 0xf2, 
		0x89, 0x01, 0xf5, 0x00, 0x02, 
		0x89, 0x01, 0xf5, 0xb2, 0x4a, 
		0x8b, 0xef, 0xb5, 0xf0, 0x02, 
		0x89, 0x01, 0x11, 0xf0, 0x6e, 
		0x89, 0x39, 0x1f, 0xff, 0xfe, 
		0x89, 0x01, 0x1b, 0xfd, 0xc0, 
		0x89, 0x6d, 0x01, 0xb0, 0x4e, 
		0x8d, 0xff, 0x09, 0x00, 0x42, 
		0x81, 0x80, 0x09, 0x00, 0x7a, 
		0xf8, 0x80, 0x09, 0x00, 0x4a, 
		0x89, 0xec, 0x09, 0x08, 0x4a, 
		0xb9, 0xff, 0xff, 0x08, 0x0a, 
		0x80, 0x00, 0x00, 0x08, 0x02, 
		0xff, 0xff, 0xff, 0xff, 0xfe
	   },{					/* 5 */
		0xff, 0xff, 0xff, 0xff, 0xfe, 
		0x80, 0x00, 0x00, 0x0d, 0x82, 
		0x80, 0x00, 0x01, 0x08, 0x92, 
		0xbf, 0xfb, 0xe1, 0x00, 0x12, 
		0xb6, 0x0a, 0x3f, 0x00, 0x12, 
		0xa2, 0x8a, 0x00, 0x20, 0x12, 
		0xa2, 0x80, 0x00, 0x3f, 0xf2, 
		0x80, 0xbf, 0xff, 0xe6, 0xc2, 
		0x88, 0x97, 0xfd, 0xa0, 0x02, 
		0x08, 0x82, 0x08, 0x20, 0x02, 
		0x88, 0xb2, 0x09, 0xa3, 0xce, 
		0x88, 0x92, 0x09, 0x22, 0x00, 
		0x9c, 0x93, 0xb9, 0x20, 0x8e, 
		0x80, 0x93, 0xf9, 0x2f, 0x82, 
		0x9c, 0x87, 0xbc, 0x28, 0x92, 
		0x94, 0x80, 0x00, 0x20, 0x82, 
		0x80, 0x80, 0x00, 0x2d, 0x82, 
		0xff, 0xff, 0xff, 0xff, 0xfe
	   },{					/* 6 */
		0xff, 0xff, 0xff, 0xff, 0xfe, 
		0x88, 0x01, 0xc0, 0x00, 0x0a, 
		0x88, 0x00, 0x00, 0x03, 0x1a, 
		0x80, 0x01, 0xf0, 0x00, 0x32, 
		0x83, 0x71, 0xff, 0x18, 0x66, 
		0xbb, 0xf1, 0xff, 0xf8, 0xc6, 
		0xa2, 0x11, 0xbf, 0x09, 0x92, 
		0xba, 0x10, 0x01, 0x08, 0x36, 
		0x82, 0x10, 0x01, 0x09, 0xf6, 
		0x03, 0xd0, 0xe1, 0x78, 0x00, 
		0x82, 0x00, 0xe0, 0x08, 0x36, 
		0x82, 0x00, 0xc0, 0x09, 0xa2, 
		0x93, 0xf0, 0xe1, 0xf9, 0x32, 
		0x9e, 0x18, 0xff, 0x0f, 0x12, 
		0x84, 0x0c, 0x06, 0x04, 0x1a, 
		0x86, 0x07, 0x1c, 0x0c, 0xca, 
		0x80, 0xe1, 0xb0, 0xe0, 0x02, 
		0xff, 0xff, 0xff, 0xff, 0xfe
	   },{					/* 7 */
		0xff, 0xff, 0xff, 0xff, 0xfe, 
		0x82, 0x00, 0x20, 0x00, 0x06, 
		0xa2, 0x9b, 0x60, 0x00, 0x06, 
		0xa2, 0x9f, 0x24, 0x46, 0xc6, 
		0xa2, 0x00, 0x20, 0x04, 0x42, 
		0xa2, 0xf5, 0x21, 0x16, 0xc6, 
		0xa6, 0xbd, 0x20, 0x00, 0x06, 
		0xb2, 0x84, 0x34, 0x4f, 0xfe, 
		0xb2, 0xf5, 0x30, 0x08, 0x00, 
		0x20, 0xc5, 0x11, 0x18, 0x00, 
		0xb2, 0xf1, 0x30, 0x0b, 0xfe, 
		0xb2, 0x01, 0x34, 0x40, 0x06, 
		0xa6, 0xff, 0x00, 0x06, 0xc6, 
		0xa2, 0x00, 0x21, 0x14, 0x42, 
		0xa2, 0xdf, 0x20, 0x06, 0xc6, 
		0xa2, 0x5b, 0x64, 0x40, 0x06, 
		0x82, 0x00, 0x20, 0x00, 0x06, 
		0xff, 0xff, 0xff, 0xff, 0xfe
	   },{					/* 8 */
		0xff, 0xff, 0xff, 0xff, 0xfe, 
		0xc4, 0x50, 0x40, 0x28, 0x02, 
		0x91, 0x17, 0x40, 0x00, 0x02, 
		0xbf, 0xb1, 0x40, 0x00, 0x02, 
		0x91, 0x15, 0x40, 0x00, 0x02, 
		0xd0, 0x55, 0x40, 0x00, 0x02, 
		0x91, 0xd0, 0x00, 0x00, 0x02, 
		0xb1, 0x15, 0x40, 0x02, 0x82, 
		0x9b, 0xf5, 0x7f, 0xff, 0xfe, 
		0x00, 0x11, 0x40, 0x01, 0x48, 
		0xbb, 0xd7, 0x44, 0x04, 0x02, 
		0x91, 0x10, 0x44, 0x05, 0x56, 
		0xd1, 0x07, 0xc4, 0x05, 0xf2, 
		0x90, 0x10, 0x0e, 0xac, 0x1a, 
		0xb1, 0x17, 0xff, 0xfd, 0xd2, 
		0x9f, 0x15, 0x55, 0x55, 0x56, 
		0xc0, 0x10, 0x00, 0x00, 0x02, 
		0xff, 0xff, 0xff, 0xff, 0xfe
	   },{					/* 9 */
		0xff,0xff,0xff,0xff,0xfe,
		0x80,0x00,0x00,0x00,0x02,
		0x80,0x00,0x00,0x00,0x02,
		0x80,0x00,0x00,0x00,0x02,
		0x80,0x00,0x00,0x00,0x02,
		0x80,0x00,0x00,0x00,0x02,
		0x80,0x00,0x00,0x00,0x02,
		0x80,0x00,0x00,0x00,0x02,
		0x80,0x00,0x00,0x00,0x02,
		0x00,0x00,0x00,0x00,0x00,
		0x80,0x00,0x00,0x00,0x02,
		0x80,0x00,0x00,0x00,0x02,
		0x80,0x00,0x00,0x00,0x02,
		0x80,0x00,0x00,0x00,0x02,
		0x80,0x00,0x00,0x00,0x02,
		0x80,0x00,0x00,0x00,0x02,
		0x80,0x00,0x00,0x00,0x02,
		0xff,0xff,0xff,0xff,0xfe
	   }
	};

int	values[4] = { 100, 10, 5, 1 };

struct	goodtype {
	int	x;
	int	y;
	int	item;
	} treasure[MAXWALLS][MAXOBJECTS] = {
		{
		0x06, 0x03, 0x60,
		0x0a, 0x03, 0x21,
		0x11, 0x05, 0x30,
		0x15, 0x05, 0x41,
		0x16, 0x05, 0x43,
		0x17, 0x05, 0x42,
		0x11, 0x07, 0x15,
		0x0b, 0x08, 0x40,
		0x0e, 0x0a, 0x43,
		0x27, 0x0a, 0x70,
		0x10, 0x0b, 0x40,
		0x0e, 0x0c, 0x41,
		0x1c, 0x0c, 0x25,
		0x05, 0x0f, 0x40,
		0x09, 0x10, 0x27,
		0x11, 0x10, 0x14
	},{
		0x02, 0x02, 0x41,
		0x08, 0x02, 0x14,
		0x20, 0x02, 0x14,
		0x26, 0x02, 0x41,
		0x14, 0x05, 0x40,
		0x0c, 0x06, 0x70,
		0x1f, 0x07, 0x21,
		0x0b, 0x08, 0x40,	/* 1 */
		0x1d, 0x08, 0x60,
		0x13, 0x09, 0x23,
		0x26, 0x09, 0x70,
		0x17, 0x0a, 0x27,
		0x0b, 0x0b, 0x60,
		0x13, 0x0b, 0x60,
		0x01, 0x0c, 0x30,
		0x09, 0x0c, 0x25,
		0x1c, 0x0d, 0x70,
		0x14, 0x0e, 0x40,
		0x02, 0x11, 0x41,
		0x08, 0x11, 0x15,
		0x20, 0x11, 0x15
	},{
		0x05, 0x02, 0x14,
		0x20, 0x03, 0x21,
		0x0c, 0x04, 0x60,
		0x1f, 0x05, 0x70,
		0x1b, 0x07, 0x60,
		0x20, 0x07, 0x60,	/* 2 */
		0x22, 0x07, 0x70,
		0x11, 0x08, 0x15,
		0x24, 0x08, 0x80,
		0x01, 0x09, 0x30,
		0x05, 0x09, 0x23,
		0x05, 0x0a, 0x27,
		0x17, 0x0a, 0x70,
		0x18, 0x0a, 0x70,
		0x21, 0x0a, 0x25,
		0x27, 0x0a, 0x70,
		0x11, 0x0b, 0x14,
		0x20, 0x0c, 0x40,
		0x0c, 0x0f, 0x60,
		0x1c, 0x0f, 0x60,
		0x23, 0x0f, 0x70,
		0x05, 0x11, 0x15,
		0x19, 0x11, 0x60
	},{
		0x14, 0x02, 0x42,
		0x22, 0x02, 0x27,
		0x27, 0x03, 0x70,
		0x0c, 0x04, 0x60,
		0x06, 0x06, 0x21,
		0x0c, 0x06, 0x41,
		0x19, 0x07, 0x70,	/* 3 */
		0x06, 0x09, 0x60,
		0x26, 0x09, 0x40,
		0x01, 0x0a, 0x30,
		0x18, 0x0a, 0x40,
		0x26, 0x0b, 0x40,
		0x18, 0x0c, 0x40,
		0x0d, 0x0d, 0x70,
		0x26, 0x0d, 0x40,
		0x18, 0x0e, 0x40,
		0x26, 0x0f, 0x40,
		0x10, 0x10, 0x25,
		0x18, 0x10, 0x40,
		0x16, 0x11, 0x60
	},{				/* 4 */
		0x04, 0x02, 0x41,
		0x0b, 0x02, 0x60,
		0x01, 0x03, 0x30,
		0x17, 0x03, 0x70,
		0x09, 0x04, 0x42,
		0x0c, 0x04, 0x14,
		0x0f, 0x04, 0x40,
		0x12, 0x04, 0x15,
		0x1a, 0x06, 0x15,
		0x12, 0x07, 0x14,
		0x1f, 0x08, 0x40,
		0x24, 0x08, 0x23,
		0x16, 0x0a, 0x27,
		0x1f, 0x0a, 0x27,
		0x27, 0x0a, 0x70,
		0x09, 0x0b, 0x60,
		0x0c, 0x0b, 0x23,
		0x0f, 0x0b, 0x80,
		0x1a, 0x0b, 0x14,
		0x08, 0x0e, 0x25,
		0x16, 0x0e, 0x40,
		0x17, 0x0e, 0x40,
		0x23, 0x0e, 0x41,
		0x04, 0x0f, 0x60,
		0x0c, 0x0f, 0x15,
		0x14, 0x0f, 0x60,
		0x16, 0x0f, 0x40,
		0x17, 0x0f, 0x40,
		0x08, 0x11, 0x70,
		0x25, 0x11, 0x70,
		0x08, 0x11, 0x70,
		0x25, 0x11, 0x70
	},{				/* 5 */
		0x1f, 0x02, 0x14,
		0x14, 0x04, 0x43,
		0x05, 0x05, 0x27,
		0x0a, 0x08, 0x70,
		0x1c, 0x08, 0x42,
		0x20, 0x08, 0x27,
		0x0d, 0x09, 0x27,
		0x17, 0x09, 0x27,
		0x1a, 0x09, 0x60,
		0x01, 0x0a, 0x30,
		0x10, 0x0a, 0x40,
		0x11, 0x0a, 0x40,
		0x12, 0x0a, 0x40,
		0x13, 0x0a, 0x40,
		0x14, 0x0a, 0x40,
		0x10, 0x0b, 0x40,
		0x11, 0x0b, 0x40,
		0x12, 0x0b, 0x40,
		0x13, 0x0b, 0x40,
		0x14, 0x0b, 0x40,
		0x10, 0x0c, 0x40,
		0x11, 0x0c, 0x40,
		0x12, 0x0c, 0x40,
		0x13, 0x0c, 0x40,
		0x14, 0x0c, 0x40,
		0x26, 0x0c, 0x70,
		0x12, 0x0d, 0x15,
		0x04, 0x0e, 0x41,
		0x05, 0x0e, 0x42,
		0x06, 0x0e, 0x43,
		0x0e, 0x0e, 0x41,
		0x12, 0x0f, 0x14,
		0x05, 0x10, 0x60,
		0x24, 0x10, 0x41,
		0x1f, 0x11, 0x15
	},{				/* 6 */
		0x26, 0x02, 0x42,
		0x11, 0x03, 0x70,
		0x09, 0x05, 0x23,
		0x1a, 0x05, 0x23,
		0x04, 0x07, 0x41,
		0x12, 0x07, 0x14,
		0x26, 0x07, 0x25,
		0x09, 0x08, 0x40,
		0x1b, 0x08, 0x60,
		0x01, 0x0a, 0x30,
		0x26, 0x0a, 0x70,
		0x27, 0x0a, 0x70,
		0x08, 0x0c, 0x41,
		0x13, 0x0c, 0x21,
		0x05, 0x0d, 0x42,
		0x17, 0x0d, 0x41,
		0x15, 0x0f, 0x41,
		0x1d, 0x0f, 0x41,
		0x0f, 0x11, 0x60,
		0x12, 0x11, 0x15,
		0x15, 0x11, 0x60
	},{				/* 7 */
		0x0e, 0x03, 0x15,
		0x18, 0x04, 0x40,
		0x1f, 0x05, 0x60,
		0x21, 0x05, 0x43,
		0x26, 0x05, 0x25,
		0x0d, 0x06, 0x40,
		0x1a, 0x06, 0x40,
		0x0a, 0x07, 0x60,
		0x18, 0x08, 0x40,
		0x01, 0x0a, 0x30,
		0x04, 0x0a, 0x21,
		0x0b, 0x0a, 0x40,
		0x13, 0x0a, 0x25,
		0x1a, 0x0a, 0x40,
		0x1e, 0x0b, 0x70,
		0x0f, 0x0c, 0x42,
		0x18, 0x0c, 0x40,
		0x13, 0x0d, 0x70,
		0x1a, 0x0e, 0x40,
		0x1f, 0x0e, 0x43,
		0x21, 0x0e, 0x43,
		0x26, 0x0e, 0x25,
		0x0e, 0x10, 0x14,
		0x18, 0x10, 0x40,
		0x18, 0x10, 0x40
	},{				/* 8 */
		0x1c, 0x02, 0x27,
		0x1e, 0x05, 0x80,
		0x08, 0x06, 0x25,
		0x09, 0x06, 0x41,
		0x12, 0x07, 0x70,
		0x09, 0x08, 0x60,
		0x20, 0x08, 0x23,
		0x01, 0x0a, 0x30,
		0x27, 0x0a, 0x70,
		0x1a, 0x0b, 0x60,
		0x0c, 0x0d, 0x70,
		0x08, 0x0e, 0x21,
		0x18, 0x0e, 0x23,
		0x1a, 0x0e, 0x23,
		0x1c, 0x0e, 0x23,
		0x06, 0x0f, 0x60,
		0x19, 0x10, 0x27,
		0x1b, 0x10, 0x27,
		0x1d, 0x10, 0x27,
		0x08, 0x11, 0x40,
	},{
		0x01, 0x0a, 0x30,
		0x20, 0x0a, 0x25
	}
    };

unsigned char	tagboost[128] = {
		255,255,248,31,248,31,248,31,248,31,128,1,128,1,128,1,
		128,1,128,1,128,1,248,31,248,31,248,31,248,31,255,255,
		255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
		255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
		255,255,248,31,248,31,248,31,248,31,128,1,128,1,128,1,
		128,1,128,1,128,1,248,31,248,31,248,31,248,31,255,255,
		255,255,255,255,252,63,252,63,252,63,252,63,192,3,192,3,
		192,3,192,3,252,63,252,63,252,63,252,63,255,255,255,255
	};

extern	int	timepass;

/****************************************************************
 * ELSE ELSE ELSE ELSE ELSE ELSE ELSE ELSE ELSE ELSE		*
 ****************************************************************/

#else

extern	struct	hightype {
	long	score;
	char	name[12];
	} highlist[64];

extern	int	beep_dead[];
extern	int	tagcount;
extern	int	tagflg;
extern	int	curscreen;
extern	int	dead;
extern	int	beep_lock[];
extern	int	beep_tag[];
extern	int	beep_click[];
extern	int	beep_goodies[];
extern	int	beep_kill[];
extern	int	beep_teleport[];
extern	struct	pltype {
		int	x;
		int	y;
		} pitlist[MAXPITS];
extern	int	okbugmake;
extern	int	bugmaketime;
extern	long	score;
extern	int	score_color;
extern	int	scorex;
extern	int	scorey;
extern	int	scoreflg;
extern	char	scorebuf[];
extern	int	scoreptr;
extern	long	highscore;
extern	long	sscore;
extern	long	points;
extern	int	point_color;
extern	int	pointx;
extern	int	pointflg;
extern	char	pointbuf[];
extern	int	pointptr;
extern	unsigned char	keys[128];
extern	unsigned char	keylock[128];
extern	unsigned char	teleport[128];
extern	unsigned char	bang[4][128];
extern	unsigned char	digits[11][28];
extern	unsigned char	digbits[11][128];
extern	unsigned int	palette[16];
extern	unsigned char	field[820];
extern	unsigned char	hold1[256];
extern	unsigned char	hold2[256];
extern	unsigned char	shot[4][32];
extern	unsigned char	man[8][128];
extern	unsigned char	bug1[8][256];
extern	unsigned char	goodies[4][256];
extern	unsigned char	pits[128];
extern	int	pattcolors[MAXWALLS][2];
extern	int	colors[MAXCOLOR];
extern	struct	bugtype	{
			int	x;
			int	y;
			int	dir;
			int	kind;
			int	lost;
		} bugs[MAXBUGS];
extern	struct	mantype {
			int	x;
			int	y;
			int	dir;
			int	key;
		} mans;
extern	struct	shottype {
			int	x;
			int	y;
			int	dir;
		} shots;
extern	int	newmandir;
extern	char	newwall[128];
extern	char	wallpatt[];
extern	int	curwall;
extern	unsigned char	walls[MAXWALLS][90];
extern	int	values[4];
extern	struct	goodtype {
		int	x;
		int	y;
		int	item;
		} treasure[MAXWALLS][MAXOBJECTS];
extern	int	timepass;
extern	unsigned char	tagboost[];

/************************************************************************
 * ENDIF ENDIF ENDIF ENDIF ENDIF ENDIF ENDIF ENDIF ENDIF ENDIF ENDIF 	*
 ************************************************************************/

#endif

/************************************************************************
 * Function type declarations						*
 ************************************************************************/

void	init(), uninit(), init_screen(), box(), setpalette(), choose_palette();
void	choose_colors(), show_bug(), move_bug(), move_man(), convert();
void	show_man(), build_wall(), show_shot(), move_shot(), fire();
void	show_score(), disp_field(), flip(), reverse(), rotate(), make_bug();
void	bang_bug(), edit_walls(), next_screen(), clear_bottom(), pause();
void	check_new_high(), welcome();

