{$C-,V-,K-,R-,U-}
(****************************************************************************)
(*                                                                          *)
(*       This program is the GT-UTIL program.  It will do several           *)
(*       utility functions with the Phone Directory as follows:             *)
(*                                                                          *)
(*       1.   Convert pre GT 4.20 directories to new format.                *)
(*       2.   Convert pre GT 8.00 directories to new format.                *)
(*       3.   Convert pre GT 9.00 directories to new format.                *)
(*       4.   Convert GT 9.xx directories to new format.                    *)
(*       5.   Convert several QMODEM .FON formats to GT format.             *)
(*       6.   List directory to the system printer.                         *)
(*       7.   Import text listing of BBS into GT directory format.          *)
(*                                                                          *)
(****************************************************************************)

program
   gt_util;

TYPE

(****************************************************************************)
(*                                                                          *)
(*                          QMODEM v1.05-B  &  1.1                          *)
(*                                                                          *)
(****************************************************************************)

   phone_type105    = RECORD
                         name                   : STRING[25];
                         number                 : STRING[14];
                         speed, dbits, sbits    : INTEGER;
                         parity                 : BYTE;
                      END;

(****************************************************************************)
(*                                                                          *)
(*                             QMODEM v2.0                                  *)
(*                                                                          *)
(*   parity seems to be one byte where value 0 = "N", 1 = "E", 2 = "O"      *)
(*   Bill Swenson.                                                          *)
(*                                                                          *)
(****************************************************************************)

   phone_type200    = RECORD
                         name                   : STRING[35];
                         number                 : STRING[14];
                         speed, dbits, sbits    : INTEGER;
                         parity                 : BYTE;
                         Script_File            : STRING[12];
                      END;

(****************************************************************************)
(*                                                                          *)
(*                             QMODEM v2.1                                  *)
(*                                                                          *)
(****************************************************************************)

   phone_type210    = RECORD
                         name                   : STRING[35];
                         number                 : STRING[14];
                         speed, dbits, sbits    : INTEGER;
                         parity                 : BYTE;
                         Script_File            : STRING[12];
                         date                   : STRING[8];
                         times                  : REAL;
                         protocol               : CHAR;
                         echo                   : CHAR;
                         whoknows               : ARRAY[1..30] OF CHAR;
                      END;

(****************************************************************************)
(*                                                                          *)
(*                          GT PowerComm 11.0                               *)
(*                                                                          *)
(****************************************************************************)
   ndialrec         = RECORD
                         redial    : CHAR;
                         name      : STRING[30];
                         hours     : STRING[9];
                         password  : STRING[30];
                         ccount    : INTEGER;
                         cduration : REAL;
                         cupload   : REAL;
                         cdnload   : REAL;
                         number    : STRING[14];
                         date      : STRING[8];
                         time      : STRING[5];
                         baud      : INTEGER;
                         parity    : INTEGER;
                         databits  : INTEGER;
                         stopbits  : INTEGER;
                         protocol  : CHAR;
                         script    : STRING[12];
                      END;
   ndialarray       = RECORD
                         no        : INTEGER;
                         entries   : ARRAY[ 1..16 ] OF ndialrec;
                      END;
   VAR
      nfile   : file OF ndialarray;
      ndir    : ndialarray;

   PROCEDURE
      reformat;
   {
      This procedure is intended to be used to upgrade old versions of the GT
      phone directory to the new improved style.  The program renames the old
      directory to OLD_GT.DIR and the new directory becomes GT.DIR, ready to
      use with GT v11.0.
   }
   TYPE
      odialrec   = RECORD
                      name     : STRING[30];
                      number   : STRING[30];
                      baud     : INTEGER;
                      parity   : INTEGER;
                      databits : INTEGER;
                      stopbits : INTEGER;
                   END;
      odialarray = RECORD
                      no       : INTEGER;
                      entries  : ARRAY[ 1..16 ] OF odialrec;
                   END;

   VAR
      ofile   : file OF odialarray;
      odir    : odialarray;
      i,j,k   : INTEGER;
      s       : STRING[255];
   BEGIN
      writeln;
      writeln('***********************************************************************');
      writeln('*    Make sure the old phone directory is in the default directory    *');
      writeln('*    and default drive, then press <enter> to begin or type "exit"    *');
      writeln('*    followed by <enter> to quit.                                     *');
      writeln('***********************************************************************');
      writeln;
      s[0] := #00;
      readln(s);
      IF ((s = 'exit') OR (s = 'EXIT')) THEN
         exit;
      assign(ofile,'GT.DIR');
      rename(ofile,'OLD_GT.DIR');
      reset(ofile);
      assign(nfile,'GT.DIR');
      rewrite(nfile);
      i := filesize(ofile);
      FOR j:=0 to pred(i) DO BEGIN
         seek(ofile,j);
         read(ofile,odir);
         ndir.no := odir.no;
         FOR k:=1 to 16 DO BEGIN
            ndir.entries[k].redial   := ' ';
            ndir.entries[k].date     := '';
            ndir.entries[k].time     := '';
            ndir.entries[k].password := '';
            ndir.entries[k].ccount   := 0;
            ndir.entries[k].cduration:= 0.0;
            ndir.entries[k].cupload  := 0.0;
            ndir.entries[k].cdnload  := 0.0;
            ndir.entries[k].hours    := '';
            ndir.entries[k].name     := odir.entries[k].name;
            ndir.entries[k].number   := odir.entries[k].number;
            ndir.entries[k].baud     := odir.entries[k].baud;
            ndir.entries[k].parity   := odir.entries[k].parity;
            ndir.entries[k].databits := odir.entries[k].databits;
            ndir.entries[k].stopbits := odir.entries[k].stopbits;
            ndir.entries[k].protocol := ' ';
            ndir.entries[k].script   := '';
         END;
         write(nfile,ndir);
      END;
      close(nfile);
      close(ofile);
   END;

   PROCEDURE
      reformat2;
   {
      This procedure is intended to be used to upgrade old versions of the GT
      phone directory to the new improved style.  The program renames the old
      directory to $GT.DIR and the new directory becomes GT.DIR, ready to
      use with GT v11.0.
   }
   TYPE
      odialrec   = RECORD
                      redial    : CHAR;
                      name      : STRING[30];
                      number    : STRING[14];
                      date      : STRING[8];
                      time      : STRING[5];
                      baud      : INTEGER;
                      parity    : INTEGER;
                      databits  : INTEGER;
                      stopbits  : INTEGER;
                   END;
      odialarray = RECORD
                      no       : INTEGER;
                      entries  : ARRAY[ 1..16 ] OF odialrec;
                   END;
   VAR
      ofile   : file OF odialarray;
      odir    : odialarray;
      i,j,k   : INTEGER;
      s       : STRING[255];
      dname   : STRING[50];
   BEGIN
      writeln;
      writeln('***********************************************************************');
      writeln('*    Make sure the old phone directory is in the default directory    *');
      writeln('*    and default drive, then enter the filename to begin or type      *');
      writeln('*    "exit" followed by <enter> to quit.                              *');
      writeln('***********************************************************************');
      writeln;
      s[0] := #00;
      readln(s);
      IF ((s = 'exit') OR (s = 'EXIT')) THEN
         exit;
      i := pos('.',s);
      IF (i > 0) THEN
         s[0] := CHR(Pred(i));
      IF (s[0] = #00) THEN
         dname := 'GT'
      ELSE
         dname := s;
      assign(ofile,dname+'.DIR');
      s := '$'+dname;
      IF s[0] > #08 THEN
         s[0] := #08;
      rename(ofile,s+'.DIR');
      reset(ofile);
      assign(nfile,dname+'.DIR');
      rewrite(nfile);
      i := filesize(ofile);
      FOR j:=0 to pred(i) DO BEGIN
         seek(ofile,j);
         read(ofile,odir);
         ndir.no := odir.no;
         FOR k:=1 to 16 DO BEGIN
            ndir.entries[k].redial   := odir.entries[k].redial;
            ndir.entries[k].date     := odir.entries[k].date;
            ndir.entries[k].time     := odir.entries[k].time;
            ndir.entries[k].password := '';
            ndir.entries[k].ccount   := 0;
            ndir.entries[k].cduration:= 0.0;
            ndir.entries[k].cupload  := 0.0;
            ndir.entries[k].cdnload  := 0.0;
            ndir.entries[k].hours    := '';
            ndir.entries[k].name     := odir.entries[k].name;
            ndir.entries[k].number   := odir.entries[k].number;
            ndir.entries[k].baud     := odir.entries[k].baud;
            ndir.entries[k].parity   := odir.entries[k].parity;
            ndir.entries[k].databits := odir.entries[k].databits;
            ndir.entries[k].stopbits := odir.entries[k].stopbits;
            ndir.entries[k].protocol := ' ';
            ndir.entries[k].script   := '';
         END;
         write(nfile,ndir);
      END;
      close(nfile);
      close(ofile);
   END;

   PROCEDURE
      reformat3;
   {
      This procedure is intended to be used to upgrade old versions of the GT
      phone directory to the new improved style.  The program renames the old
      directory to &GT.DIR and the new directory becomes GT.DIR, ready to
      use with GT v11.0.
   }
   TYPE
      odialrec   = RECORD
                      redial    : CHAR;
                      name      : STRING[30];
                      password  : STRING[30];
                      ccount    : INTEGER;
                      cduration : REAL;
                      number    : STRING[14];
                      date      : STRING[8];
                      time      : STRING[5];
                      baud      : INTEGER;
                      parity    : INTEGER;
                      databits  : INTEGER;
                      stopbits  : INTEGER;
                   END;

      odialarray = RECORD
                      no       : INTEGER;
                      entries  : ARRAY[ 1..16 ] OF odialrec;
                   END;
   VAR
      ofile   : file OF odialarray;
      odir    : odialarray;
      i,j,k   : INTEGER;
      s       : STRING[255];
      dname   : STRING[50];
   BEGIN
      writeln;
      writeln('***********************************************************************');
      writeln('*    Make sure the old phone directory is in the default directory    *');
      writeln('*    and default drive, then enter the filename to begin or type      *');
      writeln('*    "exit" followed by <enter> to quit.                              *');
      writeln('***********************************************************************');
      writeln;
      s[0] := #00;
      readln(s);
      IF ((s = 'exit') OR (s = 'EXIT')) THEN
         exit;
      i := pos('.',s);
      IF (i > 0) THEN
         s[0] := CHR(Pred(i));
      IF (s[0] = #00) THEN
         dname := 'GT'
      ELSE
         dname := s;
      assign(ofile,dname+'.DIR');
      s := '&'+dname;
      IF s[0] > #08 THEN
         s[0] := #08;
      rename(ofile,s+'.DIR');
      reset(ofile);
      assign(nfile,dname+'.DIR');
      rewrite(nfile);
      i := filesize(ofile);
      FOR j:=0 to pred(i) DO BEGIN
         seek(ofile,j);
         read(ofile,odir);
         ndir.no := odir.no;
         FOR k:=1 to 16 DO BEGIN
            ndir.entries[k].redial   := odir.entries[k].redial;
            ndir.entries[k].date     := odir.entries[k].date;
            ndir.entries[k].time     := odir.entries[k].time;
            ndir.entries[k].password := odir.entries[k].password;
            ndir.entries[k].ccount   := odir.entries[k].ccount;
            ndir.entries[k].cduration:= odir.entries[k].cduration;
            ndir.entries[k].cupload  := 0.0;
            ndir.entries[k].cdnload  := 0.0;
            ndir.entries[k].hours    := '';
            ndir.entries[k].name     := odir.entries[k].name;
            ndir.entries[k].number   := odir.entries[k].number;
            ndir.entries[k].baud     := odir.entries[k].baud;
            ndir.entries[k].parity   := odir.entries[k].parity;
            ndir.entries[k].databits := odir.entries[k].databits;
            ndir.entries[k].stopbits := odir.entries[k].stopbits;
            ndir.entries[k].protocol := ' ';
            ndir.entries[k].script   := '';
         END;
         write(nfile,ndir);
      END;
      close(nfile);
      close(ofile);
   END;

   PROCEDURE
      reformat4;
   {
      This procedure is intended to be used to upgrade old versions of the GT
      phone directory to the new improved style.  The program renames the old
      directory to !GT.DIR and the new directory becomes GT.DIR, ready to
      use with GT v11.0.
   }
   TYPE
      odialrec   = RECORD
                      redial    : CHAR;
                      name      : STRING[30];
                      password  : STRING[30];
                      ccount    : INTEGER;
                      cduration : REAL;
                      cupload   : REAL;
                      cdnload   : REAL;
                      number    : STRING[14];
                      date      : STRING[8];
                      time      : STRING[5];
                      baud      : INTEGER;
                      parity    : INTEGER;
                      databits  : INTEGER;
                      stopbits  : INTEGER;
                   END;

      odialarray = RECORD
                      no       : INTEGER;
                      entries  : ARRAY[ 1..16 ] OF odialrec;
                   END;
   VAR
      ofile   : file OF odialarray;
      odir    : odialarray;
      i,j,k   : INTEGER;
      s       : STRING[255];
      dname   : STRING[50];
   BEGIN
      writeln;
      writeln('***********************************************************************');
      writeln('*    Make sure the old phone directory is in the default directory    *');
      writeln('*    and default drive, then enter the filename to begin or type      *');
      writeln('*    "exit" followed by <enter> to quit.                              *');
      writeln('***********************************************************************');
      writeln;
      s[0] := #00;
      readln(s);
      IF ((s = 'exit') OR (s = 'EXIT')) THEN
         exit;
      i := pos('.',s);
      IF (i > 0) THEN
         s[0] := CHR(Pred(i));
      IF (s[0] = #00) THEN
         dname := 'GT'
      ELSE
         dname := s;
      assign(ofile,dname+'.DIR');
      s := '!'+dname;
      IF s[0] > #08 THEN
         s[0] := #08;
      rename(ofile,s+'.DIR');
      reset(ofile);
      assign(nfile,dname+'.DIR');
      rewrite(nfile);
      i := filesize(ofile);
      FOR j:=0 to pred(i) DO BEGIN
         seek(ofile,j);
         read(ofile,odir);
         ndir.no := odir.no;
         FOR k:=1 to 16 DO BEGIN
            ndir.entries[k].redial   := odir.entries[k].redial;
            ndir.entries[k].date     := odir.entries[k].date;
            ndir.entries[k].time     := odir.entries[k].time;
            ndir.entries[k].password := odir.entries[k].password;
            ndir.entries[k].ccount   := odir.entries[k].ccount;
            ndir.entries[k].cduration:= odir.entries[k].cduration;
            ndir.entries[k].cupload  := odir.entries[k].cupload;
            ndir.entries[k].cdnload  := odir.entries[k].cdnload;
            ndir.entries[k].hours    := '';
            ndir.entries[k].name     := odir.entries[k].name;
            ndir.entries[k].number   := odir.entries[k].number;
            ndir.entries[k].baud     := odir.entries[k].baud;
            ndir.entries[k].parity   := odir.entries[k].parity;
            ndir.entries[k].databits := odir.entries[k].databits;
            ndir.entries[k].stopbits := odir.entries[k].stopbits;
            ndir.entries[k].protocol := ' ';
            ndir.entries[k].script   := '';
         END;
         write(nfile,ndir);
      END;
      close(nfile);
      close(ofile);
   END;

   PROCEDURE
      reformat5;
   {
      This procedure is intended to be used to upgrade old versions of the GT
      phone directory to the new improved style.  The program renames the old
      directory to #GT.DIR and the new directory becomes GT.DIR, ready to
      use with GT v11.0.
   }
   TYPE
      odialrec   = RECORD
                      redial    : CHAR;
                      name      : STRING[30];
                      hours     : STRING[5];
                      password  : STRING[30];
                      ccount    : INTEGER;
                      cduration : REAL;
                      cupload   : REAL;
                      cdnload   : REAL;
                      number    : STRING[14];
                      date      : STRING[8];
                      time      : STRING[5];
                      baud      : INTEGER;
                      parity    : INTEGER;
                      databits  : INTEGER;
                      stopbits  : INTEGER;
                   END;

      odialarray = RECORD
                      no       : INTEGER;
                      entries  : ARRAY[ 1..16 ] OF odialrec;
                   END;
   VAR
      ofile   : file OF odialarray;
      odir    : odialarray;
      i,j,k   : INTEGER;
      s       : STRING[255];
      dname   : STRING[50];
   BEGIN
      writeln;
      writeln('***********************************************************************');
      writeln('*    Make sure the old phone directory is in the default directory    *');
      writeln('*    and default drive, then enter the filename to begin or type      *');
      writeln('*    "exit" followed by <enter> to quit.                              *');
      writeln('***********************************************************************');
      writeln;
      s[0] := #00;
      readln(s);
      IF ((s = 'exit') OR (s = 'EXIT')) THEN
         exit;
      i := pos('.',s);
      IF (i > 0) THEN
         s[0] := CHR(Pred(i));
      IF (s[0] = #00) THEN
         dname := 'GT'
      ELSE
         dname := s;
      assign(ofile,dname+'.DIR');
      s := '#'+dname;
      IF s[0] > #08 THEN
         s[0] := #08;
      rename(ofile,s+'.DIR');
      reset(ofile);
      assign(nfile,dname+'.DIR');
      rewrite(nfile);
      i := filesize(ofile);
      FOR j:=0 to pred(i) DO BEGIN
         seek(ofile,j);
         read(ofile,odir);
         ndir.no := odir.no;
         FOR k:=1 to 16 DO BEGIN
            ndir.entries[k].redial   := odir.entries[k].redial;
            ndir.entries[k].date     := odir.entries[k].date;
            ndir.entries[k].time     := odir.entries[k].time;
            ndir.entries[k].password := odir.entries[k].password;
            ndir.entries[k].ccount   := odir.entries[k].ccount;
            ndir.entries[k].cduration:= odir.entries[k].cduration;
            ndir.entries[k].cupload  := odir.entries[k].cupload;
            ndir.entries[k].cdnload  := odir.entries[k].cdnload;
            ndir.entries[k].hours    := odir.entries[k].hours;
            ndir.entries[k].name     := odir.entries[k].name;
            ndir.entries[k].number   := odir.entries[k].number;
            ndir.entries[k].baud     := odir.entries[k].baud;
            ndir.entries[k].parity   := odir.entries[k].parity;
            ndir.entries[k].databits := odir.entries[k].databits;
            ndir.entries[k].stopbits := odir.entries[k].stopbits;
            ndir.entries[k].protocol := ' ';
            ndir.entries[k].script   := '';
         END;
         write(nfile,ndir);
      END;
      close(nfile);
      close(ofile);
   END;

   PROCEDURE
      reformat6;
   {
      This procedure is intended to be used to upgrade old versions of the GT
      phone directory to the new improved style.  The program renames the old
      directory to #GT.DIR and the new directory becomes GT.DIR, ready to
      use with GT v11.0.
   }
   TYPE
      odialrec   = RECORD
                      redial    : CHAR;
                      name      : STRING[30];
                      hours     : STRING[9];
                      password  : STRING[30];
                      ccount    : INTEGER;
                      cduration : REAL;
                      cupload   : REAL;
                      cdnload   : REAL;
                      number    : STRING[14];
                      date      : STRING[8];
                      time      : STRING[5];
                      baud      : INTEGER;
                      parity    : INTEGER;
                      databits  : INTEGER;
                      stopbits  : INTEGER;
                   END;

      odialarray = RECORD
                      no       : INTEGER;
                      entries  : ARRAY[ 1..16 ] OF odialrec;
                   END;
   VAR
      ofile   : file OF odialarray;
      odir    : odialarray;
      i,j,k   : INTEGER;
      s       : STRING[255];
      dname   : STRING[50];
   BEGIN
      writeln;
      writeln('***********************************************************************');
      writeln('*    Make sure the old phone directory is in the default directory    *');
      writeln('*    and default drive, then enter the filename to begin or type      *');
      writeln('*    "exit" followed by <enter> to quit.                              *');
      writeln('***********************************************************************');
      writeln;
      s[0] := #00;
      readln(s);
      IF ((s = 'exit') OR (s = 'EXIT')) THEN
         exit;
      i := pos('.',s);
      IF (i > 0) THEN
         s[0] := CHR(Pred(i));
      IF (s[0] = #00) THEN
         dname := 'GT'
      ELSE
         dname := s;
      assign(ofile,dname+'.DIR');
      s := '_'+dname;
      IF s[0] > #08 THEN
         s[0] := #08;
      rename(ofile,s+'.DIR');
      reset(ofile);
      assign(nfile,dname+'.DIR');
      rewrite(nfile);
      i := filesize(ofile);
      FOR j:=0 to pred(i) DO BEGIN
         seek(ofile,j);
         read(ofile,odir);
         ndir.no := odir.no;
         FOR k:=1 to 16 DO BEGIN
            ndir.entries[k].redial   := odir.entries[k].redial;
            ndir.entries[k].date     := odir.entries[k].date;
            ndir.entries[k].time     := odir.entries[k].time;
            ndir.entries[k].password := odir.entries[k].password;
            ndir.entries[k].ccount   := odir.entries[k].ccount;
            ndir.entries[k].cduration:= odir.entries[k].cduration;
            ndir.entries[k].cupload  := odir.entries[k].cupload;
            ndir.entries[k].cdnload  := odir.entries[k].cdnload;
            ndir.entries[k].hours    := odir.entries[k].hours;
            ndir.entries[k].name     := odir.entries[k].name;
            ndir.entries[k].number   := odir.entries[k].number;
            ndir.entries[k].baud     := odir.entries[k].baud;
            ndir.entries[k].parity   := odir.entries[k].parity;
            ndir.entries[k].databits := odir.entries[k].databits;
            ndir.entries[k].stopbits := odir.entries[k].stopbits;
            ndir.entries[k].protocol := ' ';
            ndir.entries[k].script   := '';
         END;
         write(nfile,ndir);
      END;
      close(nfile);
      close(ofile);
   END;

   PROCEDURE
      printout;
   CONST
      pt      : ARRAY[0..2] OF CHAR = ('N','E','O');
      blanks  = '                                          ';

   VAR
      i,j,k    : INTEGER;
      s        : STRING[80];
      pname    : STRING[50];
      dname    : STRING[50];
      prt_file : TEXT;
      t        : INTEGER;

   BEGIN
      writeln;
      writeln('***********************************************************************');
      writeln('*    Make sure the phone directory is in the default directory and    *');
      writeln('*    default drive, then press <enter> when ready to begin or type    *');
      writeln('*    "exit" followed by <enter> to quit.   If you wish the output     *');
      writeln('*    to go to a file, instead of the printer, enter the filename.     *');
      writeln('***********************************************************************');
      writeln;
      s[0] := #00;
      readln(s);
      IF ((s = 'exit') OR (s = 'EXIT')) THEN
         exit;
      IF (s[0] = #00) THEN
         pname := 'LST:'
      ELSE
         pname := s;
      writeln;
      writeln('*****************************************************************');
      writeln('*    Type the name of the directory to be printed, or "exit"    *');
      writeln('*    to quit, followed by <enter>.                              *');
      writeln('*****************************************************************');
      writeln;
      s[0] := #00;
      readln(s);
      IF ((s = 'exit') OR (s = 'EXIT')) THEN
         exit;
      i := pos('.',s);
      IF (i > 0) THEN
         s[0] := CHR(Pred(i));
      IF (s[0] = #00) THEN
         dname := 'GT.DIR'
      ELSE
         dname := s+'.DIR';
      assign(nfile,dname);
      reset(nfile);
      assign(prt_file,pname);
      rewrite(prt_file);
      i := filesize(nfile);
      FOR j:=0 to Pred(i) DO BEGIN
         seek(nfile,j);
         read(nfile,ndir);
         FOR k:=1 to ndir.no DO BEGIN
            with ndir.entries[k] DO BEGIN
               s := copy(name+blanks,1,31);
               write(prt_file,s);
               s := copy(number+blanks,1,15);
               write(prt_file,s);
               write(prt_file,ccount:2,' ');
               t := trunc(cduration / 60.0);
               write(prt_file,t:2,':');
               t := trunc(cduration - (int(t) * 60.0));
               str(t:2,s);
               IF s[1]=' ' THEN s[1]:='0';
               write(prt_file,s,' ');
               s := copy(date+blanks,1,9);
               write(prt_file,s);
               s := copy(time+blanks,1,6);
               write(prt_file,s);
               writeln(prt_file,baud:4);
            END;
         END;
      END;
      close(nfile);
      close(prt_file);
   END;

   PROCEDURE
      import;
   CONST
      maxaccum = 5;
   VAR
      i,j,k    : INTEGER;
      s        : STRING[255];
      t        : CHAR;
      accum    : ARRAY[0..5] OF STRING[255];
      pname    : STRING[50];
      inp_file : TEXT;
      cont     : BOOLEAN;
   BEGIN
      writeln;
      writeln('***********************************************************************');
      writeln('*    Enter "exit" followed by <enter> to quit.   To continue enter    *');
      writeln('*    the name of the ASCII input file at this time.                   *');
      writeln('***********************************************************************');
      writeln;
      s[0] := #00;
      readln(s);
      IF ((s = 'exit') OR (s = 'EXIT') OR (s = '')) THEN
         exit;
      assign(inp_file,s);
      reset(inp_file);
      writeln;
      writeln('*************************************************************************');
      writeln('*    Enter "exit" followed by <enter> to quit.   To continue enter      *');
      writeln('*    the name of the output file at this time, (GT format directory).   *');
      writeln('*    WARNING: The existing contents of the output file will be lost!    *');
      writeln('*************************************************************************');
      writeln;
      s[0] := #00;
      readln(s);
      IF ((s = 'exit') OR (s = 'EXIT') OR (s = '')) THEN BEGIN
         close(inp_file);
         exit;
      END;
      i := pos('.',s);
      IF (i > 0) THEN
         s[0] := CHAR(Pred(i));
      assign(nfile,s+'.DIR');
      rewrite(nfile);
      ndir.no := 0;
      WHILE (NOT eof(inp_file)) DO BEGIN
          readln(inp_file,s);
          ndir.no := Succ(ndir.no);
          IF (ndir.no > 16) THEN BEGIN
             ndir.no := 16;
             write(nfile,ndir);
             ndir.no := 1;
          END;
          While ((s[1] in [' ','.']) AND (s[0] > #00)) DO
             delete(s,1,1);
          with ndir.entries[ndir.no] DO BEGIN
             redial := ' ';
             name := '';
             hours := '';
             password := '';
             protocol := ' ';
             script := '';
             ccount := 0;
             cduration := 0.0;
             cupload   := 0.0;
             cdnload   := 0.0;
             number := '';
             date := '';
             time := '';
             baud := 1200;
             parity := 0;
             databits := 8;
             stopbits := 1;
             FOR k:=0 to maxaccum DO
                accum[k] := '';
             k := 0;
             WHILE ((k <= maxaccum) AND (s[0] > #00)) DO BEGIN
                cont := true;
                While (cont) DO BEGIN
                   accum[k] := accum[k] + s[1];
                   t := s[1];
                   delete(s,1,1);
                   IF (s[0] = #00) THEN
                      cont := false
                   else
                      IF (s[0] < #03) THEN
                         cont := true
                      else
                         IF ((s[1]=' ') and (accum[k][1] in ['1'..'9','('])) THEN
                            cont := false
                         else
                            IF ((s[1] in ['_',' ','.']) and (s[2] = s[1])) THEN
                               cont := false
                            else
                               IF ((s[1] in ['!','#','*','@']) and (t in ['0'..'9','('])) THEN
                                  cont := false;
                END;
                k := succ(k);
                while ((s[0] > #00) and (NOT (s[1] in ['a'..'z','A'..'Z','0'..'9','(']))) DO
                   delete(s,1,1);
             END;
             k := 0;
             cont := true;
             while ((cont) and (k <= maxaccum)) DO BEGIN
                IF accum[k][0] > #00 THEN BEGIN
                   IF (accum[k][1] in ['0'..'9','(']) THEN BEGIN
                      number := copy(accum[k],1,14);
                      cont := false;
                      IF (k = 0) THEN
                         k := 1
                      else
                         k := 0;
                      FOR i:=2 TO maxaccum DO BEGIN
                         IF (accum[i][0] > #00) THEN
                         accum[k] := accum[k] + '-' + accum[i];
                      END;
                      name := copy(accum[k],1,30);
                   END;
                END;
                k := succ(k);
             END;
          END;
      END;
      IF (ndir.no > 0) THEN
         write(nfile,ndir);
      close(nfile);
      close(inp_file);
   END;

   PROCEDURE
      qmod105_import;
   VAR
      i,j,k    : INTEGER;
      qname    : STRING[50];
      pname    : STRING[50];
      cont     : BOOLEAN;
      qdir     : phone_type105;
      qfile    : file of phone_type105;
      qrec     : INTEGER;
      qsize    : INTEGER;
      s        : STRING[255];
   BEGIN
      writeln;
      writeln('***********************************************************************');
      writeln('*    Enter "exit" followed by <enter> to quit.   To continue enter    *');
      writeln('*    the name of the Qmodem 1.05 FON file at this time.               *');
      writeln('***********************************************************************');
      writeln;
      s[0] := #00;
      readln(s);
      IF ((s = 'exit') OR (s = 'EXIT') OR (s = '')) THEN
         exit;
      i := pos('.',s);
      IF (i > 0) THEN
         s[0] := CHAR(Pred(i));
      assign(qfile,s+'.FON');
      reset(qfile);
      writeln;
      writeln('*************************************************************************');
      writeln('*    Enter "exit" followed by <enter> to quit.   To continue enter      *');
      writeln('*    the name of the output file at this time, (GT format directory).   *');
      writeln('*    WARNING: The existing contents of the output file will be lost!    *');
      writeln('*************************************************************************');
      writeln;
      s[0] := #00;
      readln(s);
      IF ((s = 'exit') OR (s = 'EXIT') OR (s = '')) THEN BEGIN
         close(qfile);
         exit;
      END;
      i := pos('.',s);
      IF (i > 0) THEN
         s[0] := CHAR(Pred(i));
      assign(nfile,s+'.DIR');
      rewrite(nfile);
      ndir.no := 0;
      qsize := filesize(qfile);
      FOR i := 0 TO Pred(qsize) DO BEGIN
         seek(qfile,i);
         read(qfile,qdir);
         IF (copy(qdir.name,1,10) <> '----------') THEN BEGIN
            ndir.no := Succ(ndir.no);
            IF (ndir.no > 16) THEN BEGIN
               ndir.no := 16;
               write(nfile,ndir);
               ndir.no := 1;
            END;
            with ndir.entries[ndir.no] DO BEGIN
               redial := ' ';
               hours := '';
               name := qdir.name;
               password := '';
               protocol := ' ';
               script := '';
               ccount := 0;
               cduration := 0.0;
               cupload   := 0.0;
               cdnload   := 0.0;
               number := qdir.number;
               date := '';
               time := '';
               baud := qdir.speed;
               parity := qdir.parity;
               databits := qdir.dbits;
               stopbits := qdir.sbits;
            END;
         END;
      END;
      IF (ndir.no > 0) THEN
         write(nfile,ndir);
      close(nfile);
      close(qfile);
   END;

   PROCEDURE
      qmod200_import;
   VAR
      i,j,k    : INTEGER;
      qname    : STRING[50];
      pname    : STRING[50];
      cont     : BOOLEAN;
      qdir     : phone_type200;
      qfile    : file of phone_type200;
      qrec     : INTEGER;
      qsize    : INTEGER;
      s        : STRING[255];
   BEGIN
      writeln;
      writeln('***********************************************************************');
      writeln('*    Enter "exit" followed by <enter> to quit.   To continue enter    *');
      writeln('*    the name of the Qmodem 2.00 FON file at this time.               *');
      writeln('***********************************************************************');
      writeln;
      s[0] := #00;
      readln(s);
      IF ((s = 'exit') OR (s = 'EXIT') OR (s = '')) THEN
         exit;
      assign(qfile,s);
      reset(qfile);
      writeln;
      writeln('*************************************************************************');
      writeln('*    Enter "exit" followed by <enter> to quit.   To continue enter      *');
      writeln('*    the name of the output file at this time, (GT format directory).   *');
      writeln('*    WARNING: The existing contents of the output file will be lost!    *');
      writeln('*************************************************************************');
      writeln;
      s[0] := #00;
      readln(s);
      IF ((s = 'exit') OR (s = 'EXIT') OR (s = '')) THEN BEGIN
         close(qfile);
         exit;
      END;
      i := pos('.',s);
      IF (i > 0) THEN
         s[0] := CHAR(Pred(i));
      assign(nfile,s+'.DIR');
      rewrite(nfile);
      ndir.no := 0;
      qsize := filesize(qfile);
      FOR i := 0 TO Pred(qsize) DO BEGIN
         seek(qfile,i);
         read(qfile,qdir);
         IF (copy(qdir.name,1,10) <> '----------') THEN BEGIN
            ndir.no := Succ(ndir.no);
            IF (ndir.no > 16) THEN BEGIN
               ndir.no := 16;
               write(nfile,ndir);
               ndir.no := 1;
            END;
            with ndir.entries[ndir.no] DO BEGIN
               redial := ' ';
               hours := '';
               name := qdir.name;
               password := '';
               protocol := ' ';
               script := '';
               ccount := 0;
               cduration := 0.0;
               cupload   := 0.0;
               cdnload   := 0.0;
               number := qdir.number;
               date := '';
               time := '';
               baud := qdir.speed;
               parity := qdir.parity;
               databits := qdir.dbits;
               stopbits := qdir.sbits;
            END;
         END;
      END;
      IF (ndir.no > 0) THEN
         write(nfile,ndir);
      close(nfile);
      close(qfile);
   END;

   PROCEDURE
      qmod210_import;
   VAR
      i,j,k    : INTEGER;
      qname    : STRING[50];
      pname    : STRING[50];
      cont     : BOOLEAN;
      qdir     : phone_type210;
      qfile    : file of phone_type210;
      qrec     : INTEGER;
      qsize    : INTEGER;
      s        : STRING[255];
   BEGIN
      writeln;
      writeln('***********************************************************************');
      writeln('*    Enter "exit" followed by <enter> to quit.   To continue enter    *');
      writeln('*    the name of the Qmodem 2.10 FON file at this time.               *');
      writeln('***********************************************************************');
      writeln;
      s[0] := #00;
      readln(s);
      IF ((s = 'exit') OR (s = 'EXIT') OR (s = '')) THEN
         exit;
      assign(qfile,s);
      reset(qfile);
      writeln;
      writeln('*************************************************************************');
      writeln('*    Enter "exit" followed by <enter> to quit.   To continue enter      *');
      writeln('*    the name of the output file at this time, (GT format directory).   *');
      writeln('*    WARNING: The existing contents of the output file will be lost!    *');
      writeln('*************************************************************************');
      writeln;
      s[0] := #00;
      readln(s);
      IF ((s = 'exit') OR (s = 'EXIT') OR (s = '')) THEN BEGIN
         close(qfile);
         exit;
      END;
      i := pos('.',s);
      IF (i > 0) THEN
         s[0] := CHAR(Pred(i));
      assign(nfile,s+'.DIR');
      rewrite(nfile);
      ndir.no := 0;
      qsize := filesize(qfile);
      FOR i := 0 TO Pred(qsize) DO BEGIN
         seek(qfile,i);
         read(qfile,qdir);
         IF (copy(qdir.name,1,10) <> '----------') THEN BEGIN
            ndir.no := Succ(ndir.no);
            IF (ndir.no > 16) THEN BEGIN
               ndir.no := 16;
               write(nfile,ndir);
               ndir.no := 1;
            END;
            with ndir.entries[ndir.no] DO BEGIN
               redial := ' ';
               hours := '';
               name := qdir.name;
               password := '';
               protocol := ' ';
               script := '';
               ccount := trunc(qdir.times);
               cduration := 0.0;
               cupload   := 0.0;
               cdnload   := 0.0;
               number := qdir.number;
               date := qdir.date;
               time := '';
               baud := qdir.speed;
               parity := qdir.parity;
               databits := qdir.dbits;
               stopbits := qdir.sbits;
            END;
         END;
      END;
      IF (ndir.no > 0) THEN
         write(nfile,ndir);
      close(nfile);
      close(qfile);
   END;

VAR
   i  : INTEGER;

BEGIN
   writeln;
   writeln('*************************** MENU *******************************');
   writeln('*     1.  Convert Pre 4.20 Phone Directory to New Format.      *');
   writeln('*     2.  Convert 4.20 - 7.10 Phone Directory to New Format.   *');
   writeln('*     3.  Convert 8.xx Phone Directory to New Format.          *');
   writeln('*     4.  Convert 9.00 Phone Directory to New Format.          *');
   writeln('*     5.  Convert 9.10 Phone Directory to New Format.          *');
   writeln('*     6.  Convert 9.20 - 10.20 Phone Directory to New Format.  *');
   writeln('*     7.  Convert Qmodem 1.05 .FON to GT Directory Format.     *');
   writeln('*     8.  Convert Qmodem 2.00 .FON to GT Directory Format.     *');
   writeln('*     9.  Convert Qmodem 2.10 .FON to GT Directory Format.     *');
   writeln('*    10.  Print GT Directory to a file or System Printer.      *');
   writeln('*    11.  Import Text List to GT Directory Format.             *');
   writeln('****************************************************************');
   writeln;
   write('     Enter the number of your selection: ');
   readln(i);
   CASE i OF
      1 : reformat;
      2 : reformat2;
      3 : reformat3;
      4 : reformat4;
      5 : reformat5;
      6 : reformat6;
      7 : qmod105_import;
      8 : qmod200_import;
      9 : qmod210_import;
     10 : printout;
     11 : import;
   END;
END.
