/* Gets the current working directory, like getcwd(), but for any drive. */

/* Copyright 1986 John Navas II, All Rights Reserved.
GETCWDRV is made available for personal, non-commercial use only.  You
are granted a limited license to use GETCWDRV, and to copy it and
distribute it, provided that no fee is charged for such copying and
distribution, and that it is ONLY distributed in its original,
unmodified state. */

/* Language: Microsoft C Version 3.00 */

#include <direct.h>
#include <dos.h>
#include <stdio.h>

char *getcwdrv( p, l, d )				/* GET CURR WORKING DIR ANY DRIVE */
char *p;								/* path name string */
int l;									/* length */
int d;									/* drive ( 0 = default; 1 = A... ) */
{
	union REGS reg;
	register char *q;
	char cd;

	if ( ! ( cd = (char) d ) ||			/* no drive specified */
										/* report current drive */
			( cd = (char) bdos( 0x19, 0, 0 ) ) == --(char)d ||
										/* change drives if needed */
			(char) bdos( 0x0E, (unsigned int) (char) d, 0 ) > (char) d ) {
		q = getcwd( p, l );				/* library function */
										/* reselect original drive */
		if ( cd != (char) d ) bdos( 0x0E, (unsigned int) cd, 0 );
		}
	else q = NULL;						/* invalid drive */
	return q;
	}
