	TITLE	LQ15OO Printer Setup Utility
	PAGE	60,132

; Written by Rick Schaeffer (70120,174)
;	     E. 2121 Upriver Dr. Apt. 11
;	     Spokane, Wa.  99207
;
; Original modified extensively by Bob Lloyd  4/27/1984 to take
; advantage of Z100 features.
;
; Modified for Epson FX-80 commands 15-Apr-85
;
;	  by Richard W Sheeres
;	     Capitol Heath Users Group
;	     Bolling AFB, Washington DC
;
; Modified for Epson LQ1500 commands 21-Nov-85
; Modified for Z100PC (Z150) 23-Nov-85
;
;	  by Don M. Deck
;	     P.O. Box 1240
;	     Lone Pine, CA 93545
;
; This program provides a means of setting the various print modes on
; an Epson LQ1500 printer.  With a few exceptions this includes any of
; the Epson family that supports the graftrax option.  In addition, the
; program can easily be configured for other types of "intelligent"
; printers.  Assemble this program with the following commands:
;
;	MASM LQ1500,LQ1500;	to create LQ1500.OBJ
;	LINK LQ1500,LQ1500;	to create LQ1500.EXE
;	EXE2BIN LQ1500.EXE.COM  to create LQ1500.COM
;
; and delete the .OBJ and .EXE files.
;
; To have the program print a list of its options, type "LQ1500" (with
; no parameters).  To invoke an option, type "LQ1500 X" where "X"
; represents the option you wish to invoke.  You may include any number
; of options on the same command line and they may be mixed in any
; fashion.  For example:
;
;	LQ1500 RLI
;
; The above example will reset all other options (the "R"), set letter
; quality (the "L"), and set italic style (the "I").
;
TRUE	EQU	0FFFFH
FALSE	EQU	NOT TRUE
Z100PC	EQU	TRUE			;ASSEMBLE FOR Z100PC (Z150...)
;					;OTHERWISE ASSEMBLES FOR Z100
;
; SOME ASCII CODES
;
LF	EQU	0AH
FF	EQU	0CH
CR	EQU	0DH
SHFI	EQU	0FH
DC2	EQU	12H
DC4	EQU	14H
CAN	EQU	18H
ESC	EQU	1BH
DEL	EQU	7FH

; ENDING DELIMITERS

ENDCON	EQU	0FDH			;END OF CONSOLE STRING
ENDPRN	EQU	0FEH			;END OF PRINT STRING
ENDTBL	EQU	0FFH			;END OF PRINT CODE TABLE

;DOS EQUATES

CMDLINE	EQU	80H			;OFFSET TO COMMAND LINE
DOSEXIT	EQU	20H			;PROGRAM TERMINATION INTERRUPT
DOSFUNC	EQU	21H			;DOS FUNCTION REQUEST INTERRUPT
PRTFUNC	EQU	05H			;PRINT OUTPUT FUNCTION
CONFUNC EQU	02H			;CONSOLE OUTPUT FUNCTION

CODESEG SEGMENT
	ASSUME CS:CODESEG,SS:CODESEG,DS:CODESEG

	ORG	100H			;.COM FILE

START:	JMP	BEGIN

	IF	Z100PC

; IBM CLEAR SCREEN (SEE PAGE 6.16 PROGRAMMER'S UTILITY PACK)
;
; 	AH=6 	VIDEO I/O SCROLL ACTIVE PAGE UP FUNCTION
;	AL=0	ERASE ENTIRE WINDOW
;	CH=0	ROW OF UPPER LEFT-HAND CORNER OF SCROLL
;	CL=0	COLUMN OF UPPER LEFT-HAND CORNER OF SCROLL
;	DH=24	ROW OF LOWER RIGHT-HAND CORNER OF SCROLL
;	DL=79	COLUMN OF LOWER RIGHT-HAND CORNER OF SCROLL
;	BH=2	ATTRIBUTE BYTE FOR ERASED LINE (GREEN ON BLACK)
;
CLRSCN: MOV	AX,0600H		;CLEAR SCREEN (AH=6, AL=0)
	MOV	CX,0			;ERASE LINES 1-24,COLUMNS 1-80
	MOV	DH,24			;ROW
	MOV	DL,79			;COLUMN
	MOV	BH,2			;GREEN ON BLACK
	INT	10H			;IBM VIDEO I/O INTERRUPT

; IBM HOME CURSOR (SEE PAGE 6.15 PROGRAMMER'S UTILITY PACK)
;
;	AH=2	VIDEO I/O SET CURSOR POSITION FUNCTION
;	DH=0	ROW    - 0 IS UPPER MOST ROW
;	DL=0	COLUMN - 0 IS LEFT MOST COLUMN
;	BH=0	PAGE NUMBER
;
	MOV	AH,2			;SET CURSOR POSITION
	MOV	DX,0			;HOME CURSOR
	MOV	BH,0			;PAGE
	INT	10H			;IBM VIDEO I/O INTERRUPT
	RET

	ELSE
 
; Z100 CLEAR SCREEN AND HOME CURSOR
;
CLRSCN:	MOV	SI,OFFSET CLRMSG	;POINT TO STRING
	CALL	DSP_STRING		;WRITE STRING TO CONSOLE
CLRMSG	DB	ESC,'E',ENDCON		;H19 CLEAR SCREEN/HOME CURSOR
	RET

	ENDIF
;
; MAIN PROGRAM
;
BEGIN:  MOV     BX,CMDLINE		;GET COMMAND LINE OFFSET
        MOV     AL,[BX]			;GET COMMAND LINE LENGTH
        MOV     BYTE PTR FMATCH,0	;RESET FOUND MATCH FLAG
	CMP	AL,0			;IF LENGTH NOT ZERO
	JNZ	PARSECMD		;PROCESS COMMAND LINE
;
;	DISPLAY HELP MESSAGE ON CONSOLE
;
DSP_HELP:
	CALL	CLRSCN			;ELSE, CLEAR SCREEN
	MOV	SI,OFFSET HELPMSG	;POINT TO HELP STRINGS
DSP_STRING:
	MOV	DL,[SI]			;GET A BYTE
	CMP	DL,ENDCON		;IS IT END OF STRING?
	JZ	EXIT_DOS		;YES...TERMINATE PROGRAM
	PUSH	SI			;SAVE POINTER
	MOV	AH,CONFUNC		;SETUP CONSOLE FUNCTION
	INT	DOSFUNC			;DISPLAY CHARACTER
	POP	SI			;RETRIEVE POINTER
	INC	SI			;BUMP TO NEXT CHARACTER
	JMP	DSP_STRING		;LOOP FOR NEXT CHARACTER
;
; PARSE COMMAND LINE AND CHECK EACH PRINTER CODE AGAINST TABLE. IF
; FOUND, SEND CONTROL CODE STRING TO PRINTER, OTHERWISE SKIP TO NEXT
; COMMAND LINE ENTRY.  IF ALL ENTRIES ON COMMAND LINE ARE NOT IN THE
; TABLE, DISPLAY THE HELP MESSAGE.
;
PARSECMD:
        CMP     AL,0			;IF LENGTH ZERO
        JZ      CHK_FMATCH		;CHECK FOR COMMAND LINE MATCH
        INC     BX			;BUMP TO NEXT CHARACTER
        DEC     AL			;DECREMENT COUNT
        MOV     AH,[BX]			;GET COMMAND LINE CHARACTER
        CMP     AH,'a' 			;COMPARE TO 'a'
        JL      CHK_TABLE		;IF NOT LOWERCASE LETTER
        CMP     AH,'z'			;COMPARE TO 'z'
        JG      CHK_TABLE		;IF NOT LOWERCASE LETTER
        AND     AH,0DFH			;ELSE CONVERT TO UPPER CASE

; CHECK TABLE FOR CODE FROM COMMAND LINE

CHK_TABLE:
        PUSH    BX			;SAVE COMMAND LINE INDEX
        PUSH    AX			;SAVE LENGTH
        CALL    FIND_CODE		;FIND CODE & SEND TO PRINTER
        POP     AX			;RETRIEVE COUNT
        POP     BX			;AND POINTER
        JMP     PARSECMD		;LOOP BACK FOR MORE
;
; IF COMMAND LINE CONTAINED CODE(S), FMATCH WILL BE SET TO 1
; AND PROGRAM TERMINATES.  OTHERWISE, FMATCH WILL BE SET TO 0
; AND HELPMSG IS DISPLAYED.
;
CHK_FMATCH:
        CMP     BYTE PTR FMATCH,0	;DID WE GET A MATCH?
        JNZ     EXIT_DOS		;YES...JUST EXIT
	JMP	DSP_HELP		;NO...DISPLAY HELP SCREEN

; EXIT TO MSDOS

EXIT_DOS:
	INT	DOSEXIT			;TERMINATE PROGRAM
;
; LOCATE THE COMMAND CODE IN TABLE & SEND TO PRINTER
;
FIND_CODE:
	MOV	SI,OFFSET LQ_TABLE	;POINT AT TABLE
FC_LOOP:
	CMP	BYTE PTR [SI],ENDTBL	;AT END OF TABLE?
	JZ	PRT_EXIT		;YES...EXIT FIND_CODE
	CMP	[SI],AH			;MATCH?
	JZ	PRT_CODE		;YES...SEND CODE TO PRINTER
SKIP:					;NO, LOOP TO END OF ENTRY
	INC	SI			;BUMP TO NEXT CHARACTER
	CMP	BYTE PTR [SI],ENDPRN	;END OF ENTRY?
        JNZ     SKIP			;NOPE
        INC     SI			;YES...BUMP TO NEXT TABLE ENTRY
        JMP     FC_LOOP			;AND CHECK FOR MATCH
;
; SEND CONTROL CODE STRING TO PRINTER
;
PRT_CODE:
	MOV	BYTE PTR FMATCH,1	;SET FOUND MATCH FLAG
	INC	SI			;BUMP PAST COMMAND CHARACTER
PC_LOOP:
	MOV	DL,[SI]			;GET A BYTE
	CMP	DL,ENDPRN		;IS IT END OF STRING?
	JZ	PRT_EXIT		;YES...EXIT PRT_CODE
	PUSH	SI			;SAVE POINTER
	MOV	AH,PRTFUNC		;SETUP PRINT FUNCTION
	INT	DOSFUNC			;DO PRINT
	POP	SI			;RETRIEVE POINTER
	INC	SI			;BUMP TO NEXT CHAR
	JMP	PC_LOOP			;LOOP FOR NEXT CHAR
PRT_EXIT:
	RET

	PAGE
;
; DATA AND TABLE DEFINITIONS
;
FMATCH: DB	0			;FOUND MATCH FLAG
;
HELPMSG	DB	'	Epson LQ1500 Print Mode Selections '
	DB	'Ver 1.0 by Don M. Deck',CR,LF,CR,LF
	DB	'	R - Reset to TOP of form, DRAFT Quality, '
	DB	'PICA (10 cpi) Style, 6 LPI',CR,LF,CR,LF
	DB	'	QUALITY                                  '
	DB	'LPI',CR,LF
	DB	'	-------                                  '
	DB	'---',CR,LF
	DB	'	L - Letter                               '
	DB	'8 - 8 Lines per inch',CR,LF
	DB	'	                                         '
	DB	CR,LF
	DB	'	STYLE                                    '
	DB	'MISCELLANEOUS',CR,LF
	DB	'	-----                                    '
	DB	'-------------',CR,LF
	DB	'	E - Elite (12 cpi)                       '
	DB	'F - Form feed (top of form)',CR,LF
	DB	'	P - Proportional (overrides pica/elite)  '
	DB	'V - Line feed',CR,LF
	DB	'	I - Italic                               '
	DB	'/ - Carriage Return',CR,LF
	DB	'	J - Justified (full)                     '
	DB	'B - Buffer clear',CR,LF
	DB	'	C - Condensed (draft quality only)       '
	DB	'H - Half speed',CR,LF
	DB	'	X - Expanded                             '
	DB	'O - Paper out sensor OFF',CR,LF
	DB	'	M - Emphasized                           '
	DB	'T - Unidirectional',CR,LF
	DB	'	D - Doublestrike                         '
	DB	'Y - High order bit ON',CR,LF
	DB	'	U - Underline                            '
	DB	'Z - High order bit OFF',CR,LF
	DB	'	S - Small                                '
	DB	CR,LF
	DB	'	A - APR mode                             '
	DB	CR,LF,CR,LF
	DB	'	USAGE: LQ1500 P1[P2..Pn] where Pn is '
	DB	'from above menu.',ENDCON

	PAGE
;
; LQ1500 Print Function Table
;
; The following is the table which controls this program.  It can
; easily be modified to support other options and/or other types of
; printers.  Each option is also shown in the HELP MESSAGE screen.
;
; In the table, each option consists of two elements:
;   1.  The letter or number which invokes the option.  The program
;	will automatically convert lower case letters to upper case
;	at run time so be sure to only use upper case letters here.
;
;   2.  The string of characters to be sent to the printer to turn
;	on the selected option(s).  This can be any set of characters
;	and *MUST* be ended with "ENDPRN".
;
; Note that both elements must be present in each table entry.  A null
; table entry would consist of the command letter/number followed by
; "ENDPRN".
;
; The table must be ended with "ENDTBL".
;
; (Earlier versions of this program included a third element which
; consisted of a string of characters to be sent to the console display
; to inform the user what action had been taken or to be displayed if
; the user invoked the program with no parameters or with an
; unimplemented parameter.  This string ended with "CR,LF,ENDCON".
; These strings have been relocated to a Help Screen and removed from
; the table.  The display code has been modified accordingly.)
;
; (Earlier versions also included codes to both turn ON a printer mode
; and to turn OFF the same printer mode.  For the most part, the OFF
; entry has been removed.  Use the R - Reset command to clear the
; printer to power-up configuration and set new modes.  The Reset
; command is prefixed by a form feed to make sure that when Reset
; re-initializes top of form, that the paper is properly positioned.
; This can be removed if you prefer to manually enter a form feed or
; adjust the paper.)
;
LQ_TABLE LABEL BYTE
;
	DB	'/'			;Carriage Return
	DB	CR,ENDPRN
;
;	0 thru 7 not used
;
	DB	'8'			;8 lines per inch
	DB	ESC,'0',ENDPRN
;
;	9 not used
;
	DB	'A'			;APR mode
	DB	ESC,'M',ESC,'3',34,ENDPRN
;
	DB	'B'			;Buffer clear
	DB	CAN,ESC,DEL,ENDPRN
;
	DB	'C'			;Condensed on
	DB	ESC,SHFI,ENDPRN		;use reset to turn off
;
	DB	'D'			;Doublestrike
	DB	ESC,'G',ENDPRN		;use reset to turn off
;
	DB	'E'			;Elite (12 cpi)
	DB	ESC,'M',ENDPRN		;use reset to set pica
;
	DB	'F'			;Form feed (top of form)
	DB	FF,ENDPRN
;
;	DB	'G'			;not used
;	DB	ENDPRN
;
	DB	'H'			;Half speed on
	DB	ESC,'s',1,ENDPRN	;use reset for full speed on
;
	DB	'I'			;Italics
	DB	ESC,'4',ENDPRN		;use reset for standard
;
	DB	'J'			;Justification (full) on
	DB	ESC,'a',3,ENDPRN	;use reset to turn off
;
;	DB	'K'			;not used
;	DB	ENDPRN
;
	DB	'L'			;Letter quality
	DB	ESC,'x',1,ENDPRN
;
	DB	'M'			;Emphasized on
	DB	ESC,'E',ENDPRN		;use reset to turn off
;
;	DB	'N'			;not used
;	DB	ENDPRN
;
	DB	'O'			;Paper out sensor off
	DB	ESC,'8',ENDPRN		;use reset to turn on
;
	DB	'P'			;Proportional quality
	DB	ESC,'p',1,ENDPRN	;use reset to turn off
;
;	DB	'Q'			;not used
;	DB	ENDPRN
;
	DB	'R'			;Reset printer & top of form
	DB	ESC,'@',ENDPRN
;
	DB	'S'			;Small print
	DB	ESC,SHFI,ESC,'S',1,ESC,'3',17,ENDPRN
;
	DB	'T'			;Unidirectional on
	DB	ESC,'U',1,ENDPRN	;use reset for bidirectional on
;
	DB	'U'			;Underline on
	DB	ESC,'-',1,ENDPRN	;use reset to turn off
;
	DB	'V'			;Line feed
	DB	LF,ENDPRN
;
;	DB	'W'			;not used
;	DB	ENDPRN
;
	DB	'X'			;Expanded (Enlarged) on
	DB	ESC,'W',1,ENDPRN	;use reset to turn off
;
	DB	'Y'			;High order bit on
	DB	ESC,'>',ENDPRN
;
	DB	'Z'			;High order bit off
	DB	ESC,'=',ENDPRN
;
	DB	ENDTBL
CODESEG	ENDS
	END	START
