;..............................................................................
;
; title      mexit.asm
; version     1.04
; date	     10/29/85
; written by  Kevin Murphy
;
;
;..............................................................................
; >>> comments <<<
;..............................................................................
;
;
;
;	       >>>>>>> READ MEXIT.DOC <<<<<<<
;
;
;..............................................................................
; >>> conditional equates <<<
;..............................................................................
;
NO	EQU	0		; Not true
YES	EQU	NOT NO		; True
CHECK	EQU	0FFH		; For return value calls
;
;
;..............................................................................
; >>> ascii equates <<<
;..............................................................................
;
NULL	EQU	00H		; Null is null
BELL	EQU	07H		; Console bell
BS	EQU	08H		; Backspace
LF	EQU	0AH		; Linefeed
CR	EQU	0DH		; Carridge return
;
;
;..............................................................................
; >>> BDOS equates <<<
;..............................................................................
;
WBOOT	EQU	0000H		; CP/M warm boot
;
BDOSJMP	EQU	WBOOT +	5	; BDOS call address
;
TPA	EQU	WBOOT +	100H	; TPA
;
;
;..............................................................................
; >>> Machine specific equates / user set as needed <<<
;..............................................................................
;
MHZ	EQU	4		; Processor clock speed in MHz
;
MSPEED	EQU	003CH		; Baud speed pointer 1 = 300, 5 = 1200 6 = 2400
;
BAUD3	EQU	1
BAUD12	EQU	5
BAUD24	EQU	6
;
ZCPR	EQU	YES		; ZCPR being used
;
MAXDRV	EQU	003DH		; Location of maxdrive byte
WHEEL	EQU	003EH		; Location of wheel byte
MAXUSR	EQU	003FH		; Location of maxuser byte
;
CLOCK	EQU	YES		; YES if using a hardware clock in BYE
;
UPLDS	EQU	0054H		; Location of KMD or XMODEM upload count
DNLDS	EQU	0055H		; Location of KMD or XMODEM download count
;
FILEDRV	EQU	'C' - 41H	; USERS file drive
FILEUSR	EQU	15		; USERS file user area number
;
;
;
;..............................................................................
; >>> METAL buffer offsets <<<
;..............................................................................
; These are taken right out of MEINIT.ASM supplied by Tim Gary
;
UNUMBER	EQU	0	; User number (also seek pos into users file) (2 bytes)
UFIRST	EQU	2	; First name of user	      (0 terminated string)
ULAST	EQU	17	; Last name of user	      (0 terminated string)
UPASS	EQU	38	; Password		      (0 terminated string)
UDATE	EQU	47	; Date last logged on	      (0 terminated string)
UTIME	EQU	56	; Time last logged on	      (0 terminated string)
UCITY	EQU	65	; City of user		      (0 terminated string)
ULASTRD	EQU	94	; Message at last login 	      (2 bytes)
USTATUS	EQU	96	; User status character (+snXxabc)    (1 byte)
UJMPOS	EQU	99	; Auto jump to OS on login? ('1'=yes) (1 byte)
UBELL	EQU	101	; Bell enabled? ('1'=yes)	      (1 byte)
URP	EQU	102	; Auto read on login? ('1'=yes)       (1 byte)
UNULLS	EQU	104	; Nulls 			      (1 byte)
UHEIGHT	EQU	105	; Terminal height		      (1 byte)
UWIDTH	EQU	106	; Terminal width		      (1 byte)
UUPLOAD	EQU	109	; Upload file count   (2 byte) --not used yet--
UDNLOAD	EQU	111	; Download file count (2 byte) --not used yet--
UMINS	EQU	113	; Minutes on today    (1 byte) --not used yet--
UCALLS	EQU	117	; Unsigned number of calls	      (2 byte)
UDEF	EQU	124	; You can actually use these locs..   (124-127)

;
;..............................................................................
; >>> Main program <<<
;..............................................................................
;
	ORG	TPA		; Start at the begining
;
START:	XTHL			; Exchange SP & HL
	SHLD	OLDSTCK		; Put stack address away for error exit's
	XTHL			; Get back the stack pointer
	LDA	0004H		; Get current drive and user
	STA	OLDUSR		; Save them

;
;
;......
;
	CALL	BYECHK		; Make sure BYE is home
	CPI	00H		; If 00H its OK
	JNZ	BADBYE		; Nope, say so and exit
	CALL	WHOSIT		; Get WHO data address, and user/sector number
	CPI	'*'		; Check the error flag, if it's a "*", ooopps
	JZ	EXIT1		; Yep, error, jump out, stacks ok so dont worry
	MVI	A,FILEDRV	; Get user file drive
	CALL	SELDRV		; Set it
	MVI	A,FILEUSR	; Get user
	CALL	SELUSR		; Set it
	CALL	ENTEXT		; Are we coming or going
	CPI	00H		; If it is zero, then first time thru
	JNZ	LOGOUT		; Nope, logging out
	JMP	LOGON		; Yep.. loggig in
;
;
;................................
;
BADBYE:	LXI	D,ERROR		; Point to error msg
	CALL	PRINTS		; Print it
;
;
;................................
;
EXIT:	LDA	OLDUSR		; Retore old drive and user
	STA	0004H		; Stuff them
;
EXIT1:	RET			; We use RET because BYE "CALLED" the program
				; And expects a RET
;
;
;................................
;
ERREXIT:LHLD	OLDSTCK		; Get old stack pointer
	XTHL			; Put in
	JMP	EXIT		; Now it's ok to exit with a RET

;
;
;..............................................................................
; >>> utility routines <<<
;..............................................................................
;
				; Insure that the WHO buffer in BYE was setup
				; Right, if so get the user number
WHOSIT:	CALL	WHO		; Get the WHO address
	LXI	D,75		; Offset it to point to LCDATA + 75
	DAD	D		; Point to null leader of user number
	MOV	A,M		; Get Who buffer +75
	CPI	00H		; Is it zero
	JNZ	NOWHO		; Nope ... then we should not try to run this
	INX	H		; Point to LCDATA + 76
	SHLD	WHO76		; Save it for later
	MOV	A,M		; Get lo byte of user number
	STA	USERN		; Put it away
	INX	H
	MOV	A,M		; Get hi byte
	STA	USERN +	1	; Put it away
	RET
;
;
;................................
;
				; No WHO buffer is available, say so
NOWHO:	LXI	H,BADWHO	; Point to error message
	CALL	PRINTL		; Print it
	MVI	A,'*'		; Stuff in an "*" so we know it's a bad buzz
	RET
;
;
;...............................
;
				; Are we coming or going ?
				; If the hi bit of the hi byte is lo
				; We are coming, if hi we're going
ENTEXT:	LDA	USERN +	1	; Get hi byte of user number
	ANI	80H		; Mask all but hi bit
	JNZ	GOEN		; It was hi so we're on the way out
	LDA	USERN +	1	; Comin in, set the flag
	ORI	80H
	LHLD	WHO76		; Get who +76
	INX	H		; Move to who +77
	MOV	M,A		; Put away the flaged byte
	XRA	A		; Set the comin flag
	RET			; Return to sender
;
GOEN:	MVI	A,0FFH		; Set the going flag
	RET			; Return to sender
;
;
;................................
;
LOGOUT:	LDA	UPLDS		; Get uploads
	CPI	00H		; If zero, maybe no update needed
	JNZ	RUNOUT		; Not zero, so update
	LDA	DNLDS		; Get downloads
	CPI	00H		; If this is zero too, then no update is needed
	JNZ	RUNOUT		; Not zero, then update the file
	JMP	EXIT		; No news for file so just exit
;
;
;................................
;
RUNOUT:	CALL	READBUF		; Prep, open and read user file record
	LDA	UPLDS		; Get lastest number of uploads
	MOV	B,A		; Save it for a minute
	LXI	H,LOGBUF	; Point to the user info
	LXI	D,UUPLOAD	; Get the offset to upload count lo byte
	DAD	D		; Add it to the pointer
	MOV	A,M		; Get present count
	ADD	B		; Add the new count
	MOV	M,A		; Put back the modified count
	LDA	DNLDS		; Get lastest number of down loads
	MOV	B,A		; Save it
	LXI	H,LOGBUF	; Point to user info
	LXI	D,UDNLOAD	; Get offset to downloads
	DAD	D		; Add it to the pointer
	MOV	A,M		; Get the old count
	ADD	B		; Add the new count
	MOV	M,A		; Put the modified count in the buffer
	CALL	WRTBUF		; Write the updated log back to the disk
	XRA	A		; Zero the counters
	STA	UPLDS		; If he is still on system (re-exiting metal)
	STA	DNLDS		; We don't want to log too many
	JMP	EXIT		; Say bye bye to this stuff
;
;
;................................
;
LOGON:	CALL	READBUF		; Prep, open , and read the user file
	CALL	GETNAME		; Move the name from user info to name buffer
	LXI	H,LOGBUF	; Point to user info
	LXI	D,UUPLOAD	; Get the offset to upload reg
	DAD	D		; Add it to the pointer
	MOV	A,M		; Get the upload count
	LXI	H,UPCNT		; Point to upcount ascii buffer
	CALL	DEC8		; Make the count into ascii
	LXI	H,LOGBUF	; Point to user info
	LXI	D,UDNLOAD	; Get offset
	DAD	D		; Add it in
	MOV	A,M		; Get the download count
	LXI	H,DNCNT		; Point to ascii down load count buffer
	CALL	DEC8		; Make it ascii
	CALL	RTCBUF		; Get the address of the RealTimeBuffer in HL
	LXI	D,0007H		; Offset to point at time on system
	DAD	D		; Add it
	MOV	A,M		; Get the time on byte
	STA	ONTIME		; Store it
	MVI	A,0FFH		; Set to return MAX-TIME value from BYE
	CALL	MAXTIME		; OK, ask for it
	STA	ALLTIME		; Store it for later
	CPI	NULL		; Is it a sysop ???
	JZ	NOTIME		; No .. then tell them how long their allowed
;
	 IF	ZCPR
	LDA	WHEEL		; Check wheel also
	CPI	NULL		; Is it zero ???
	JNZ	NOTIME		; Yep, then tell them how long they are allowed
	 ENDIF			; ZCPR
;
	LDA	ALLTIME		; Get back time allowed
	JMP	SHOTIM		; Go fix up the display
;
NOTIME:	MVI	A,0FFH
	STA	SYSOP
	JMP	TIMDONE		; OK, done with time stuff....	go on
;
;
;................................
;
				; Normal user, show time allowed
SHOTIM:	LXI	H,TIM		; Point to the 3 ascii time bytes
	CALL	DEC8		; We've got maxtime in A, so just call DEC8
				; Make it into ascii
				; Fall thru, we're done
	LDA	ONTIME		; Get time on
	MOV	B,A		; Put it aside
	LDA	ALLTIME		; Get max time allowed
	SUB	B		; Subtract time on from maxtime
	LXI	H,TIMLEFT	; Point to ascii buffer
	CALL	DEC8		; Make the result ascii
;
TIMDONE:LXI	D,HEADER	; Make it pretty
	CALL	PRINTS
	LXI	D,LOGMSG	; Print out the rest of the message
	CALL	PRINTS
	LDA	MSPEED
	CPI	BAUD3
	JZ	BPS3
	CPI	BAUD12
	JZ	BPS12
	CPI	BAUD24
	JZ	BPS24
	JMP	NOBAUD
;
BPS3:	LXI	D,B3MSG
	CALL	PRINTS
	JMP	NOBAUD
;
BPS12:	LXI	D,B12MSG
	CALL	PRINTS
	JMP	NOBAUD
;
BPS24:	LXI	D,B24MSG
	CALL	PRINTS
;
NOBAUD:	LDA	SYSOP
	CPI	0FFH
	JZ	SPECIAL
;
	 IF	CLOCK
	LXI	D,NORMAL
	CALL	PRINTS
	CALL	PRTON		; Show time on
	LXI	D,TIMMSG
	CALL	PRINTS
	 ENDIF			; Clock
;
	LXI	D,LAST
	CALL	PRINTS
	JMP	EXIT		; Bye bye
;
;................................
;
SPECIAL:LXI	D,SPEC
	CALL	PRINTS
	JMP	EXIT
;
;
;................................
;
GETNAME:LXI	D,NEWNAME	; Point to the name print buffer
	LXI	H,LOGBUF	; Point to the user info
	LXI	B,UFIRST	; Get offset
	DAD	B		; Add it to the pointer
GETFRST:MOV	A,M		; Get the character
	CPI	NULL		; Is it a null ???
	JZ	LASTNAME	; Yep,, then we are done with the first name
	CALL	NEXT		; No, save the character and inc the pointers
	JMP	GETFRST		; Get the next character
;
LASTNAME:			; Get the last name
	MVI	A,' '		; Put a space between first and last
	CALL	NEXT		; Save the character and inc the pointer
	LXI	H,LOGBUF	; Reset the user info pointer
	LXI	B,ULAST		; Get the offset for last name
	DAD	B		; Add it to the pointer
;
GETLAST:MOV	A,M		; Get a character
	CPI	NULL		; Is it a null ???
	JZ	NAMEDONE	; Yep,, then we are done
	CALL	NEXT		; Nope, save it, inc the pointers
	JMP	GETLAST		; Get the next character
;
NAMEDONE:
	MVI	A,'$'		; Terminate the string
				; Fall thru to NEXT, then return to sender
;
;
;...............................
;
NEXT:	STAX	D		; Put the character away
	INX	H		; Inc the pointers
	INX	D
	RET			; Return to sender
;
;
;...............................
;
DIRMTCH:	CALL	INITFCB		; Zero the FCB
	LXI	D,LOGFCB	; Point to the FCB
	CALL	SFIRST		; Look for the file
	INR	A		; If we got FF back there is no file
	JZ	FILNOT		; No file , no worky, so exit this mess
	RET
;
;
;
;................................
;
READBUF:CALL	SETUP		; Prep, and open the file
	CALL	RREAD
	CPI	0
	JNZ	NOOP2
	CALL	CLOSEIT
	RET			; Return to sender

;................................
;
				; Write the buffer to the disk file
WRTBUF:	CALL	SETUP		; Set up a file op
	CALL	RWRITE		; Write the modified record
	CPI	0		; Make sure it's OK
	JNZ	NOMAKE		; Bad buzz.... go show local error
	LXI	H,WRTMSG	; Say that we are updating
	CALL	PRINTL		;
	CALL	CLOSEIT		; Close up the file
	RET			; Return to sender
;
;
;
;................................
;
SETUP:	LXI	D,SCRATCH	; Set the DMA to the buffer, for scratch area
	CALL	SETDMA		; Tell the bios
	CALL	DIRMTCH		; Make sure we know where the file is
	CALL	INITFCB		; Be safe, clean up the FCB
	LXI	D,LOGFCB	; Point to FCB
	CALL	OPENF		; Open the file
	INR	A		; Bad read ???
	JZ	NOOP		; Yep.. exit
	CALL	INITFCB		; Zero it again
	XRA	A		; Zero A
	STA	RAND		; Zero random read count, always read
	STA	RAND + 1	; Record zero first
	LXI	D,LOGFCB	; Point to fcb
	CALL	RREAD		; Read a sector  (dummy read)
	CPI	0		; Test error
	JNZ	NOOP1		; Show error
	LXI	D,LOGBUF	; Point to buffer
	CALL	SETDMA		; Set DMA
	LDA	USERN		; Get lo byte of user number
	SUI	1		; Fix it ,,, user one = record zero
	STA	RAND
	LDA	USERN +	1
	ANI	7FH		; Mask
	STA	RAND + 1	; Set random record number
	LXI	D,LOGFCB
	RET			; Return to sender
;
;
;................................
;
INITFCB:XRA	A		; Make it zero
	STA	LOGFCB + 12	; Zero out the FCB
	STA	LOGFCB + 32
	RET
;
;................................
;
				; Close the file
CLOSEIT:LXI	D,LOGFCB	; Point to FCB
	CALL	CLOSEF		; Close the file
	CPI	0FFH		; Bad close ??
	JZ	NOMAKE		; Yep ... exit
	RET			; Return to sender
;
;
;................................
;
				; NO OPen , bad file open error
NOOP:	LXI	H,NOPEN		; Point to message
	CALL	PRINTL		; Print it
	JMP	ERREXIT		; Exit
				; NO OPen , bad file open error
NOOP1:	LXI	H,NREAD		; Point to message
	CALL	PRINTL		; Print it
	JMP	ERREXIT		; Exit
				; NO OPen , bad file open error
NOOP2:	LXI	H,NREAD2	; Point to message
	CALL	PRINTL		; Print it
	JMP	ERREXIT		; Exit
;
FILNOT:	LXI	H,NOFILE
	CALL	PRINTL
	JMP	ERREXIT
;
NOMAKE:	LXI	H,BADMAKE	; Print bad make file msg
	CALL	PRINTL
	JMP	ERREXIT		; Exit
;
;
;................................
;
				; Print to local console only
				; HL points to the string, terminate with zero
PRINTL:	MOV	A,M		; Get a character
	CPI	'$'		; Is it a terminator ???
	RZ			; Yep, then we are done, return to sender
	PUSH	H
	CALL	PUT7		; Nope, then print it on local console
	POP	H
	INX	H		; Knock up the string pointer
	JMP	PRINTL		; Loop till done

;
;..............................................................................
;		These next two routines are from BYE500
;..............................................................................
;
; BINBCD will convert a 0-99 binary number to 0-99 BCD number.
; Call with (A)=binary number 0-99. (A)=0-99 BCD on exit
;
BINBCD:	PUSH	B
	PUSH	H
	ADI	100		; Make it a 3 digit number
	PUSH	PSW
	XRA	A
	STA	BCDBUF+1	; Clear work buffer
	STA	BCDBUF+2
	POP	PSW
	LXI	H,BCDBUF	; Store ascii here
	CALL	DEC8		; Will convert to 100-199 ascii
	LDA	BCDBUF+1	; MSN of number
	SBI	'0'		; Subtract ascii
	RLC
	RLC
	RLC
	RLC			; Rotate to high nibble
	MOV	B,A		; Save in B
	LDA	BCDBUF+2	; LSN of number
	SUI	'0'		; Subtract ascii
	ORA	B		; Merge high nibble
	POP	H
	POP	B
	RET
;
BCDBUF:	DB	0,0,0,'$'	; Three byte buffer
;
;-----------------------------------------------------------------------
;
; DEC8 will convert an 8 bit binary number in A to 3 ASCII bytes.
; HL points to the MSB location where the ASCII bytes will be stored.
; Leading zeros are suppressed, so store spaces in your buffer before calling.
;
DEC8:	PUSH	B
	PUSH	D
	MVI	E,0		; Leading zero flag
	MVI	D,100
;
DEC81:	MVI	C,'0'-1
;
DEC82:	INR	C
	SUB	D		; 100 or 10
	JNC	DEC82		; Still +
	ADD	D		; Now add it back
	MOV	B,A		; Remainder
	MOV	A,C		; Get 100/10
	CPI	'1'		; Zero?
	JNC	DEC84		; Yes
	MOV	A,E		; Check flag
	ORA	A		; Reset?
	MOV	A,C		; Restore byte
	JZ	DEC85		; Leading zeros are skipped
;
DEC84:	MOV	M,A		; Store it in buffer pointed at by HL
	INX	H		; Increment storage location
	MVI	E,0FFH		; Set zero flag
;
DEC85:	MOV	A,D
	SUI	90		; 100 to 10
	MOV	D,A
	MOV	A,B		; Remainder
	JNC	DEC81		; Do it again
	ADI	'0'		; Make ascii
	MOV	M,A		; And store it
	POP	D
	POP	B
	RET
;
;
;..............................................................................
;		      end of routines from BYE
;..............................................................................
;
;******************************************************************************
;..............................................................................
; >>> BDOS calls <<<
;..............................................................................
;
BDOS:	JMP	BDOSJMP		; Go get bdos
	RET			; Return to sender
;
;
SYSRST:
;0				; System reset, (warm boot)
	MVI	C,00H
	CALL	BDOS
	RET
;
;
CONIN:
;1				; Get an input character (console)
	MVI	C,01H		; Return ascii character in A
	CALL	BDOS
	RET
;
;
CONOUT:
;2				; Send an output character (console)
	MVI	C,02H		; Entry ascii character in A
	MOV	E,A
	CALL	BDOS
	RET
;
;
LSTOUT:
;5				; Send ascii character to LST: device
	MVI	C,05H		; Entry ascii character in A
	MOV	E,A
	CALL	BDOS
	RET
;
;
PRINTS:
;9				; Print string pointed to by DE
	MVI	C,09H		; '$' terminates string
	CALL	BDOS
	RET
;
;
RCONBUF:
;10				; Read console buffer
	MVI	C,0AH		; Entry DE = buffer address
	CALL	BDOS		; DE + 0 = max number of characters
				; DE + 1 = returns number of characters read
	RET			; DE + 2 = 1st buffer character
;
;
CONSTAT:
;11				; Get console status
	MVI	C,0BH			; Return it in A
	CALL	BDOS
	RET
;
;
RSTDSK:
;13				; Reset disk system
	MVI	C,0DH
	CALL	BDOS
	RET
;
;
SELDRV:
;14				; Select default drive
	MVI	C,0EH		; Entry A = drive  0 = A, 1 = B so on...
	MOV	E,A
	CALL	BDOS
	RET
;
;
OPENF:
;15				; Open a file
	MVI	C,0FH		; Entry DE points to FCB
	CALL	BDOS		; Return A = FFH if no file found
	RET
;
;
CLOSEF:
;16				; Close a file
	MVI	C,10H		; Entry DE points to FCB
	CALL	BDOS		; Return A = FFH if file not found
	RET
;
;
SFIRST:
;17
	MVI	C,11H		; Search for FCB match
	CALL	BDOS		; Entry DE points to FCB
	RET			; Return A = 0FFH if file not found
;
;
READF:
;20
	MVI	C,14H		; Read sequential file sector
	CALL	BDOS		; Entry DE points to FCB
	RET			; Write to current DMA
				; Return A = 00h if read was OK
;
;
WRITEF:
;21				; Write sequential sector
	MVI	C,15H		; Entry DE points to FCB
	CALL	BDOS		; From current DMA
	RET			; Return A = 00H if write was OK
;
;
MAKEF:
;22
	MVI	C,16H		; Make a file
	CALL	BDOS		; Entry DE points to FCB
	RET			; Return A = 0FFH if bad buzz
;
;
RREAD:
;33
	MVI	C,21H		; Random read of file
	CALL	BDOS		; Entry DE points to FCB
	RET
;
;
RWRITE:
;34
	MVI	C,22H		; Random write of file
	CALL	BDOS		; Entry DE points to FCB
	RET


;
;
SETDMA:
;26				; Set the DMA address
	MVI	C,1AH		; Entry DE = DMA address
	CALL	BDOS
	RET
;
;
SELUSR:
	MOV	E,A		; Select default user
	MVI	C,20H		; Entry A = user number
	CALL	BDOS
	RET
;
;..............................................................................
;  >>> Extended BDOS calls <<<	       (bye337m or newer)
;..............................................................................
;
BYECHK:
;32				; BYE check (BYE exsistance test)
				; Return A = 0 if BYE is home, FFH if not
	MVI	E,241		; Send a 241 decimal with the user command
	MVI	C,20H		; Set up the user command
	CALL	BDOS		; Let bdos do it to it
	CPI	4DH		; If bye is there, we should have a 77 decimal
	JNZ	BADCHK		; Nope, bad BYE, say so
	MVI	A,00H		; All is well, so send good news
	RET			; Return to sender
;
BADCHK:	MVI	A,0FFH		; Bad stuff
	RET			; Return to sender
;
;
RINST:				; Get raw modem input status
;61				; Return A = FFH if ready, A = 0 if not ready
	MVI	C,3DH
	CALL	BDOS
	RET
;
;
ROUTST:				; Get raw modem output status
;62				; Return A = FFH if ready, A = 0 if not ready
	MVI	C,3EH
	CALL	BDOS
	RET
;
;
OUT8:				; Output 8 bit character to modem
;63				; Entry character in A
	MVI	C,3FH
	MOV	E,A
	CALL	BDOS
	RET
;
;
IN8:				; Input 8 bit character from modem
;64				; Return  character in A
	MVI	C,40H
	CALL	BDOS
	RET
;
;
CARST:
;65				; Get carrier detect status
				; Return A = FFH if carrier, A = 0 if not
	MVI	C,41H
	CALL	BDOS
	RET
;
;
CONST:
;66				; Get local console input status
	MVI	C,42H		; Return  A = FFH if ready, A = 0 if not
	CALL	BDOS
	RET
;
;
GET7:
;67				; Get 7 bit character from local console
	MVI	C,43H		; Return  character in A
	CALL	BDOS
	RET
;
;
PUT7:
;68				; Send a 7 bit character to local console
	MVI	C,44H		; Entry character in A
	MOV	E,A
	CALL	BDOS
	RET
;
;
MDRV:
;69				; Get/set maxdrive
	MVI	C,45H		; Entry A = drive (0 = A, 1 = B....)
	MOV	E,A		; Entry A = FFH, then return current maxdrive
	CALL	BDOS		; Return (if A = FFH at entry) A = maxdrive
	RET
;
;
MUSR:
;70				; Get/set maxuser
	MVI	C,46H		; Entry A = user (0 = 0, so on)
	MOV	E,A		; Entry A = FFH, then return current maxuser
	CALL	BDOS		; Return (if A = FFH at entry) A = maxuser
	RET
;
;
NULLS:
;71				; Get/set number of nulls
	MVI	C,47H		; Entry A = number of nulls (0 to 9)
	MOV	E,A		; Entry A = FFH, then return current number
	CALL	BDOS		; Return (if A = FFH at entry) A = nulls
	RET
;
;
TIMOUT:
;72				; Get/set number of time out minutes
	MVI	C,48H		; Entry A = number of mins
	MOV	E,A		; Entry A = FFH, then return current value
	CALL	BDOS		; Return (if A = FFH at entry) A = # of mins
	RET
;
;
CASE:
;73				; Get/set upper-case only flag
	MVI	C,49H		; Entry A = 0 (upper & lowwer case OK)
	MOV	E,A		; Entry A = 20H (uppercase only)
	CALL	BDOS		; Entry A = FFH (return current setting)
				; Return A = (if FFH at entry) current setting
	RET
;
;
LFM:
;74				; Get/set line feed masking
	MVI	C,4AH		; Entry A = 0 (OK to send line feeds)
	MOV	E,A		; Entry A = 1 (dont send me any line feeds)
	CALL	BDOS		; Entry A = FFH (return current setting)
	RET			; Return A = (if FFH at entry) current setting
;
;
HARDON:
;75				; Get/set hardlog active flag
	MVI	C,4BH		; Entry A = 0 (hardlog OFF)
	MOV	E,A		; Entry A = 1 (hardlog ON)
	CALL	BDOS		; Entry A = FFH (return current setting)
	RET			; Return A = (if FFH at entry) current setting
;
;
WRTLOC:
;76				; Get/set write lock flag
	MVI	C,4CH		; Entry A = 0 normal (no write lock)
	MOV	E,A		; Entry A = 1 no hangup  (write lock active)
	CALL	BDOS		; Entry A = FFH (return current setting)
	RET			; Return A = (if FFH at entry) current setting
;
;
MOFF:
;77				; Get/set modem queit flag
	MVI	C,4DH		; Entry A = 0 (modem I/O is OK)
	MOV	E,A		; Entry A = 1 (kill modem I/O) local only
	CALL	BDOS		; Entry A = FFH (return current setting)
	RET			; Return A = (if FFH at entry) current setting
;
;
BELLEN:
;78				; Get/set local console bell enable
	MVI	C,4EH		; Entry A = 0 (keep that damn bell queit)
	MOV	E,A		; Entry A = 0 (ring... ring... ring...)
	CALL	BDOS		; Entry A = FFH (return current setting)
	RET			; Return A = (if FFH at entry) current setting
;
;
RTCBUF:
;79				; Get address of RTC buffer
	MVI	C,4FH		; Return HL = RTC address
	CALL	BDOS		; (RO) RTC address  -byte- (hours) BCD
				; (RO) RTC address + 1	-byte- (mins) BCD
	RET			; (RO) RTC address + 2	-byte- (secs) BCD
				; (RO) RTC address + 3	-byte- (century) BCD
				; (RO) RTC address + 4	-byte- (year) BCD
				; (RO) RTC address + 5	-byte- (month) BCD
				; (RO) RTC address + 6	-byte- (day) BCD
				; (RO) RTC address + 7	-byte- (time on) BINARY
				; RTC address + 8  -byte- (reserved) BINARY
				; (RO) RTC address + 9	-byte- (CHOUR) BINARY
				; (RO) RTC address + 10  -byte- (CMIN) BINARY
				; (RW) RTC address + 11  -byte- (LHOUR) BINARY
				; (RW) RTC address + 12  -byte- (LMIN) BINARY
;
;
WHO:
;80				; Return address of LASTCALLER WHO data
	MVI	C,50H		; Return HL = WHO address
	CALL	BDOS		; Read / write up to 78 characters
	RET			; If 1st character is a space, no data ready
				; If 1st character is a NULL (00H) no buffer
;
;
MAXTIME:
;81				; Entry A = 0 (unlimited time allowed)
	MVI	C,51H		; Entry A = 1 to 244 (minutes allowed)
	MOV	E,A		; Entry A =FFH (return current setting)
	CALL	BDOS		; Return A = (if FFH at entry) current setting
	RET
;
;
LOGIN:
;82				; Set login time
	MVI	C,52H		; Entry D = hours (0 to 23)
	CALL	BDOS		; Entry E = minutes (0 to 59)
	RET
;
;
PRTON:
;83				; Print time on system message
	MVI	C,53H
	CALL	BDOS
	RET
;
;
;..............................................................................
; >>> Messages <<<
;..............................................................................
;
HEADER:	DB	CR,LF,LF,'[ Well Hello there, '
NEWNAME:DS	40		; Allow a max of 40 characters for the name
	DB	'$'		; Insure string termination
LOGMSG:	DB	'  Good to see you again ]'
	DB	CR,LF,LF,'[ You have uploaded a total of  '
UPCNT:	DB	'   '
	DB	' file(s) ]'
	DB	CR,LF,'[ You''ve downloaded a total of  '
DNCNT:	DB	'   '
	DB	' file(s) ]','$'
NORMAL:	DB	CR,LF,LF,'[ You are allowed  '
TIM:	DB	'   '
	DB	' total minutes on the system ]',CR,LF,'$'
TIMMSG:	DB	CR,LF,'[ You have about '
TIMLEFT:DB	'   '
	DB	' minutes left ]','$'
LAST:	DB	CR,LF,LF,'[ Enjoy your stay here at Murphy''s ]'
	DB	CR,LF,LF,'$'
SPEC:	DB	CR,LF,LF,'[ You have unlimited time on the system ]',CR,LF,LF,'$'
B3MSG:	DB	CR,LF,'[ You are logged in at 300 baud ]',CR,LF,'$'
B12MSG:	DB	CR,LF,'[ You are logged in at 1200 baud ]',CR,LF,'$'
B24MSG:	DB	CR,LF,'[ You are logged in at 2400 baud ]',CR,LF,'$'
ERROR:	DB	BELL,CR,LF,'Sorry, you need bye 501 or newer',CR,LF,'$'
BADWHO:	DB	CR,LF,'No WHO bufffer data available',CR,LF,'$'
BADMAKE:DB	CR,LF,'Cant write to users file',CR,LF,'$'
NOPEN:	DB	CR,LF,'Cant open the users file',CR,LF,'$'
NREAD:	DB	CR,LF,'Cant read user zero record',CR,LF,'$'
NREAD2:	DB	CR,LF,'Cant read users record',CR,LF,'$'
WRTMSG:	DB	CR,LF,'[Updating users file]',CR,LF,'$'
NOFILE:	DB	CR,LF,'Cant find users file',CR,LF,'$'
;
;
;..............................................................................
;
OLDUSR:	DB	0		; This is where we save the orig drive/user
USERN:	DB	0,0		; User number
WHO76:	DW	0000		; Save WHO pointer + 76
OLDSTCK:DW	0000		; Pointer to old stack, incase of error exit
ONTIME:	DB	0		; Time the user has already been on
ALLTIME:DB	0		; Total time allowed on system
SYSOP:	DB	0
;
;
;..............................................................................
;
LOGFCB:	DB	0,'USERS      '	; Define the file control block
	DS	21
RAND:	DW	0
	DB	0
;
;
;................................
;
LOGBUF:	DS	128
SCRATCH:DS	128

;
;................................
;
	END
