; CBBS	O O	  O	O O	O   O 	.ASM
;	O O	  O	O O	 O O
;	O   O	  O	O   O	  O
;
;		----------------
;THE FILES CONTAINING THE MESSAGES HAVE THE
;FILE NAME 'MESSAGE' AND THE FILETYPE  'XNN'
;WHERE NN IS THE LAST 2 DIGITS OF THE MESSAGE
;NUMBER, ROUNDED BASED ON THE VALUE OF "FILEMSK"
;(SEE DESCRIPTION IN CBBS.ASM), AND 'X' IS A LITERAL
;'X'.  THUS, IF "FILEMSK" IS 0FEH, MESSAGE 12345
;WILL BE WRITTEN TO FILE MESSAGE.X44
;
;EACH MESSAGE IS PRECEEDED BY A BELL CHAR
;(NOT KEYABLE BY THE USER).
;
;MOD LOG: (THRU 3.2 WRITTEN TO "HISTORY")
;
;====> HISTORICAL COMMENTS SINCE 3.3 TO "HISTORY.033"
;
;====>	RETRIEVE FLAGGED MESSAGES
;
RTRVFLG	CALL	ILPRT
	DB	CR,LF,'Retrieving flagged msgs: '
	DB	'C skips, K aborts.',CR,LF,0
	MVI	A,3	;SET SO ^K TURNS OFF RETRIEVE
	STA	CTLKSW	;	BY STORING 0 INTO FLAGPTR
;			
;====>	MAIN ENTRY - RETRIEVE MSGS
;
RTRV	LDA	RTOGO	;MORE TO RETRIEVE?
	ORA	A
	JZ	RTVG
	DCR	A
04	JP	RTVST	;RETRIEVE NEXT
04	ADI	2	;UN-DO DCR, +1
	JMP	RTVST	;RETRIEVE PREV
;
RTVG	LHLD	FLAGPTR	;ANY FLAGGED?
	MOV	A,H
	ORA	A
	JNZ	RTVF
	CALL	GETVAR
	DB	CR,LF,'Msg #: to retrieve (C/R when done)',0
	DW	ANSWER
03	DW	17	;HELP MSG #
	DB	5	;MSG # LEN
	LDA	ANSWER	;JUST
	CPI	CR	;	C/R?
	JZ	FUNCT	;	YES, EXIT
	CPI	'+'	;REQUEST TO
	JNZ	RTVNPL	;	DUMP NEXT 10?
02;COMMENT OUT NEXT 3
;	LDA	PASSFLG
;	ORA	A
;	JNZ	RTVNPL
	MVI	A,10	;RETRIEVE BLOCK OF 10
RTVST	STA	RTOGO	;SAVE 10 OR -10
;
;INCREMENT NUMBER
;
	LXI	H,MSGNO+4 ;UNITS DIGIT
04	ORA	A	;NEXT OR PREV?
04	JZ	RTVG	;NO MORE
04	JM	RTVPR	;PREV
	CALL	ADD1	;ADD 1 IN ASCII
	JMP	RTVOK	;SKIP FORMATTING
04;MODS:
;
;REQUEST TO RETRIEVE PREVIOUS
;
RTVPR:
05;MODS:
;
;CHECK THAT NOT BACKING PAST 00000
;
	LXI	H,MSGNO	;POINT
	LXI	D,MSGNO+1
	CALL	COMP4	;ALL DIGITS SAME?
	JNZ	RTVN00
	SUI	'0'	;YES SAME, BUT 0?
	JZ	RTVST	;	YES, STORE 0 TO GO
05;END
RTVN00	LXI	H,MSGNO+4
	CALL	SUB1	;BACK UP 1
	JMP	RTVOK	;CONTINUE
04;END
;
;MOVE FLAGGED MSG # TO MSGNO
;
RTVF	MOV	A,M	;AT LAST NUMBER?
	CPI	CR
	JZ	RTVFE	;	YES, END
	LXI	D,MSGNO	;NO, GET
	MVI	B,5	;	NEXT
	CALL	MOVE	;	#
	SHLD	FLAGPTR	;UPDATE POINTER
	JMP	RTVOK	;	RETRIEVE IT
;
;NO MORE FLAGGED TO RETRIEVE, TURN IT OFF
;	AND RETURN TO "FUNCT";
;
RTVFE	LXI	H,0
	SHLD	FLAGPTR
	JMP	FUNCT
;
;PAD NUMBER TO 5 BYTES
;
RTVNPL	EQU	$
04;MODS:
	CPI	'-'	;RETRIEVE 10 PREV?
	MVI	A,(-10) AND 0FFH
	JZ	RTVST	;YES, DO THEM
	CALL	JUSTA	;R. JUST. ANS. INTO 'MSGNO'
	JC	RTVG	;BAD NUMBER
;
;FOLLOWING 2 LINES WERE OLD (NON INDEXING)
;RTVOK	LHLD	MSGNO	;GET 2 FIRST DIGITS
;	SHLD	MSGFT	;SAVE AS FILETYPE
;
RTVOK	CALL	SETMSGN	;SETUP FILENAME
;
	LXI	H,MSGFN	;POINT TO 'MESSAGE ',MSGNO
	CALL	SETRD	;SET UP TO READ
	JNC	RTVFN	;FILE FOUND
;
;MSG NOT FOUND
;
RTRVN	CALL	ILPRT
	DB	'No msg ',0
	LXI	H,MSGNO
	CALL	TYPEMCR
	CALL	CRLF
	JMP	RTRV	;GET NEXT
;
;FILE WHICH POTENTIALLY CONTAINS THE MESSAGE
;HAS BEEN FOUND.  NOW FIND THE MESSAGE NUMBER
;
RTVFN	CALL	RDBYTE
	JC	RTRVN
	CPI	7	;BELL?
	JNZ	RTVFN
;GOT BELL CHAR - MATCH MESSAGE
	LXI	H,MSGNO
	MVI	B,5	;CHARS TO MATCH
RTVFNM	CALL	RDBYTE
	JC	RTRVN
	CMP	M	;MATCH?
	JNZ	RTVFN	;NO, SCAN FOR NEXT
	INX	H
	DCR	B
	JNZ	RTVFNM
;MESSAGE FOUND - PRINT IT
	CALL	RDBYTE	;KILL COMMA AFTER NUMBER
	CALL	ILPRT
	DB	CR,LF,'Msg ',0
	LXI	H,MSGNO
	CALL	TYPEMCR
	CALL	ILPRT
	DB	' is ',0
	CALL	RTVCM	;# LINES
	CALL	ILPRT
	DB	' line(s) on ',0
	CALL	RTVCM	;DATE
	CALL	ILPRT
	DB	' from ',0
	CALL	RTVCM
	CALL	ILPRT
	DB	CR,LF,'to ',0
	CALL	RTVCM
	CALL	ILPRT
	DB	' re: ',0
	call	rdbyte
	jc	rtrv
	sta	perflg	;save for later
	call	type	;fake into subject printout
	CALL	RTVCM	;SUBJECT
	CALL	CRLF
	CALL	CRLF
RTVSKP	lda	perflg
	cpi	'.'
	jnz	rtskp1
	call	rdbyte
	jc	rtrv
	cpi	cr
	jz	rtskp1	;cr found setnon-personal
;
;password found, now move it to the buffer
;
	mvi	b,3
	lxi	h,perbuf
	mov	m,a
	inx	h
getpas	call	rdbyte
	mov	m,a
	inx	h
	dcr	b
	jnz	getpas
;
;password from user now stored in perbuf
;so get password from user
;
	lda	pasflg
	ora	a
	jz	rtskp1	;skip check for operator
	call	getvar
	db	cr,lf
	db	'enter password ',0
	dw	passwd
	dw	-1	;no help message #
	db	4
	lxi	h,perbuf
	lxi	d,passwd
	call	comp4
	jz	rtskp1
;
;wrong password entered
;
	call	ilprt
	db	'++wrong password++',0
	xra	a
	sta	perflg
	jmp	rtrv
;
rtskp1	xra	a
	sta	perflg
	call	crlf
rtskp2	call	rdbyte	;skip password
	jc	rtrv
	cpi	lf
	jnz	rtskp2
;
RTVRD	CALL	RDBYTE
	JC	RTRV
	CPI	'G'-40H	;NEXT MSG HDR?
	JZ	RTRVEND
	CALL	NDTYPE
	CALL	CTLCKS	;CTL-C?
	JNZ	RTVRD	;NO.
	CALL	CRLF
RTRVEND	LDA	INBUF	;MORE STACKED?
	CPI	CR
	JNZ	RTRV
	LDA	RTOGO
	ORA	A
	JNZ	RTRV
	LHLD	FLAGPTR
	MOV	A,H
	ORA	L
	JNZ	RTRV
	CALL	ILPRT
	DB	'--End of ',0
	LXI	H,MSGNO
	CALL	TYPEMCR
	CALL	CRLF
	JMP	RTRV
;
;READ FIELD FROM MESSAGE (NAME, DATE, ETC)
;
RTVCM	CALL	RDBYTE
	JNC	RTVCMN
	POP	H	;KILL RETURN ADDR
	JMP	RTRV
;
RTVCMN	CPI	','
	RZ		;END OF FIELD
	CPI	CR
	JZ	RDBYTE	;EAT UP L/F, RETURN
	CALL	NDTYPE
	CALL	CTLCKS	;CHECK CTL C, K, S
	JZ	RTRV
	JMP	RTVCM
;
01 ;START OF 01 MODS
;SET MESSAGE NUMBER.  IN BASIC, THIS WOULD SIMPLY BE:
;FILE# = FILEDIV*INT(MSGNO/FILEDIV) 
;
;1. CONVERT LAST 2 DIGITS OF MSGNO TO BINARY
SETMSGN	LXI	H,MSGNO+3 ;TO ASCII #
	MOV	A,M	;GET 10S
	SUI	'0'	;MAKE BINARY
	MOV	B,A
	ADD	A	;X2
	ADD	A	;X4
	ADD	B	;X5
	ADD	A	;X10
	MOV	B,A	;SAVE
	INX	H	;TO UNITS
	MOV	A,M	;GET UNITS
	SUI	'0'	;MAKE BINARY
	ADD	B	;A=DECIMAL VALUE
;2. DIVIDE BY FILEDIV
	MVI	B,0FFH	;QUOTIENT
	MVI	C,FILEDIV ;DIVISOR
SETMDIV	INR	B
	SUB	C	;SUBTRACT DIVISOR
	JNC	SETMDIV	;LOOP 'TILL DONE
;3. MULTIPLY BY FILEDIV
	MVI	C,FILEDIV
	XRA	A
SETMMUL	ADD	B
	DCR	C
	JNZ	SETMMUL
;4. CONVERT BACK TO ASCII IN MSGFT
	LXI	H,MSGFT+1
	MVI	M,'0'-1
SETM2	INR	M
	SUI	10
	JNC	SETM2
	ADI	10+'0'
	INX	H
	MOV	M,A
	RET		;WITH MSGFT SET.
01 ;END OF 01 MODS
;
	LINK	CBBSOPER ;TO NEXT .ASM FILE
