/******************************************************************************
 *
 * 	METAL library functions
 *
 *	FILE: HMLIB.C version 1.30xx
 *
 *
 *		Metal and Metal Message System are Trademarked and
 *			Copyright (c) 1984  Tim Gary
 *			    All rights reserved.
 *
 *
 *	Common utility finctions used in METAL, MENTER and MUTIL
 *
 ******************************************************************************
 *
 * 1.30xx 7/07/85  QX10 routine fixed...
 * 1.30xx 7/01/85  Echo toggle with ^E implemented..
 * 1.30xx 6/23/85  Sysop ^P thing for list output added, new qx10 clock stuff.
 * 1.30xx 6/19/85  Findbye put back..
 * 1.30xx 6/12/85  Modified new date routine to check if ;y was entered earlier
 * 1.30xx 6/09/85  Enf of line bell every other char after linelen-8
 * 1.30xx 5/02/85  Modified Date question to only accept y/n answers.
 * 1.30xx 3/07/85  LinkBye added for use in cpm 8/16 systems for hanging up.
 * 1.30xx 3/04/85  LF's converted to spaces in getl..
 * 1.30xx 2/26/85  ZCPR3 Support added, and old RESETDRIVE stuff deleted.
 * 1.20b 01/13/85  MM58167A Kenmore Computer Tech. clock board support added.
 * 1.20b 01/11/85  Time compare added.
 * 1.20b 01/07/85  Set getl to ignore linefeeds...
 * 1.20b 01/05/85  Fix type to strip bit 8 (for WS files), getchar also strips.
 * 1.20b 01/05/84  New clock routines added.. CCS and QX10.
 * 1.20a 11/04/84  Counters routines made less dependant upon right info.
 * 1.10e 11/02/84  Added to pcounters routine, now wil write to specified file
 *		  if arg!=0.  Put writestat routine here, for easy access.
 * 1.10e 10/30/84  Parsing routine fixed to zap trailing blanks in ask func.
 *		  Future note: CAN'T change in getline!!!!!!!!
 *
 * 1.10c 10/0x/84  Hayes clock date order changed to reasonable mm/dd/yy form.
 *
 * 1.10b <none>
 * 1.10a  8/31/84  Overlay stuff started.
 *
 * 1.01a  6/27/84  Multi user stuff inserted.
 * 1.01a  6/10/84  Setup for Aztec C 1.06.  CCS clock stuff added.
 *
 * 1.0c   5/17/84 Added Hayes clock support.
 *
 * 1.0b   4/20/84 (continued) Added usindex() (index ignoring case), distext()
 * 1.0b   4/14/84 (continued) Findbye routine setup..
 * 1.0b	  4/13/84  Added Upper/lower case routines.  Added Novice user help.
 *		Putchar returns char typed at [More] prompt for checking.
 *		Removed several MENTER only functions (putcaller, writestat..)
 *		External height variable used for screen height now.
 *
 * 1.0a	  1/25/84  Added terminal height code.  Now pauses with [more] prompt
 *
 * 1.0	  1/17/84  Version 3.0a new format of files.
 *
 *****************************************************************************/

#define HMLIB
#include "xpm.h"
#include "hmh.h"
#include "hmconfg.h"
#include "ctype.h"

#define dgetchar getchar


/********************************
 * Return index into type table *
 ********************************/

get_type(t_char)
 char t_char;
{
register int i;

for (i=0; O.user_type[i].type!='\0'; i++) 
	if (O.user_type[i].type==t_char) break;

if (O.user_type[i].type=='\0') --i;	/* return last real type */
return i;
}


/********************************
 * type a file, stop on a break *
 ********************************/

type(filename)
 char *filename;
{
FILE *fil;
register int cfast;

if ((fil=open(filename,F_RD | F_UNLOCK))==NULL) return ERROR;  /* open text file for read */

novhelp();	/* help novice if he is one */

read(fil,1);	/* getc doesn't do this initially, sigh */
while ( (cfast=getc(fil))!=ERROR && cfast!=EOF )
		{
		cfast&=0x7f;	/* strip high bit so doc mode ws files work */
		if (cfast!='\r') if (bcputchar(cfast)==ERROR) break;
		}

close(fil);

return NULL;
}


/*******************************************************
 * display text from pointer to array of char pointers *
 *   (eg   static char *it_hlp[] = { "1","2","3",0 }; )*
 *******************************************************/

dis_text(sp)
 register char **sp;
{
while (*sp && (send(*sp++)!=ERROR));
}


/* A one liner to help novices out on the system */

novhelp()
{
if (user.parm.expert==POFF)
	send("\nControl-K to abort, Control-S to pause.\n");
}


/* Regular old putchar, but checks for break (^K, etc..) chars. 
   Returns ERROR if one hit, else it returns the char		*/

bcputchar(ch)
 int ch;
{
register int a;

if (!breakkey())
	{
	if ( ((a=toupper(putchar(ch)))=='N') || ((a & 0x1f)==0xb) ) a=ERROR;
	}
  else a=ERROR;

return a;
}


send(s)		/* send string while checking for break */
register char *s;
{
while (*s) if (bcputchar(*s++)==ERROR) return ERROR;;
return 0;	/* else ok */
}

/****************************************
 * Print string to printer (LST:)	*
 ****************************************/

print(str)
 register char *str;
{
while (*str) bdos(5,*str++);
}


/********************************
 * check for ^k ^x, ^s, etc..	*
 ********************************/

breakkey()		/* check for break */
{
register int key;

if (key=bdos(6,0xff))
	{
	if (((key & 0x1f)==0xb)		/* stop if ^K, ^X, etc.. */
		|| ((key & 0x1f)==0x18))
		{
		putchar('\n');
		return ERROR;
		}
	if ((key & 0x1f)==0x13)	/* pause if ^S */
		getd();
	globalchar=key;		/* save the char for later reference */
	}
return 0;	/* none pressed */
}


/******************************************************************************
 * ask: get string after prompting user.
 *
 *	question= prompt string (will NOT be printed if ';' used
 *		to get mult. commands/options..
 *	str	= place to put string
 *	maxchars= max # of chars to be accepted from terminal
 *	options	= following BITs that may be combined:
 *		UPLOW	: accept upper/lower case input
 *		UP	: upper case conversion is made
 *		NOECHO	: turn off display of chars as they are entered
 *		NUMBER	: a 'position' number is output instead of chars typed
 *		MSGLINE	: ONLY FOR getl(*).. for it to accept MAXMSGLINE chars
 *
 *****************************************************************************/

ask(question,str,maxchars,options)
 char *question,*str;
 int maxchars;
 register char options;
{
register char *temp,*temp1;

if ((strloc==0) || (glbstr[strloc]=='\0'))
	{
	send(question);				/* ask the question */
	getl(glbstr,options);			/* get the line */
	strloc=0;				/* make sure of this */
	}

/* now that we have line input	*/

temp1=0xffff;			/* initial not found flag */
temp=index(&glbstr[strloc],';');
if (temp==0) temp=0xffff;	/* convert 0 to ffff for easy compare */

if (sepstr)
	{
	temp1=index(&glbstr[strloc],sepstr);
	if (temp1==0) temp1=0xffff;
	}
if (temp!=temp1) /* if not both 0xffff */
	temp<temp1 ? (*temp='\0') : (*temp1='\0',temp=temp1);

if (strlen(&glbstr[strloc])>=maxchars)
	glbstr[strloc+maxchars]='\0';		/* same here */

if (options & UP) upcase(&glbstr[strloc]);	/* all upper case if spec'd */

strcpy(str,&glbstr[strloc]);		/* copy it to where it's wanted */

if (temp!=0xffff) strloc=(temp-glbstr)+1;	/* updates strloc if ';' */
	else strloc=0;				/* else start over */

	/* kill trailing blanks */
/* for (temp=str+strlen(str); temp!=str && isspace(*temp); *(temp--)='\0'); */

}	/* ask */


/* read a line of input from console */

getl(s,options)
 char *s,options;
{
register char c;
register int llen;
char *temp;
register int count;

if (!echo_flag) options|=NOECHO;	/* force no echo if this set */

if (options&MSGLINE) llen=O.MAXMSGLINE;
	else llen=MAXLINE;
temp=s; count=0; s=temp;

if ((user.parm.bell)==PON) putchar(7);	/* ring bell */
while ((c=getd()) != '\r' )
	{
	if (c=='\n') c=' ';	/* convert a linefeed to a space.. */
	if (c=='\b' || c==0x7f)
		{		/* backspace or DEL */
		if (!count) continue;
		--count;
		--s;
		if (!(options & NOECHO) || (options & NUMBER)) send("\b \b");
		continue;
		}
	if (c>31)		/* tab goes in directly */
		{
		if (count<llen)
			{
			*s++=c;
			++count;
			}
			else c=0;	/* don't echo */
		if (count>=llen-8 && (count&1))	/* bell every other char */
			putchar(7);
				
		}
	if (c==9)
		{
		if (count+16<llen)
			for (c=0;c<8;++c,++count) *s++=' '; /* fill spaces */
		c=9;
		}
	if ((c==24) || (c==21))
		{		/* ^X or ^U cancels line */
		send("#\n");
		count=0; s=temp;	/* clear buffer (effectively) */
		}
	else if (!(options & NOECHO))
		{
		if (c==9) for (c=0; c<8; c++) putchar(' '); /* tab */
		  else if (c>31) putchar(c);
		}
	     else if ((options & NUMBER) != 0) putchar( (count % 10)+'0');

	} /* while */
*s='\0';	/* end of string */
putchar('\n');
return temp;
}


static char line=1;	/* current line (relative to last input)	*/

/**************
 * New putchar that counts columns
 *************/

putchar(ch)
 register int ch;
{
static int pos=0;	/* position on line */
register int i,c;

c=NULL;	/* returned character for MORE prompt */

if (ch=='\t')		/* check for tab and expand */
	{
	for (i = 0;  i <= (pos+8)-((pos+8) & 0xf8);  i++)
		putchar(' ');
	return;
	}

if (ch=='\n') { pos=0; line++; outc('\r'); outc(ch); }
 else { if (ch>=' ') pos++; outc(ch); }

if (ch=='\r') pos=0;	/* reset posistion on line to zip */

if (line>=height && height!=0)
	{
	new_page();	/* MUST BE HERE OR RECURSIVE PUTCHAR WILL CROKE */
	if (user.parm.expert==POFF)
		{
		printf("[Press RETURN to continue]");
		c=getd();		/* get char which clears lines */
		putchar('\n');
		}
	  else	{
		printf("  ");
		c=getd();
		putchar('\r');
		}
	}

return c;
} /* new putchar */


outc(ch)
 register int ch;
{
bdos(6,ch);
if (print_flag==ON) bdos(5,ch);		/* if printer flag on, write to it */
}


/* new getchar to clear line variable, etc..	*/

getchar()
{
register int cfast;

cfast=(getd()&0x7f);
if (echo_flag) putchar(cfast);

return cfast;
}

getd()
{
register int cfast;
new_page();		/* reset line counter */
cfast=c_wait();
if (user.status==SYSOP)
    if (cfast==0x10)	/* ^P */
	{
	if (print_flag) print_flag=OFF;
		else print_flag=ON;
	return c_wait();
	}
if (cfast==5)		/* ^E */
	{
	if (echo_flag) echo_flag=OFF;
		else echo_flag=ON;
	return c_wait();
	}
return cfast;
}

c_wait()
{
register int cfast;
while(!(cfast = (bdos(6,0xff) & 0x7f) ) );
return cfast;
}


new_page()
{
line=1;
}


/************************************************************************
 * To add your own clock routine, define the RTC clock setup to COMPUPRO or
 * HAYES then change the routine below to read your clock board, and put the
 * time and date (formated hh:mm:ss and mm-dd-yy) in the variables
 * (character pointers) time and date.	 
 ************************************************************************/

/******************************************************
 * CompuPro/ccs/qx10/Hayes, etc. read clock functions *
 ******************************************************/

readclock()
{
register int i;
int match_flag;
char t;

/* compupro/ccs vars */

char clock_buf[6]; 	/* place to put what's read */
static int p[12] = { 5,4,3,2,1,0,10,9,8,7,12,11 };	/* commands */

setmem(clock_buf,6,0);	/* clear bcd digit buffer */

if (O.RTC==COMPUPRO || O.RTC==CCS)
 {
 if (O.RTC==COMPUPRO)
  {
  for (i=0; i<12; i++)
	{
	out((char)O.CLKCMD,p[i]+0x10);
	t=in((char)O.CLKDATA);
	if (!i) t=(t-8)&0xf;
	clock_buf[i/2] |= (i&1) ? t : (t<<4);
	} /* for */
  } /* end of compupro routine */
else
 if (O.RTC==CCS)
  {
  out((char)O.CLKCMD,0xf);
  out((char)O.CLKCMD,3);	/* A chan. output mode/no interupts */
  out((char)O.CLKCMD+2,0xcf);
  out((char)O.CLKCMD+2,0xcf);	/* B chan. input mode */
 
  for (i=0; i<12; i++)
	{
	out((char)O.CLKDATA,p[i]|0x40);		/* hold digit */
	while (in((char)O.CLKDATA+2) & 0x40);	/* wait til held */

	out((char)O.CLKDATA,in((char)O.CLKDATA)+0x10);
	while (in((char)O.CLKDATA+2) & 0x80);	/* ok data wait */
/* all that to read a darn digit... */
	t=in((char)O.CLKDATA+2);
	if (!i) t=(t-8)&0xf;
	clock_buf[i/2] |= (i&1) ? t : (t<<4);
	out(O.CLKDATA,0);		 	/* clear wait flag */
	} /* for loop */
  } /* end of ccs routine */

/* common ccs/compupro code */

clock_ascii(time,date,clock_buf,clock_buf+3);

 } /* ccs+compupro */
   else
     if (O.RTC==HAYES)		/* hayes chronogragh */
	{
	char tdate[DATELEN+1];
	outpstr(O.CLKCMD,O.CLKOMASK,O.CLKDATA,"\r\r\r\r\rATVD-\r");
	inpstr(O.CLKCMD,O.CLKIMASK,O.CLKDATA,'\r',2,date);
	outpstr(O.CLKCMD,O.CLKOMASK,O.CLKDATA,"\r\r\r\r\rATVT:\r");
	inpstr(O.CLKCMD,O.CLKIMASK,O.CLKDATA,'\r',2,time);
	for (i=0; i<500; i++);
	outpstr(O.CLKCMD,O.CLKOMASK,O.CLKDATA,"\r\r\r\r\rATRD\r");
	inpstr(O.CLKCMD,O.CLKIMASK,O.CLKDATA,'\r',9,tdate);	/* get date */
	outpstr(O.CLKCMD,O.CLKOMASK,O.CLKDATA,"\r\r\r\r\rATRT\r");
	inpstr(O.CLKCMD,O.CLKIMASK,O.CLKDATA,'\r',9,time);	/* get time */
	tdate[2]='\0';  tdate[8]='\0';
	sprintf(date,"%s/%s",tdate+3,tdate);	/* change to mm/dd/yy */
	} /* Hayes.. */

  if (O.RTC==QX10)
	{

#asm
	push	h
	push	d
	push	b
	lxi	h,buffer_	; location to put results in..
	call	CREAD		; read the sucker...
	pop	b
	pop	d
	pop	h
	jmp	ENDQX10
;
; new QX10 routine for independent of os use...
; Submitted by Norm Greggory  Used with permission.. (comments are his):
;****************************************************************************
;  (bye version)
;  v1.2 June 1985   Norm Gregory   Seattle 'downspout' 206-325-1325
;
; NOTE: It is no longer required that the user define the starting address
;       of the BIOS area. Modifications allowing fuller compatibility
;       with most versions of CP/M have been incorporated (i.e. removing
;       the need for indirect access to clock via BIOS jump table.
;
;	Since we are accessing the CMOS chip directly this insert should
;	work under any QX-10 operating system.
;
; THANKS TO:  Roger Lanphere (Mt Vernon, WA) for invaluable help whenever
;	asked.  Mick Gaitor (Brooklyn, NY) for much of the code here.  I
;	borrowed heavily from his MXC-QX10.ASM.  If you are using MEX on
;       your QX-10 you should be using his overlays.  Super job Mick!
;	And Wayne Masters (San Jose, CA) for all his BYE3 work and help 
;	with the inserts.       - NG (06/14/85)
;
;****************************************************************************
;
BUSY    EQU     80H             ;Mask to test for clock busy condition
CLKADR  EQU     3DH             ;QX-10 clock command register port
CLKDAT  EQU     3CH             ;QX-10 clock data register port
STBYTE  EQU     0AH             ;Clock memory addr to check for clock busy
CENTURY EQU    015h		;Hey, it's the 1900's (for a while).
;
;=========
;
; CREAD: gets date/time directly from the LSI 46818 chip.
;        (doing it this way rather than through the QX-10 BIOS
;        call makes this overlay independent of the version
;        of the Epson CPM (A or B) being used.)
;
; Time/Date buffer consists of 6 bytes of packed BCD-encoded information
; located in buffer TBFR.   Time/Date buffer is of the following format:
;
;        TBFR  + 0      = month
;              + 1      = day
;              + 2      = year
;              + 3      = hour
;              + 4      = minute
;              + 5      = second
;
CREAD:
        CALL    CLKBSY          ;Wait till clock is idle
; we pass this!         LXI     H,TBFR          ;Point to time/date buffer
        LXI     D,ADRTBL        ;Point to clock memory data address table
        MVI     B,6             ;Number of data items to read
TDLOOP: LDAX    D               ;Get next clock memory data address
        OUT     CLKADR          ;and send addr to clock port
        IN      CLKDAT          ;Read clock data
        MOV     M,A             ;and store in time/date buffer
        INX     H               ;Set next time/date buffer position
        INX     D               ;Set next clock memory data address
        DCR     B               ;One less data item
        JNZ     TDLOOP          ; - continue read till done
        RET
;
CLKBSY:                         ;Routine to wait till clock is idle
        MVI     A,STBYTE        ;Check if clock is updating
        OUT     CLKADR          ;Send address
        IN      CLKDAT          ;Read clock
        ANI     BUSY            ;Test bit 7
        JNZ     CLKBSY          ;Jump if clock busy
        RET
;
ADRTBL: DB      8,7,9,4,2,0     ;Clock memory addr tbl for mo,da,yr,hr,min,sec
;		9,8,7,4,2,0 (was)	yr,mo,da...
;***************************************************************************
;
ENDQX10: nop
;
#endasm
	;	/* will this work? */
	clock_ascii(time,date,buffer+3,buffer);
	} /* if QX10 */

  if (O.RTC==KENMORE)
	{
	do {
	   for (i=7; i>1; i--)
		buffer[7-i]=in((char)O.CLKDATA+i);

	   match_flag=TRUE;

	   for (i=7; i>1; i--)
		if (buffer[7-i] != in((char)O.CLKDATA+i))
			match_flag=FALSE;
	   } while (!match_flag);

	buffer[2]=O.CLKCMD;	/* get year from config.. */
	clock_ascii(time,date,buffer+3,buffer);
	}

} /* readclock */


clock_ascii(t,d,tb,db)
 char *t,*d,*tb,*db;
{
sprintf(t,"%02x:%02x:%02x",(int)tb[0],(int)tb[1],(int)tb[2]);
sprintf(d,"%02x/%02x/%02x",(int)db[0],(int)db[1],(int)db[2]);
}


getdate()
{
if (O.RTC!=NOCLOCK) readclock();
return date;
}


/******************************************************************
 * compare times, return minutes difference.  Works for 47:59 hours.
 * passed: current time, compare time, current date, compare date
 ******************************************************************/

timecomp(t1,t2,d1,d2)
 char *t1,*t2,*d1,*d2;
{
register int mins1,mins2,mins;

mins1=atoi(t1+3); mins1+=(atoi(t1)*60);
mins2=atoi(t2+3); mins2+=(atoi(t2)*60);
if (strcmp(d1,d2)) mins1+=1440;	/* dates have changed. Add a day */

return mins1-mins2;
}	


/*************************************
 * output string to port specified.  *
 *   expected is:  1) status port    *
 *   2) data out mask  3) data port  *
 *   4) the string to be sent        *
 * note: nulls may not be sent via   *
 * this routine!!  0 terminates str  *
 * if data/status>255 then memory    *
 * mapped i/o is performed	     *
 *************************************/

outpstr(stat,stmask,data,string)
 unsigned stat,data;
 char stmask;
 register char *string;
{
while (*string) outchar(stat,stmask,data,*string++);
}


outchar(stat,stmask,data,c)
 register unsigned stat,data;
 char stmask,c;
{
if (stat>255)
	{
	while (!( (*(char *)stat & stmask)));
	*(char *)data=c;
	}
  else {
	while (!( in((char)stat) & stmask));
	out((char)data,c);
	}
}


/********************************
 * input string from port...	*
 * parms:  1) status port	*
 * 2) status mask  3) data port	*
 * 4) end of string char	*
 * 5) max chars over all	*
 * 6) string pointer to place	*
 * string			*
 *  note: same as above for 	*
 * memory mapped ports..	*
 ********************************/

inpstr(stat,stmask,data,eos,max,string)
 unsigned stat,data,max;
 char stmask,eos;
 register char *string;
{
char inpchar();

*(string+max)='\0';	/* make sure of termination */

while (max--)
	{
	*string=inpchar(stat,stmask,data) & 0x7f;
	if (*(string++)==eos)
		{
		*(string-1)='\0'; /* terminate, and abort */	
		break;
		}
	}
} /* inpstr */


char inpchar(stat,stmask,data)
 register unsigned stat,data;
 char stmask;
{
unsigned to=50000;
while ( to-- && !( ((stat>255) ? *(char *)stat : in((char)stat)) & stmask) );
return ( (data>255) ? *(char *)data : in((char)data) );
}


/************************************************************************
 * String functions...							*/


/* convert string to all upper case */

upcase(str)
register char *str;
{
for (;*str;++str) *str=toupper(*str);
}


/* check for a space in the given string  (returns 1 if space, else 0) */

isspc(str)
register char *str;
{
while(*str) if (*str++<=' ') return TRUE; /* return TRUE if space/cntrl */
return FALSE;	/* else FALSE returned */
}


/* capitalize a string (all words in the string */

capstr(str)
 char *str;
{
register char *tp;

*str=toupper(*str);	/* first char is easy */

for ( tp=str; tp<str+strlen(str); ++tp )
	{
	if (*tp==' ') if (*(tp+1)!='\0') *(tp+1)=toupper(*(tp+1));
			else break;
	}
}


/* case independent string compare function */

ustrcmp(s1,s2)
 register char *s1,*s2;
{
for ( ; toupper(*s1)==toupper(*s2); s1++, s2++)
	if (*s1=='\0') return (toupper(*s1)-toupper(*s2));
			/* if at end of first string, test for=length/return */

return (toupper(*s1)-toupper(*s2));
}

/* case independent string compare function */

ustrncmp(s1,s2,n)
 register char *s1,*s2;
 register int n;
{
for ( ; (toupper(*s1)==toupper(*s2)) && (n>0); s1++, s2++, n--)
	if (*s1=='\0') return (toupper(*s1)-toupper(*s2));
			/* if at end of first string, test for=length/return */

return (n ? (toupper(*s1)-toupper(*s2)) : 0);
}


/*****************************
 * Same as index(s,c), but with two strings
 *****************************/

sindex(s1,s2)
 register char *s1,*s2;
{
 register char *sp;

for (sp=s2; strlen(s1)<=strlen(sp); sp++)
	if (!strncmp(s1,sp,strlen(s1))) return sp;

return 0;	/* no match */
}


/*****************************
 * Same as sindex(s1,s2), but IGNORE CASE in comparison
 *****************************/

usindex(s1,s2)
 char *s1,*s2;
{
 register char *sp;

for (sp=s2; strlen(s1)<=strlen(sp); sp++)
	if (!ustrncmp(s1,sp,strlen(s1))) return sp;

return 0;	/* no match */
}


/* get the counters from counters file */

gcntrs(f)
char *f;
{
char tdate[DATELEN+1];

#ifndef MULTI_USER
int id_num;		/* make dumby local copy if single user */
#endif

/* in case of failure.... */

callnum=id_num=0;	/* for defaults in case nothing found */

if ((counters=open(f ? f : COUNTERS,F_RD | F_LOCK))!=0)
	{
	read(counters,0);
	sscanf(bufloc(counters),"%d %d %d %s %d %d",&msgcount,
		&callnum,&nextmsg,(O.RTC ? tdate : date),&id_num,&privmsgs);

#ifdef TURBODOS

	if (strncmp(in_loc,ID_STR,3))
		{
		sprintf(bufloc(counters),"%d %u %u %s %d %d",msgcount,callnum,
			nextmsg,date,++id_num,privmsgs);
		write(counters,0);
		strcpy(id_loc,ID_STR);
		*(id_loc+3)=(char)id_num;
		}

#endif	/* TurboDos */

	close(counters);
	}
}


/* put the counters file on disk */

pcounters(f)
 char *f;
{
#ifndef MULTI_USER
int id_num=0;
#endif

counters=open(f ? f : COUNTERS,F_RW | F_LOCK);
 sprintf(bufloc(counters),"%d %u %u %s %d %d",msgcount,callnum,
	nextmsg,date,id_num,privmsgs);
 write(counters,0);
close(counters);
}


/* output string to the 25th status line.. */

writestat(str)
 register char *str;
{
if (O.STATUSLINE)		/* 25th line status display on???? */
   {
   if (O.OSMASK)
	{
	outpstr(O.OSTAT,O.OSMASK,O.ODATA,O.TO25);  /* get to 25th line	*/
	outpstr(O.OSTAT,O.OSMASK,O.ODATA,str);	   /* output string	*/
	outpstr(O.OSTAT,O.OSMASK,O.ODATA,O.FROM25);  /* get back	*/
	}
   else	{	/* otherwise O.ODATA is address of output routine BIOS DEP! */
	outsbios(O.TO25);
	outsbios(str);
	outsbios(O.FROM25);
	}
   }
}

outsbios(s)
 register char *s;
{
while (*s) outcbios(*s++);
}

char glob_ch;	/* so I can find the char easily */
char *glob_ad;

outcbios(c)
 register char c;
{
glob_ch=c;
glob_ad=O.ODATA;

#asm
	lda	glob_ch_
	mov	c,a
sillyk:	lxi	d,sillyk+8	; terrible kluge, do not change following
	push	d		; instructions without changing this too!!!
	lhld	glob_ad_
	pchl
	nop

#endasm

}


/*  Linkbye...   This routine loads and runs BYE.COM, this will disconnect
 * 	the current caller.  BYE86 needs this to be done since the location
 *	0 (c3/cd) disconnect trick doesn't work under it.
 *
 *  3/7/85
 */

linkbye()
{
setusr(fcbinit(BYE,0x5c));	/* setup correct default FCB and right user */

#asm


;	This is taken from mentr.asm routine..
;
; The routine moves itself into the bffer at 80h, and procedes to load the
; program that is called for...	Kludgey, but effective..
;
	lxi	sp,0ffh
	mvi	c,0fh		; open code..
	lxi	d,005ch		; fcb
	call	0005		; bdos
	cpi	0ffh		; error?
	jz	0		; yes boot...
	lxi	d,loader
	lxi	h,0080h		; dma..
	lxi	b,07fh
movloop:
	ldax	d
	mov	m,a
	inx	d
	inx	h
	dcr	c
	jnz	movloop
;	lxi	sp,0ffh		; stack goes to a safe place
	lxi	b,005ch		; fcb
	jmp	080h		; jump to loader...
;
loader:
	lxi	d,100h		; tpa
load1:
	push	d
	push	b
	mvi	c,1ah		; set dma..
	call	0005		; bdos
	pop	d
	push	d
	mvi	c,14h		; read seq.
	call	0005		; bdos
	pop	b
	pop	d
	ora	a		; error?
	jz	80h+(bumpdma-loader)	; jrz bumpdma
a1:	mvi	c,1ah		; set dma
	lxi	d,0080h		; reset default dma address..
	call	0005		; bdos
	mvi	c,10h		; close
	lxi	d,05ch
	call	0005
	jmp	100h		; tpa.. (program just loaded)
;
bumpdma:
	lxi	h,0080h
	dad	d
	xchg
	jz	80h+(load1-loader)	; jr loader
;
lend:	db	0

#endasm

}


/******************************************************************
 * initialize the bye variable to point to location if BYE active */

findbye()
{
register char *p;

bye=(*(char *)2)*256+*(char *)1-2;
bye=(*(char *)(bye+1))*256+*(char *)bye+6;

/* bye keeps mucking everyone up by changing the locations of strings */
for (p=bye; p<=bye+35; p++)
	if (!ustrncmp("bye",p,3)) break;

if (p>=bye+25) bye=nothing;

/* now for the values that we use the bye variable for.. */
maxuser=bye;
tout=bye+2;
nulls=bye+3;
}


/* EOF hmlib.c */

