
/*  Library version of help routines.. */


#include "xpm.h"	/* CPMIO header file for i/o operations.*/
#include "megen.h"	/* general defines		*/
#include "meglob.h"	/* global variable definitions	*/
#include "meovfn.h"	/* overlay function numbers	*/
#include "mefiles.h"	/* file names			*/

#include "ctype.h"


typedef struct {
	char	file_stat;	/* 00=file here.. ff=empty	*/
	char	file_name[11];	/* filename (like fcb setup)	*/
	int	seek;		/* seek location in file	*/
	int	length;		/* number of records in file	*/
	char	pad[16];	/* crc/pad..			*/
	} lib_fcb;

static FILE *l_fd=0;		/* init to point to nothing..	*/
static char l_name[18];		/* name of last library file	*/

ltype(libname,mname)
 char *libname;		/* library name */
 char *mname;		/* member name  */
{
lib_fcb *l_fcb;
int ndrecs;		/* number of directory records to scan	*/
register int i,n,flag;

if (strcmp(libname,l_name))	/* no match.. close old, open new */
	{
	close(l_fd);
	if ( !(l_fd=open(libname,0)) )	/* error on open */
		{
		*l_name='\0';		/* clear for next */
		return ERROR;
		}
	strcpy(l_name,libname);	/* make new name */
	}

/* library open..  scan for member.. and display (like type) */

l_fcb=bufloc(
read(l_fd,0);
ndrecs=l_fcb->length;

flag=TRUE;
for (i=1; i<ndrecs && flag; i++)
	{
	for (n=0; n<4; n++)
		{
		l_fcb=bufloc(l_fd)+(n*32);
		if (!strncmp(l_fcb,mname,11))
			{
			flag=FALSE;
			break;
			}
		}
	read(l_fd,1);
	}

if (flag) return ERROR;		/* member not found */





