;
;  File: MEINIT.ASM
; 
;  This file can be used as a starting point for an initialization
; routine file Metal/Z-Msg versions 1.40xx..SUBJECT TO CHANGE!!!
;
;  This is an entirely optional insert file.
;
;  An initialization routine is handy for setting up other remote
; access system programs (eg. bye).  The following information is
; passed to this routine from the message system:
;
;	. Whether or not BYE is active
;	. a pointer to the 'user structure' which contains the user
;	  name, where they are from, etc..
;	. a pointer to the 'user status' parameter block coresponding
;	  to the current user.  This will give things like the max
;	  amount of time allowed on the system, max user, max drive, etc..
;
;   The init routine is called after the user name and password have
; been verified by the system.
;
; *** This routine must not excede 251 bytes in length !! ***
;				   ===

	org	384h		; fixed location to put it at..

	db	0ffh		; flag to tell message system init routine
				; is installed...
bye:	db	00		; passed flag if bye is active..
user:	dw	0000		; pointer to user structure
status:	dw	0000		; pointer to user status info
	db	00,00,00,00,00,00	; reserved for later..

; The following are offsets from 'user' above

unumber	equ	0	; user number (also seek pos into users file) (2 bytes)
uname	equ	3	; full name of user           (0 terminated string)
upass	equ	30	; password                    (0 terminated string)
ucity	equ	39	; city of user                (0 terminated string)
udate	equ	66	; date last on         (BCD coded MMDDYY - 3 bytes)
utime	equ	69	; time last on         (BCD coded HHMM   - 2 bytes)
ulastrd	equ	71	; message at last login               (2 bytes)
ustatus	equ	73	; user status character (+snXxabc)    (1 byte)
ujmpos	equ	74	; auto jump to OS on login? (bit 1 ON=yes) (1 byte)
uflags	equ	75	; flags as follows: bit 1=expert mode
			; 		    bit 3=bell enable
			;		    bit 4=read new msgs flag
unulls	equ	76	; nulls                               (1 byte)
uwidth	equ	77	; terminal width                      (1 byte)
uheight	equ	78	; terminal height                     (1 byte)
umins	equ	79	; minutes on today    (1 byte) --not used yet--
tothour	equ	80	; total hours on system (2 byte, --not used yet--)
totmins	equ	82	; remainder total mins on system (1 byte  --NUY--)
ucalls	equ	83	; unsigned number of calls            (2 byte)
uupload	equ	85	; upload file count   (2 byte) --not used yet--
udnload	equ	87	; download file count (2 byte) --not used yet--
udef	equ	124	; You can actually use these locs..   (124-127)

; The following offsets are from 'status' above...
; (these are same as version 1.3xx)

sstatus	equ	0	; status char (+snXxabc)
smaxdrv	equ	1	; max drive
smaxusr	equ	2	; max user
sacttout equ	3	; activity timeout in mins (timeout if not typing)
skillflg equ	4	; kill messages flag..
szcprflg equ	5	; wheel privs?
sreadprv equ	6	; read private msgs?
spostmsg equ	7	; allowed to post messages?
stimeout equ	8	; logoff timeout in minutes
sz3flags equ	9	; 2 byte commands file flag (zcpr3 only)


;  *********************************************************
; * Insert your routine here..  IT MUST PRESERVE REGISTERS  *
;	  v   v   v   v   v   v   v   v   v   v   v   


;
;
	ret		; simple return ends routine

; Last byte in routine must not be at an address over 047FH...
