;CBBS V3.5.0 	CBBSSUB3.ASM - NON-DISK ROUTINES # 3
;07/11/81 12:58:23
;	LINKS TO CBBSIDS	IDS
;		 CBBSHAYS	HAYES
;		 CBBSPMMI	PMMI
;	    OR	 CBBSMODM	SERIAL
;
;	O O O	O   O	O O	 O O
;	O 	O   O	O   O	O   O
; CBBS	O O O	O   O	O O	   O 	.ASM
;	    O	O   O	O   O	O   O
;	O O O	O O O	O O	 O O
;
;MOD LOG: (THRU 3.2 MOVED TO "HISTORY")
;
;====> HISTORICAL COMMENTS SINCE 3.3 TO "HISTORY.033"
;
;---->	SETTAB CONVERTS SPACES IN A LINE TO TABS.
;CALLED PRIOR TO WRITING A LINE TO DISK, TO SAVE
;DISK SPACE.
;
;INPUT	HL = LINE TO CONVERT.
;OUTPUT	HL = CONVERTED LINE (CONVERTED IN PLACE)
;
SETTABS	PUSH	H	;SAVE BUFF ADDR
;
;SETTABS PASS 1: STORES TABS EVERY 8 COLUMNS, PROVIDING
;THERE IS A SPACE IN THE COLUMN.
;
	MVI	B,1	;SET COLUMN
STTBL	MOV	A,M	;GET CHAR
	CPI	CR	;END?
	JZ	STTB2	;YES, TO PASS 2
	MOV	A,B	;AT A..
	ANI	7	;..TAB STOP?
	JNZ	STTNT	;NOT TIME FOR TAB
	MOV	A,M	;STORE TAB IF..
	CPI	' '	;..IT'S A SPACE
	JNZ	STTNT	;..NOT A SPACE
	MVI	M,TAB	;OVERLAY SPACE
STTNT	INX	H	;TO NEXT CHAR
	INR	B	;BUMP COLUMN
	JMP	STTBL	;LOOP
;
;SETTABS PASS 2: BACKS UP THRU THE LINE STORING 00H
;IN EVERY BYTE PRECEDING A TAB.
;
STTB2	DCR	B	;BACK UP COL #
	JZ	STTB3	;DONE?
	DCX	H	;BACK UP COL ADDR
	MOV	A,M	;GET CHAR
	CPI	TAB
	JZ	STTB2T	;GOT A TAB
	ORA	A	;GET A NULL?
	JNZ	STTB2	;NO, LOOP
STTB2T	DCR	B	;BACK UP COL
	JZ	STTB3	;TO PASS 3 IF DONE
	DCX	H	;BACK UP COL
	MOV	A,M	;GET CHAR
	CPI	TAB	;IF TAB SKIP..
	JZ	STTB2T	;..BACK OVER IT
	CPI	' '	;IF NOT SPACE,..
	JNZ	STTB2	;..DON'T..
	MVI	M,0	;OVERLAY ' ' WITH OOH
	JMP	STTB2T	;LOOP
;
;SETTABS PASS 3: DELETE NON-ESSENTIAL TABS,
;I.E. ONES WHICH FUNCTIONALLY CAN BE REPLACED
;BY A SINGLE SPACE.
;
STTB3	INX	H	;TO NEXT CHAR
	MOV	A,M	;GET CHAR
	CPI	CR	;END?
	JZ	STTB4	;TO PASS 4
	CPI	TAB	;LOOP IF..
	JNZ	STTB3	;..NOT A TAB
	DCX	H	;PREVIOUS
	MOV	A,M
	INX	H	;A NULL?
	ORA	A
	JZ	STTB3	;YES, OK
	MVI	M,' '	;CHANGE TAB TO SPACE
	JMP	STTB3
;
;SETTABS PASS 4: DELETES THE NULLS (00H)
;PACKING THE LINE IN PLACE.
;
STTB4	POP	H	;GET BUFF ADDR
	PUSH	H	;SAVE BACK
	MOV	D,H	;HL = INPUT POINTER
	MOV	E,L	;DE = OUTPUT POINTER
STTB4L	MOV	A,M	;GET CHAR
	ORA	A	;NULL?
	JZ	STTB4N	;YES, SKIP STORE
	STAX	D	;SAVE OUTPUT
	INX	D
STTB4N	INX	H
	CPI	CR	;END OF BUFF?
	JNZ	STTB4L	;NO, LOOP
	POP	H	;GET BUFF
	RET
01;START OF MODS
;
;ROUTINE TO FLUSH THE BUFFERS IF RUNNING UNDER FAST
;
 	IF	FAST	;OPTIONAL BUFFERING?
;
FLUSH	PUSH	B
	PUSH	D
	PUSH	H
	LHLD	1	;GET WARM BOOT
	INX	H	;POINT TO LO(W.BOOT)
02	INX	H	;POINT TO HI(W.BOOT)
	MOV	A,M	;SEE WHERE WBOOT IS
	CMP	H	;JUMPING LOWER IN MEM?
	JZ	FLUSHRT	;NO, NO FAST
	JNC	FLUSHRT	;NO FAST
;
;FLUSH BUFFERS
;
	LHLD	6	;GET BDOS ADDR
	DCX	H
	DCX	H
	DCX	H	;BACK UP TO FLUSH ENTRY
	MOV	A,M	;MAKE SURE ITS A JMP
	CPI	0C3H
	CZ	PCHLIT	;GO FLUSH
FLUSHRT	POP	H
	POP	D
	POP	B
	RET
;
PCHLIT	PCHL
	ENDIF		;FAST
01;END OF MODS '01'
;
;LINK TO APPROPRIATE NEXT .ASM FILE
;
	IF	IDS
	LINK	CBBSIDS
	ENDIF
;
	IF	HAYES
	LINK	CBBSHAYS
	ENDIF
;
	IF	PMMI
	LINK	CBBSPMMI
	ENDIF
;
	IF	SERMODM
;	LINK	CBBSMODM
	link	cbbswork
	ENDIF
;
..ERROR AT END OF 'CBBSSUB3.ASM': NO MODEM SELECTED
;
;- YOU DID NOT SELECT ANY OF THE SUPPORTED
;MODEMS, AND SET ONE OF THE FOLLOWING TO TRUE:
;
;	PMMI, IDS, HAYES, OR SERMODM
;
