;	 O O	O O O	O O O
;	O   O	O   O	O	O   O
; CBBS	O   O	O O O	O O	O O O	.ASM
;	O   O	O	O	O O
;	O O O	O	O O O	O   O
;
;
;MODS   O	OO OO
; CBBS	O O O	O   O	O   O	O O O	.ASM
;	O   O   O   O   O   O   O   O
;	O   O   O O O   O O     O   O
;
;MODIFICATIONS LOG:
;
;	10/29/79
;ORIGINALLY WRITTTEN;
;
;====> HISTORICAL COMMENTS SINCE 3.3 TO "HISTORY.033"
;
;OUTBOARD MODEM CONTROL PORT EQUATES
;
MODMCTL	EQU	2a00H	;USE SSW FOR TESTING
;	INPUT BITS IN MODMCTL
MODMCTS	EQU	02H	;(NOT) CTS (I.E. CARRIER)
MODMRI	EQU	20H	;(NOT) RING INDICATOR
;	OUTPUT BITS FOR MODMCTL
MODMFH	EQU	10H	;OFF HOOK
;
;SERIAL PORT INIT CHARS
;
SERLCTL	EQU	2a00h	;CONTROL PORT
SERLDAT	EQU	serlctl+1	;DATA PORT
SERLIN1	EQU	00H	;FIRST INIT CHAR
SERLIN2	EQU	00H	;SECOND INIT CHAR
SERLDAV	EQU	2	;DATA AVAILABLE
SERLTBM	EQU	1	;XMIT BUFF EMPTY
;
;ROUTINE TO CONNECT TO THE CALLER
;
CONNECT	EQU	$
	MVI	A,CTLMOTR ;LEAVE DISKETTE..
	OUT	CTLPORT	;..MOTOR ON
;
	MVI	A,MODMFH ;OFF HOOK
	OUT	MODMCTL	;TO MODEM CTL PORT
;
	MVI	A,SERLIN1
	OUT	SERLCTL	;INIT CHAR 1
	MVI	A,SERLIN2
	OUT	SERLCTL	;INIT CHAR 2
;
	MVI	B,15	;APPROX # SEC. DELAY
DELAY	LXI	H,9A00H	;1 SEC DELAY
DELLP	IN	MODMCTL
	ANI	MODMCTS
	JZ	GOTCAR	;EXIT LOOP IF CARRIER FOUND
	DCX	H	;DECR. LOOP COUNT
	MOV	A,H
	ORA	L
	JNZ	DELLP
;DELAYED ANOTHER SECOND, MORE SECONDS?
	DCR	B	;DCR SECONDS
	JNZ	DELAY	;YES
	JMP	NOCAR
;
;LOOK FOR C/R AT EACH SPEED
;
GOTCAR	MVI	A,10+1	;10 TRIES FOR C/R
	STA	TRIES
;
;QUIT IF NO C/R HAS BEEN READ AFTER 10 TRIES
;
TRY1	LXI	H,TRIES
	DCR	M
	JZ	NOCAR	;NO CARRIER
;
	CALL	CKCR	;C/R OF LOSS OF CARRIER?
	RZ
	JMP	TRY1	;TRY 10 TIMES
;
;TEST FOR C/R ENTERED, OR LOSS OF CARRIER
;
CKCR	CALL	KEYIN
	CPI	CR
	RZ
	INR	A	;FF MEANS NO CARR
	RNZ
;
;NO CARRIER FOUND
;
NOCAR	LXI	H,NOCON
	JMP	PRDIS	;PRINT MSG, EXIT TO PROM
NOCON	DB	CR,LF
	DB	'++NO C/R SEEN, OR LOSS OF CARRIER'
	DB	CR,LF,'    ',0
;
;HANGUP THE PHONE, WAIT 1 SEC, RETURN
;
HANGUP	XRA	A
	OUT	MODMCTL	
	LXI	H,0	;ABOUT 1 SEC @ 2MHZ
HANGWT	DCX	H
	MOV	A,H
	ORA	L
	JNZ	HANGWT
	RET
;
;WAIT FOR PHONE TO RING IF RE-INIT
;
	IF	REINIT
RINGWT	IN	MODMCTL	;INPUT STATUS PORT
	ANI	MODMRI	;RINGING?
	JZ	START
	IN	SSW	;GO TO START IF REMOTE
	ANI	REMOTE	;..SWITCH TURNED OFF
	JZ	START
	JMP	RINGWT
	ENDIF		;REINIT
;
	LINK	CBBSWORK ;NEXT .ASM FILE
