;CBBS V3.5.0 	CBBSHAYS.ASM - HAYES MODEM
;07/11/81 12:58:51
;	LINKS TO CBBSWORK
;
;	O   O	O O O	O   O	O O O
;	O   O	O   O	 O O	O
;CBBS	O O O	O O O	  O	O O O	.ASM
;	O   O	O   O	  O 	    O
;	O   O	O   O	  O 	O O O
;
;MOD LOG (THRU 3.2 WRITTEN TO "HISTORY")
;
;<< NO FURTHER MODS >>
;
;DC HAYES MODEM BOARD EQUATES
;
DCHDAT	EQU	80H	;DATA PORT ADDRESS
;
;STATUS INPUT PORT, AND IT'S BITS:
;
DCHST	EQU	DCHDAT+1 ;STATUS PORT
;
DCHRI	EQU	80H	;RING INDICATE
DCHCD	EQU	40H	;CARRIER DETECT
DCHOE	EQU	10H	;OVERFLOW ERR
DCHFE	EQU	8	;FRAMING ERROR
DCHPE	EQU	4	;PARITY ERROR
DCHTRE	EQU	2	;TX REG EMPTY
DCHRRF	EQU	1	;RCV REG FILLED
;
;CONTROL OUTPUT PORT 1 AND IT'S BITS:
;
DCHCP1	EQU	DCHST	;CONTROL PORT 1
;
DCHPI	EQU	10H	;PARITY INHIBIT
DCHSBS	EQU	8	;STOP BIT SELECT
DCH8BT	EQU	4+2	;8 BIT SELECT
DCHEPE	EQU	1	;EVEN PARITY ENABLE
;
;CONTROL OUTPUT PORT 2 AND IT'S BITS:
;
DCHCP2	EQU	DCHST+1	;CONTROL PORT 2
;
DCHOH	EQU	80H	;1=OFF HOOK
DCHRID	EQU	20H	;1=RING INDICATE DISABLE
DCHTST	EQU	10H	;1=SELF TEST
DCHES	EQU	8	;1=ECHO SUPPRESS
DCHMS	EQU	4	;1=ORIG 0=ANS, (MODE SEL)
DCHTXE	EQU	2	;1=TRANSMIT ENABLE
DCHBRS	EQU	1	;1=300, 0=110 BAUD RATE SELECT
;
;		----
;
;CONNECT WITH CALLER, AWAIT CARRIER FOR 15 SEC
;
CONNECT	CALL	SET110	;PICK UP PHONE, 110 BAUD
	MVI	B,15	;APPROX # SEC. DELAY
DELAY	LXI	H,9A00H	;1 SEC DELAY
DELLP	IN	DCHST	;GET STATUS
	ANI	DCHCD	;CHECK FOR CARRIER
	JNZ	GOTCAR	;EXIT LOOP IF CARRIER FOUND
	DCX	H	;DECR. LOOP COUNT
	MOV	A,H
	ORA	L
	JNZ	DELLP
;DELAYED ANOTHER SECOND.
;MORE SECONDS?
	DCR	B
	JNZ	DELAY	;YES
	JMP	NOCAR
;
;PHASE 1 - LOOK FOR C/R AT EITHER SPEED
;
GOTCAR	MVI	A,10+1	;10 TRIES FOR C/R
	STA	TRIES
;
;QUIT IF NO C/R HAS BEEN READ AFTER 10 TRIES
;
TRY1	LXI	H,TRIES
	DCR	M
	JZ	NOCAR	;NO CARRIER
	CALL	SET110
	CALL	KEYIN	;GET A CHAR
	CPI	CR
	RZ		;OK.  GO WELCOME ABOARD
	INR	A	;LOSS OF CARRIER?
	JZ	NOCAR	;YES
	CALL	SET300
	CALL	KEYIN	;GET A CHAR
	CPI	CR
	RZ		;OK.  GO WELCOME ABOARD
	INR	A	;LOSS OF CARRIER?
	JNZ	TRY1	;NO, TRY AGAIN
;
;NO CARRIER FOUND
;
NOCAR	LXI	H,NOCON
	JMP	PRDIS	;PRINT MSG, EXIT TO PROM
;
NOCON	DB	CR,LF
	DB	'++NO C/R SEEN, OR LOSS OF CARRIER'
	DB	CR,LF,'    ',0
;
;BAUD RATE SET SUBROUTINES FOR HAYES MODEM
;
;SET SPEED TO 110 BAUD - PARITY INHIBIT, 2 STOP BITS,
;ANSWER MODE
;
SET110	MVI	A,DCHPI+DCHSBS+DCH8BT
	OUT	DCHCP1
	MVI	A,DCHOH+DCHRID+DCHTXE
	OUT	DCHCP2
	RET
;
;SET SPEED TO 300 BAUD, PARITY INHIBIT, 1 STOP BIT,
;ANSWER MODE
;
SET300	MVI	A,DCHPI+DCH8BT
	OUT	DCHCP1
	MVI	A,DCHOH+DCHRID+DCHTXE+DCHBRS
	OUT	DCHCP2
	RET
;
;ROUTINE TO HANG UP PHONE
;
HANGUP	XRA	A
	OUT	DCHCP2	;HANG UP
	RET
;
;IF RUNNING "REINIT", AWAIT PHONE RING.
;
	IF	REINIT
RINGWT	IN	DCHST	;INPUT HAYES STATUS PORT
	ANI	DCHRI	;RINGING?
	JZ	START
	IN	SSW	;GO TO START IF REMOTE
	ANI	REMOTE	;..SWITCH TURNED OFF
	JZ	START
	JMP	RINGWT
	ENDIF		;REINIT
;
	LINK	CBBSWORK ;NEXT .ASM FILE
