
/*
 *  @(#)timeblk.h	4.2          11/16/82
 * Tektronix 8560 Unix System Kernel
 *
 *	Based on Western Electric Version 7 Unix
 *
 *	Tektronix Modifications from Western Electric code
 *	Copyright C, 1981, Tektronix Inc.
 *	All rights Reserved
 */


/* timming information has been added to the unix kernel in a dozen
 *  places to give system engineering information on how much time
 *  unix spends in swaping, I/O, idle, and memory allocation, etc.
 *
 * some counters are updated at each clock interrupt, others are collected
 *  as approiate routine is called.
 * this block is pointed by the cvt table.  A user program will open 
 *  /dev/kmem every once in a while and read this data and output to a file
 *  for later interpretation?  (Feb 82 rexm)
 *
 * Modules affected:  
 *   /h/parm.h is where TIMMING is defined.
 *    /dev/pms.c iop.c bio.c  
 *    /sys/malloc.c slp.c sys1.c trap.c clock.c text.c
 *    /h/cvt.h is where timeblk is included and defined.
 *    /conf/mch.s 
 */

struct timeblk {
/*  routine conf/mch.s has the code to count the number of interrupts.
 *    Since you cannot ifdef, the code is commented out.
 *  The counter, like iop_, must be at the start of the timeblk structure,
 *    since the assembler doesnt know about sturctures.
 */
	long	num_intr;	/* # of interrupts */  

/*
 *  The iop information is collected in the iop driver iop.c ioprdwr()
 *   (iop must be first thing in data base because iop.c had too many
 *   ( symbols so only the first four of timeblk are defined there )
 */
#define MAXOPS 8
	int	iop_in[MAXOPS];	  /* # of input requests for iop/hsi per chan */
	long	iop_bin[MAXOPS];  /* # of bytes of input for iop/hsi per chan */

	int	iop_out[MAXOPS];  /* # of output requests for iop/hsi per chan*/
	long	iop_bout[MAXOPS]; /* # of bytes of output for iop/hsi per chan*/


/* utime,stime or idle are updated each tick in clock.c */
	long	utime;		/* time processor spent in user process */
	long	stime;		/* time processor spent in system process */
	long	idle;		/* idle time */
	int	error;		/* set if error found in timing routines */

/* num_dcmds is inc as each disk cmd is written to controller pms.c pmsstart()
 * num_dcmds is dec as each disk cmd is finished in pms.c pmsterm() 
 * (histogram) each tick hist_dcmd[num-dcmd]++ in clock.c 
 */
#define MAXDCMD 20		/* max number of disk cmds */
	long	hist_dcmds[MAXDCMD];

/* num_swaps is set to 0-4 depending of state of two local swap buffers being
 * BUSY and WANTED in code in dev/bio.c swap().
 * each tick, the histogram is updated in clock.c   hist_swap[num_swap]++
 */
#define MAXSWAPS 5
	long	hist_swaps[MAXSWAPS];

/* 
 * number on program loads and bytes loaded are updated in sys1.c getxfile().
 */
	long	pgm_loads;	/* number of program loads */
	long	pgm_dload;	/* number of program data load bytes */
	long	pgm_tload;	/* number of program text load bytes */

/*
 * routines effected include dev/bio.c, sys/slp.c sys/text.c.
 * swap() in bio.c add all writes to total counters
 * xswap()->xccdec() check to see if text sharable and no once else 
 *        using it then swaps out text.  (add to text counters)
 *
 *
 */
	long	texti_swaps;	/* number of text swap in requests */
	long	texti_bswaps;	/* number of bytes of text swaped in */

	long	texto_swaps;	/* number of text swap requests out */
	long	texto_bswaps;	/* number of bytes of text swaped out */

	long	totali_swaps;	/* number of total swap requests in */
	long	totali_bswaps;	/* number of bytes of total swaped in */

	long	totalo_swaps;	/* number of total swap requests out */
	long	totalo_bswaps;	/* number of bytes of total swaped out */

/*
 *   disk read/writes  in dev/pms.c
 *   number of cache hits is updated in routine incore() in bio.c
 */
	long	disk_reads;	/* number of disk reads */
	long	disk_writes;	/* number of disk writes */
	long	num_cache;	/* number of rd/wr cache hits on disk */

/* 
 *  exit info is collected in exit() routine in sys1.c
 */
	long	num_exits;	/* number of process exits */
	long	tim_exits;	/* wall clock time of completed processes */

/* memory and swap usage is done in malloc.c malloc() and mfree(),slp.c expand()
 *   mem_free +- size to free or expand.   
 *   ( depending on whether coremap or swapmap)
 *
 *    (highest amt of memory used) is check there also.
 *
 */
	long	mem_used;	/* clicks of used main memory */
	long	swap_used;	/* blocks of virtual memory used */

/*  num_calls is updated in trap.c when a trap 6 (system call) occurs
 *  num_ovl is updated in machdep.c sysphys()
 */
	long	num_calls;	/* number of system calls */
	long	num_ovl;	/* number of menlo overlay switches */




/*  These counter are placed at the end, so they won't be zeroed, when
 *    the application program collects this info.
 */
	int	num_dcmds;	/* current number of outstanding disk cmds */
	int	num_swaps;	/* number of outstanding swaps (0-4) */
	long	mem_high;	/* largest amt of memory ever used */
	long	swap_high;	/* largest amt of swap ever used */
} ;

#ifdef KERNEL
	extern struct timeblk timeblk;
#endif
