/*
 * @(#)bootblk.h	1.3	11/23 command block format
 * (With extensions for Boot/Diagnostic ROM)
 */

 /*
  * Command block sructure
  * Note: The first word structure is only for reference
  * since it is more efficient to use masks.
  */

struct cfstword				/* first word of command */
	{
	unsigned	c_device  : 7;	/* Minor device number	 */
	unsigned	c_tag     : 1;	/* Command blk ownership */
	unsigned	c_command : 7;	/* Command code		 */
	unsigned	c_intenbl : 1;	/* Interrupt enable bit	 */
	};
/*
 *	Constants for c_dev and c_cmd to do the
 * 	work of the first word structure.
 */
# define CD_TAGMSK	0x80		/* ownership tag mask	*/
# define CD_DEVMSK	0x7f		/* device number mask	*/

# define CC_INTMSK	0x80		/* interrupt enable mask */
# define CC_CMDMSK	0x7f		/* command code mask	*/

struct cmdblk				/* direct version	  */
	{
	char 		c_dev;		/* Minor device number	 */
	char 		c_cmd;		/* Command code		 */
	unsigned	c_txkey;	/* Transaction key	  */
	long		c_sys_adr;	/* System address	  */
	unsigned	c_length;	/* Data length		  */
	long		c_resp_adr;	/* Response address	  */
	};

/*
 * Ownership flags (c_dev b7)
 */

#define CMD_GPIO	0x80
#define	CMD_PDP		0x00

/*
 * Request interrupt flags (c_cmd b7)
 */

#define CMD_NOINT	0x00		/* no interrupt */
#define CMD_REQINT	0x80		/* request interrupt */

/*
 * command code definitions in cmd_def.h
 */

#ifdef DIAGS
/*
 * Boot/Diagnostic ROM Command Codes
 */

#define BR_MIN		32		/* Lowest num. command	*/
#define BR_NOP		BR_MIN+0	/* NOP			*/
#define BR_BOOT		BR_MIN+1	/* Boot			*/
#define	BR_READ		BR_MIN+2	/* Diag Read		*/
#define BR_WRITE	BR_MIN+3	/* Diag Write		*/
#define BR_WRRD		BR_MIN+4	/* Diag Write/Read	*/
#define BR_WIGGLE	BR_MIN+5	/* Diag GPIB		*/
#define BR_ERRINT	BR_MIN+6	/* Diag ERR/INT Test	*/
#define BR_OUTBYTE	BR_MIN+7	/* Diag Force out byte	*/
#define BR_DMABYTE	BR_MIN+8	/* Diag DMA out byte	*/
#define BR_SELFTEST	BR_MIN+9	/* Selftest		*/
#define BR_MAX		BR_SELFTEST	/* Highest num. command	*/

/*
 * 'device' byte bit definitions for Diagnostic Commands
 */

#define DEVBIT_WORD	0x01		/* 1 => Word operation	*/
#define DEVBIT_XCEIV	0x02		/* Enable GPIB Xceivers	*/

#endif

/*
 * 11/23 response block format 
 */

struct respblk
	{
	char		r_device;	/* Minor device number	 */
	char		r_tag;		/* Response block ownership */
	unsigned	r_error;	/* Response/error code	 */
	unsigned	r_txkey;	/* Transaction key	 */
	unsigned	r_value;	/* Returned Value	 */
	};

#ifdef DIAGS
struct slft_rspblk
	{
	char		r_device;	/* Minor device number	 */
	char		r_tag;		/* Response block ownership */
	unsigned	r_error;	/* Response/error code	 */
	unsigned	r_txkey;	/* Transaction key	 */
	unsigned	r_ramsize;	/* Valid RAM size (in bytes) */
	long		r_pnumh;	/* High PROM part number */
	long		r_pnuml;	/* Low PROM part number	 */
	};
#endif

/*
 * Response block ownership tag (r_tag)
 */

#define RES_GPIO	0		/* Owned by GPIO	*/
#define RES_PDP		1		/* Owned by PDP		*/
#define RES_BUSY	2		/* Busy by PDP		*/

/*
 *	GPIO Response codes
 */

#define	RES_NULL	0x00		/* No response set-up	*/
#define	RES_DONE	0x01		/* Done - no error	*/
#define	RES_ERROR 	0x02		/* Error		*/
#define	RES_WAIT	0x03		/* Wait for ready 	*/
#define	RES_READY	0x04		/* Quit waiting		*/

/*
 *	Warnings/Informative
 */

#define WRN_RAM		0x41		/* Less than std RAM available	*/

/*
 *	Fatal Errors
 */

#define ERR_NOTBOOT	0xc1		/* Not a boot monitor command */
#define ERR_TIMEOUT	0xc2		/* Bus timeout occurred	*/
#define ERR_ROOM	0xc3		/* Boot file too large to fit */
#define ERR_MAGIC	0xc4		/* Bad magic number in boot file*/
#define ERR_RELOC	0xc5		/* Relocation still in boot file*/

/*
 * command and response queue structures
 */

struct queptr {
	long cq_addr;		/* current address */
	long cq_begin;		/* the begining of this queue */
	long cq_end;		/* the end of this queue */
	char cq_active;		/* true if queue is active */
};

#ifndef DIAGS

struct queptr CmdQueP;		/* Command queue pointers */
struct queptr ResQueP;		/* Response queue pointers */

#endif


struct sq_cmdblk			/* set queues version	  */
	{
	long		c_cq_adrs;	/* Command queue address  */
	unsigned	c_cq_length;	/* Command queue length	  */

	long		c_rq_adrs;	/* Response queue address */
	unsigned	c_rq_length;	/* Response queue length  */
	};
