# ifdef SCCSID
/* static char *sccsid = @(#)mtdev.h	1.2; */
# endif



# define MTC_PARAM_SIZ	5
# define MT_BUF_SIZ	2



struct dy_param {
	char c[MTC_PARAM_SIZ];		/* a parameter string */
};


struct mtc_cmdend {
	char del_lf;			/* LF */
	char del_cr;			/* CR */
};


struct dy_ctrlstat {

		/* Note: this first parm. is also the polled status */
	struct dy_param dy_mtctrl;	/* Dylon controller status */
	char dy_del1;			/* , */
	struct dy_param dy_mt;		/* mag-tape status */
	char dy_del2;			/* , */
	struct dy_param dy_format;	/* formatter status */
	char dy_del3;			/* , */
	struct dy_param dy_rlen;	/* record length */
	struct mtc_cmdend dy_cend;	/* LF CR */
};


struct dy_spoll {
	struct dy_param dys_mtctrl;	/* Dylon controller status */
	struct mtc_cmdend dys_cend;	/* LF CR */
};


struct dy_errstat {
	struct dy_param dye_err1;	/* error parameter one */
	char dye_del1;			/* , */
	struct dy_param dye_err2;	/* error parameter two */
	struct mtc_cmdend dye_cend;	/* LF CR */
};


struct dy_flags {
	char	flg_ctrl;
	char	flg_mt;
	char	flg_format;
	char	flg_p1err;
	char	flg_p2err;
};


/*
 * The bits of flg_ctrl, converted from dy_mtctrl.
 *	Note: these are the flags which are returned from a serial poll.
 */

# define FC_UNR		1		/* unit not ready */
# define FC_FMD		2		/* file mark detected */
# define FC_EOT		4		/* end of tape */
# define FC_FIP		8		/* file is protected */
# define FC_RFNC	16		/* MTC ready for next command */
# define FC_ERR		32		/* error exists */
# define FC_A0		64		/* Always zero */
# define FC_ROC		128		/* read operation complete */


/*
 * The bits of flg_mt, converted from dy_mt.
 */

# define FM_7TK		1		/* 7 track tape */
# define FM_NRZ		2		/* ???? */
# define FM_EOT		4		/* end of tape */
# define FM_LDP		8		/* at load point */
# define FM_FPT		16		/* file protected */
# define FM_RWD		32		/* rewinding */
# define FM_ONL		64		/* online */
# define FM_RDY		128		/* ready */


/*
 * The bits of flg_format, converted from dy_format.
 */

# define FF_INIT	1		/* initialized, */
				/* set only after reset */

# define FF_A0		2		/* always zero */
# define FF_FMK		4		/* file mark */
# define FF_CER		8		/* corrected error */
# define FF_HER		16		/* hard error */
# define FF_CCGID	32		/* phase encoded or */
					/* indentity detect */

# define FF_ENDBLK	64		/* end of block */
# define FF_FMTBSY	128		/* formatter busy */


/*
 * The bits of flg_p1err, converted from dy_err1.
 */

# define FE_NOERR	0		/* no error */

# define FE1_RETRY	1		/* retries exhausted */
# define FE1_BOVF	2		/* Buffer overflow */
# define FE1_EDE	4		/* logical End of Data Encontered */
# define FE1_WRP	8		/* Write Protected or */
					/* not on line */
# define FE1_FMK	16		/* File Mark detected */
# define FE1_LDP	32		/* Load Point - reverse action */
# define FE1_EOT	64		/* End of Tape encountered */
# define FE1_NOD	128		/* No Data encountered */


/*
 * The bits of flg_p2err, converted from dy_err2.
 */

# define FE2_UBRX	1		/* unexpected byte received */
# define FE2_UBRQ	2		/* unexpected byte requested */
# define FE2_ICC	4		/* Illeagal char. in command */
# define FE2_PEXC	8		/* parameter exceeds config. size */
# define FE2_SA2	16		/* Sec. Addr. 2 received */
					/* with no rd/wr command */
# define FE2_GERR	32		/* GPIB bus error */
# define FE2_PERR	64		/* Parameter error or */
# define FE2_AIOM	128		/* Abort I/O message received */


struct mt_param {
	unsigned mp_drivetype;		/* type of drive/transport */
	int mp_rewind;			/* rewind on close = YES */
	unsigned mp_maxrec;		/* maximum record length */
};


/*
 * Drive types
 */

# define DY_9TRK	0		/* Dylon 9 track */
# define DY_DC300	1		/* Dylon DC-300 */
# define DY_TYPES	2		/* number of drive types */


struct mt_ddata {
	struct dy_flags mt_flgs;	/* status flags */
	unsigned mt_reclen;		/* record length */
	unsigned mt_permission;		/* r/w permission of open */
	int mt_writflg;			/* we wrote on tape = YES */
	int mt_readflg;			/* we read tape = YES */
	unsigned mt_tracknum;		/* current track number */
	struct mt_param mt_parm;	/* parameters for mag-tape */
};


/*
 * The flags of READ/WRITE permission of an open.
 */

# define MTP_READ	1		/* READ ONLY */
# define MTP_WRITE	2		/* WRITE ONLY */
# define MTP_RW		3		/* READ and WRITE */


/*
 * Track number ranges
 */

# define DY_1TRACK	1		/* the first track */
# define DY_LASTTRACK	4		/* the last track */


struct mt_odata {
	char mt_buf[MT_BUF_SIZ];	/* I/O buffer */
};


# define MAX_CMD_LEN	28		/* Maximum length of a cmd */
# define CMD_P1_SIZ	10
# define CMD_P2_SIZ	16
# define CMD_P3_SIZ	22
# define CMD_P4_SIZ	MAX_CMD_LEN


/*
 * The Secondary addresses of the mag-tape controller:
 *
 * My Listen Address -
 *	MTL_xx		mag-tape listen
 */

# define MTL_MTC	1	/* MTC commands */
# define MTL_ID		2	/* Input Data */

# define MTL_SDC	4	/* Select Device Clear */
# define MTL_BC		5	/* Buffer Clear */

/*
 * My Talk Address -
 *	MTT_xx		mag-tape talk
 */

# define MTT_OS		1	/* Operational Status */
# define MTT_OD		2	/* Output Data */
# define MTT_ES		3	/* Error Status */
# define MTT_SP		4	/* Serial Poll */
# define MTT_BC		5	/* Buffer Clear */


struct cmd_par2 {
	char p2[2];			/* room for 2 char arg. */
};


struct cmd_par5 {
	char p5[5];			/* room for 5 char arg. */
};


struct cmd_par6 {
	char p6[6];			/* room for 5 char arg. */
};


/*
 * End of data list command
 */

struct dy_ed_cmd {
	struct cmd_par2 dy_cmd;		/* command name */
	struct cmd_par6 dy_eod;		/* Decimal val. of EOD char. */
	struct cmd_par6 dy_reclen;	/* record length specifer */
	struct cmd_par2 dy_eoi;		/* EOI control, off or on */
	struct cmd_par2 dy_cout;	/* continuous output spec. */
};


/*
 * Read records command
 */

struct dy_rr_cmd {
	struct cmd_par2 dy_cmd;		/* command name */
};


/*
 * rewind command
 */

struct dy_rw_cmd {
	struct cmd_par2 dy_cmd;		/* command name */
};


/*
 * Direction flags for selecting forward or reverse spacing
 */

# define FORWARD	0
# define REVERSE	1


/*
 * space files command
 */

struct dy_sf_cmd {
	struct cmd_par2 dy_cmd;		/* command name */
	struct cmd_par6 dy_cnt;		/* number of files to space */
	struct cmd_par2 dy_direction;	/* forward or reverse */
};


/*
 * space record command
 */

struct dy_sr_cmd {
	struct cmd_par2 dy_cmd;		/* command name */
	struct cmd_par6 dy_cnt;		/* number of records to space */
	struct cmd_par2 dy_direction;	/* forward or reverse */
};


/*
 * transport select command
 */

struct dy_ts_cmd {
	struct cmd_par2 dy_cmd;		/* command name */
	struct cmd_par5 dy_trnum;	/* transport number */
};


/*
 * write file mark command
 */

struct dy_wf_cmd {
	struct cmd_par2 dy_cmd;		/* command name */
};


/*
 * Write records command
 */

struct dy_wr_cmd {
	struct cmd_par2 dy_cmd;		/* command name */
};


/*
 * Select unit, ie: drive (this is for the DC-300)
 */

struct dy_us_cmd {
	struct cmd_par2 dy_cmd;		/* command name */
	struct cmd_par5 dy_drnum;	/* drive number */
};


/*
 * Select track number on DC-300 
 */

struct dy_st_cmd {
	struct cmd_par2 dy_cmd;		/* command name */
	struct cmd_par5 dy_track;	/* track number */
};


/*
 * Write erase to end of tape on DC-300
 *	count = 0 is erase to end of tape
 */

struct dy_we_cmd {
	struct cmd_par2 dy_cmd;		/* command name */
	struct cmd_par2 dy_ecnt;	/* erase count */
};


/*
 * Initialized command data
 *
 *	NOTE:  some of the fields are filled in by the routines
 * which use the command.
 */ 

struct mt_cmd {
	struct dy_rw_cmd dy_rw;		/* rewind command */
	struct dy_rr_cmd dy_rr;		/* read a record command */
	struct dy_wr_cmd dy_wr;		/* write a record command */
	struct dy_wf_cmd dy_wf;		/* write file mark command */
	struct dy_ed_cmd dy_ed;		/* End of data list command */
	struct dy_sf_cmd dy_fsf;	/* forward space files cmd */
	struct dy_sf_cmd dy_bsf;	/* reverse space files cmd */
	struct dy_sr_cmd dy_fsr;	/* forward space records cmd */
	struct dy_sr_cmd dy_bsr;	/* reverse space records cmd */
	struct dy_ts_cmd dy_ts;		/* transport select command */
	struct dy_us_cmd dy_us;		/* drive select command */
	struct dy_st_cmd dy_st;		/* select track command */
	struct dy_we_cmd dy_we;		/* erase to end of tape cmd */
};


struct mt_cmd mtcmd

# ifdef MTCMD_DATA
	={
		{{"RW"}},

		{{"RR"}},

		{{"WR"}},

		{{"WF"}},

		{{"ED"}, {"  256,"}, {" 4096,"}, {"1,"}, {" 1"}},

		{{"SF"}, {"     ,"}, {" 0"}},

		{{"SF"}, {"     ,"}, {" 1"}},

		{{"SR"}, {"     ,"}, {" 0"}},

		{{"SR"}, {"     ,"}, {" 1"}},

		{{"TS"}, {"     "}},

		{{"US"}, {"     "}},

		{{"TS"}, {"     "}},

		{{"WE"}, {" 0"}}
}
# endif
;


/*
 * mag-tape operation parameters
 */

 struct mtdevop {
	unsigned mt_op;			/* operation to be done */
	unsigned mt_cnt;		/* number of times */
};


/*
 * Types of operations that can be issued
 */

# define MTWEOF		1		/* write a file mark */
# define MTFSF		2		/* forward space 'n' files */
# define MTBSF		3		/* reverse space 'n' files */
# define MTFSR		4		/* forward space 'n' records */
# define MTBSR		5		/* reverse space 'n' records */
# define MTREW		6		/* rewind the tape */
# define MTRESET	7		/* software reset to tape control */
