/*
 * @(#)ctrdev.h	1.1
 *	
 * Controller  and general device definitions.
 *
 */

/*
 * device operation parameter structure
 */
 struct gdevop {
	unsigned 	operation;	/* operation to be done	*/
	unsigned	passed;		/* passed data 		*/
	unsigned	returned;	/* returned data	*/
};

/*
 * device operation codes
 */
#define GDSETADR	1	/* Set gpib address */
#define GDIFC		2	/* Send Interface clear */
#define GDATNT		3	/* Set ATN True */
#define GDATNF		4	/* Set ATN False */
#define GDRENT		5	/* Set REN True */
#define GDRENF		6	/* Set REN False */

#define GDINTCMD	7	/* Send interface command */

#define GDWSRQ		8	/* Wait for Service request */
#define GDWDVSRQ	9	/* Wait for device Service request */

#define GDENPOLL	10	/* enable auto serial poll */
#define GDNOPOLL	11	/* no auto serial poll */

#define GDSPOLL		12	/* Serial poll device */
#define GDSPSTAT	13	/* get serial poll status */
#define GDPPOLL		14	/* conduct parallel poll */

#define GDEOI		15	/* force byte with EOI */
#define GDWEOI		16	/* release and wait for EOI */
#define GDADRCMD	17	/* Send addressed command */
#define GDBUSTAT	18	/* get GPIB bus status */
#define GDIFCT		19	/* set ATN true */



/*
 * device data declrations
 */
#define	CTR_DEVD	sizeof(struct cnddat);	/* device data length */

struct cnddat {
	unsigned	cn_wait;		/* wait reason */
};

/*
 * wait reasons
 */
#define	W_NONE		0	/* no wait */
#define	W_SRQ		1	/* wait for any service request */
#define	W_MYSRQ		2	/* wait for my service request */


/*
 * open data declrations
 */
#define	CTR_OPEND	0	/* open data length */


/*
 * general device definitions
 * no open or device data
 */

#define	GEN_DEVD	0	/* device data length */
#define	GEN_OPEND	0	/* open data length */
