
            case 1: /* Operator found */
               switch ( lachar )
               {

                  case '[':
                  case '{':
                     lachar = '(';
                  case '(':
                     token = lachar;
                     break;

                  case ']':
                  case '}':
                     lachar = ')';
                  case ')':
                     token = lachar;
                     break;

                 default:
                     if (latran == 1)
                        token = EOS;
                     else
                        token = lachar;
               }
               break;

            case 2: /* Symbol found */
	       value = 0;
	       token = SYM;
               break;

            case 3: /* Decimal number found */
               value = value * 10 + dignum;
               token = DECNUM;
               break;

            case 4: /* PC symbol found */
	       value = pc;
	       token = PC;
	       relocatable++;
	       break;

            case 5: /* Hex Number or gt relop */
	       if (!strcmp (symbol, "=")) token = GE;
	       else token = GT;
               break;

            case 6: /* Hex Number found */
               value = (value << 4) + dignum;
               token = HEXNUM;
               break;

	    case 7: /* operator found */
	       if (!strcmp (symbol, "=")) token = EQ;
	       else if (!strcmp (symbol, "#=")) token = NE;
	       else if (!strcmp (symbol, "#")) token = NOT;
	       else if (!strcmp (symbol, "<=")) token = LE;
	       else if (!strcmp (symbol, "<")) token = LT;
	       else if (!strcmp (symbol, ">=")) token = GE;
	       else if (!strcmp (symbol, ">")) token = GT;
	       else if (!strcmp (symbol, "&")) token = AND;
	       value = 0;
	       break;

            case 9: /* String found */
	       if (strlen(symbol) <= sizeof (tokval))
	       {
	          int i;
		  for (i = 0; i < (int)strlen(symbol); i++)
		     value = (value << 8) | symbol[i];
	       }
	       token = STRING;
	       break;

            case 10: /* Divide or right shift op found */
	       if (!strcmp (symbol, "/")) token = RTSHIFT;
	       else token = '/';
	       break;

            case 11: /* Comma found, end of expression */
	       token = EOS;
	       break;

            case 13: /* recognize exponent sign*/
               token = FLTNUM;
               break;

            case 14: /* recognize exponent */
               token = FLTNUM;
               sexp = sexp * 10 + dignum;
               break;

	    case 15: /* process exponent sign */
               token = FLTNUM;
               if (lachar == '-')
                  expsgn = -1;
	       break;

            case 16: /* process fraction */
               token = FLTNUM;
	       if (dignum == 0)
	       {
		  if (!digitfound)
		     leadingzero++;
	       }
	       else digitfound = TRUE;
	       fracdigits++;
               sfrc = sfrc * 10 + dignum;
	       break;

            case 17: /* build exponential form */
	       {
		  union {
		     DOUBLE xxd;
		     uint32 xxl[2];
		  } xx;
		  char *last;

		  token = FLTNUM;
#ifdef DEBUG_STRTOD
		  printf ("Float format: \n");
		  printf ("   before symbol = %s\n", symbol);
#endif
		  xx.xxd = ibm_strtod (symbol, &last);
#ifdef ASM_BIG_ENDIAN
		  sprintf (symbol, "%08.8X%08.8X", xx.xxl[0], xx.xxl[1]);
#else
		  sprintf (symbol, "%08.8X%08.8X", xx.xxl[1], xx.xxl[0]);
#endif
#ifdef DEBUG_STRTOD
		  printf ("   symbol = %x, last = %x\n",
			   (long)symbol, (long)last);
		  printf ("   after symbol = %s\n", symbol);
#endif
	       }
	       break;

            case 18: /* Number found */
	       evalue = evalue * 10 + dignum;
	       numdigits++;
	       token = FLTNUM;
               break;

	    case 19: /* process sign */
               token = FLTNUM;
               if (lachar == '-')
                  numsgn = -1;
	       break;

