/***********************************************************************
*
* lnkdef.h - Linker header for the TI 990 computer.
*
* Changes:
*   06/05/03   DGP   Original.
*   06/25/03   DGP   Added Module type and associated formats.
*   05/25/04   DGP   Added Long entry/extern tags.
*
***********************************************************************/

#include <stdio.h>

/*
** Definitions
*/

#define NORMAL 0
#define ABORT  12

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#define VERSION "1.1.2"

#define EOFSYM ':'

#define MAXLINE 256
#define LINESPAGE 60
#define MAXFILES 30
#define IDTSIZE 8

#define TEMPSPEC "lnkXXXXXX"

/*
** Object output formats
*/

#define OBJFORMAT "%c%04X"
#define IDTFORMAT "%c%04X%-8.8s"
#define REFFORMAT "%c%4.4X%-6.6s"
#define DEFFORMAT "%c%4.4X%-6.6s"
#define SEQFORMAT "%6.6d\n"
#define LREFFORMAT "%c%4.4X%-32.32s"
#define LDEFFORMAT "%c%4.4X%-32.32s"

/*
** Listing formats
*/

#define H1FORMAT "LNK990 %-8.8s  %-24.24s  %s Page %04d\n\n"

#define MODFORMAT "  %-8.8s   %04X    %04X   %s  %s  %s  %s\n"
#define SYMFORMAT " %-8.8s %4.4X%c%c "
#define LONGSYMFORMAT " %-34.34s %4.4X%c%c "

/*
** Data type definitions
*/

#define int8            char
#define int16           short
#define int32           int
typedef int             t_stat;                         /* status */
typedef int             t_bool;                         /* boolean */
typedef unsigned int8   uint8;
typedef unsigned int16  uint16;
typedef unsigned int32  uint32, t_addr;                 /* address */

#if defined (WIN32)                                     /* Windows */
#define t_int64 __int64
#elif defined (__ALPHA) && defined (VMS)                /* Alpha VMS */
#define t_int64 __int64
#elif defined (__ALPHA) && defined (__unix__)           /* Alpha UNIX */
#define t_int64 long
#else                                                   /* default GCC */
#define t_int64 long long
#endif                                                  /* end OS's */
typedef unsigned t_int64        t_uint64, t_value;      /* value */
typedef t_int64                 t_svalue;               /* signed value */

#define MSB 0
#define LSB 1

/*
** Memory
*/

#define MEMSIZE 65768

typedef struct
{
   char tag;
   int	value;
   int	relocatable;
   int  external;
   int  global;
} Memory;

#define GETMEM(m) \
(((memory[(m)+MSB] & 0xFF) << 8)|(memory[(m)+LSB] & 0xFF))

#define PUTMEM(m,v) \
{ memory[(m)+MSB] = (v) >> 8 & 0xFF; memory[(m)+LSB] = (v) & 0xFF; }

/*
** Symbol table
*/

#define MAXSYMLEN 32
#define MAXSHORTSYMLEN 6
#define MAXSYMBOLS 5000

typedef struct
{
   char symbol[MAXSYMLEN+2];
   char module[MAXSYMLEN+2];
   int value;
   int relocatable;
   int external;
   int global;
   int longsym;
   int muldef;
   int undef;
} SymNode;

/*
** Module table
*/

#define MAXMODULES 100

typedef struct 
{
   char name[IDTSIZE+2];
   char date[12];
   char time[12];
   char creator[12];
   char objfile[256];
   int origin;
   int length;
} Module;

/*
** Object tags
*/

#define BINIDT_TAG	01
#define IDT_TAG		'0'
#define ABSENTRY_TAG	'1'
#define RELENTRY_TAG	'2'
#define RELEXTRN_TAG	'3'
#define ABSEXTRN_TAG	'4'
#define RELGLOBAL_TAG	'5'
#define ABSGLOBAL_TAG	'6'
#define CKSUM_TAG	'7'
#define NOCKSUM_TAG	'8'
#define ABSORG_TAG	'9'
#define RELORG_TAG	'A'
#define ABSDATA_TAG	'B'
#define RELDATA_TAG	'C'
#define EOR_TAG		'F'

#define RELSYMBOL_TAG	'G'
#define ABSSYMBOL_TAG	'H'
#define LOAD_TAG	'U'
#define RELSREF_TAG	'V'
#define ABSSREF_TAG	'Y'

#define LRELSYMBOL_TAG	'i'
#define LABSSYMBOL_TAG	'j'
#define LRELEXTRN_TAG	'l'
#define LABSEXTRN_TAG	'm'
#define LRELGLOBAL_TAG	'n'
#define LABSGLOBAL_TAG	'o'
#define LLOAD_TAG	'p'
#define LRELSREF_TAG	'q'
#define LABSSREF_TAG	'r'

#define CHARSPERREC	66  /* Chars per object record */
#define CHARSPERCASREC	73  /* Chars per cassette object record */
#define WORDTAGLEN	5   /* Word + Object Tag length */
#define BINWORDTAGLEN	3   /* Word + Binary Object Tag length */
#define EXTRNLEN	11  /* Tag + SYMBOL + addr */
#define GLOBALLEN	11  /* Tag + SYMBOL + addr */
#define IDTLEN		13  /* Tag + IDT + length */
#define BINIDTLEN	11  /* Tag + IDT + binary length */
#define SEQUENCENUM	74  /* Where to put the sequence */

#define TIMEOFFSET 17
#define DATEOFFSET 27
#define CREATOROFFSET 38

extern int lnkloader (FILE *, int, int, char *);
extern int lnkpunch (FILE *, int);
extern void printheader (FILE *);
extern SymNode *symlookup (char *, char *, int);
