#include <stdio.h>
#include <string.h>

#define MAXMEMSIZE 1024

#define HEXDUMP(file,ptr,size,offset)	\
{\
   int jjj;\
   int iii;\
   char *tp;\
   char *cp;\
   for (iii = 0, tp = (char *)(ptr), cp = (char *)(ptr); iii < (size); )\
   {\
      fprintf ((file), "%08X  ", iii+offset);\
      for (jjj = 0; jjj < 8; jjj++)\
      {\
	 if (cp < ((char *)(ptr)+(size)))\
	 {\
	    fprintf ((file), "%02.2X", *cp++ & 0xFF);\
	    if (cp < ((char *)(ptr)+(size)))\
	    {\
	       fprintf ((file), "%02.2X ", *cp++ & 0xFF);\
	    }\
	    else\
	    {\
	       fprintf ((file), "   ");\
	    }\
	 }\
	 else\
	 {\
	    fprintf ((file), "     ");\
	 }\
	 iii += 2;\
      }\
      fprintf ((file), "   ");\
      for (jjj = 0; jjj < 8; jjj++)\
      {\
	 if (tp < ((char *)(ptr)+(size)))\
	 {\
	    if (isprint(*tp))\
	       fprintf ((file), "%c", *tp);\
	    else\
	       fprintf ((file), ".");\
	    tp++;\
	    if (tp < ((char *)(ptr)+(size)))\
	    {\
	       if (isprint(*tp))\
		  fprintf ((file), "%c ", *tp);\
	       else\
		  fprintf ((file), ". ");\
	       tp++;\
	    }\
	    else\
	    {\
	       fprintf ((file), "  ");\
	    }\
	 }\
	 else\
	 {\
	    fprintf ((file), "   ");\
	 }\
      }\
      fprintf ((file), "\n");\
   }\
}


int
main (int argc, char **argv)
{
   FILE *fd;
   int index;
   int size;
   int org;
   int ch;
   char mem[MAXMEMSIZE];

   if (argc != 2)
   {
      fprintf (stderr, "usage: hd file\n");
      exit (1);
   }

   if ((fd = fopen (argv[1], "r")) == NULL)
   {
      perror ("Can't open");
      exit (1);
   }

   size = 0;
   org = 0;
   printf ("Dump of %s:\n", argv[1]);
   while ((ch = fgetc (fd)) != EOF)
   {
      mem[size++] = ch % 0xFF;
      if (size == MAXMEMSIZE)
      {
	 HEXDUMP (stdout, mem, size, org);
	 org += MAXMEMSIZE;
	 size = 0;
      }
   }
   if (size)
      HEXDUMP (stdout, mem, size, org);


   fclose (fd);
   
}
