/*	msreg.h	4.4	83/01/04	*/

/*
 * Hardware mouse registers
 */
union mousedata {
	u_short	m_reg;
#ifndef OLDMOUSE
	/* structs used in 4 ms 3 sample cycle mouse tracking */
	struct butreg { 		/* button sample structure */
		char kbd;		/* kybd bits of parallel port */
		u_short butflags:4;	/* if 1000B then but sample */
		u_short buttons:3;	/* left-middle-right, 1 is on */
					/* Note: encoding dif from old */
		u_short power:1;	/* always 1 because is +5 volts	*/
	} m_but;
	struct deltareg { 		/* delta sample structure */
		char kbd;		/* kybd bits of parallel port */
		char	delta;		/* delta in 2's comp
/* this definition of delta replaces the 2 lines below:
 *		u_short delta:7;
 *		u_short power:1;	   always 1 because is +5 volts
 */
	} m_delta;
#else
	struct mousereg {
		char	m_kbd;		/* keyboard bits */
		u_short	m_ydel:2;	/* y delta gray code */
		u_short	m_xdel:2;	/* x delta gray code */
		u_short m_buttons:2;	/* button info */
		u_short m_toggle:1;	/* toggle bit */
	} m_mouse;
#endif
};

#ifdef KERNEL
extern union mousedata Mouse;
#endif

/*
 * Software mouse registers
 */
struct ms_softc {
	int	ms_xloc;		/* X location */
	int	ms_yloc;		/* Y location */
	u_char	ms_lastbutt;		/* last buttons */
	struct	mousebuf *ms_buf;	/* buffer address or NULL */
	int	ms_bufsize;		/* buffer size (in pages) */
#ifdef	OLDMOUSE
	short	ms_xvel;		/* X velocity */
	short	ms_yvel;		/* Y velocity */
	short	ms_xaccel;		/* X acceleration */
	short	ms_yaccel;		/* Y acceleration */
	u_char	ms_lasttoggle;		/* last toggle bit */
	u_char	ms_lastxdel;		/* last x delta (gray) */
	u_char	ms_lastydel;		/* last y delta (gray) */
	short	ms_numident;		/* # identical samples */
#endif
};

#ifdef KERNEL
extern struct ms_softc ms_softc;
#endif

#define MS_NUMSTOP 30	/* Stop mouse after n identical samples */
#define MS_MAXBUFS 20	/* Max # of pages for mouse buffer */
