/*	pte.h	4.12	83/03/26	*/

/*
 * Sun software page table entry
 *
 * There are two major kinds of pte's: those which have ever existed (and are
 * thus either now in core or on the swap device), and those which have
 * never existed, but which will be filled on demand at first reference.
 * There is a structure describing each.  There is also an ancillary
 * structure used in page clustering (never used on the Sun).
 */

#ifdef KERNEL
#include "../sun/mmu.h"
#else
#include <sun/mmu.h>
#endif

#ifndef LOCORE
struct pte {
unsigned int	pg_v:1,			/* valid bit */
		pg_prot:4,		/* access control */
		pg_fod:1,		/* is fill on demand (=0) */
		:10;
	struct	hpagent pg_hpagent;	/* hardware page table entry */
};


struct hpte {
unsigned int	pg_high:9,		/* special for clustering */
		:7;
	struct	hpagent pg_hpagent;	/* hardware page table entry */
};

struct fpte {
unsigned int	pg_v:1,
		pg_prot:4,
		pg_fod:1,		/* is fill on demand (=1) */
		:1,
		pg_fileno:5,		/* file mapped from or TEXT or ZERO */
		pg_blkno:20;		/* file system block number */
};

#define	pg_m		pg_hpagent.hpag_mod
#define	pg_r		pg_hpagent.hpag_acc
#define	pg_space	pg_hpagent.hpag_type
#define	pg_pfnum	pg_hpagent.hpag_ppag
#endif

#define	PG_V		0x80000000
#define	PG_PROT		0x78000000
#define	PG_FOD		0x02000000
#define	PG_R		0x00008000
#define	PG_M		0x00004000
#define	PG_PFNUM	0x00003fff	/* XXX - includes type field */
#define	PG_PROTSHFT	27		/* bit position where prot starts */

#define	PG_FZERO	(NOFILE)
#define	PG_FTEXT	(NOFILE+1)
#define	PG_FMAX		(PG_FTEXT)

#define	PG_NOACC	0
#define	PG_KW		0x28000000
#define	PG_KR		0x18000000
#define	PG_UW		0x78000000
#define	PG_URKW		0x68000000
#define	PG_URKR		0x60000000

#define	PGSP_OBMEM	0x0000
#define	PGSP_INVAL	0x1000
#define	PGSP_MBMEM	0x2000
#define	PGSP_MBIO	0x3000

/*
 * Pte related macros
 */
#define	dirty(pte)	((pte)->pg_fod == 0 && (pte)->pg_pfnum && (pte)->pg_m)

#ifndef LOCORE
#ifdef KERNEL
struct	pte *vtopte();

/* utilities defined in locore.s */
extern	struct pte Sysmap[];
extern	struct pte Usrptmap[];
extern	struct pte usrpt[];
extern	struct pte Swapmap[];
extern	struct pte Forkmap[];
extern	struct pte Xswapmap[];
extern	struct pte Xswap2map[];
extern	struct pte Pushmap[];
extern	struct pte Vfmap[];
extern	struct pte mmap[];
extern	struct pte msgbufmap[];
extern	struct pte camap[];
#endif
#endif
