/*
	Demo program which uses the region fill routine to do VLSI
	layout diagrams.  The box and draw commands with mirror and
	angle options are from Mead and Conway, 'Intro. to VLSI
	systems'.
	*/
#	include <usercore.h>
#	define lambda	4
#	define poly	0
#	define diff	1
#	define cuts	2
#	define metl	3
#	define impl	4


	int polymask = 1;		/* red */
	int diffmask = 2;		/* green */
	int metlmask = 4;		/* blue */
	int cutsmask = 8;		/* black */
	int implmask = 16;		/* yellow */

	float red[] =
		{ 1.0,0.0,0.5,0.0,0.5,0.0,0.333,0.,0.,0.,0.,0.,0.,0.,0.,
		  1.0,1.0,0.5,0.5,0.5,1.0,0.5,1.0,0.,0.,0.,0.,0.,0.,0.,0.};
	float green[] =
		{ 0.0,1.0,0.5,0.0,0.0,0.5,0.333,0.,0.,0.,0.,0.,0.,0.,0.,
		  1.0,0.5,1.0,0.5,0.5,0.5,1.0,1.0,0.,0.,0.,0.,0.,0.,0.,0.};
	float blue[] =
		{ 0.0,0.0,0.0,1.0,0.5,0.5,0.333,0.,0.,0.,0.,0.,0.,0.,0.,
		  0.0,0.0,0.0,0.0,0.5,0.5,0.5,0.5,0.,0.,0.,0.,0.,0.,0.,0.};

/*	short polymask[] = {	0x7777, 0xeeee, 0xdddd, 0xbbbb,
				0x7777, 0xeeee, 0xdddd, 0xbbbb,
				0x7777, 0xeeee, 0xdddd, 0xbbbb,
				0x7777, 0xeeee, 0xdddd, 0xbbbb };
	short diffmask[] = {	0xbbbb, 0xdddd, 0x7777, 0x7777,
				0xbbbb, 0xdddd, 0x7777, 0x7777,
				0xbbbb, 0xdddd, 0x7777, 0x7777,
				0xbbbb, 0xdddd, 0x7777, 0x7777 };
	short metlmask[] = {	0xcccc, 0x3333, 0xffff, 0xffff,
				0xcccc, 0x3333, 0xffff, 0xffff,
				0xcccc, 0x3333, 0xffff, 0xffff,
				0xcccc, 0x3333, 0xffff, 0xffff };
	short cutsmask[] = {    0xffff, 0xffff, 0xeeee, 0xeeee,
				0xffff, 0xffff, 0xeeee, 0xeeee,
				0xffff, 0xffff, 0xeeee, 0xeeee,
				0xffff, 0xffff, 0xeeee, 0xeeee };
	short implmask[] = {    0xffff, 0xffff, 0xbbbb, 0xdddd,
				0xffff, 0xffff, 0xbbbb, 0xdddd,
				0xffff, 0xffff, 0xbbbb, 0xdddd,
				0xffff, 0xffff, 0xbbbb, 0xdddd };
*/
	/* define the basic circuit cells            */
	/*	type, x,  y, lx, ly, nx, ny, ix, iy  */

	short placell[] = { 5, 28, 28,
		diff, 0,  2,  8,  8,  1,  2,  1, 14,
		diff, 16, 0,  4, 28,  1,  1,  1,  1,
		poly, 10, 0,  4, 28,  2,  1, 12,  1,
		cuts,  2, 4,  4,  4,  1,  2,  1, 14,
		metl,  0, 2, 28,  8,  1,  2,  1, 14
		};
	short placon[] = { 10, 32, 28,
		diff, 0,  2,  8,  8,  1,  2,  1, 14,
		diff, 18, 8,  8,  8,  1,  1,  1,  1,
		diff, 26, 8,  6,  4,  1,  1,  1,  1,
		poly, 12, 2, 20,  4,  1,  2,  1, 16,
		poly,  6, 2,  6,  8,  1,  2,  1, 14,
		poly, 28,14,  4,  4,  1,  1,  1,  1,
		cuts,  2, 4,  8,  4,  1,  2,  1, 14,
		cuts, 20,10,  4,  4,  1,  1,  1,  1,
		metl, 18, 0,  8, 28,  1,  1,  1,  1,
		metl,  0, 2, 12,  8,  1,  2,  1, 14
		};
	short pullup[] = { 18, 40, 28,
		impl, 17, 1, 22, 10,  1,  1,  1,  1,
		impl,  1, 9, 10, 16,  1,  1,  1,  1,
		impl,  1,15, 18, 10,  1,  1,  1,  1,
		diff,  0, 2,  8,  8,  1,  1,  1,  1,
		diff,  8, 4, 36,  4,  1,  1,  1,  1,
		diff,  4,10,  4,  8,  1,  1,  1,  1,
		diff,  4,18, 36,  4,  1,  1,  1,  1,
		diff, 18,16,  8,  8,  1,  1,  1,  1,
		poly, 20, 0, 16, 12,  1,  1,  1,  1,
		poly, 36, 2,  4,  8,  1,  1,  1,  1,
		poly, 16,16,  4,  8,  1,  1,  1,  1,
		poly,  0,14, 16, 12,  1,  1,  1,  1,
		poly,  0,12, 12,  2,  1,  1,  1,  1,
		cuts,  2, 4,  4,  4,  2,  1, 34,  1,
		cuts, 16,18,  8,  4,  1,  1,  1,  1,
		metl,  0, 0,  8, 28,  1,  1,  1,  1,
		metl, 14,16, 12,  8,  1,  1,  1,  1,
		metl, 34, 2,  8,  8,  1,  1,  1,  1
		};
	short plaground[] = { 7, 28, 20,
		diff, 16, 2,  4, 18,  1,  1,  1,  1,
		diff, 12, 6,  8,  8,  1,  1,  1,  1,
		poly,  6, 0,  4, 20,  1,  1,  1,  1,
		poly, 10, 0,  4,  4,  1,  2,  1, 16,
		poly, 22, 2,  4, 18,  1,  1,  1,  1,
		cuts, 14, 8,  4,  4,  1,  1,  1,  1,
		metl,  0, 6, 28,  8,  1,  1,  1,  1
		};

	/*  Define the routines for drawing cellular arrays */
int suncolor();

/*----------------------------------*/
main()
{
	char ch;

	if (initialize_core( DYNAMICC, SYNCHRONOUS,THREED)) exit(0);
	if (initialize_view_surface( suncolor, FALSE)) exit(1);
	select_view_surface( suncolor);
	set_viewport_2( 0., 1., 0., .75);
	set_window( 0., 1023., 200., 1000.);
	set_output_clipping( TRUE);
	set_window_clipping( FALSE);
	define_color_indices( suncolor, 1, 31, red, green, blue);

	create_retained_segment( 1);
	    set_primitive_attributes( &PRIMATTS);
	    set_rasterop( ORROP);
	    legend();
	    draw(placell,0,0,60,94,5,5,28,28);
	    draw(placon,0,0,60+140,94,1,5,1,28); 
	    draw(pullup,0,0,60-38,94,1,5,1,28);
	    draw(plaground,0,0,60,94-20,5,2,28,158);
	close_retained_segment();
	set_segment_visibility( 1, FALSE);
	set_segment_visibility( 1, TRUE);
	do {
	    sleep(5);
	    new_frame();
	} while (TRUE);
    }
/*---------------------------------*/
legend()
{
	set_font( 4);  set_charsize(9.,9.);  set_text_index( 1);
	move_abs_2( 100., 237.);
	text("Implant  Diffusion  Poly      Cuts      Metal");
	box( impl,25,62,20,7,1,1,1,1);
	box( diff,60,62,20,7,1,1,1,1);
	box( poly,95,62,20,7,1,1,1,1);
	box( cuts,130,62,20,7,1,1,1,1);
	box( metl,165,62,20,7,1,1,1,1);
}
/*---------------------------------*/
box(pat,x,y,lx,ly,nx,ny,ix,iy) short pat,x,y,lx,ly,nx,ny,ix,iy;
{
    float xlist[4], ylist[4];
    int i,j,k,l;

    switch (pat) {
        case 0: set_fill_index( polymask); break;
	case 1: set_fill_index( diffmask); break;
	case 2: set_fill_index( cutsmask); break;
	case 3: set_fill_index( metlmask); break;
	case 4: set_fill_index( implmask); break;
	default:;
	}
    ix *= lambda;
    iy *= lambda;
    lx *= lambda;
    ly *= lambda;

    for (i=0; i<nx; i++) {
	k = x * lambda + (i*ix);
        for (j=0; j<ny; j++) {
	    l = y * lambda + (j*iy);
    	    xlist[0] = k;  xlist[1] = xlist[0];
    	    xlist[2] = k + lx;  xlist[3] = xlist[2];
    	    ylist[0] = l;  ylist[1] = l + ly;
    	    ylist[2] = ylist[1];  ylist[3] = ylist[0];

    	    polygon_abs_2( xlist, ylist, 4);
	    }
	}
}
/*---------------------------------*/
draw(obj,angle,mirror,x0,y0,nx,ny,ix,iy)
    short *obj,angle,mirror, x0,y0,nx,ny,ix,iy;
{
    short boxcount, i,j,k,xdest, ydest;
    short *ptr,*ptr1,pat,bx,by,blx,bly,bnx,bny,bix,biy;
    short lx, ly;

    ptr = obj;
    boxcount = *ptr++;
    lx = *ptr++ * lambda;  ly = *ptr++ * lambda;

    for (i=0; i<nx; i++) {
	xdest = x0 + (i*ix);
        for (j=0; j<ny; j++) {
	    ydest = y0 + (j*iy);
	    ptr1 = ptr;
    	    for ( k=0; k<boxcount; k++) {
	        pat = *ptr1++;
	        bx = xdest + *ptr1++;     by = ydest + *ptr1++;
	        blx = *ptr1++;      bly = *ptr1++;
	        bnx = *ptr1++;      bny = *ptr1++;
	        bix = *ptr1++;      biy = *ptr1++;
        	box( pat,bx,by,blx,bly,bnx,bny,bix,biy);
	    }
	}
    }
}
