/*	mouse.h	4.2	82/12/17	*/

/*
 * Mouse info passed by system to user
 * X and Y are in absolute, infinite mouse coordinates
 * Clamping, scaling, and movement must be done by user
 */
struct mouseinfo {
	long	mi_x;		/* X */
	long	mi_y;		/* Y */
	int	mi_buttons;	/* # of buttons in queue */
};

/*
 * Mouse buffer shared in memory between user and system
 * Established by mmap system call
 */
struct mousebuf {
	int	mb_size;	/* size (in mouseinfo units) of buffer */
	int	mb_off;		/* current offset in buffer */
	struct mouseinfo mb_info[1];	/* however many samples */
};

#define	MIOCGPOS	_IOR(m, 0, struct mouseinfo)	/* get mouse info */
#define	MIOCGBUFS	_IOR(m, 1, int)	/* get mouse buffer size */
#define	MIOCSBUFS	_IOW(m, 2, int)	/* set mouse buffer size */
