/*	sunromvec.h	2.6	82/10/28	*/

/* (C) Copyright 1982 by Sun Microsystems, Inc. */

/*
 * sunromvec.h
 *
 * This defines the structure of the vector table at the first of the boot rom.
 *
 * History:
 *
 * 8 June 1982
 * Originally written by John Gilmore to replace EMULATE TRAP calls with
 * something simpler, smaller, and cheaper.
 *
 * 11 August 1982  -  JCGilmore
 * Assorted things added for Rev D.
 *
 * 13 September 1982  -  JCGilmore
 * Changed all typedefs to structs so all the defining files don't need
 * to be #include-d along with these pointer declarations.
 *
 * 22 September 1982 -- JCGilmore
 * Added the assembler language definition of DiagRet, since its C definition
 * can't be accessed in an assembler instruction.
 */

/* Sun Monitor ROM Vector
 *
 * This vector table is the only knowledge the outside world has of this prom.
 * It is referenced by hardware (Reset SSP, PC), things in the 2nd prom, and
 * programs & operating systems that run under the monitor.  Once located,
 * no entry can be re-located unless you change the world that needs it.
 * 
 * The entries start at location 0x200000 [very first thing in the Prom].
 *
 * The easiest way to reference elements of this vector is to say:
 *
 *	*RomVecPtr->xxx
 *
 * as in:
 *
 *	(*RomVecPtr->v_putchar) (c);
 *
 * This is pretty cheap as it only generates   movl 0x2000xx,a0  jsr a0@ .
 * That's 2 bytes longer, and 4 cycles longer, than a simple subroutine call.
 *
 */

struct sunromvec {

	char *v_initsp;		/* Initial SSP for hardware RESET */
	int (*v_startmon)();	/* Initial PC  for hardware RESET */
/* Monitor and hardware revision and identification */
	char *v_SunRev;		/* Revision level of monitor & hardware */
	long *v_SerialNum;	/* Serial number of this Sun */
 	int *v_MemorySize;	/* Physical onboard memory size */
/* Monitor-managed single-character input and output */
	unsigned char (*v_getchar)();	/* Get char from cur input source */
	int (*v_putchar)();	/* Put char to current output sink */
	int (*v_mayget)();	/* Maybe get char from current input source */
	int (*v_mayput)();	/* Maybe put char to current output sink */
	unsigned char *v_EchoOn;/* Should getchar echo its input? */
	unsigned char *v_InSource;/* Input source selector */
	unsigned char *v_OutSink;	/* Output sink selector */
/* Monitor-managed keyboard input (scanned by monitor refresh routine) */
	int (*v_getkey)();	/* Get next translated key if one exists */
	int (*v_InitGetkey)();	/* Initialize before first getkey */
	unsigned int *v_translation;	/* Keyboard translation selector */
	unsigned char *v_KeybId;	/* Up/down keyboard ID byte */
	struct keyboard **v_CurKeyboard;/* Addr current keyboard defn struct */
	struct keymap * (**v_SetTable)();/* Addr current shift->table mapper */
	struct keybuf *v_Keybuf;	/* Up/down keycode buffer */
/* Monitor-managed framebuffer output and terminal emulation */
	int (*v_finit)();		/* Framebuffer initialization routine */
	int (*v_fwritechar)();	/* Write a character to FB "terminal" */
	int *v_FBAddr;		/* Address of frame buffer we are using */
	char **v_FontTable;	/* Address of font table for FB "terminal" */
	int (*v_fwrstr)();	/* Write a string to FB -- faster */
/* Monitor-managed mouse input (scanned by monitor refresh routine) */
	int *v_MouseBuf;	/* Placeholder for Mouse input buffer */
/* Monitor-managed line input and parsing */
	unsigned char *v_linbuf;	/* The line input buffer */
	unsigned char **v_lineptr;	/* Current pointer into linbuf */
	int *v_linesize;	/* Total length of line in linbuf */
	int (*v_getline)();	/* Fill linbuf from current input source */
	unsigned char (*v_getone)();	/* Get next char from linbuf */
	unsigned char (*v_peekchar)();/* Peek at next char without reading it */
	int (*v_gethexbyte)();	/* Get next 2 chars and xlate to binary */
	int (*v_getnum)();	/* Get next numerics and xlate to binary */
/* Monitor-managed phrase output to current output sink */
	int (*v_message)();	/* Print a null-terminated string */
	int (*v_printhex)();	/* Print N digits of a longword in hex */
/* Memory management routines which must run outside mappable address space */
	int (*v_SetSeg)();	/* Set segment map entry X in context C */
	short (*v_GetSeg)();	/* Get segment map entry X from context C */
/* Refresh related information */
	int (*v_KeyFrsh)();	/* Address that oughta be in level 7 vector */
	int (*AbortEnt)();	/* Monitor entry point from keyboard abort */
	int *v_RefrCnt;		/* Refresh routines's millisecond count */
/* Assorted useful things added after the first bunch */
	char *(*v_bedecode)();	/* Bus error decoding routine */
	int (**v_keyentry)();	/* Called when table has unknown entry */
/* Monitor internal interface information */
	struct globram *v_GlobPtr;	/* Addr of monitor global variables */
	int (*v_diagret)();	/* Re-entry point for diagnostics */
/*				   See bottom of this file for DiagRet. */
/* Assorted other things added for Rev D				*/
	int *v_KRptInitial;	/* ms to wait before repeating held key */
	unsigned char *v_KRptTick; /* ms to wait between repetitions */
	char ***v_KStrTab;	/* Ptr to table of strings gen'd by keys */
	int (*v_pos)();		/* Cursor positioner for terminal emulator */
	int (*v_blinkscreen)();	/* Screen blinker (bell) for term emulator */
	int (*v_ExitOp)();	/* Exits from user program to Monitor */
};

#define  RomVecPtr ((struct sunromvec *)0x200000)

asm ("DiagRet = 0x2000ac");	/* Make it accessible from assembler */

/******************** End of sunromvec.h ************************************/
