/*	sir.h	4.3	83/01/15	*/

/*
 * Software controlled (and implemented) interrupts
 * Vector table for software interrupts is sirtab in locore.s
 */
#define	SIR_MAX		16	/* # of soft intr levels (must fit in mask) */

#define	SIR_CONSOUT	1	/* level for console output */
#define	SIR_NET		2	/* level for network code */
#define	SIR_MBCOPY	3	/* level to copy data to/from Multibus */
#define	SIR_SOFTCLOCK	4	/* level for softclock interrupts */

#define	siron(sirn)	(sirmask |= (1<<(sirn)))

#if defined(KERNEL) && !defined(LOCORE)
int	sirmask;
#endif
