#include <usercore.h>
#include <math.h>

int sunbitmap();
main()
	{
	char string[81];
	int length, n;
	float theta, deltheta, wmat[4][4];

	initialize_core(BASIC, SYNCHRONOUS, THREED);
	initialize_view_surface(sunbitmap, FALSE);
	select_view_surface(sunbitmap);
	set_view_reference_point(0.0, 0.0, 0.5);
	set_view_plane_normal(0.0, 0.0, -1.0);
	set_view_plane_distance(0.0);
	set_projection(PERSPECTIVE, 0.0, 0.0, 1.5);
	set_view_up_3(0.0, 1.0, 0.0);
	set_window(-1.0, 1.0, -1.0, 1.0);
	set_view_depth(0.0, 1.0);
	set_viewport_3(.125, .875, 0.0, .75, 0.0, 1.0);
	initialize_device(KEYBOARD, 1);
	set_keyboard(1, 80, "", 1);
	set_image_transformation_type(NONE);
	identity(wmat);
	set_world_coordinate_matrix_3(wmat);
	theta = 0.0;
	deltheta = 2.0 * 3.14159 / 100.0;
	for (n = 1; n <= 100; n++)
		{
		create_retained_segment(n);
		set_primitive_attributes( &PRIMATTS);
		cube();
		close_retained_segment();
		theta += deltheta;
		wmat[0][0] = wmat[2][2] = cos(theta);
		wmat[0][2] = sin(theta);
		wmat[2][0] = -wmat[0][2];
		set_world_coordinate_matrix_3(wmat);
		set_segment_visibility(n, FALSE);
		}
	n = 1;
	set_segment_visibility(n, TRUE);
	do
		{
		set_segment_visibility(n, FALSE);
		if ( ++n > 100) n = 1;
		set_segment_visibility(n, TRUE);
		await_keyboard(0, 1, string, &length);
		}
	while (length == 0);
	terminate_device(KEYBOARD, 1);
	deselect_view_surface(sunbitmap);
	terminate_core();
	}


cube()
	{
	move_abs_3( 0.5,  0.5,  0.5);
	line_abs_3( 0.5, -0.5,  0.5);
	line_abs_3(-0.5, -0.5,  0.5);
	line_abs_3(-0.5,  0.5,  0.5);
	line_abs_3( 0.5,  0.5,  0.5);
	move_abs_3( 0.5,  0.5, -0.5);
	line_abs_3( 0.5, -0.5, -0.5);
	line_abs_3(-0.5, -0.5, -0.5);
	line_abs_3(-0.5,  0.5, -0.5);
	line_abs_3( 0.5,  0.5, -0.5);
	move_abs_3( 0.0,  0.5, -0.5);
	line_abs_3( 0.0, -0.5, -0.5);
	move_abs_3( 0.5,  0.0, -0.5);
	line_abs_3(-0.5,  0.0, -0.5);
	move_abs_3( 0.5,  0.5,  0.5);
	line_abs_3( 0.5,  0.5, -0.5);
	move_abs_3( 0.5, -0.5,  0.5);
	line_abs_3( 0.5, -0.5, -0.5);
	move_abs_3(-0.5,  0.5,  0.5);
	line_abs_3(-0.5,  0.5, -0.5);
	move_abs_3(-0.5, -0.5,  0.5);
	line_abs_3(-0.5, -0.5, -0.5);
	}
identity(mat) float mat[4][4];
{
	int i;
	float *pmat;
	pmat = &mat[0][0];
	for (i=0; i<16; i++)
		*pmat++ = 0.0;
	mat[0][0] = mat[1][1] = mat[2][2] = mat[3][3] = 1.0;
}
