/*	cpu.h	4.11	83/03/26	*/

#ifndef LOCORE
#include <mon/sunromvec.h>
#endif

#define	SUN_1		1
#define	SUN_2		2

#define	SUN_MAX		2

#ifndef LOCORE
#ifdef KERNEL
int	cpu;
#endif
#endif

#ifndef LOCORE
/*
 * The context structure is used to allocate
 * contexts and maintains the lru linked list
 * of processes using contexts.
 */

struct context {
	struct	context *ctx_forw;	/* linked list of free or use */
	struct	context *ctx_back;	/* linked list of free or use */
	struct	proc *ctx_procp;	/* back pointer to proc structure */
	struct	pmeg *ctx_pmeg[NSEGMAP];/* pmeg allocation for this context */
	u_short	ctx_context;		/* bits to load into context register */
};

#ifdef KERNEL
extern struct context context[];
extern struct context ctxfreelist, ctxhead;
extern struct pte Ctxmap[];
extern struct user ctxutl;
#endif

#define	CSEG	60		/* segment for manipulation of contexts */

#define	setseg	(*RomVecPtr->v_SetSeg)

/*
 * The pmeg structure allocates the hardware page map
 * entry groups and other stuff.
 */
struct pmeg {
	struct	pmeg *pm_forw;		/* forward link */
	struct	pmeg *pm_back;		/* backward link */
	struct	proc *pm_procp; 	/* back pointer to proc using */
	struct	pte *pm_pte;		/* pointer to pte's mapping */
	short	pm_seg;			/* segment with process address space */
	short	pm_count;		/* number of valid pte's in group */
};

#ifdef KERNEL
extern struct pmeg pmeg[];
extern struct pmeg pmeghead;
extern int kernpmeg;
#endif
#endif !LOCORE
