Program EtherTest;

Imports Memory from Memory;
Imports Ether10IO from Ether10IO;
{Imports GetNetAddr from GetNetAddr;}
Imports Util from Util;
Imports KeyBoard from KeyBoard;

Type    ptrString = ^String;

Var     BuffSeg, blocks: Integer;
        ename, message: String;
        thisaddr, otheraddr: EtherAddress;
        eshead, erhead: pEtherHeader;
        esbuff, erbuff: pEtherBuff;
        esstat, erstat: pEtherStatus;
        RecvCmd: EtherCommand;

        pString: ptrString;
        top, bot: UWindNum;
        topw, botw: UWindow;
        tempr: URect;

Handler E10ReceiveDone (stat: pEtherStatus);

        Var     ps: ptrString;

        Begin
        UChangeWindow (top);
        if stat <> erstat
            then writeln ('*** receive status is not erstat ***')
            else begin
                ps := ReCast (erbuff, ptrString);
                writeln (ps^);
                with erhead^ do
                    begin
                    Dest := thisaddr;
                    Src := otheraddr;
                    EType := 0;
                    end;
                E10IO (RecvCmd, erhead, erbuff, erstat, 100);
                end;
        UChangeWindow (bot);
        End;

Begin
UInit;
{
blocks := 2 * UBlocks (WordSize (EtherHeader) + WordSize (EtherBuff)
                                        + WordSize (EtherStatus));
write (blocks:1, ' blocks required ... How many? ');
readln (blocks);
}
BuffSeg := UCreateSegment (7, 1, 7);    { 7 was experimentally determined }
SetMobility (BuffSeg, UnMovable);
{
writeln (blocks:1, ' blocks in segment number ', Buffseg);
}

New (BuffSeg, 1024, esbuff);
New (BuffSeg, 1024, erbuff);
New (BuffSeg, 8, eshead);
New (BuffSeg, 8, erhead);
New (BuffSeg, 2, esstat);
New (BuffSeg, 2, erstat);

NetAddrInit;
repeat
    write ('What is this Perq''s ethernet name? ');
    readln (ename);
    until NetAddrLookup (ename, thisaddr);
E10Reset (thisaddr);

repeat
    write ('What is the other Perq''s ethernet name? ');
    readln (ename);
    until NetAddrLookup (ename, otheraddr);

tempr := UScrOutside;
with tempr do
    UHeight := UHeight div 2;
topw := USysWindow (tempr, True);
botw := topw;
UWndBelow (botw, topw, 0);
bot := UNewWindNum;
top := UNewWindNum;
botw . uthick := bot;
topw . uthick := top;
UDrwWindow (botw);
UTitle ('                           Click any button to quit.');
UDrwWindow (topw);
UTitle ('                           Click any button to quit.');
UChangeWindow (bot);
KBMode := [KBEcho, KBTranslate, KBStripCR, KBCharCursor];

if UGetBool ('Which receive command?', 'Receive', 'PromiscuousReceive')
    then RecvCmd := EReceive
    else RecvCmd := EPromiscuousReceive;

with erhead^ do
    begin
    Dest := thisaddr;
    Src := otheraddr;
    EType := 0;
    end;
E10IO (RecvCmd, erhead, erbuff, erstat, 100);

pstring := recast (esbuff, ptrString);
with tempr do
    begin
    utop := 1022;
    uleft := 766;
    uwidth := 1;
    uheight := 1;
    end;
UOnCursor (tempr);
KBNewLine;

repeat
    KBPoll;
    if KBEOL then
        begin
        with eshead^ do
            begin
            Dest := otheraddr;
            Src := thisaddr;
            EType := 0;
            end;

        pString^ := KBLine;

        E10WIO (ESend, eshead, esbuff, esstat, 100);
        KBNewLine;
        end;
    UPollButtons;
    until UButtons <> [];

UChangeWindow (0);
UPaint (UBackGnd, UScrOutside);
UOffButton;
UOffCursor;
UDispSegment (BuffSeg);
End.
