{**************************************}
{
{        Spice Region Editor
{        Richard Cohn
{        April 1, 1981
{
{**************************************}


module RegionEditor;


exports

imports FileSystem from FileSystem;
imports IO_Others from IO_Others;
imports Canvas from EdCanvas;
imports Screen from Screen;
 
{$Include EdHeader.pas }  { global constant, type, and variable declarations }
{$Include EdCmds.pas }    { table of editor commands }

 
{**********************************
{    Exported Procedures
{**********************************}

procedure LookForCommand (Canv:  Canvas);
procedure FilterMouseCommand;
procedure EditRegion;
function GetNumber (SendNums:  boolean):  integer;
      
      
{**********************************}
 private
{**********************************}
 
  
imports EditSetup from EdInit;        
imports ScreenUtilities from EdScreen;
imports TextUtilities from EdText;
imports ReplayUtilities from EdReplay;
imports MoveCommands from EdMove;
imports SearchCmds from EdSearch;
imports InsertDeleteCmds from EdInsert;
imports Perq_String from Perq_String;
imports Except from Except;
imports System from System;
imports Clock from Clock;


{****************************************************************}

procedure LookForCommand (Canv:  Canvas);

{ If there's an event in the command queue, grab it.  Update
{ mouse (xPointer, yPointer) but don't move it on screen.   }

var
    xOldMove, yOldMove:  integer;
    NewTimStr:  string;

begin
if ((NewEvent.Cmd = NullCmd) and (NewEvent.x = 0) and (NewEvent.y = 0))
    or (Replay = ReplaySingleStep) then
    begin
    GetTString(NewTimStr);
    if NewTimStr <> TimStr then
        begin
        TimStr := NewTimStr;
        ChangeTitle (Concat(EdTitle, TimStr))
        end
    end;
if Canv = CanvTrans then
    begin
    GetTrnKey;
    exit (LookForCommand)
    end; { if Canv = CanvTrans ... }
NewEvent := GetKey (InputQueue);
if remembering then
    { mouse deactivated if remembering macro }
    begin
    newEvent.x := 0;
    newEvent.y := 0;
    if (newEvent.cmd <> nullCmd) and not newEvent.returned then
        EnQueueKey (macroQueue, newEvent);
    end
else if PtrDisplayed then
    begin
    xOldMove := xMove;
    yOldMove := yMove;
    xMove := NewEvent.x;
    yMove := NewEvent.y;
    if (abs (xMove) > MouseJump) or (abs (yMove) > MouseJump) or
        (xMove * xOldMove < 0) or (yMove * yOldMove < 0) then
        begin
        xMove := 0;
        yMove := 0
        end;
    xPointer := xPointer + xMove;
    yPointer := yPointer + yMove;
    with CurWin^.Bound^ do
        begin
        if xPointer < xMin then
            xPointer := xMin
        else if xPointer > xMax then
            xPointer := xMax;
        if yPointer < yMin then
            yPointer := yMin
        else if yPointer > yMax then
            yPointer := yMax
        end { with }
    end; { if PtrDisplayed }
with CurWin^ do
    if not (IsPrompt or (NewEvent.Cmd in [NullCmd, NoopCmd, IllegalCmd])) then
        if CountChanges and (NewEvent.Cmd in ChangeCmds) then
            begin
            nMoves := 0;
            nChanges := nChanges + 1;
            if nChanges = 1 then
                RefreshName;
            end
        else if (nChanges > 0) and (nMoves < MaxMovesCount) then
            begin
            nMoves := nMoves + 1;
            nChanges := nChanges + 1
            end;        
if DEBUG [6] then
    if newEvent.cmd <> nullCmd then
        StatusNumber ('LookForCommand:  cmd = ', newEvent.cmd);
end; { LookForCommand }


{****************************************************************************}

procedure FilterMouseCommand;

{ Catch scroll and thumb commands.  Preceded by calls to LookForCommand
{ to get command and DisplPointer to get current pointer area (Thumb,
{ Scroll, or Text).                                                    }

begin
if (CurrentPtr <> TextPtr) and (NewEvent.Cmd in MouseCmds) then
    begin
    NewEvent.x := 0;
    NewEvent.y := 0;
    ReturnKey (inputQueue, NewEvent);
    if CurrentPtr = ScrollPtr then
        NewEvent.Cmd := ToggleScroll
    else
        NewEvent.Cmd := ToggleThumb
    end
end; { FilterMouseCommand }


{*****************************************************************}

   function GetNumber (SendNums:  boolean):  integer;
   const FirstCol = 30;  { assumes previous prompt < 30 chars }
   var NextNumber, Digit: integer;
       OldWin:  pTextWindow;
   begin { GetNumber }
    OldWin := CurWin;
    ChangeTextWindow (PromptWindow);
    MovePencil (0, FirstCol);
    Digit := 1;
    NextNumber := Ord(NewEvent.Ch) - Ord('0');
    write (NewEvent.Ch);
    repeat
        repeat LookForCommand (CanvDflt)
        until NewEvent.Cmd <> NullCmd;
        if SendNums then
            SendKey (NewEvent);
        if NewEvent.Ch in Numbers then
            begin
            Digit := Digit + 1;
            if Digit > MaxDigits then { trying to make a big number }
                begin 
                Warn('Number too large--reset to 1');
                GetNumber := 1;
                ChangeTextWindow (OldWin);
                exit(GetNumber)
                end;
            write (NewEvent.Ch);
            NextNumber := NextNumber * 10 + Ord(NewEvent.Ch) - Ord('0')
            end
    until not (NewEvent.Ch in Numbers);
    ClearLine (0,0,0);
    ChangeTextWindow (OldWin);
    if NextNumber >= 0 then
        GetNumber := NextNumber
    else
        GetNumber := 0
   end { GetNumber };
  
  
{****************************************************************************}

procedure EditRegion;


var 
    LastCmd:  KeyCommand;
    LastRepeatCount:  integer;
    P:  Position;
    i:  integer;
  
   
{*****************************************************************}

procedure DebugEditor;

{ Print out debugging info or toggle debug switch. }

var
    OldWin:  pTextWindow;
    switch:  integer;
    
  procedure printchunks;
  
  
   procedure printlist( Q, R: Position; S: string );
   var P: pChunk;
       X: record case integer of
           1: (P: pChunk);
           2: (Seg: integer;
               Off: integer)
           end;
       done: boolean;
   begin { printlist }
    write(chr(12));
    writeln(s);
    P := Q.Chunk;
    Writeln('starting offset = ',Q.Offset);
    repeat done := P = R.Chunk;
     with P^ do
      begin X.P := P;
       write('chunk=', X.Seg:1, ',', X.Off:1);
       X.P := next;
       write(' next=', X.Seg:1, ',', X.Off:1);
       X.P := prev;
       write(' prev=', X.Seg:1, ',', X.Off:1);
       write(' cpage=', cpage:1, ' first=', first:1, ' length=', length:1);
       writeln(' order=', orderp:1, ',', orderc:1);
       P := next
      end
    until done;
    writeln('ending offset = ',R.Offset);
    repeat LookForCommand (CanvKeyBd)
    until NewEvent.Cmd <> NullCmd
   end { printlist };
  
  
  begin { printchunkc }
   ChangeTextWindow (OldWin);
   MovePencil (0,0);
   if SelectWindow = CurWin then
   printlist(Bufary[SelectB].first,Bufary[SelectB].last,'** Select **');
   with CurWin^ do
       printlist(FilledFirst,FilledLast,'** Filled **');
   printlist(emptyfirst,emptylast,'** Empty **');
   RefreshTextWindow
  end { printchunks };

begin { DebugEditor }
Prompt ('Debug command (0, ..., 9):  ');
repeat LookForCommand (CanvKeyBd)
until NewEvent.Cmd <> NullCmd;
if NewEvent.Ch in ['0'..'9'] then
    begin
    OldWin := CurWin;
    ChangeTextWindow (PromptWindow);
    ClearLine (0,0,0);
    if NewEvent.Ch = '0' then
        PrintChunks
    else
        begin
        write ('Debug ', newEvent.ch);
        switch := ord (newEvent.ch) - ord ('0');
        DEBUG [switch] := not DEBUG [switch];
        if DEBUG [switch] then
            write (' on')
        else
            write (' off');
        end; { else }
    ChangeTextWindow (OldWin);
    repeat LookForCommand (CanvKeyBd)
    until NewEvent.Cmd <> NullCmd
    end
else 
    Write(Bel);
NeedPrompt := true;
ImmedPrompt := true
end; { DebugEditor }


{*****************************************************************}

procedure GetRepeatCount;

var OldWin:  pTextWindow;  

begin { GetRepeatCount }
  OldWin := CurWin;
  ChangeTextWindow (PromptWindow);
  if RepeatCount = 1 then
      Prompt ('Repeat Count:  ')
  else
      begin
      ClearLine (0,0,0);
      write ('Repeat count:  ', RepeatCount:  2, ' * ');
      end;
  NeedPrompt := true;
  ImmedPrompt := false;
  CountChanges := false;
  repeat LookForCommand (CanvKeybd)
  until NewEvent.Cmd <> NullCmd;
  CountChanges := true;
  if not (NewEvent.Ch in Numbers) then
      RepeatCount := DefaultRepeat * RepeatCount
  else
      RepeatCount := GetNumber (false) * RepeatCount;
  if NewEvent.Cmd = Reject then
      begin
      Warn ('Repeat Count aborted.');
      RepeatCount := 1
      end
  else
      begin
      if not (NewEvent.Ch in Numbers) then
          ReturnKey (inputQueue, NewEvent);
      if (RepeatCount <= 0) or (RepeatCount > MaxRepeatCount) then
          begin
          Warn ('Repeat count reset to 1');
          RepeatCount := 1
          end
      else 
          begin
          ClearLine (0,0,0);
          write ('Repeat count =', RepeatCount);
          NeedPrompt := true;
          ImmedPrompt := true
          end
      end;
ChangeTextWindow (OldWin);
MoveTextPointer (CurWin^.CurLine, CurWin^.CurCol);
NewEvent.Cmd := CountCmd
end { GetRepeatCount }; 
        

{*****************************************************************}

procedure ChangeParameter;

var Param:  char;
    OldWin:  pTextWindow;
    val: integer;

begin
CountChanges := false;
OldWin := CurWin;
ChangeTextWindow (PromptWindow);
Prompt ('Change Autosave, Jump, L or R Margin, Screen, Tab, Verify, or WordWrap:');
repeat LookForCommand (CanvDflt)
until NewEvent.Ch <> NullCh;
SendKey (NewEvent);
Param := chr (LAND (#177, ord (NewEvent.Ch)));
if Param in ['a'..'z'] then
    Param := chr (ord (Param) + ord ('A') - ord ('a'));
if not (Param in ValidParams) then
    write (BEL);
ImmedPrompt := false;
if Param in ValidParams then
  if Param = 'V' then
    begin
    Verify := not Verify;
    if Verify then
        Prompt ('Verify On')
    else
        Prompt ('Verify Off')
    end
  else if Param = 'W' then
    begin
      wordWrap := not wordWrap;
      if wordWrap then
        prompt('Word Wrap On')
      else
        prompt('Word Wrap Off');
    end
  else if Param = 'S' then
    begin
    BlackScreen := not BlackScreen;
    if BlackScreen then
        IOSetFunction (CTInvert)
    else
        IOSetFunction (CTNormal);
    NeedPrompt := true;
    ImmedPrompt := true
    end
  else
    begin
    ClearLine (0,0,0);
    case param of
      'A':  write ('Autosave increment [', OldWin^.SaveAfter:1, ']:  ');
      'T':  write ('Tab spaces [', TabSpaces:1, ']:  ');
      'J':  write ('Mousejump [', MouseJump:1, ']:  ');
      'L':  write ('Left margin [', DfltLeftMargin:1, ']:  ');
      'R':  write ('Right margin [', DfltRightMargin:1, ']:  ');
      end;  { case }
    repeat LookForCommand (CanvDflt)
    until NewEvent.Cmd <> NullCmd;
    SendKey (NewEvent);
    if NewEvent.Ch in Numbers then
        case param of
          'A':
            begin
            NormSaveAfter := GetNumber (true);
            OldWin^.SaveAfter := NormSaveAfter;
            write ('Save after ', NormSaveAfter:1, ' changes')
            end;
          'T':
            begin
            TabSpaces := GetNumber (true);
            write ('Tab Spaces = ', TabSpaces:1)
            end;
          'J':
            begin
            MouseJump := GetNumber (true);
            write ('Mouse Jump = ', MouseJump:1)
            end;
          'L':
            begin
            val := GetNumber (true);
            if val >= oldWin^.RightMargin then
              prompt('Left Margin must be less than right margin')
            else if val < 0 then
              prompt('Left Margin must be > 0')
            else
              begin
                dfltLeftMargin := val;
                oldWin^.leftMargin := dfltLeftMargin;
                write ('Left Margin = ', dfltLeftMargin:1);
              end;
            end;
          'R':
            begin
            val := GetNumber (true);
            if val <= oldWin^.LeftMargin then
              prompt('Right Margin must be greather than left margin')
            else if val < 0 then
              prompt('Right Margin must be > 0')
            else
              begin
                dfltRightMargin := val;
                oldWin^.rightMargin := dfltRightMargin;
                write ('Right Margin = ', dfltRightMargin:1);
              end;
            end;
        end
    else
        Prompt ('Change parameter aborted')
    end
else 
    Prompt ('Change parameter aborted');
CountChanges := true;
NeedPrompt := true;
ChangeTextWindow (OldWin);
MoveTextPointer (CurWin^.CurLine, CurWin^.CurCol);
end; { ChangeParameter }


{*****************************************************************}

procedure StartRembering;

{ Start saving user's commands in the macro queue.  }

begin  { StartRembering }
if remembering then
    begin
    Warn ('Already remembering!');
    exit (StartRembering);
    end;
remembering := true;
FreeQueue (macroQueue);
CmdPrompt := macroPrompt;
immedPrompt := true;
needPrompt := true;
end;  { StartRembering }


{*****************************************************************}

procedure StopRembering;

{ Stop saving user's commands in the macro queue.  }
begin  { StopRembering }
if not remembering then
    exit (StopRembering);
macroQueue.last^.event.cmd := endMacroMarker;   { so that we can repeat it }
remembering := false;
Prompt ('Stopped remembering.');
if InsertMode then 
    CmdPrompt := InsModePrompt
else
    CmdPrompt := CmdModePrompt;
needPrompt := true;
end;  { StopRembering }


{*****************************************************************}

procedure ExecMacro;

{ Execute the current macro if one exists. }

begin  { ExecMacro }
if IsEmpty (macroQueue) then
    Warn ('No macro defined')
else if remembering then
    begin
    { kill macro since it contains a yank macro queue cmd already }
    Warn ('No recursive macros allowed--macro aborted');
    remembering := false;
    FreeQueue (macroQueue);
    end
else
    for i := 1 to repeatCount do
        ReturnQueue (inputQueue, macroQueue);
macroRunning := true;
end;  { ExecMacro }


{*****************************************************************}

procedure GetPrefixedCommand;

begin
SendKey (NewEvent);
Prompt ('Prefix key--complete command:');
CountChanges := false;
repeat LookForCommand (CanvKeyBd)
until NewEvent.Cmd <> NullCmd;
CountChanges := true;
NewEvent.Cmd := LOR (PrefixBit, NewEvent.Cmd);
with CurWin^ do
    if NewEvent.Cmd in ChangeCmds then
        begin
        nMoves := 0;
        nChanges := nChanges + 1;
        if nChanges = 1 then
            RefreshName;
        end
    else if (nChanges > 0) and (nMoves < MaxMovesCount) then
        begin
        nMoves := nMoves + 1;
        nChanges := nChanges + 1
        end;        
NeedPrompt := true;
ImmedPrompt := true
end;


{*****************************************************************}

handler CtlCAbort;
begin
CtrlCPending := false
end;


{*****************************************************************}

handler CtlC;
begin
CtrlCPending := false
end;


{*****************************************************************}

handler Dump (Message:  String);

var
    i:  integer;
    debugging:  boolean;

begin
debugging := false;
for i := 1 to 9 do
    debugging := debugging or DEBUG [i];
if debugging then
    raise Dump (Message)
end;


{*****************************************************************}

begin { RegionEdit }
ExitEdit := false;
LastCmd := NoopCmd;
LastRepeatCount := 1;
repeat
    if ImmedPrompt then
        begin
        ImmedPrompt := false;
        Prompt (CmdPrompt)
        end
    else
        if NeedPrompt then
            ImmedPrompt := true;
    if (Replay = NotReplaying) and (LastCmd in ReplayCmds) and
        not (LastCmd in [BSChar, DelBChar]) then
        FlushTranscript;
    if not (LastCmd in RepeatableCmds) then
        LastCmd := NoopCmd;
    RepeatCount := 1;
    NewEvent.Cmd := NullCmd;
    repeat
        repeat
            LookForCommand (CanvDflt);
            DisplPointer (xPointer,yPointer);
            FilterMouseCommand
        until (NewEvent.Cmd <> NullCmd);
        if NewEvent.Cmd = CountCmd then
            GetRepeatCount
    until NewEvent.Cmd <> CountCmd;
    Automatic := NewEvent.Cmd = DoAgainCmd;
    if Automatic then
        begin
        NewEvent.Cmd := LastCmd;
        RepeatCount := LastRepeatCount
        end;
    if NewEvent.Cmd = PrefixKey then
        GetPrefixedCommand;
    if newEvent.Cmd = endMacroMarker then
      begin
        LastCmd := doMacro;
        LastRepeatCount := 1;
      end
    else
      begin
        LastCmd := NewEvent.Cmd;
        LastRepeatCount := RepeatCount;
      end;
    if Replay = NotReplaying then
        if NewEvent.Cmd in ReplayCmds then
            begin
            if RepeatCount <> 1 then
                begin
                SendTrnByte (chr (lor (#200, CountCmd)));
                SendTrnWord (RepeatCount)
                end;
            SendKey (NewEvent)
            end;
    
    with CurWin^, NewEvent do
            
        { Change Position Commands }
        
        if Cmd = ForChar then
                   MoveForChar (repeatCount)
        else if Cmd = BackChar then
                   MoveBakChar (repeatCount)
        else if Cmd = ForWord then
                    MoveForWord (repeatCount)
        else if Cmd = BackWord then
                   MoveBackWord (repeatCount)
        else if Cmd = BeginLine then
                  MoveTextPointer (CurLine,0)
        else if Cmd = EndLine then
                    MoveTextPointer (CurLine, Ln [CurLine].Length-1)
        else if Cmd = UpLine then
                     MoveUpLine (repeatCount)
        else if Cmd = DownLine then
                   MoveDownLine (repeatCount)
        else if Cmd = UpPage then
                     MoveUpPage (repeatCount)
        else if Cmd = DownPage then
                   MoveDnPage (repeatCount)
        else if Cmd = TopWindow then
                  MoveTextPointer (0,0)
        else if Cmd = BottomWindow then
               MoveBottomWindow
        else if Cmd = BeginFile then
                  Show (Add (FilledFirst,2), 0, LastLine)
        else if Cmd = EndFile then
                    Show (FilledLast,  0, LastLine)
        else if Cmd = PosToSelect then
                if SelectWindow = CurWin then
                            Show (Bufary [SelectB].First, 0, LastLine)
                        else
                            Warn ('No selection in this window')
        else if Cmd = SetMark then
                    begin
                    Prompt ('Mark set.');
                    NeedPrompt := true;
                    Mark := GetPosition (CurLine, CurCol);
                    UpdateThumbBar
                    end
        else if Cmd = FindMark then
                   if Mark <> NilPosition then
                        begin
                        P := GetPosition (CurLine, CurCol);
                        Show (Mark, 0, LastLine);
                        Mark := P;
                        UpdateThumbBar
                        end
                    else
                        Warn ('No mark set in this window')

        { Change Selection Commands }

        else if Cmd in [SelChar, SelWord, SelLine, ExtendSel,
            UpSelChar, UpSelWord, UpSelLine, UpExtend] then
              SelectText
        else if Cmd = SelAll then
              SelectAllText

        { Actions on Postion }

        else if Cmd in InsCmds then
              InsertAtPosition
        else if Cmd = Twiddle then
               TwiddleChars
        else if Cmd in [OpenSpace, OpenIndent] then
             MakeOpenSpace
        else if Cmd = DelFChar then
              DelForChar (repeatCount)
        else if Cmd in [BSChar, DelBChar] then
              DelBackChar (repeatCount)
        else if Cmd = DelFWord then
              DelForWord (repeatCount)
        else if Cmd = DelBWord then
              DelBackWord (repeatCount)
        else if Cmd = DelELine then
              DelEndLine (repeatCount)
        else if Cmd = DelTWhite then
             DelToWhiteSpace
        else if Cmd = DelBLine then
              DelBegLine
        else if Cmd = Yank then
             YankBuffer (KillB)
        else if Cmd = PopKill then
               ModifyKillRing (repeatCount = 1)

        { Actions on Selection }

        else if Cmd = InsSelection then
              YankBuffer (SelectB)
        else if Cmd = DelSelection then
              DeleteSelection

        { Search Commands }

        else if Cmd in [InSearchString, InReplaceString] then
              GetString
        else if Cmd = SearchUp then
                   FindString (false)
        else if Cmd = SearchDown then
                   FindString (true)
        else if Cmd = ReplaceUp then
                  ReplaceString (false)
        else if Cmd = ReplaceDown then
                  ReplaceString (true)
        else if Cmd in [ForSearch, RevSearch] then
              Find
        else if Cmd in [ForReplace, RevReplace] then
              Replace

        { Formatting Commands }

        else if Cmd = IncrNum then
            IncrNumber (RepeatCount)
        else if Cmd = DecrNum then
            IncrNumber (-RepeatCount)
        else if Cmd = ParaFill then
            FillCurParagraph
        else if Cmd = SelFill then
            FillSelection
        else if cmd = LineCenter then
            CenterCurLine
        else if Cmd = SelCenter then
            CenterSelection
        else if Cmd = blockIndent then
            indentBlock
        else if Cmd = blockUndent then
            undentBlock

        { Macro Commands }

        else if cmd = startMacro then
            StartRembering
        else if cmd = stopMacro then
            StopRembering
        else if cmd = doMacro then
            ExecMacro
        else if cmd = endMacroMarker then
            macroRunning := false

        { Change Mode Commands }

        else if Cmd = ToggleInsert then
               ChangeMode
        else if Cmd = ToggleScroll then
            begin
            if ScrollOn then 
              ScrollText
            end
        else if Cmd = ToggleThumb then
            begin
            if ThumbOn then
              ThumbText
            end
        else if Cmd = NewParm then
                    ChangeParameter
        else if Cmd = DebugCmd then
                   DebugEditor
        else
            ExitEdit := true;
    
    with CurWin^ do
        if not ExitEdit and (SaveAfter > 0) and (nChanges > SaveAfter) then
            begin
            ExitEdit := true;
            NewEvent.Cmd := BackFile
            end
until ExitEdit;

ReturnKey (inputQueue, NewEvent)

end. { EditRegion }
