Program Convert;

Imports Image from Image;
Imports Util from Util;

Const   oldDirectory = 'Sys:Part1>Images>';
        oldExtension = '.OPkdBin';
        oldPattern = '*.OPkdBin';
        oldMaxSize = 256;

Type    oldim = Record
                oldName: String [25];
                oRows, oCols: Integer;
                oldData: Pointer;
                SegNum: Integer;
                End;

Imports Sail_String from Sail_String;
Imports PMatch from PMatch;
Imports Memory from Memory;
Imports Raster from Raster;

Type    Data = Packed Array [1..oldMaxSize, 1..oldMaxSize] of 0..1;
        PtrData = ^Data;

Const   DISize = WordSize (Data);                       { words in an oldim }
        LineLength = oldMaxSize div 16;                 { words in a row }

Type    DataInteger = Array [1..DISize] of Integer;
        PtrDI = ^DataInteger;

Exception oldexcept (s: string);

Function oldCreate (Name: String; Rws, Cls: Integer): oldim;

        Const   MSize = DISize div 256;         { 256 words in a block }

        Var     im: oldim;
                pd: PtrData;
                IPat: String;

        Begin
        if Rws < 1 then
            Raise oldExcept ('oldCreate: Rows less than 1');
        if Rws > oldMaxSize then
            Raise oldExcept ('oldCreate: Rows greater than oldMaxSize');
        if Rws mod 16 <> 0 then
            Raise oldExcept ('oldCreate: Rows not multiple of 16');
        if Cls < 1 then
            Raise oldExcept ('oldCreate: Cols less than 1');
        if Cls > oldMaxSize then
            Raise oldExcept ('oldCreate: Cols greater than oldMaxSize');
        if Cls mod 16 <> 0 then
            Raise oldExcept ('oldCreate: Cols not multiple of 16');
        IPat := OldPattern;
        if PattMatch (Name, IPat, True) then
            Adjust (Name, Length (Name) - Length (oldExtension));
                                                { cut off extension }
        with im do
            begin
            oldName := Name;
            oRows := Rws;
            oCols := Cls;
            CreateSegment (SegNum, MSize, 1, MSize + 5);
            New (SegNum, 4, pd);
            rasterop (RXor, Cls, Rws, 0, 0, LineLength, pd,
                                        0, 0, LineLength, pd);
            oldData := Recast (pd, Pointer);
            end;
        oldCreate := im;
        End;

Function oldRead (Name: String): oldim;

        Var     f: File of Integer;
                FileName, bullshit: String;
                im: oldim;
                r, c, i, j, start: Integer;
                pdi: PtrDI;

        Begin
        FileName := oldDirectory;
        AppendString (FileName, Name);
        bullshit := oldpattern;
        if not PattMatch (FileName, bullshit, True) then
            AppendString (FileName, oldExtension);
        ReSet (f, FileName);
        r := f^;
        get (f);
        c := f^;
        im := oldCreate (Name, r, c);
        pdi := ReCast (im . oldData, PtrDI);
        for i := 1 to r do
            begin
            start := (i - 1) * LineLength;
            for j := 1 to (c div 16) do
                begin
                get (f);
                pdi ^ [start + j] := f^;
                end;
            end;
        Close (f);
        oldRead := im;
        End;

Var     im: Image;
        old: OldIm;
        filnam: String;
        foo, bar: PtrData;
        r: URect;
        p: Pointer;

Begin
UInit;
filnam := UGetFile ('What old image do you want to convert?',
                                        olddirectory, oldpattern);
old := oldread (filnam);
imgcreate (im);
with im^, old do
    begin
    ImgName := OldName;
    Rows := orows;
    Cols := OCols;
    ImgUpLeft . UX := 400;
    ImgUpLeft . UY := 400;
    end;
r := ImgRect (im);
p := USaveRect (r);
ImgDisplay (im);
foo := ReCast (im^ . ImgData, PtrData);
bar := ReCast (old . oldData, PtrData);
foo^ := bar^;
ImgDisplay (im);
if UGetBool ('Store this image?', 'Yes', 'No') then
    ImgWrite (im);
URstorRect (r, p);
End.
