Program TestReceive;

Imports Ether10IO from Ether10IO;
Imports EBuffer from EBuffer;

Procedure printptr (p: pointer; s: string);

        var     bullshit: record case boolean of
                        true:  (ptr: pointer);
                        false: (os: integer;
                                sg: integer);
                        end;

        Begin
        with bullshit do
            begin
            ptr := p;
            writeln (s, ' is from segment ', sg:1, ' offset ', os:1);
            end;
        End;

Procedure printaddr (ea: EtherAddress; s: String);

        Begin
        with ea do
            writeln (s, High:1, ', ', Mid:1, ', ', Low:1, '.');
        End;

Var     Rec1Buf, Rec2Buf: pEtherBuffer;
        Rec1Head, Rec2Head: pEtherHeader;
        Rec1Stat, Rec2Stat: pEtherStatus;
        AdRec: pEtherAdRec;
        MyAddress, HisAddress, BroadcastAddr: EtherAddress;
        RecCmd: EtherCommand;

Function EquAddress (a, b: EtherAddress): Boolean;

        Begin
        EquAddress := (a . High = b . High) and (a . Mid = b . Mid) and
                (a . Low = b . Low);
        End;

Handler E10ReceiveDone (stat: pEtherStatus);

        Handler E10DByteError;

                Begin
                writeln ('Bad number of bits in received packet.');
                End;

        Type    CharArray = Packed Array [0 .. 1498] of Char;
                pCharArray = ^CharArray;

        Label   1;

        Var     Bytes: Integer;
                head: pEtherHeader;
                buf: pEtherBuffer;
                ans: Boolean;
                i: Integer;
                phooey: pCharArray;

        Begin
        writeln;
        if stat = Rec1Stat
            then begin
                writeln ('Received #1.');
                head := Rec1Head;
                buf := Rec1Buf;
                end
            else if stat = Rec2Stat
            then begin
                writeln ('Received #2.');
                head := Rec2Head;
                buf := Rec2Buf;
                end
            else begin
            writeln ('Received packet with unknown status block.');
            printptr (stat, 'stat');
            Exit (TestReceive);
            end;
        Bytes := E10DataBytes (stat^ . BitsRecv);
        with Head^ do
            begin
            if EquAddress (Dest, BroadcastAddr) then
                begin
                printaddr (Src, 'Received broadcast packet from ');
                GoTo 1;
                end;
            if not EquAddress (Dest, MyAddress) then
                begin
                writeln ('Received packet not to me.');
                end;
            if not EquAddress (Src, HisAddress) then
                begin
                writeln ('Received packet not from him.');
                end;
            end;
        with Head^ do
            begin
            printaddr (Src, 'Src is ');
            printaddr (Dest, 'Dest is ');
            writeln ('Type is ', EType:1);
            end;
        with Stat^ do
            begin
            writeln ('CRCError is ', CRCError);
            writeln ('Collision is ', Collision);
            writeln ('RecvTrans is ', RecvTrans);
            writeln ('Busy is ', Busy);
            writeln ('ClockOver is ', ClockOver);
            writeln ('PIP is ', PIP);
            writeln ('Carrier is ', Carrier);
            writeln ('RetryTime is ', RetryTime:1);
            writeln ('SendError is ', SendError);
            writeln ('CmdInProg is ', CmdInProg);
            writeln ('BitsRecv is ', BitsRecv:1);
            writeln ('Bytes is ', Bytes:1);
            end;
{
        write ('Show the contents of the buffer? (T/F) ');
        readln (ans);
        if ans then
            begin
            write ('characters (or bytes) (T/F) ? ');
            readln (ans);
            if ans
              then
                begin
                write ('Entire buffer (or just ', Bytes:1, ' bytes) ? (T/F) ');
                readln (ans);
                phooey := ReCast (Buf, pCharArray);
                if ans
                    then for i := 0 to 1498 do
                        write (phooey^ [i], ', ')
                    else for i := 0 to Bytes do
                        write (phooey^ [i], ', ');
                writeln;
                end
              else
                begin
                write ('Entire buffer (or just ', Bytes:1, ' bytes) ? (T/F) ');
                readln (ans);
                phooey := ReCast (Buf, pCharArray);
                if ans
                    then for i := 0 to 1498 do
                        write (ord (phooey^ [i]):3, ', ')
                    else for i := 0 to Bytes do
                        write (ord (phooey^ [i]):3, ', ');
                writeln;
                end;
            end;
}
1:      E10IO (RecCmd, Head, Buf, Stat, MaxDataBytes);
        writeln ('Set up receive again.');
        write ('Type <return> to end program.');
        End;

Var     ans: Boolean;

Begin
EB_Alloc (2, AdRec);
EB_Buffers (Rec1Head, Rec1Buf, Rec1Stat);
EB_Buffers (Rec2Head, Rec2Buf, Rec2Stat);
writeln ('Buffers Allocated.');
E10Init;
MyAddress := E10GetAdr;
printaddr (MyAddress, 'My address is ');
write ('Swap bytes of high & mid addresses? (T/F) ');
readln (ans);
if ans then
    begin
    with MyAddress do
        begin
        High := LOR (Shift (High, -8), Shift (High, 8));
        Mid := LOR (Shift (Mid, -8), Shift (Mid, 8));
        end;
    printaddr (MyAddress, 'Now my address is ');
    end;
write ('Swap bytes of low address? (T/F) ');
readln (ans);
if ans then
    begin
    with MyAddress do
        Low := LOR (Shift (Low, -8), Shift (Low, 8));
    printaddr (MyAddress, 'Now my address is ');
    end;
with HisAddress do
    begin
    write ('His address:  High? ');
    readln (High);
    write ('Mid? ');
    readln (Mid);
    write ('Low? ');
    readln (Low);
    end;
printaddr (HisAddress, 'His address is ');
with BroadCastAddr do
    begin
    High := -1;
    Mid := -1;
    Low := -1;
    end;
with AdRec^ do
    begin
    LowAddress := MyAddress . Low;
    MCB := MltCstNone;
    end;
E10Reset (AdRec);
writeln ('Reset Ethernet.');
write ('Promiscuous receives? (T/F) ');
readln (ans);
if ans
    then RecCmd := EPromiscuousReceive
    else RecCmd := EReceive;
E10IO (RecCmd, Rec1Head, Rec1Buf, Rec1Stat, MaxDataBytes);
E10IO (RecCmd, Rec2Head, Rec2Buf, Rec2Stat, MaxDataBytes);
writeln ('Set up receives.');
write ('Type <return> to end program.');
readln;
E10Reset (AdRec);
End.
