program Test;

Imports Ether10IO from Ether10IO;
Imports EBuffer from EBuffer;
Imports ELowSends from ELowSends;

Const   Data = 1001;
        Ack  = 1002;
        NAck = 1003;

Type    pStr = ^String;

Var     SendBuf,  RecBuf,  AckBuf:  pEtherBuffer;
        SendHead, RecHead, AckHead: pEtherHeader;
        SendStat, RecStat, AckStat: pEtherStatus;
        AdRec: pEtherAdRec;
        MyAddress, HisAddress, BroadcastAddress: EtherAddress;
        Rec_Command: EtherCommand;

Procedure printptr (p: pointer; s: string);

        var     bullshit: record case boolean of
                        true:  (ptr: pointer);
                        false: (os: integer;
                                sg: integer);
                        end;

        Begin
        with bullshit do
            begin
            ptr := p;
            writeln (s, ' is from segment ', sg:1, ' offset ', os:1);
            end;
        End;

Procedure printaddr (ea: EtherAddress; s: String);

        Begin
        with ea do
            writeln (s, High:1, ', ', Mid:1, ', ', Low:1, '.');
        End;

Function EquAddress (a, b: EtherAddress): Boolean;

        Begin
        EquAddress := (a . High = b . High) and (a . Mid = b . Mid) and
                (a . Low = b . Low);
        End;

Function Swab (i: Integer): Integer;

        Begin
        Swab := LOR (Shift (i, -8), Shift (i, 8));
        End;

Handler E10ReceiveDone (stat: pEtherStatus);

        Var     PacketOK: Boolean;

        Handler E10DByteError;

                Begin
                writeln ('Bad number of bits in received packet.');
                PacketOK := False;
                End;

        Type    CharArray = Packed Array [0 .. 1498] of Char;
                pCharArray = ^CharArray;

        Label   1, 2;

        Var     Bytes: Integer;
                sbuf: pStr;
                ans: Boolean;
                i: Integer;
                phooey: pCharArray;

        Begin
        writeln;
        if stat <> RecStat then
            begin
            writeln ('Received packet status not RecStat.');
            printptr (stat, 'stat');
            Goto 2;
            end;
        PacketOK := True;
        Bytes := E10DataBytes (stat^ . BitsRecv);
        with RecHead^ do
            begin
            if EquAddress (Dest, BroadcastAddress) then
                begin
                printaddr (Src, 'Received broadcast packet from ');
                Goto 1;
                PacketOK := False;
                end;
            if not EquAddress (Dest, MyAddress) then
                begin
                printaddr (Dest, 'Received packet to ');
                printaddr (Src, 'It is from ');
                Goto 1;
                PacketOK := False;
                end;
            if not EquAddress (Src, HisAddress) then
                begin
                printaddr (Src, 'Received packet from ');
                PacketOK := False;
                end;
            end;
        Case RecHead^ . EType of
            Data: begin
                sbuf := ReCast (RecBuf, pStr);
                printptr (sbuf, 'sbuf in receive');
                writeln ('Received data:');
                writeln (sbuf^);
                if PacketOK
                    then AckHead^ . EType := Ack
                    else AckHead^ . EType := NAck;
                SendNoAck (AckHead, AckBuf, AckStat, MinDataBytes)
                end;
            Ack: begin
                ELS_Receive (RecHead^ . Src, 1, True);
                end;
            NAck: begin
                ELS_Receive (RecHead^ . Src, 1, False);
                end;
            Otherwise: begin
                writeln ('Received packet with unknown type ',
                                RecHead^ . EType :1);
                end;
            end;
        if not PacketOK then
            begin
            with RecHead^ do
                begin
                printaddr (Src, 'Src is ');
                printaddr (Dest, 'Dest is ');
                writeln ('Type is ', EType:1);
                end;
            with RecStat^ do
                begin
                writeln ('CRCError is ', CRCError);
                writeln ('Collision is ', Collision);
                writeln ('RecvTrans is ', RecvTrans);
                writeln ('Busy is ', Busy);
                writeln ('ClockOver is ', ClockOver);
                writeln ('PIP is ', PIP);
                writeln ('Carrier is ', Carrier);
                writeln ('RetryTime is ', RetryTime:1);
                writeln ('SendError is ', SendError);
                writeln ('CmdInProg is ', CmdInProg);
                writeln ('BitsRecv is ', BitsRecv:1);
                writeln ('Bytes is ', Bytes:1);
                end;
            write ('Show the contents of the buffer? (T/F) ');
            readln (ans);
            if ans then
                begin
                write ('Entire buffer (or just ', Bytes:1, ' bytes) ? (T/F) ');
                readln (ans);
                phooey := ReCast (RecBuf, pCharArray);
                if ans
                    then for i := 0 to 1498 do
                        write (ord (phooey^ [i]):3, ', ')
                    else for i := 0 to Bytes do
                        write (ord (phooey^ [i]):3, ', ');
                writeln;
                end;
            end;
1:      E10IO (Rec_Command, RecHead, RecBuf, RecStat, MaxDataBytes);
        writeln ('Set up receive.');
2:      write ('Please continue.  Send? ');
        End;

Var     sbuf: pStr;
        i, j: Integer;
        ans: Boolean;

Begin
write ('Timeout (seconds) ? ');
readln (i);
write ('# Retries ? ');
readln (j);
ELS_Init (i, j);
EB_Alloc (3, AdRec);
EB_Buffers (SendHead, SendBuf, SendStat);
EB_Buffers (AckHead, AckBuf, AckStat);
EB_Buffers (RecHead, RecBuf, RecStat);
writeln ('Buffers Allocated.');
printptr (AdRec, 'AdRec');
printptr (SendHead, 'SendHead');
printptr (SendBuf, 'SendBuf');
printptr (SendStat, 'SendStat');
printptr (AckHead, 'AckHead');
printptr (AckBuf, 'AckBuf');
printptr (AckStat, 'AckStat');
printptr (RecHead, 'RecHead');
printptr (RecBuf, 'RecBuf');
printptr (RecStat, 'RecStat');
E10Init;
MyAddress := E10GetAdr;
with MyAddress do
    begin
    High := Swab (High);
    Mid := Swab (Mid);
    end;
printaddr (MyAddress, 'My address is ');
with HisAddress do
    begin
    write ('His address:  High? ');
    readln (High);
    write ('Mid? ');
    readln (Mid);
    write ('Low? ');
    readln (Low);
    end;
printaddr (HisAddress, 'His address is ');
with AdRec^ do
    begin
    LowAddress := MyAddress . Low;
    MCB := MltCstNone;
    end;
E10Reset (AdRec);
writeln ('Reset Ethernet.');
write ('Promiscuous receives (T/F) ? ');
readln (ans);
if ans
    then Rec_Command := EPromiscuousReceive
    else Rec_Command := EReceive;
E10IO (Rec_Command, RecHead, RecBuf, RecStat, MaxDataBytes);
writeln ('Set up receive.');
writeln;
sbuf := ReCast (SendBuf, pStr);
printptr (sbuf, 'sbuf in main');
with SendHead^ do
    begin
    Src := MyAddress;
    Dest := HisAddress;
    EType := Data;
    end;
with AckHead^ do
    begin
    Src := MyAddress;
    Dest := HisAddress;
    end;
repeat
    write ('Send? ');
    readln (sbuf^);
    if sbuf^ <> 'quit' then
        begin
        case SendWAck (SendHead, SendBuf, SendStat, MaxDataBytes, 1) of
            SWA_Received: writeln ('Message received.');
            SWA_Timeout:  writeln ('Timed out--not received.');
            SWA_Error:    writeln ('Send-within-send.');
            Otherwise:    writeln ('Illegal return value from SendWAck');
            end;
        end;
    until sbuf^ = 'quit';
E10Reset (AdRec);
End.

