program ls4;
{**************************************}
{ Author: Peter H. Feiler CRT Siemens Corp.   (first steps)
{ Abstract:
{       ls4 filename/fpag,lpag
{           fpag => first wanted page
{           lpag => last wanted page
{ 
{       List a file over the rs232 and multiplexer to a line printer device.
{
{ Quirks:
{       the connection number for the printer is known in the program.
{
{ log.:
{
{ 18 Feb 82  (sjc) Added menu of .pas files if no file specified 
{
{ 31-jan-82  (sv)  expanded li4 to ls4 (with: filename,page # and date)
{
{ 29-jan-82  (sv)  the amount of wanted pages can be specified
{ 
{ 26-jan-82  (sv)  Now it should know  <FF>'s  in the file . 
{                  If the printer is busy, it retries  for about 20 sec's . 
{
{ 22-jan-82  (sv)  running version, that doesn't miss characters
{
**************************************}
const m = false;  {if true then include menu stuff}

Imports io from io;
Imports ioerrors from ioerrors;
Imports CmdParse from CmdParse;
imports rs232baud from rs232baud;
Imports system from system;
Imports clock from clock;
imports FileSystem from FileSystem;
imports perq_string from Perq_string;

{$ifc m then}
imports Menu from Menu;
imports MyFileStuff from MyFileStuff;
{$endc}

const debug = true;   

const
    chCR = chr(13);
    chLF = chr(10);
    chFF = chr(12);
    chBYE = chr(23);
    chXON = chr(17);
    chON = chr(145);
    chXOFF = chr(19);
    chOFF = chr(147);

var     timstring:string;
        time:timestamp;
        fp,lp:string;
        infile:text;
        filename:string;
        textbuffer:string;
        cstr:string;
        c1,c2,c3:char;
        stat: DevStatusBlock;
        k,iold:integer;
        fpag,lpag:integer;
        param:boolean;

{$ifc m then}
Var     ThisFile, MyDirec: PtrFile;
        List: MuList;
        MyChoice, LL: Integer;
        ChoiceWindow: AWindow;
{$endc}

label 100;


function readchrs:char;
var c:char; 
begin
        while iocread(rs232in,c) <> IOEIOC do ;
        readchrs := c;
end;


procedure readmatchrs(ch:char);
var
    i:integer;
    c:char;
begin
    while true do
    begin
          if readchrs = ch then exit(readmatchrs);
    end;  
end;


procedure writechrs(c:char);
var
    ic:char;                
    i: integer;
begin   
        for i:=1 to 10 do
        begin
        if iocread (rs232in,ic) = IOEIOC then
                if ic = chOFF then
                  readmatchrs(chON);
                if ic = chXOFF then
                  readmatchrs(chXON);                
        end;
        if iocwrite(rs232out,c) <> IOEIOC then
                        writeln('** RSOut error **'); 
end;
 
       
procedure writers(str:string);
var
    i:integer;
begin
        for i := 1 to length(str) do
                writechrs(str[i]);
end;


procedure writelnrs(str:string);
begin
        writers(str);
        writechrs(chCR);
end;


procedure eatcharsrs;
var c:char;
begin
        while iocread(rs232in,c) <> IOEIOB do ;
end;


procedure munchrs(n:integer);
var 
    i:integer;
    c : char;
begin
        for i := 1 to n do
            c := readchrs;
end;


procedure readlnrs;
var
    i:integer;
    c:char;
begin
    while true do
    begin
        if readchrs= chLF then exit(readlnrs);
    end;  
end;  


procedure i2asc(var inr:integer;var istr:string);
var  ich:char;
     i,ih:integer;
begin
i:=inr;
istr:='';
if (inr > 9999) then
  begin 
  writeln ('Error in i2asc');
  exit (i2asc);
  end;
if (inr>999)then
  begin 
  ih:=i div 1000;
  ich:=chr(ih+48);
  appendchar(istr,ich);
  i:= i - (ih * 1000);
  end; 
if (inr>99)then
  begin 
  ih:=i div 100;
  ich:=chr(ih+48);
  appendchar(istr,ich);
  i:= i - (ih * 100);
  end ;
if (inr>9)then
  begin 
  ih:=i div 10;
  ich:=chr(ih+48);
  appendchar(istr,ich);
  i:= i - (ih * 10);
  end;
  ich:=chr(i+48);
  appendchar(istr,ich);
  end;
   

procedure delay(i:integer);
var  n,m,m1:integer;
begin
for n:=1 to i do
  begin
  for m:=1 to 1000 do
  m1:=m div 4;
  end;
end;
  

procedure printfile(filename:string;fpag,lpag:integer);
var  f:text;
     str:string[255];
     pag:string;
     i,k,ipag:integer;
     print:boolean;
begin
        writeln('printing ',filename);
        reset(f,filename);
        GetTString(timstring);
        k:=1;
        ipag:=1;
        while not eof(f) do
          begin 
          if(ipag>=fpag)and(ipag<=lpag) then print:=true
          else print:=false;  
            if print and (k=1)then
              begin 
              writechrs(chFF);
              writechrs(chLF);
              writechrs(chLF);
              writers(filename);
              for i := 1 to 24 do  
                writechrs(' ');
              i2asc(ipag,pag);
              writers('Page ');
              writers(pag);
              for i := 1 to 24 do                  
                writers(' ');      
              writelnrs(timstring);
              writechrs(chLF);
              writechrs(chLF);
              writechrs(chLF);
              end;
          readln(f,str);
          for i:=1 to length(str) do
          begin
            if str[i] = chFF then
              k:=54
            else  if print then
              writechrs(str[i]);
            end;
          if  print and ( k < 54 ) then
          begin
            writechrs(chCR);
            writechrs(chLF);
          end;
          delay(1);                
          k:=k+1;
          if k > 53 then
            begin
            k:=1; 
            ipag:=ipag+1; 
            end;             
          end;
        writechrs(chFF);
        writeln('printing complete');
end;


  Procedure NextArgStr(var CmdStr, ArgStr: String);
  var Broke: string;
  begin
  RemDelims(CmdStr, ' ', Broke);
  GetSymbol(CmdStr, ArgStr, ' ', Broke);
  end;


  Function ArgCount(Str: String): integer;
  var StrLength, i, Count: integer;
      LastWasSpace: boolean;
  begin
  LastWasSpace := true;
  Count := 0;
  StrLength := Length(Str);
  for i := 1 to StrLength do
    begin
    if LastWasSpace and (Str[i] <> ' ') then
      begin
      LastWasSpace := false;
      Count := Count + 1;
      end
    else if Str[i] = ' ' then
      LastWasSpace := true;
    end;
  ArgCount := Count;
  end;  

Procedure prepcmdline(var UsrCmdLine,Cmdlin:string);
  var il:integer;
      sub:char;

  begin
    CmdLin := '';
    for il:=1 to length(UsrCmdLine) do 
      begin
      if (UsrCmdLine[il] = '/') or (UsrCmdLine[il] = ',') then
         sub:= ' '
      else  sub:=UsrCmdLine[il];
         AppendChar(Cmdlin,sub)
      end;
  end;

                          

Procedure MyParseCmds(var f:string;var fpag,lpag:integer;var param:boolean);
  var Str: string;
      Cmdlin:string;
      ArgC, dum,il: integer;
  begin
  prepcmdline(UsrCmdLine,Cmdlin);  
  ArgC := ArgCount(Cmdlin);
  fpag:=0;
  lpag:=0;
  if ArgC < 2 then
    begin
        writeln('No Filename given');
        Param := false;
    end
    else
    begin
        NextArgStr(Cmdlin, Str);        
        NextArgStr(Cmdlin, f);
        NextArgStr(Cmdlin, fp);
        NextArgStr(Cmdlin, lp);
        for il:=1 to length(fp) do
          fpag:=fpag*10+(ord(fp[il])-48);
        for il:=1 to length(fp) do
          lpag:=lpag*10+(ord(lp[il])-48);
        if(fpag=0) then fpag:=1;
        if(lpag=0) then lpag:=999;
        Param := true;
    end; 
  end;

function existfile(filename:string):boolean;
var dum1,dum2:integer;
begin
   existfile := FSlookup(filename,dum1,dum2) <> 0;
end;


{ the main program }
begin

{ Initialize RS232 connection }

with Stat
do    begin
      ByteCnt := 1;
      RSRcvEnable := true;
      end;
IOPutStatus( RS232In, Stat );
SetBaud('4800', true);
    MyParseCmds(Filename,fpag,lpag,param);

{$ifc m then}
    if not param then
        begin
        MyDirec := Directory ('.', '.pas');
        with List do
            begin
            ThisFile := MyDirec;
            LL := 0;
            while (ThisFile <> nil) and (LL < MuMaxSize - 1) do
                begin
                LL := LL + 1;
                Choices [LL] := ThisFile ^ . Name;
                ThisFile := ThisFile ^ . Next;
                end;
            if LL > 0
                then begin
                    ListLength := LL + 1;
                    Choices [ListLength] := '** NONE (ABORT) **';
                    MuInit;
                    with MenuArea, AInside do
                        begin
                        astyle := ASolid;
                        athick := 2;
                        atop := MuScreen . AInside . atop + 4;
                        aheight := MuScreen . AInside . aheight - 8;
                        awidth := 25 * 9 + 30;
                        aleft := 761 - awidth;
                        end;
                    with ChoiceWindow, AInside do
                        begin
                        aheight := 25;
                        awidth := 25 * 9 + 10;    { 25 characters }
                        astyle := ANoBorder;
                        athick := 0;
                        end;
                    MuDraw (List, ChoiceWindow, false);
                    MyChoice := Menu (List);
                    MuErase (List);
                    if MyChoice <> ListLength
                        then begin
                            filename := Choices [MyChoice];
                            fpag := 1;
                            lpag := 999;
                            param := true;
                            end
                        else param := false;
                    end
                else param := false;
            end;
        end; 
{$endc}

    if param then 
    if existfile(filename) then
    begin
        reset(infile,filename); 
        cstr := 'c 220';        { printer connection # }
        k := 1;
        eatcharsrs;
          printfile(filename,fpag,lpag);
    end
    else  writeln('*** File does not exist ***')
end.
