Module PenteIO;

Exports

Type    Inhabitant = (White, Black, Empty);
        Adversary = White .. Black;

Const   Size = 19;

Type    IOBoardType = Array [1 .. Size, 1 .. Size] of Inhabitant;
        IOMove = Record
                Row: 1 .. Size;
                Col: 1 .. Size;
                End;

Procedure BeginPenteIO;
        { Call exactly once at beginning of program }

Procedure InitBoard (Window: Boolean);
        { Normally call once at beginning of game }

Function GetPlayersMove (Player: Adversary): IOMove;
        { Does not display the move }

Procedure DispBoard (Var IOBoard: IOBoardType);
        { Update the display to be like IOBoard }

Procedure EndPenteIO;
        { Call exactly once at end of program }

Private

Imports Util from Util;

Const   Title = 
    'SIEMENS championship PENTE training program  --  Don''t mess around!!';

Var     Board: IOBoardType;
        wind, boardwind: UWindow;
        sqsize: Integer;

Procedure Square (row, col: Integer);

        Var     r: URect;

        Begin
        with r do
            begin
            UTop := boardwind . UInside . UTop + (row - 1) * sqsize;
            ULeft := boardwind . UInside . ULeft + (col - 1) * sqsize;
            UHeight := sqsize;
            UWidth := sqsize;
            end;
        r := URctExpand (r, -1);
        case Board [row, col] of
            Black: UPaint (UBlack, r);
            White: UPaint (UWhite, r);
            Empty: UPaint (UGrey, r);
            end;
        End;

Procedure BeginPenteIO;

        Begin
        UInit (UVersion);
        USaveWindow (UScrWindow);
        wind . UThick := UNewWindNum;
        End;

Procedure EndPenteIO;

        Begin
        URstorWindow (UScrWindow);
        End;

Procedure InitBoard (Window: Boolean);

        Var     i, j: Integer;

        Begin
        UPaint (UBackGnd, UScrOutside);
        with boardwind, UInside do
            begin
            ULeft := 0;
            UHeight := 768;
            UWidth := 768;
            UStyle := USolid;
            UInside := URctExpand (UInside, -7);
            end;
        if Window
            then begin
                with wind, UInside do
                    begin
                    UStyle := USysTWindow;
                    UInside := UScrInside;
                    UHeight := UHeight - 768;
                    end;
                UDrwWindow (wind);
                UTitle (Title);
                boardwind . UInside . UTop := 256;
                end
            else begin
                boardwind . UInside . UTop := 128;
                end;
        with boardwind, UInside do
            begin
            i := UWidth;
            if i mod Size < 6
                then sqsize := (i div Size) - 1
                else sqsize := i div Size;
            UThick := (i mod Size) div 2;
            UInside := URctExpand (UInside, - UThick);
            end;
        UDrwWindow (boardwind);
        for i := 1 to Size do
            begin
            for j := 1 to Size do
                begin
                Board [i, j] := Empty;
                Square (i, j);
                end;
            end;
        End;

Function GetPlayersMove (Player: Adversary): IOMove;
{ Does not display the move }

        Var     i, j: Integer;
                m: IOMove;

        Begin
        UOnCursor (boardwind . UInside);
        UOnButton;
        i := UCursor . UY;
        j := UCursor . UX;
        UOffButton;
        UOffCursor;
        writeln ('i = ', i:4, ', j = ', j:4);
        with boardwind . UInside do
            begin
            i := i - UTop;
            j := j - ULeft;
{
            writeln ('i = ', i:4, ', j = ', j:4);
}
            i := (i div sqsize) + 1;
            j := (j div sqsize) + 1;
{
            writeln ('i = ', i:4, ', j = ', j:4);
}
            end;
        if i > Size then i := Size;
        if j > Size then j := Size;
        with m do
            begin
            Row := i;
            Col := j;
            end;
        GetPlayersMove := m;
        End;

Procedure DispBoard (Var IOBoard: IOBoardType);

        Var     i, j: Integer;

        Begin
        for i := 1 to Size do
            for j := 1 to Size do
                if IOBoard [i, j] <> Board [i, j] then
                    begin
                    write ('change at (', i:1, ', ', j:1, ') to ');
                    writeln (RECAST (IOBoard [i, j], Integer):1);
                    Board [i, j] := IOBoard [i, j];
                    Square (i, j);
                    end;
        End.
