MODULE T3Sub ;
EXPORTS
IMPORTS Tempest from T3;
PROCEDURE Initialize ;
FUNCTION FasterDeltaScore (node : integer) : integer;
PROCEDURE PrintPath (path : pathtype; var outchan : text);
FUNCTION FasterLosePoints (node : integer) : integer;
procedure UpperBound ;
FUNCTION InUpperBound (sg : subgraph) : integer;
PROCEDURE InitSubGraph (stdsubgraph : SubGraph);
procedure Do_Command (commandstring : string;
                      var inchan : text;
                      prompt : string);
procedure CommandLoop (prompt : string; var inchan : text);

PRIVATE


PROCEDURE Initialize ;
VAR
    i, j, k : integer;
BEGIN

    for i := LOWLINKS to HIGHLINKS do stdsubgraph[i] := TRUE;
    for i := LOWLINKS to HIGHLINKS do assumesg[i] := TRUE;

    ValOfNode[LOWNODES+0] :=    0;  ColorOfNode[LOWNODES+0] :=    NONE;
    ValOfNode[LOWNODES+1] :=  125;  ColorOfNode[LOWNODES+1] :=  YELLOW;
    ValOfNode[LOWNODES+2] :=    0;  ColorOfNode[LOWNODES+2] :=  YELLOW;
    ValOfNode[LOWNODES+3] :=    0;  ColorOfNode[LOWNODES+3] :=   GREEN;
    ValOfNode[LOWNODES+4] :=    0;  ColorOfNode[LOWNODES+4] :=     RED;
    ValOfNode[LOWNODES+5] :=   25;  ColorOfNode[LOWNODES+5] :=     RED;
    ValOfNode[LOWNODES+6] :=   35;  ColorOfNode[LOWNODES+6] :=  PURPLE;
    ValOfNode[LOWNODES+7] :=   20;  ColorOfNode[LOWNODES+7] :=   GREEN;
    ValOfNode[LOWNODES+8] :=   15;  ColorOfNode[LOWNODES+8] :=  YELLOW;
    ValOfNode[LOWNODES+9] :=   10;  ColorOfNode[LOWNODES+9] :=  YELLOW;
    ValOfNode[LOWNODES+10] :=   0;  ColorOfNode[LOWNODES+10] := YELLOW;
    ValOfNode[LOWNODES+11] :=  50;  ColorOfNode[LOWNODES+11] := YELLOW;
    ValOfNode[LOWNODES+12] :=  25;  ColorOfNode[LOWNODES+12] := PURPLE;
    ValOfNode[LOWNODES+13] :=   0;  ColorOfNode[LOWNODES+13] :=    RED;
    ValOfNode[LOWNODES+14] :=  10;  ColorOfNode[LOWNODES+14] :=    RED;
    ValOfNode[LOWNODES+15] :=  15;  ColorOfNode[LOWNODES+15] :=  GREEN;
    ValOfNode[LOWNODES+16] :=   0;  ColorOfNode[LOWNODES+16] :=  GREEN;
    ValOfNode[LOWNODES+17] :=  40;  ColorOfNode[LOWNODES+17] := YELLOW;
    ValOfNode[LOWNODES+18] :=   0;  ColorOfNode[LOWNODES+18] :=   NONE;
    ValOfNode[LOWNODES+19] :=  20;  ColorOfNode[LOWNODES+19] := PURPLE;
    ValOfNode[LOWNODES+20] :=   5;  ColorOfNode[LOWNODES+20] := PURPLE;
    ValOfNode[LOWNODES+21] :=  60;  ColorOfNode[LOWNODES+21] :=    RED;
    ValOfNode[LOWNODES+22] :=  30;  ColorOfNode[LOWNODES+22] :=  GREEN;
    ValOfNode[LOWNODES+23] :=   0;  ColorOfNode[LOWNODES+23] :=   NONE;
    ValOfNode[LOWNODES+24] :=  30;  ColorOfNode[LOWNODES+24] := YELLOW;
    ValOfNode[LOWNODES+25] := 300;  ColorOfNode[LOWNODES+25] := PURPLE;
    ValOfNode[LOWNODES+26] :=  15;  ColorOfNode[LOWNODES+26] := PURPLE;
    ValOfNode[LOWNODES+27] :=  25;  ColorOfNode[LOWNODES+27] :=  GREEN;
    ValOfNode[LOWNODES+28] :=   0;  ColorOfNode[LOWNODES+28] :=    RED;
    ValOfNode[LOWNODES+29] :=  70;  ColorOfNode[LOWNODES+29] :=  GREEN;
    ValOfNode[LOWNODES+30] :=  35;  ColorOfNode[LOWNODES+30] :=    RED;
    ValOfNode[LOWNODES+31] :=   0;  ColorOfNode[LOWNODES+31] := YELLOW;
    ValOfNode[LOWNODES+32] :=   5;  ColorOfNode[LOWNODES+32] := PURPLE;
    ValOfNode[LOWNODES+33] :=  40;  ColorOfNode[LOWNODES+33] := PURPLE;
    ValOfNode[LOWNODES+34] :=  65;  ColorOfNode[LOWNODES+34] := YELLOW;
    ValOfNode[LOWNODES+35] :=   0;  ColorOfNode[LOWNODES+35] :=   NONE;
    ValOfNode[LOWNODES+36] :=  30;  ColorOfNode[LOWNODES+36] :=  GREEN;
    ValOfNode[LOWNODES+37] :=   0;  ColorOfNode[LOWNODES+37] :=   NONE;
    ValOfNode[LOWNODES+38] :=  80;  ColorOfNode[LOWNODES+38] :=    RED;
    ValOfNode[LOWNODES+39] :=  40;  ColorOfNode[LOWNODES+39] :=  GREEN;
    ValOfNode[LOWNODES+40] :=   0;  ColorOfNode[LOWNODES+40] :=   NONE;

    for i := 0 to 7 do BEGIN
        numlightson[i] := 0;
        if (LAnd (i, YELLOW) > 0) then numlightson[i] := numlightson[i] + 1;
        if (LAnd (i,  GREEN) > 0) then numlightson[i] := numlightson[i] + 1;
        if (LAnd (i,    RED) > 0) then numlightson[i] := numlightson[i] + 1;
    END;

    HasFlag[LOWLINKS+0] :=  0;
    HasFlag[LOWLINKS+1] :=  0;
    HasFlag[LOWLINKS+2] :=  0;
    HasFlag[LOWLINKS+3] :=  0;
    HasFlag[LOWLINKS+4] :=  0;
    HasFlag[LOWLINKS+5] :=  0;
    HasFlag[LOWLINKS+6] :=  0;
    HasFlag[LOWLINKS+7] :=  0;
    HasFlag[LOWLINKS+8] :=  0;
    HasFlag[LOWLINKS+9] :=  0;
    HasFlag[LOWLINKS+10] := 0;
    HasFlag[LOWLINKS+11] := 1;
    HasFlag[LOWLINKS+12] := 0;
    HasFlag[LOWLINKS+13] := 1;
    HasFlag[LOWLINKS+14] := 0;
    HasFlag[LOWLINKS+15] := 1;
    HasFlag[LOWLINKS+16] := 0;
    HasFlag[LOWLINKS+17] := 0;
    HasFlag[LOWLINKS+18] := 0;
    HasFlag[LOWLINKS+19] := 0;
    HasFlag[LOWLINKS+20] := 0;
    HasFlag[LOWLINKS+21] := 0;
    HasFlag[LOWLINKS+22] := 1;
    HasFlag[LOWLINKS+23] := 0;
    HasFlag[LOWLINKS+24] := 1;
    HasFlag[LOWLINKS+25] := 1;
    HasFlag[LOWLINKS+26] := 1;
    HasFlag[LOWLINKS+27] := 0;
    HasFlag[LOWLINKS+28] := 1;
    HasFlag[LOWLINKS+29] := 0;
    HasFlag[LOWLINKS+30] := 0;
    HasFlag[LOWLINKS+31] := 1;
    HasFlag[LOWLINKS+32] := 1;
    HasFlag[LOWLINKS+33] := 0;
    HasFlag[LOWLINKS+34] := 0;
    HasFlag[LOWLINKS+35] := 1;
    HasFlag[LOWLINKS+36] := 0;
    HasFlag[LOWLINKS+37] := 0;
    HasFlag[LOWLINKS+38] := 0;
    HasFlag[LOWLINKS+39] := 0;
    HasFlag[LOWLINKS+40] := 1;
    HasFlag[LOWLINKS+41] := 0;
    HasFlag[LOWLINKS+42] := 0;
    HasFlag[LOWLINKS+43] := 0;
    HasFlag[LOWLINKS+44] := 0;
    HasFlag[LOWLINKS+45] := 0;
    HasFlag[LOWLINKS+46] := 0;
    HasFlag[LOWLINKS+47] := 0;
    HasFlag[LOWLINKS+48] := 0;
    HasFlag[LOWLINKS+49] := 1;
    HasFlag[LOWLINKS+50] := 0;
    HasFlag[LOWLINKS+51] := 1;
    HasFlag[LOWLINKS+52] := 0;
    HasFlag[LOWLINKS+53] := 0;
    HasFlag[LOWLINKS+54] := 0;
    HasFlag[LOWLINKS+55] := 1;
    HasFlag[LOWLINKS+56] := 1;
    HasFlag[LOWLINKS+57] := 0;
    HasFlag[LOWLINKS+58] := 0;
    HasFlag[LOWLINKS+59] := 0;
    HasFlag[LOWLINKS+60] := 0;
    HasFlag[LOWLINKS+61] := 1;
    HasFlag[LOWLINKS+62] := 0;
    HasFlag[LOWLINKS+63] := 1;
    HasFlag[LOWLINKS+64] := 0;
    HasFlag[LOWLINKS+65] := 1;
    HasFlag[LOWLINKS+66] := 1;
    HasFlag[LOWLINKS+67] := 1;
    HasFlag[LOWLINKS+68] := 0;
    HasFlag[LOWLINKS+69] := 0;
    HasFlag[LOWLINKS+70] := 0;
    HasFlag[LOWLINKS+71] := 0;
    HasFlag[LOWLINKS+72] := 0;
    HasFlag[LOWLINKS+73] := 0;
    HasFlag[LOWLINKS+74] := 0;

    SmallEnd[LOWLINKS+0] :=  39;  BigEnd[LOWLINKS+0] :=  40;
    SmallEnd[LOWLINKS+1] :=   0;  BigEnd[LOWLINKS+1] :=   1;
    SmallEnd[LOWLINKS+2] :=   0;  BigEnd[LOWLINKS+2] :=   2;
    SmallEnd[LOWLINKS+3] :=   0;  BigEnd[LOWLINKS+3] :=   3;
    SmallEnd[LOWLINKS+4] :=   0;  BigEnd[LOWLINKS+4] :=   4;
    SmallEnd[LOWLINKS+5] :=   1;  BigEnd[LOWLINKS+5] :=   5;
    SmallEnd[LOWLINKS+6] :=   2;  BigEnd[LOWLINKS+6] :=   5;
    SmallEnd[LOWLINKS+7] :=   3;  BigEnd[LOWLINKS+7] :=   6;
    SmallEnd[LOWLINKS+8] :=   3;  BigEnd[LOWLINKS+8] :=   7;
    SmallEnd[LOWLINKS+9] :=   4;  BigEnd[LOWLINKS+9] :=   8;
    SmallEnd[LOWLINKS+10] :=  5;  BigEnd[LOWLINKS+10] :=  6;
    SmallEnd[LOWLINKS+11] :=  6;  BigEnd[LOWLINKS+11] :=  7;
    SmallEnd[LOWLINKS+12] :=  7;  BigEnd[LOWLINKS+12] :=  8;
    SmallEnd[LOWLINKS+13] :=  5;  BigEnd[LOWLINKS+13] :=  9;
    SmallEnd[LOWLINKS+14] :=  5;  BigEnd[LOWLINKS+14] := 10;
    SmallEnd[LOWLINKS+15] := 10;  BigEnd[LOWLINKS+15] := 11;
    SmallEnd[LOWLINKS+16] :=  6;  BigEnd[LOWLINKS+16] := 11;
    SmallEnd[LOWLINKS+17] :=  7;  BigEnd[LOWLINKS+17] := 12;
    SmallEnd[LOWLINKS+18] :=  8;  BigEnd[LOWLINKS+18] := 13;
    SmallEnd[LOWLINKS+19] :=  8;  BigEnd[LOWLINKS+19] := 14;
    SmallEnd[LOWLINKS+20] :=  9;  BigEnd[LOWLINKS+20] := 18;
    SmallEnd[LOWLINKS+21] :=  9;  BigEnd[LOWLINKS+21] := 15;
    SmallEnd[LOWLINKS+22] := 10;  BigEnd[LOWLINKS+22] := 15;
    SmallEnd[LOWLINKS+23] := 11;  BigEnd[LOWLINKS+23] := 16;
    SmallEnd[LOWLINKS+24] := 12;  BigEnd[LOWLINKS+24] := 16;
    SmallEnd[LOWLINKS+25] := 12;  BigEnd[LOWLINKS+25] := 13;
    SmallEnd[LOWLINKS+26] := 13;  BigEnd[LOWLINKS+26] := 17;
    SmallEnd[LOWLINKS+27] := 14;  BigEnd[LOWLINKS+27] := 17;
    SmallEnd[LOWLINKS+28] := 14;  BigEnd[LOWLINKS+28] := 23;
    SmallEnd[LOWLINKS+29] := 15;  BigEnd[LOWLINKS+29] := 18;
    SmallEnd[LOWLINKS+30] := 15;  BigEnd[LOWLINKS+30] := 19;
    SmallEnd[LOWLINKS+31] := 16;  BigEnd[LOWLINKS+31] := 20;
    SmallEnd[LOWLINKS+32] := 16;  BigEnd[LOWLINKS+32] := 21;
    SmallEnd[LOWLINKS+33] := 17;  BigEnd[LOWLINKS+33] := 22;
    SmallEnd[LOWLINKS+34] := 17;  BigEnd[LOWLINKS+34] := 23;
    SmallEnd[LOWLINKS+35] := 18;  BigEnd[LOWLINKS+35] := 19;
    SmallEnd[LOWLINKS+36] := 19;  BigEnd[LOWLINKS+36] := 24;
    SmallEnd[LOWLINKS+37] := 20;  BigEnd[LOWLINKS+37] := 24;
    SmallEnd[LOWLINKS+38] := 20;  BigEnd[LOWLINKS+38] := 21;
    SmallEnd[LOWLINKS+39] := 21;  BigEnd[LOWLINKS+39] := 26;
    SmallEnd[LOWLINKS+40] := 22;  BigEnd[LOWLINKS+40] := 26;
    SmallEnd[LOWLINKS+41] := 22;  BigEnd[LOWLINKS+41] := 23;
    SmallEnd[LOWLINKS+42] := 18;  BigEnd[LOWLINKS+42] := 24;
    SmallEnd[LOWLINKS+43] := 24;  BigEnd[LOWLINKS+43] := 28;
    SmallEnd[LOWLINKS+44] := 24;  BigEnd[LOWLINKS+44] := 35;
    SmallEnd[LOWLINKS+45] := 24;  BigEnd[LOWLINKS+45] := 29;
    SmallEnd[LOWLINKS+46] := 24;  BigEnd[LOWLINKS+46] := 25;
    SmallEnd[LOWLINKS+47] := 25;  BigEnd[LOWLINKS+47] := 26;
    SmallEnd[LOWLINKS+48] := 26;  BigEnd[LOWLINKS+48] := 30;
    SmallEnd[LOWLINKS+49] := 26;  BigEnd[LOWLINKS+49] := 37;
    SmallEnd[LOWLINKS+50] := 26;  BigEnd[LOWLINKS+50] := 31;
    SmallEnd[LOWLINKS+51] := 23;  BigEnd[LOWLINKS+51] := 26;
    SmallEnd[LOWLINKS+52] := 23;  BigEnd[LOWLINKS+52] := 31;
    SmallEnd[LOWLINKS+53] := 18;  BigEnd[LOWLINKS+53] := 28;
    SmallEnd[LOWLINKS+54] := 27;  BigEnd[LOWLINKS+54] := 33;
    SmallEnd[LOWLINKS+55] := 27;  BigEnd[LOWLINKS+55] := 28;
    SmallEnd[LOWLINKS+56] := 28;  BigEnd[LOWLINKS+56] := 33;
    SmallEnd[LOWLINKS+57] := 33;  BigEnd[LOWLINKS+57] := 34;
    SmallEnd[LOWLINKS+58] := 28;  BigEnd[LOWLINKS+58] := 34;
    SmallEnd[LOWLINKS+59] := 28;  BigEnd[LOWLINKS+59] := 35;
    SmallEnd[LOWLINKS+60] := 29;  BigEnd[LOWLINKS+60] := 35;
    SmallEnd[LOWLINKS+61] := 25;  BigEnd[LOWLINKS+61] := 36;
    SmallEnd[LOWLINKS+62] := 30;  BigEnd[LOWLINKS+62] := 37;
    SmallEnd[LOWLINKS+63] := 31;  BigEnd[LOWLINKS+63] := 37;
    SmallEnd[LOWLINKS+64] := 31;  BigEnd[LOWLINKS+64] := 38;
    SmallEnd[LOWLINKS+65] := 31;  BigEnd[LOWLINKS+65] := 39;
    SmallEnd[LOWLINKS+66] := 31;  BigEnd[LOWLINKS+66] := 32;
    SmallEnd[LOWLINKS+67] := 32;  BigEnd[LOWLINKS+67] := 39;
    SmallEnd[LOWLINKS+68] := 38;  BigEnd[LOWLINKS+68] := 39;
    SmallEnd[LOWLINKS+69] := 33;  BigEnd[LOWLINKS+69] := 40;
    SmallEnd[LOWLINKS+70] := 35;  BigEnd[LOWLINKS+70] := 36;
    SmallEnd[LOWLINKS+71] := 36;  BigEnd[LOWLINKS+71] := 40;
    SmallEnd[LOWLINKS+72] := 36;  BigEnd[LOWLINKS+72] := 37;
    SmallEnd[LOWLINKS+73] := 20;  BigEnd[LOWLINKS+73] := 25;
    SmallEnd[LOWLINKS+74] := 21;  BigEnd[LOWLINKS+74] := 25;
    

    for i := LOWNODES to HIGHNODES do nlinksfrom[i] := 0;
    for i := LOWNODES to HIGHNODES do BEGIN
        for j := LOWLINKS to HIGHLINKS do BEGIN
            if ((smallend[j] = i) or (bigend[j] = i)) then BEGIN
                nlinksfrom[i] := nlinksfrom[i] + 1;
                linksfrom[i, nlinksfrom[i]] := j;
                if (smallend[j] = i) then
                    tonode[i, nlinksfrom[i]] := bigend[j]
                else tonode[i, nlinksfrom[i]] := smallend[j];
            END;
        END;
    END;

    for i := LOWNODES to HIGHNODES do BEGIN
        maxvisits[i] := SHIFT (nlinksfrom[i], -1);
    END;

    for i := LOWNODES to HIGHNODES do for j := LOWNODES to HIGHNODES do BEGIN
        GetThereFromHere[i, j] := BOGUSLINK;
        for k := LOWLINKS to HIGHLINKS do BEGIN
            if ((smallend[k] = i) and (bigend[k] = j)) then
                GetThereFromHere[i, j] := k;
            if ((smallend[k] = j) and (bigend[k] = i)) then
                GetThereFromHere[i, j] := k;
        END;
    END;

    for i := LOWNODES to HIGHNODES do Lon[i] := NONE;
    Lon[2] :=  YELLOW;
    Lon[3] :=   GREEN;
    Lon[4] :=     RED;
    Lon[28] :=    RED;
    Lon[31] := YELLOW;

    for i := LOWNODES to HIGHNODES do Loff[i] := YELLOW+GREEN+RED+PURPLE;
    Loff[10] :=    GREEN+RED+PURPLE;
    Loff[13] := YELLOW+GREEN+PURPLE;
    Loff[16] :=   YELLOW+RED+PURPLE;
END;


FUNCTION FasterDeltaScore (node : integer) : integer;
BEGIN
    if ((node = 18) or (node = 23)) then BEGIN
        FasterDeltaScore := 10 * globnumflags[curdepth];
        Exit (FasterDeltaScore);
    END;
    
    if (node = 35) then BEGIN
        FasterDeltaScore := 25 * numlightson[globlightson[curdepth]];
        Exit (FasterDeltaScore);
    END;

    if (node = 37) then BEGIN
        FasterDeltaScore := 50 * numlightson[globlightson[curdepth]];
        Exit (FasterDeltaScore);
    END;
    
    if (LAND (globlightson[curdepth], colorofnode[node]) <> 0) then 
        FasterDeltaScore := SHIFT (valofnode[node], 1)
    else FasterDeltaScore := valofnode[node];
END;

PROCEDURE InitState (state : statetype; startnode : integer);
BEGIN
END;

PROCEDURE PrintPath (path : pathtype; var outchan : text);
VAR
    i, link : integer;
    state : statetype;
BEGIN
    if (path.numinpath <= 0) then BEGIN
        writeln (outchan, 'NULL PATH');
        Exit (PrintPath);
    END;
    if (path.numinpath > NUMLINKS+1) then BEGIN
        writeln (outchan, 'PATH TOO LONG');
        Exit (PrintPath);
    END;

    InitState (state, path.path[1]);
    with path do for i := 2 to numinpath do BEGIN
        link := GetThereFromHere[path[i-1], path[i]];
        if (link = BOGUSLINK) then BEGIN
            writeln (outchan,'Node ', path[i]:2, '  bogus link -- hyperspace');
            state.curnode := path[i];
        END
        else if (NOT IsLegalNextMove (state, path[i])) then BEGIN
            writeln (outchan, 'Node ', path[i]:2, '  Twice used link');
            AddNodeToState (state, path[i]);
            state.score := state.score + DeltaScore (state, path[i]);
        END
        else BEGIN
            AddNodeToState (state, path[i]);
            state.score := state.score + DeltaScore (state, path[i]);
            if (HasFlag[link] > 0) then
                writeln (outchan, 'Flag    (#', state.numflags:1, ')');
            write (outchan, 'Node ', path[i]:2, ' ');
            write (outchan, '     ', DeltaScore (state, path[i]):3);
            write (outchan, '  ');
            if (LAnd (state.lightson, YELLOW) > 0) then write (outchan, 'Y')
            else write (outchan, ' ');
            if (LAnd (state.lightson, GREEN) > 0) then write (outchan, 'G')
            else write (outchan, ' ');
            if (LAnd (state.lightson, RED) > 0) then write (outchan, 'R')
            else write (outchan, ' ');
            writeln (outchan);
        END;
    END;
    writeln (outchan, 'Total Score ', state.score:4);
END;
    




FUNCTION FasterLosePoints (node : integer) : integer;
BEGIN
    FasterLosePoints := 0;
    if (LAnd (colorofnode[node], YELLOW+GREEN+RED) > 0) then 
        if (LAND (globlightson[curdepth], colorofnode[node]) = 0) then
            FasterLosePoints := ValOfNode[node];
    if ((node = 18) or (node = 23)) then
{        FasterLosePoints := (4-numbumpers) * (21 - globnumflags[curdepth]);}
        FasterLosePoints := 10 * (sgmaxflags - globnumflags[curdepth]);
    if (node = 35) then
        FasterLosePoints := (3-numlightson[globlightson[curdepth]])*25;
    if (node = 37) then
        FasterLosePoints := (3-numlightson[globlightson[curdepth]])*50;
END;

procedure UpperBound ;
VAR
    totYellow, totGreen, totRed, totPurple : integer;
    i, subtotal, grandtotal, weight :integer;
    flagweight, b25weight, b50weight : integer;
    flags : integer;
BEGIN
    flags := 0;
    for i := LOWLINKS to HIGHLINKS do if (hasflag[i]>0)then flags:=flags+1;
    
    totYellow := 0;
    totGreen := 0;
    totRed := 0;
    totPurple := 0;
    for i := LOWNODES to HIGHNODES do begin
        weight := nlinksfrom[i] DIV 2;
        case colorofnode[i] of
            YELLOW: totYellow := totYellow + valofnode[i] * weight;
            GREEN: totGreen := totGreen + valofnode[i] * weight;
            RED: totRed := totRed + valofnode[i] * weight;
            PURPLE: totPurple := TotPurple + valofnode[i] * weight;
            NONE: ;
            otherwise: writeln ('Bad color');
        end;
    end;
    flagweight := (nlinksfrom[18] DIV 2) + (nlinksfrom[23] DIV 2);
    b25weight := nlinksfrom[35] DIV 2;
    b50weight := nlinksfrom[37] DIV 2;
    
    writeln ('Numflags is ', flags:2);
    writeln ('tots: YGRP: ', totyellow:5, totgreen:5, totred:5, totpurple:5);
    SubTotal := totPurple + 2*(totyellow+totgreen+totred) +
        flags*10*flagweight + 
        3 * 25 * b25weight +
        3 * 50 * b50weight;
    writeln ('Subtotal is ', subtotal:5);
    GrandTotal := Subtotal - 125 - 100;
    writeln ('GrandTotal is ', grandtotal:5);
END;

FUNCTION InUpperBound (sg : subgraph) : integer;
CONST
    VERBOSE = TRUE;
VAR
    totYellow, totGreen, totRed, totPurple : integer;
    i, subtotal, weight :integer;
    flagweight, b25weight, b50weight : integer;
    flags : integer;
BEGIN
    { it is assumed that nlinksfrom represents sg }
    
    flags := 0;
    for i := LOWLINKS to HIGHLINKS do
      if (sg[i]) then
        if (hasflag[i]>0) then
          flags:=flags+1;
    
    totYellow := 0;
    totGreen := 0;
    totRed := 0;
    totPurple := 0;
    for i := LOWNODES to HIGHNODES do begin
        weight := nlinksfrom[i] DIV 2;
        case colorofnode[i] of
            YELLOW: totYellow := totYellow + valofnode[i] * weight;
            GREEN: totGreen := totGreen + valofnode[i] * weight;
            RED: totRed := totRed + valofnode[i] * weight;
            PURPLE: totPurple := TotPurple + valofnode[i] * weight;
            NONE: ;
            otherwise: writeln ('Bad color');
        end;
    end;
    flagweight := (nlinksfrom[18] DIV 2) + (nlinksfrom[23] DIV 2);
    b25weight := nlinksfrom[35] DIV 2;
    b50weight := nlinksfrom[37] DIV 2;
    
    SubTotal := totPurple + 2*(totyellow+totgreen+totred) +
        flags*10*flagweight + 
        3 * 25 * b25weight +
        3 * 50 * b50weight;
    InUpperBound := SubTotal;

    {$IFC VERBOSE THEN}
        writeln ('UPPER BOUND');
        writeln ('TotYellow ', totYellow:1);
        writeln ('TotGreen  ', totGreen:1);
        writeln ('TotRed    ', totRed:1);
        writeln ('TotPurple ', totPurple:1);
        writeln ('Flags     ', flags:1);
        writeln ('FlagWeight  ', flagweight:1);
        writeln ('B25Weight   ', b25weight:1);
        writeln ('B50Weight   ', b50weight:1);
        writeln ('Total     ', SubTotal:1);
    {$ENDC}

END;




PROCEDURE InitSubGraph (stdsubgraph : SubGraph);
CONST
    VERBOSE = TRUE;
VAR
    i, j, k : integer;
BEGIN
    for i := LOWNODES to HIGHNODES do nlinksfrom[i] := 0;
    for i := LOWNODES to HIGHNODES do BEGIN
        for j := LOWLINKS to HIGHLINKS do if (stdsubgraph[j]) then BEGIN
            if ((smallend[j] = i) or (bigend[j] = i)) then BEGIN
                nlinksfrom[i] := nlinksfrom[i] + 1;
                linksfrom[i, nlinksfrom[i]] := j;
                if (smallend[j] = i) then
                    tonode[i, nlinksfrom[i]] := bigend[j]
                else tonode[i, nlinksfrom[i]] := smallend[j];
            END;
        END;
    END;

    for i := LOWNODES to HIGHNODES do BEGIN
        maxvisits[i] := SHIFT (nlinksfrom[i], -1);
    END;

    for i := LOWNODES to HIGHNODES do for j := LOWNODES to HIGHNODES do BEGIN
        GetThereFromHere[i, j] := BOGUSLINK;
    END;
    for k := LOWLINKS to HIGHLINKS do if (stdsubgraph[k]) then BEGIN
        GetThereFromHere[smallend[k], bigend[k]] := k;
        GetThereFromHere[bigend[k], smallend[k]] := k;
    END;
    
    sgmaxflags := 0;
    for i := LOWLINKS to HIGHLINKS do if (stdsubgraph[i]) then
        if (hasflag[i] > 0) then sgmaxflags := sgmaxflags + 1;
    {$IFC VERBOSE THEN}
        writeln ('InitSubGraph, sgmaxflags is ', sgmaxflags:1);
    {$ENDC}
END;


procedure Do_Command (commandstring : string;
                      var inchan : text;
                      prompt : string);
VAR
    i, num, link : integer;
    a, b, c : integer;
    longnum, longi : long;
    thisscore, bestscore : integer;
    ch : char;
    outchan, inchan2 : text;
    instr, outstr : string;
    count : integer;
begin
    if (length (commandstring) <> 0) then ch := commandstring[1]
    else ch := 'h';

    case ch of 
        'c':
            BEGIN
                Writeln ('Bound is ', InUpperBound (stdsubgraph):1);
            END;

        'f':
            BEGIN
                writeln ('Enter the name of the output file');
                readln (inchan, outstr);
                rewrite (outchan, outstr);
                If (NOT IsLegalPath (mainpath)) then BEGIN
                    writeln (outchan, 'Warning, path is not legal');
                    writeln (outchan);
                END;
                PrintPath (mainpath, outchan);
                close (outchan);
            END;

        'g':
            BEGIN
                writeln ('set up default turned-off links');
                writeln ('These links encompass the begin-end assumptions');
                for i := LOWLINKS to HIGHLINKS do if (not assumesg[i]) then
                    write (i:1, ' ');
                writeln ;
                writeln ('Enter a sequence of links to turn off');
                writeln ('End with a blank line');

                for i := HIGHLINKS downto LOWLINKS do 
                    stdsubgraph[i] := assumesg[i];
                { zap standard links }
{                stdsubgraph[2] := FALSE;
                stdsubgraph[3] := FALSE;
                stdsubgraph[4] := FALSE;
                stdsubgraph[6] := FALSE;
                stdsubgraph[9] := FALSE;
                stdsubgraph[56] := FALSE;
                stdsubgraph[69] := FALSE;
                stdsubgraph[71] := FALSE;}
                while (not eoln (inchan)) do begin
                    read (inchan, i);
                    if ((i>=LOWLINKS) and (i<=HIGHLINKS)) then
                        stdsubgraph[i] := FALSE;
                end;
                InitSubGraph (stdsubgraph);
                for i := LOWNODES to HIGHNODES do
                  if ((i <> STARTNODE) and (i <> FINISHNODE)) then
                    if ((nlinksfrom[i] MOD 2) = 1) then
                      writeln ('Warning, Odd Node ', i:1);
               if (nlinksfrom[STARTNODE] <> 1) then 
                   writeln ('Nlinksfrom STARTNODE <> 1');
               if (nlinksfrom[FINISHNODE] <> 1) then 
                   writeln ('Nlinksfrom FINISHNODE <> 1');
            END;

        'h': writeln ('No Help Yet');

        'p':
            BEGIN
                If (NOT IsLegalPath (mainpath)) then BEGIN
                    writeln ('Warning, path is not legal');
                    writeln ;
                END;
                PrintPath (mainpath, output);
            END;

        'q':
            BEGIN
                Writeln ('Quitting...');
                Exit (Tempest);
            END;

        'r':
            BEGIN
                writeln ('How many tries of a random path?, and scrambles');
                readln (inchan, longnum, i, num);
                RScramble (i, num);
                bestscore := 0;
                count := 0;
                longi := 0;
                while (longi < longnum) do BEGIN
                    longi := longi + 1;
                    count := count + 1;
                    if ((count mod 10000) = 0) then BEGIN
                         write ('.');
                         count := 0;
                    END;
                    thisscore := RandomSearch (MainPath);
                    if (thisscore > BestScore-0) then
                        write (thisscore:1, ' ');
                    if (thisscore > bestscore) then BEGIN
                        writeln ('NEWBEST ', thisscore:1, ' ');
                        bestscore := thisscore;
                        PrintPath (mainpath, output);
                        rewrite (outchan, 'random.best');
                        PrintPath (mainpath, outchan);
                        close (outchan);
                    END;
                END;
            END;

        '*':
            BEGIN
                writeln ('Setting up the begin-end assumptions');
                writeln ('enter a number 1 to 4 for the beginning');
                readln (a);
                if ((a < 1) or (a > 4)) then begin
                    writeln ('BOGUS, set to 1');
                    a := 1;
                end;
                writeln ('Enter a number 69, 71, or 0 for the ending');
                readln (b);
                if ((b <> 69) and (b <> 71) and (b <> 0)) then begin
                    writeln ('BOGUS, set to 0');
                    b := 0;
                end;
                for i := LOWLINKS to HIGHLINKS do assumesg[i] := TRUE;
                case a of
                    1:
                        BEGIN
                            assumesg[2] := FALSE; assumesg[6] := FALSE;
                            assumesg[3] := FALSE;
                            assumesg[4] := FALSE; assumesg[9] := FALSE;
                        END;
                    2:
                        BEGIN                    

                            assumesg[1] := FALSE; assumesg[5] := FALSE;
                            assumesg[3] := FALSE;
                            assumesg[4] := FALSE; assumesg[9] := FALSE;
                        END;
                    3:
                        BEGIN
                            assumesg[1] := FALSE; assumesg[5] := FALSE;
                            assumesg[2] := FALSE; assumesg[6] := FALSE;
                            assumesg[4] := FALSE; assumesg[9] := FALSE;
                        END;
                    4:
                        BEGIN
                            assumesg[1] := FALSE; assumesg[5] := FALSE;
                            assumesg[2] := FALSE; assumesg[6] := FALSE;
                            assumesg[3] := FALSE;
                        END;
                    otherwise: writeln ('ERROR');
                end;
                case b of
                    69:
                        BEGIN
                            assumesg[71] := FALSE;
                            assumesg[0] := FALSE;
                            assumesg[65] := FALSE;
                        END;
                    71:
                        BEGIN
                            assumesg[69] := FALSE;
                            assumesg[0] := FALSE;
                            assumesg[56] := FALSE;
                            assumesg[65] := FALSE;
                        END;
                    0:
                        BEGIN
                            assumesg[69] := FALSE;
                            assumesg[71] := FALSE;
                            assumesg[56] := FALSE;
                        END;
                    otherwise: writeln ('ERROR 2');
                end;
            END;

        '%':
            BEGIN
                writeln ('Enter the number of edges allowed ');
                readln (inchan, i);
{                EdgeSearch (i);}
                NewEdgeSearch (i);
            END;

        '!':
            BEGIN
                writeln ('Enter the threshold');
                readln (inchan, pointThreshold);
                CompleteSearch ;
            END;

        '>':
            BEGIN
                writeln ('Redirect output, ARE YOU SURE YOU WANT TO DO THIS');
                readln (inchan, outstr);
                if (length (outstr)>0) then if (outstr[1] = 'y') then begin
                    writeln ('Enter the name of the output file');
                    readln (inchan, outstr);
                    writeln ('Be sure to use a matching ''<'' command');
                    close (output);
                    rewrite (output, outstr);
                end;
            END;
        '@':
            BEGIN
                writeln ('Get Input from command file');
                writeln ('Enter the name of the command file');
                readln (inchan, instr);
                writeln ('taking commands from file ''', instr, '''.');
                reset (inchan2, instr);
                CommandLoop ('T>> ', inchan2);
                close (inchan2);
            END;
        '<':
            BEGIN
                close (output);
                exit (tempest);
            END;
        'z':
            BEGIN
                writeln ('Zapping Path');
                MainPath.numinpath := 0;
            END;

        '-':
            BEGIN
                if (mainpath.numinpath <= 0) then
                    writeln ('Null Path, not popping')
                else BEGIN
                    writeln ('Popping from Path');
                    mainpath.numinpath := mainpath.numinpath - 1;
                END;
            END;

        '0',
        '1',
        '2',
        '3',
        '4',
        '5',
        '6',
        '7',
        '8',
        '9':
            BEGIN
                num := ord (ch) - ord ('0');
                if (length (commandstring) > 1) then
                    if (('0'<=commandstring[2])and(commandstring[2]<='9'))then
                        num := num * 10 + ord (commandstring[2])-ord ('0');
                if (num > 40) then writeln ('Bad Node Number, must be 0..40')
                else if (mainpath.numinpath >= NUMLINKS+1) then
                    writeln ('Can''t Add node, Path is maximum length')
                else BEGIN
                    mainpath.numinpath := mainpath.numinpath + 1;
                    mainpath.path[mainpath.numinpath] := num;
                END;
                with mainpath do if (numinpath > 1) then begin
                    link := GetThereFromHere[path[numinpath-1],
                        path[numinpath]];
                    if (link = BOGUSLINK) then BEGIN
                        writeln ('WARNING,  bogus link -- hyperspace');
                    END
                end;
           END;
        otherwise: writeln ('Commands are: cfhpqz-!#');
    end;
end;

procedure CommandLoop (prompt : string; var inchan : text);
var
    continue : boolean;
    commandstring : string;
begin
    writeln ;
    write (prompt);
    while (not eof (inchan)) do begin
        readln (inchan, commandstring);
        if (length (commandstring) <> 0) then begin
            Do_Command (commandstring, inchan, prompt);
        end;
        writeln ;
        write (prompt);
    end;
end;


{PRIVATE}

procedure foo ;
begin
end.
{ }
