program tempest ;
{ COPYRIGHT (C) 1982 BRUCE LADENDORF }
IMPORTS CmdParse FROM CmdParse;
IMPORTS Rand FROM Rand;

IMPORTS Tick FROM Tick;

CONST
    NUMNODES = 41;
    LOWNODES = 0;
    HIGHNODES = LOWNODES + NUMNODES - 1;
    
    NUMLINKS = 75;
    LOWLINKS = 0;
    HIGHLINKS = LOWLINKS + NUMLINKS - 1;
    
    STARTNODE = 0;
    FINISHNODE = 40;

    NONE = 0;
    YELLOW = 1;
    GREEN = 2;
    RED = 4;
    PURPLE = 8;
    ALL = YELLOW + GREEN + RED + PURPLE;

    BOGUSLINK = LOWLINKS-1;

TYPE
    PathType = record
        path : array [1..NUMLINKS+1] of integer;
        numinpath : integer;
    end;
{    smallStatetype = record 
        lightson : integer;
        score : integer;
        numflags : integer;
        curnode : integer;
        lostpoints : integer;
        linkused : integer;
        nextnode : integer;
    end;}
    StateType = record
        linkfree : array [LOWLINKS..HIGHLINKS] of boolean;
        lightson : integer;
        score : integer;
        numflags : integer;
        curnode : integer;
    end;
    SubGraph = array [LOWLINKS..HIGHLINKS] of boolean;
VAR
    assumesg, stdsubgraph : subgraph;
    sgmaxflags : integer;
    ValOfNode : array [LOWNODES..HIGHNODES] of integer;
    ColorOfNode : array [LOWNODES..HIGHNODES] of integer;
    GetThereFromHere : 
        array [LOWNODES..HIGHNODES, LOWNODES..HIGHNODES] of integer;
    Lon, Loff : array [LOWNODES..HIGHNODES] of integer;
    
    numlightson : array [0..7] of integer;
    
    hasflag : array [LOWLINKS..HIGHLINKS] of integer;
    smallend, bigend : array [LOWLINKS..HIGHLINKS] of integer;

    linksfrom, tonode : array [LOWNODES..HIGHNODES, 1..8] of integer;
    nlinksfrom : array [LOWNODES..HIGHNODES] of integer;
    maxvisits : array [LOWNODES..HIGHNODES] of integer;

    MainPath : pathtype;

    { replacement variables for complete search }
    globlightson : array [1..NUMLINKS] of integer;
    globscore : array [1..NUMLINKS] of integer;
    globnumflags : array [1..NUMLINKS] of integer;
    globcurnode : array [1..NUMLINKS] of integer;
    globlinks : array [LOWLINKS..HIGHLINKS] of boolean; { sort of replacement }

    { search variables for new complete search }
    { at 2222, all arrays and variables are valid for 1..curdepth-1,
        except nexnode[curdepth] }
    curdepth : integer;
    nextnode : array [1..NUMLINKS] of integer;
    linkused : array [1..NUMLINKS] of integer;
    lostpoints : array [1..NUMLINKS] of integer;
    numvisits : array [LOWNODES..HIGHNODES] of integer;
    flagstoget : array [1..NUMLINKS] of integer;
    totlostpoints : integer;
    Numbumpers : integer;
    nodelastuse : array [LOWNODES..HIGHNODES] of integer;
    nodesbackup : array [LOWNODES..HIGHNODES, 1..4] of integer;
    nodenumbackup : array [LOWNODES..HIGHNODES] of integer;
    badnews : array [1..NUMLINKS] of integer;
    bndepth : integer;

    { misc vars for complete search }
    pointThreshold : integer;
    compath : pathtype;

CONST
    NEWMAXEDGES = 30;

VAR
    i : integer;
    badlinks : array [LOWLINKS..HIGHLINKS] of integer;
        { > 0 IFOF link is not to be used in further searching}
    oddnodes : array [LOWNODES..HIGHNODES] of boolean;
        { TRUE if node currently has odd number of links }
    curlinks : array [1..NEWMAXEDGES] of integer;
    linktried : array [1..NEWMAXEDGES] of integer;
    thelinks : array [1..NEWMAXEDGES, 1..NUMLINKS] of integer;
{    curdepth : integer;}
    numodd :integer;
    firsttime : boolean;
    foundone : boolean;
    linkis : integer;
    startlink : integer;
    numsolutions : integer;


FUNCTION InUpperBound (sg : subgraph) : integer; forward;
procedure CommandLoop (prompt : string; var inchan : text); forward;

PROCEDURE Initialize ;
VAR
    i, j, k : integer;
BEGIN

    for i := LOWLINKS to HIGHLINKS do stdsubgraph[i] := TRUE;
    for i := LOWLINKS to HIGHLINKS do assumesg[i] := TRUE;

    ValOfNode[LOWNODES+0] :=    0;  ColorOfNode[LOWNODES+0] :=    NONE;
    ValOfNode[LOWNODES+1] :=  125;  ColorOfNode[LOWNODES+1] :=  YELLOW;
    ValOfNode[LOWNODES+2] :=    0;  ColorOfNode[LOWNODES+2] :=  YELLOW;
    ValOfNode[LOWNODES+3] :=    0;  ColorOfNode[LOWNODES+3] :=   GREEN;
    ValOfNode[LOWNODES+4] :=    0;  ColorOfNode[LOWNODES+4] :=     RED;
    ValOfNode[LOWNODES+5] :=   25;  ColorOfNode[LOWNODES+5] :=     RED;
    ValOfNode[LOWNODES+6] :=   35;  ColorOfNode[LOWNODES+6] :=  PURPLE;
    ValOfNode[LOWNODES+7] :=   20;  ColorOfNode[LOWNODES+7] :=   GREEN;
    ValOfNode[LOWNODES+8] :=   15;  ColorOfNode[LOWNODES+8] :=  YELLOW;
    ValOfNode[LOWNODES+9] :=   10;  ColorOfNode[LOWNODES+9] :=  YELLOW;
    ValOfNode[LOWNODES+10] :=   0;  ColorOfNode[LOWNODES+10] := YELLOW;
    ValOfNode[LOWNODES+11] :=  50;  ColorOfNode[LOWNODES+11] := YELLOW;
    ValOfNode[LOWNODES+12] :=  25;  ColorOfNode[LOWNODES+12] := PURPLE;
    ValOfNode[LOWNODES+13] :=   0;  ColorOfNode[LOWNODES+13] :=    RED;
    ValOfNode[LOWNODES+14] :=  10;  ColorOfNode[LOWNODES+14] :=    RED;
    ValOfNode[LOWNODES+15] :=  15;  ColorOfNode[LOWNODES+15] :=  GREEN;
    ValOfNode[LOWNODES+16] :=   0;  ColorOfNode[LOWNODES+16] :=  GREEN;
    ValOfNode[LOWNODES+17] :=  40;  ColorOfNode[LOWNODES+17] := YELLOW;
    ValOfNode[LOWNODES+18] :=   0;  ColorOfNode[LOWNODES+18] :=   NONE;
    ValOfNode[LOWNODES+19] :=  20;  ColorOfNode[LOWNODES+19] := PURPLE;
    ValOfNode[LOWNODES+20] :=   5;  ColorOfNode[LOWNODES+20] := PURPLE;
    ValOfNode[LOWNODES+21] :=  60;  ColorOfNode[LOWNODES+21] :=    RED;
    ValOfNode[LOWNODES+22] :=  30;  ColorOfNode[LOWNODES+22] :=  GREEN;
    ValOfNode[LOWNODES+23] :=   0;  ColorOfNode[LOWNODES+23] :=   NONE;
    ValOfNode[LOWNODES+24] :=  30;  ColorOfNode[LOWNODES+24] := YELLOW;
    ValOfNode[LOWNODES+25] := 300;  ColorOfNode[LOWNODES+25] := PURPLE;
    ValOfNode[LOWNODES+26] :=  15;  ColorOfNode[LOWNODES+26] := PURPLE;
    ValOfNode[LOWNODES+27] :=  25;  ColorOfNode[LOWNODES+27] :=  GREEN;
    ValOfNode[LOWNODES+28] :=   0;  ColorOfNode[LOWNODES+28] :=    RED;
    ValOfNode[LOWNODES+29] :=  70;  ColorOfNode[LOWNODES+29] :=  GREEN;
    ValOfNode[LOWNODES+30] :=  35;  ColorOfNode[LOWNODES+30] :=    RED;
    ValOfNode[LOWNODES+31] :=   0;  ColorOfNode[LOWNODES+31] := YELLOW;
    ValOfNode[LOWNODES+32] :=   5;  ColorOfNode[LOWNODES+32] := PURPLE;
    ValOfNode[LOWNODES+33] :=  40;  ColorOfNode[LOWNODES+33] := PURPLE;
    ValOfNode[LOWNODES+34] :=  65;  ColorOfNode[LOWNODES+34] := YELLOW;
    ValOfNode[LOWNODES+35] :=   0;  ColorOfNode[LOWNODES+35] :=   NONE;
    ValOfNode[LOWNODES+36] :=  30;  ColorOfNode[LOWNODES+36] :=  GREEN;
    ValOfNode[LOWNODES+37] :=   0;  ColorOfNode[LOWNODES+37] :=   NONE;
    ValOfNode[LOWNODES+38] :=  80;  ColorOfNode[LOWNODES+38] :=    RED;
    ValOfNode[LOWNODES+39] :=  40;  ColorOfNode[LOWNODES+39] :=  GREEN;
    ValOfNode[LOWNODES+40] :=   0;  ColorOfNode[LOWNODES+40] :=   NONE;

    for i := 0 to 7 do BEGIN
        numlightson[i] := 0;
        if (LAnd (i, YELLOW) > 0) then numlightson[i] := numlightson[i] + 1;
        if (LAnd (i,  GREEN) > 0) then numlightson[i] := numlightson[i] + 1;
        if (LAnd (i,    RED) > 0) then numlightson[i] := numlightson[i] + 1;
    END;

    HasFlag[LOWLINKS+0] :=  0;
    HasFlag[LOWLINKS+1] :=  0;
    HasFlag[LOWLINKS+2] :=  0;
    HasFlag[LOWLINKS+3] :=  0;
    HasFlag[LOWLINKS+4] :=  0;
    HasFlag[LOWLINKS+5] :=  0;
    HasFlag[LOWLINKS+6] :=  0;
    HasFlag[LOWLINKS+7] :=  0;
    HasFlag[LOWLINKS+8] :=  0;
    HasFlag[LOWLINKS+9] :=  0;
    HasFlag[LOWLINKS+10] := 0;
    HasFlag[LOWLINKS+11] := 1;
    HasFlag[LOWLINKS+12] := 0;
    HasFlag[LOWLINKS+13] := 1;
    HasFlag[LOWLINKS+14] := 0;
    HasFlag[LOWLINKS+15] := 1;
    HasFlag[LOWLINKS+16] := 0;
    HasFlag[LOWLINKS+17] := 0;
    HasFlag[LOWLINKS+18] := 0;
    HasFlag[LOWLINKS+19] := 0;
    HasFlag[LOWLINKS+20] := 0;
    HasFlag[LOWLINKS+21] := 0;
    HasFlag[LOWLINKS+22] := 1;
    HasFlag[LOWLINKS+23] := 0;
    HasFlag[LOWLINKS+24] := 1;
    HasFlag[LOWLINKS+25] := 1;
    HasFlag[LOWLINKS+26] := 1;
    HasFlag[LOWLINKS+27] := 0;
    HasFlag[LOWLINKS+28] := 1;
    HasFlag[LOWLINKS+29] := 0;
    HasFlag[LOWLINKS+30] := 0;
    HasFlag[LOWLINKS+31] := 1;
    HasFlag[LOWLINKS+32] := 1;
    HasFlag[LOWLINKS+33] := 0;
    HasFlag[LOWLINKS+34] := 0;
    HasFlag[LOWLINKS+35] := 1;
    HasFlag[LOWLINKS+36] := 0;
    HasFlag[LOWLINKS+37] := 0;
    HasFlag[LOWLINKS+38] := 0;
    HasFlag[LOWLINKS+39] := 0;
    HasFlag[LOWLINKS+40] := 1;
    HasFlag[LOWLINKS+41] := 0;
    HasFlag[LOWLINKS+42] := 0;
    HasFlag[LOWLINKS+43] := 0;
    HasFlag[LOWLINKS+44] := 0;
    HasFlag[LOWLINKS+45] := 0;
    HasFlag[LOWLINKS+46] := 0;
    HasFlag[LOWLINKS+47] := 0;
    HasFlag[LOWLINKS+48] := 0;
    HasFlag[LOWLINKS+49] := 1;
    HasFlag[LOWLINKS+50] := 0;
    HasFlag[LOWLINKS+51] := 1;
    HasFlag[LOWLINKS+52] := 0;
    HasFlag[LOWLINKS+53] := 0;
    HasFlag[LOWLINKS+54] := 0;
    HasFlag[LOWLINKS+55] := 1;
    HasFlag[LOWLINKS+56] := 1;
    HasFlag[LOWLINKS+57] := 0;
    HasFlag[LOWLINKS+58] := 0;
    HasFlag[LOWLINKS+59] := 0;
    HasFlag[LOWLINKS+60] := 0;
    HasFlag[LOWLINKS+61] := 1;
    HasFlag[LOWLINKS+62] := 0;
    HasFlag[LOWLINKS+63] := 1;
    HasFlag[LOWLINKS+64] := 0;
    HasFlag[LOWLINKS+65] := 1;
    HasFlag[LOWLINKS+66] := 1;
    HasFlag[LOWLINKS+67] := 1;
    HasFlag[LOWLINKS+68] := 0;
    HasFlag[LOWLINKS+69] := 0;
    HasFlag[LOWLINKS+70] := 0;
    HasFlag[LOWLINKS+71] := 0;
    HasFlag[LOWLINKS+72] := 0;
    HasFlag[LOWLINKS+73] := 0;
    HasFlag[LOWLINKS+74] := 0;

    SmallEnd[LOWLINKS+0] :=  39;  BigEnd[LOWLINKS+0] :=  40;
    SmallEnd[LOWLINKS+1] :=   0;  BigEnd[LOWLINKS+1] :=   1;
    SmallEnd[LOWLINKS+2] :=   0;  BigEnd[LOWLINKS+2] :=   2;
    SmallEnd[LOWLINKS+3] :=   0;  BigEnd[LOWLINKS+3] :=   3;
    SmallEnd[LOWLINKS+4] :=   0;  BigEnd[LOWLINKS+4] :=   4;
    SmallEnd[LOWLINKS+5] :=   1;  BigEnd[LOWLINKS+5] :=   5;
    SmallEnd[LOWLINKS+6] :=   2;  BigEnd[LOWLINKS+6] :=   5;
    SmallEnd[LOWLINKS+7] :=   3;  BigEnd[LOWLINKS+7] :=   6;
    SmallEnd[LOWLINKS+8] :=   3;  BigEnd[LOWLINKS+8] :=   7;
    SmallEnd[LOWLINKS+9] :=   4;  BigEnd[LOWLINKS+9] :=   8;
    SmallEnd[LOWLINKS+10] :=  5;  BigEnd[LOWLINKS+10] :=  6;
    SmallEnd[LOWLINKS+11] :=  6;  BigEnd[LOWLINKS+11] :=  7;
    SmallEnd[LOWLINKS+12] :=  7;  BigEnd[LOWLINKS+12] :=  8;
    SmallEnd[LOWLINKS+13] :=  5;  BigEnd[LOWLINKS+13] :=  9;
    SmallEnd[LOWLINKS+14] :=  5;  BigEnd[LOWLINKS+14] := 10;
    SmallEnd[LOWLINKS+15] := 10;  BigEnd[LOWLINKS+15] := 11;
    SmallEnd[LOWLINKS+16] :=  6;  BigEnd[LOWLINKS+16] := 11;
    SmallEnd[LOWLINKS+17] :=  7;  BigEnd[LOWLINKS+17] := 12;
    SmallEnd[LOWLINKS+18] :=  8;  BigEnd[LOWLINKS+18] := 13;
    SmallEnd[LOWLINKS+19] :=  8;  BigEnd[LOWLINKS+19] := 14;
    SmallEnd[LOWLINKS+20] :=  9;  BigEnd[LOWLINKS+20] := 18;
    SmallEnd[LOWLINKS+21] :=  9;  BigEnd[LOWLINKS+21] := 15;
    SmallEnd[LOWLINKS+22] := 10;  BigEnd[LOWLINKS+22] := 15;
    SmallEnd[LOWLINKS+23] := 11;  BigEnd[LOWLINKS+23] := 16;
    SmallEnd[LOWLINKS+24] := 12;  BigEnd[LOWLINKS+24] := 16;
    SmallEnd[LOWLINKS+25] := 12;  BigEnd[LOWLINKS+25] := 13;
    SmallEnd[LOWLINKS+26] := 13;  BigEnd[LOWLINKS+26] := 17;
    SmallEnd[LOWLINKS+27] := 14;  BigEnd[LOWLINKS+27] := 17;
    SmallEnd[LOWLINKS+28] := 14;  BigEnd[LOWLINKS+28] := 23;
    SmallEnd[LOWLINKS+29] := 15;  BigEnd[LOWLINKS+29] := 18;
    SmallEnd[LOWLINKS+30] := 15;  BigEnd[LOWLINKS+30] := 19;
    SmallEnd[LOWLINKS+31] := 16;  BigEnd[LOWLINKS+31] := 20;
    SmallEnd[LOWLINKS+32] := 16;  BigEnd[LOWLINKS+32] := 21;
    SmallEnd[LOWLINKS+33] := 17;  BigEnd[LOWLINKS+33] := 22;
    SmallEnd[LOWLINKS+34] := 17;  BigEnd[LOWLINKS+34] := 23;
    SmallEnd[LOWLINKS+35] := 18;  BigEnd[LOWLINKS+35] := 19;
    SmallEnd[LOWLINKS+36] := 19;  BigEnd[LOWLINKS+36] := 24;
    SmallEnd[LOWLINKS+37] := 20;  BigEnd[LOWLINKS+37] := 24;
    SmallEnd[LOWLINKS+38] := 20;  BigEnd[LOWLINKS+38] := 21;
    SmallEnd[LOWLINKS+39] := 21;  BigEnd[LOWLINKS+39] := 26;
    SmallEnd[LOWLINKS+40] := 22;  BigEnd[LOWLINKS+40] := 26;
    SmallEnd[LOWLINKS+41] := 22;  BigEnd[LOWLINKS+41] := 23;
    SmallEnd[LOWLINKS+42] := 18;  BigEnd[LOWLINKS+42] := 24;
    SmallEnd[LOWLINKS+43] := 24;  BigEnd[LOWLINKS+43] := 28;
    SmallEnd[LOWLINKS+44] := 24;  BigEnd[LOWLINKS+44] := 35;
    SmallEnd[LOWLINKS+45] := 24;  BigEnd[LOWLINKS+45] := 29;
    SmallEnd[LOWLINKS+46] := 24;  BigEnd[LOWLINKS+46] := 25;
    SmallEnd[LOWLINKS+47] := 25;  BigEnd[LOWLINKS+47] := 26;
    SmallEnd[LOWLINKS+48] := 26;  BigEnd[LOWLINKS+48] := 30;
    SmallEnd[LOWLINKS+49] := 26;  BigEnd[LOWLINKS+49] := 37;
    SmallEnd[LOWLINKS+50] := 26;  BigEnd[LOWLINKS+50] := 31;
    SmallEnd[LOWLINKS+51] := 23;  BigEnd[LOWLINKS+51] := 26;
    SmallEnd[LOWLINKS+52] := 23;  BigEnd[LOWLINKS+52] := 31;
    SmallEnd[LOWLINKS+53] := 18;  BigEnd[LOWLINKS+53] := 28;
    SmallEnd[LOWLINKS+54] := 27;  BigEnd[LOWLINKS+54] := 33;
    SmallEnd[LOWLINKS+55] := 27;  BigEnd[LOWLINKS+55] := 28;
    SmallEnd[LOWLINKS+56] := 28;  BigEnd[LOWLINKS+56] := 33;
    SmallEnd[LOWLINKS+57] := 33;  BigEnd[LOWLINKS+57] := 34;
    SmallEnd[LOWLINKS+58] := 28;  BigEnd[LOWLINKS+58] := 34;
    SmallEnd[LOWLINKS+59] := 28;  BigEnd[LOWLINKS+59] := 35;
    SmallEnd[LOWLINKS+60] := 29;  BigEnd[LOWLINKS+60] := 35;
    SmallEnd[LOWLINKS+61] := 25;  BigEnd[LOWLINKS+61] := 36;
    SmallEnd[LOWLINKS+62] := 30;  BigEnd[LOWLINKS+62] := 37;
    SmallEnd[LOWLINKS+63] := 31;  BigEnd[LOWLINKS+63] := 37;
    SmallEnd[LOWLINKS+64] := 31;  BigEnd[LOWLINKS+64] := 38;
    SmallEnd[LOWLINKS+65] := 31;  BigEnd[LOWLINKS+65] := 39;
    SmallEnd[LOWLINKS+66] := 31;  BigEnd[LOWLINKS+66] := 32;
    SmallEnd[LOWLINKS+67] := 32;  BigEnd[LOWLINKS+67] := 39;
    SmallEnd[LOWLINKS+68] := 38;  BigEnd[LOWLINKS+68] := 39;
    SmallEnd[LOWLINKS+69] := 33;  BigEnd[LOWLINKS+69] := 40;
    SmallEnd[LOWLINKS+70] := 35;  BigEnd[LOWLINKS+70] := 36;
    SmallEnd[LOWLINKS+71] := 36;  BigEnd[LOWLINKS+71] := 40;
    SmallEnd[LOWLINKS+72] := 36;  BigEnd[LOWLINKS+72] := 37;
    SmallEnd[LOWLINKS+73] := 20;  BigEnd[LOWLINKS+73] := 25;
    SmallEnd[LOWLINKS+74] := 21;  BigEnd[LOWLINKS+74] := 25;
    

    for i := LOWNODES to HIGHNODES do nlinksfrom[i] := 0;
    for i := LOWNODES to HIGHNODES do BEGIN
        for j := LOWLINKS to HIGHLINKS do BEGIN
            if ((smallend[j] = i) or (bigend[j] = i)) then BEGIN
                nlinksfrom[i] := nlinksfrom[i] + 1;
                linksfrom[i, nlinksfrom[i]] := j;
                if (smallend[j] = i) then
                    tonode[i, nlinksfrom[i]] := bigend[j]
                else tonode[i, nlinksfrom[i]] := smallend[j];
            END;
        END;
    END;

    for i := LOWNODES to HIGHNODES do BEGIN
        maxvisits[i] := SHIFT (nlinksfrom[i], -1);
    END;

    for i := LOWNODES to HIGHNODES do for j := LOWNODES to HIGHNODES do BEGIN
        GetThereFromHere[i, j] := BOGUSLINK;
        for k := LOWLINKS to HIGHLINKS do BEGIN
            if ((smallend[k] = i) and (bigend[k] = j)) then
                GetThereFromHere[i, j] := k;
            if ((smallend[k] = j) and (bigend[k] = i)) then
                GetThereFromHere[i, j] := k;
        END;
    END;

    for i := LOWNODES to HIGHNODES do Lon[i] := NONE;
    Lon[2] :=  YELLOW;
    Lon[3] :=   GREEN;
    Lon[4] :=     RED;
    Lon[28] :=    RED;
    Lon[31] := YELLOW;

    for i := LOWNODES to HIGHNODES do Loff[i] := YELLOW+GREEN+RED+PURPLE;
    Loff[10] :=    GREEN+RED+PURPLE;
    Loff[13] := YELLOW+GREEN+PURPLE;
    Loff[16] :=   YELLOW+RED+PURPLE;
END;

PROCEDURE InitState (VAR state : statetype; startnode : integer);
VAR
    i : integer;
BEGIN
    with state do BEGIN
        for i := LOWLINKS to HIGHLINKS do linkfree[i] := TRUE;
        lightson := NONE;
        score := 0;
        numflags := 0;
        curnode := StartNode;
    END;
END;

PROCEDURE AddNodeToState (VAR state : statetype; node : integer);
VAR
    link : integer;
BEGIN
    link := GetThereFromHere[state.curnode, node];
    with state do BEGIN
        linkfree[link] := FALSE;
        numflags := numflags + hasflag[link];
        if (Lon[node] <> NONE) then LightsOn := LOR (LightsOn, Lon[node]);
        if (Loff[node] <> ALL) then LightsOn := LAnd (LightsOn, Loff[node]);
        curnode := node;
    END;
END;

FUNCTION IsLegalNextMove (state : statetype; node : integer) : boolean;
VAR
    link : integer;
BEGIN
    { legal move if there is a link from the curnode in the state to the
      node and it is allowed to take the link }

    IsLegalNextMove := FALSE;
    link := GetThereFromHere[node, state.curnode];
    if (link <> BOGUSLINK) then if (state.linkfree[link]) then
        IsLegalNextMove := TRUE
END;

FUNCTION IsLegalPath (path : pathtype) : boolean;
VAR
    state : statetype;
    i : integer;
BEGIN
    { must start at start, end at end, be a continuous path and not use
      any link twice or more }

    if ((path.numinpath < 1) or (path.numinpath > NUMLINKS+1)) then BEGIN
        IsLegalPath := FALSE;
        Exit (IsLegalPath);
    END;

    if ((path.path[1] <> STARTNODE) or
        (path.path[path.numinpath] <> FINISHNODE)) then BEGIN
            IsLegalPath := FALSE;
            Exit (IsLegalPath);
    END;

    InitState (state, STARTNODE);
    for i := 2 to path.numinpath do BEGIN
        If (NOT IsLegalNextMove (state, path.path[i])) then BEGIN
            IsLegalPath := FALSE;
            Exit (IsLegalPath);
        END;
        AddNodeToState (state, path.path[i]);
    END;
    IsLegalPath := TRUE;
END;                  

FUNCTION DeltaScore (state : statetype; node : integer) : integer;
BEGIN
    if ((node = 18) or (node = 23)) then BEGIN
        DeltaScore := 10 * state.numflags;
        Exit (DeltaScore);
    END;
    
    if (node = 35) then BEGIN
        DeltaScore := 25 * numlightson[state.lightson];
        Exit (DeltaScore);
    END;

    if (node = 37) then BEGIN
        DeltaScore := 50 * numlightson[state.lightson];
        Exit (DeltaScore);
    END;
    
    if (LAND (state.lightson, colorofnode[node]) <> 0) then 
        DeltaScore := SHIFT (valofnode[node], 1)
    else DeltaScore := valofnode[node];
END;

FUNCTION FasterDeltaScore (node : integer) : integer;
BEGIN
    if ((node = 18) or (node = 23)) then BEGIN
        FasterDeltaScore := 10 * globnumflags[curdepth];
        Exit (FasterDeltaScore);
    END;
    
    if (node = 35) then BEGIN
        FasterDeltaScore := 25 * numlightson[globlightson[curdepth]];
        Exit (FasterDeltaScore);
    END;

    if (node = 37) then BEGIN
        FasterDeltaScore := 50 * numlightson[globlightson[curdepth]];
        Exit (FasterDeltaScore);
    END;
    
    if (LAND (globlightson[curdepth], colorofnode[node]) <> 0) then 
        FasterDeltaScore := SHIFT (valofnode[node], 1)
    else FasterDeltaScore := valofnode[node];
END;

PROCEDURE OtherPrintPath (path : pathtype; var outchan : text);
VAR
    i, j, link : integer;
    state : statetype;
    curscore, cn : integer;
BEGIN
    if (path.numinpath <= 0) then BEGIN
        writeln (outchan, 'NULL PATH');
        Exit (OtherPrintPath);
    END;
    if (path.numinpath > NUMLINKS+1) then BEGIN
        writeln (outchan, 'PATH TOO LONG');
        Exit (OtherPrintPath);
    END;

    InitState (state, path.path[1]);
    with path do for i := 2 to numinpath do BEGIN
        link := GetThereFromHere[path[i-1], path[i]];
        if (link = BOGUSLINK) then BEGIN
            writeln (outchan,'Node ', path[i]:2, '  bogus link -- hyperspace');
            state.curnode := path[i];
        END
        else if (NOT IsLegalNextMove (state, path[i])) then BEGIN
            writeln (outchan, 'Node ', path[i]:2, '  Twice used link');
            AddNodeToState (state, path[i]);
            state.score := state.score + DeltaScore (state, path[i]);
        END
        else BEGIN
            AddNodeToState (state, path[i]);
            state.score := state.score + DeltaScore (state, path[i]);
            if (HasFlag[link] > 0) then BEGIN
                write (outchan, '(Flag #', state.numflags:2, ')');
                cn := 10;
                for j := cn+1 to 20 do write (outchan, ' ');
                write (outchan, ' --');
                write (outchan, ' ');
                if (LAnd (state.lightson,YELLOW)>0) then write (outchan, 'Y')
                else write (outchan, ' ');
                if (LAnd (state.lightson, GREEN) > 0) then write (outchan, 'G')
                else write (outchan, ' ');
                if (LAnd (state.lightson, RED) > 0) then write (outchan, 'R')
                else write (outchan, ' ');
                writeln (outchan);
            END;
            
{            write (outchan, 'Node ', path[i]:2, ' ');
            write (outchan, '     ', DeltaScore (state, path[i]):3);
            write (outchan, '  ');}
            cn := 1;
            case path[i] of
              2:  write (outchan, 'A');
              3:  write (outchan, 'B');
              4:  write (outchan, 'C');
              10: write (outchan, 'D');
              13: write (outchan, 'F');
              16: write (outchan, 'E');
              18: 
                BEGIN
                    write (outchan, 'G');
                    write (outchan, ' (10x', state.numflags:2, ' flags)');
                    cn := 15;
                END;
              23:
                BEGIN
                    write (outchan, 'K');
                    write (outchan, '(10x', state.numflags:2, ' flags)');
                    cn := 15;
                END;
              28: write (outchan, 'H');
              31: write (outchan, 'J');
              35:
                BEGIN
                    write (outchan, 'L');
                    write (outchan, ' (25x', numlightson[state.lightson]:1,
                        ' lights)');
                    cn := 15;
                END;
              37:
                BEGIN
                    write (outchan, 'M');
                    write (outchan, ' (50x', numlightson[state.lightson]:1,
                        ' lights)');
                    cn := 15;
                END;
              0: 
                BEGIN
                    write (outchan, 'START');
                    cn := 5;
                END;
              40: 
                BEGIN
                    write (outchan, 'FINISH');
                    cn := 6;
                END;
              otherwise:
                BEGIN
                    write (outchan, ValOfNode[path[i]]:1);
                    if (ValOfNode[path[i]] < 10) then cn := 1
                    else if (ValOfNode[path[i]] < 100) then cn := 2
                    else cn := 3;
                    case ColorOfNode[path[i]] of
                      RED: BEGIN write (outchan, ' Red'); cn:=cn+4; END;
                      GREEN: BEGIN write (outchan, ' Green'); cn := cn+6; END;
                      YELLOW: BEGIN write (outchan, ' Yellow'); cn:=cn+7; END;
                      PURPLE: BEGIN write (outchan, ' Purple'); cn:=cn+7; END;
                    end; {case}
                    case path[i] of
                      20: BEGIN  write (outchan, ' (Near E)'); cn:=cn+9; END;
                      32: BEGIN write (outchan, ' (Near J)'); cn:=cn+9; END;
                    end; {case}
                    if (LAND (ColorOfNode[path[i]], 
                        state.lightson) <> 0) then BEGIN
                        write (outchan, ' (lit)');
                        cn := cn + 6;
                    END;
                END;
            end; {case}
            curscore := DeltaScore (state, path[i]);
            for j := cn+1 to 20 do write (outchan, ' ');
            if (curscore = 0) then write (outchan, ' --')
            else write (outchan, curscore:3);
              
            write (outchan, ' ');
            if (LAnd (state.lightson, YELLOW) > 0) then write (outchan, 'Y')
            else write (outchan, ' ');
            if (LAnd (state.lightson, GREEN) > 0) then write (outchan, 'G')
            else write (outchan, ' ');
            if (LAnd (state.lightson, RED) > 0) then write (outchan, 'R')
            else write (outchan, ' ');
            writeln (outchan);
        END;
    END;
    {                  123456789012345678901234567  }
    writeln (outchan, '-----------------------');
    writeln (outchan, 'Total Score        ', state.score:4);
END;
    
PROCEDURE PrintPath (path : pathtype; var outchan : text);
VAR
    i, link : integer;
    state : statetype;
BEGIN
    if (path.numinpath <= 0) then BEGIN
        writeln (outchan, 'NULL PATH');
        Exit (PrintPath);
    END;
    if (path.numinpath > NUMLINKS+1) then BEGIN
        writeln (outchan, 'PATH TOO LONG');
        Exit (PrintPath);
    END;

    InitState (state, path.path[1]);
    with path do for i := 2 to numinpath do BEGIN
        link := GetThereFromHere[path[i-1], path[i]];
        if (link = BOGUSLINK) then BEGIN
            writeln (outchan,'Node ', path[i]:2, '  bogus link -- hyperspace');
            state.curnode := path[i];
        END
        else if (NOT IsLegalNextMove (state, path[i])) then BEGIN
            writeln (outchan, 'Node ', path[i]:2, '  Twice used link');
            AddNodeToState (state, path[i]);
            state.score := state.score + DeltaScore (state, path[i]);
        END
        else BEGIN
            AddNodeToState (state, path[i]);
            state.score := state.score + DeltaScore (state, path[i]);
            if (HasFlag[link] > 0) then
                writeln (outchan, 'Flag    (#', state.numflags:1, ')');
            write (outchan, 'Node ', path[i]:2, ' ');
            write (outchan, '     ', DeltaScore (state, path[i]):3);
            write (outchan, '  ');
            if (LAnd (state.lightson, YELLOW) > 0) then write (outchan, 'Y')
            else write (outchan, ' ');
            if (LAnd (state.lightson, GREEN) > 0) then write (outchan, 'G')
            else write (outchan, ' ');
            if (LAnd (state.lightson, RED) > 0) then write (outchan, 'R')
            else write (outchan, ' ');
            writeln (outchan);
        END;
    END;
    writeln (outchan, 'Total Score ', state.score:4);
END;
    
FUNCTION SonsOf (Node : integer; State : statetype) : PathType;
BEGIN
END;


FUNCTION RandomSearch (VAR Randpath : pathtype) : integer;
LABEL
    1111;
CONST
    VERBOSE = FALSE;
VAR
    i, temp, choice : integer;
    numout : integer;
    out : array [1..8] of integer;
    state : statetype;
BEGIN
    for i := LOWNODES to HIGHNODES do BEGIN
        maxvisits[i] := SHIFT (nlinksfrom[i], -1);
    END;

    {$IFC VERBOSE THEN}
        writeln ('Trying a random path');
    {$ENDC}
    InitState (state, STARTNODE);
    with RandPath do begin
        path[1] := STARTNODE;
        path[2] := 1;
        numinpath := 2;
    end;
    AddNodeToState (state, 1);
    with state do begin
        linkfree[6] := FALSE;
        linkfree[3] := FALSE;
        linkfree[9] := FALSE;
        score := 125;
    end;
    {special inits}
    with state do begin
        linkfree[69] := FALSE;
        linkfree[56] := FALSE;
        linkfree[71] := FALSE;
{        linkfree[15] := FALSE;
        linkfree[19] := FALSE;
        linkfree[20] := FALSE;
        linkfree[25] := FALSE;
        linkfree[36] := FALSE;
        linkfree[41] := FALSE;
        linkfree[47] := FALSE;
        linkfree[59] := FALSE;
        linkfree[70] := FALSE;
}
    end;

    
    { until reach final node, choose one of the possible successor nodes
        until reaching either FINALNODE or no move is possible ==> ABORT }
    WHILE TRUE DO with state, randpath do BEGIN
        {HACK ALERT}
        if (state.curnode = 28) then if (state.linkfree[55]) then begin
            out[1] := 27;
            choice := 1;
            goto 1111;
        end;
        numout := 0;
        for i := 1 to nlinksfrom[curnode] do BEGIN
            temp := tonode[curnode, i];
            if (linkfree[linksfrom[curnode, i]]) then
              {if (maxvisits[temp] > 0) then} BEGIN
                numout := numout + 1;
                out[numout] := temp;
              END;
        END;
        {$IFC VERBOSE THEN}
            write ('NN Choices:');
            for i := 1 to numout do write (' ', out[i]:2);
            write ('  ');
        {$ENDC}
        if (numout = 0) then begin
            {$IFC VERBOSE THEN}
                writeln ('ABORT');
            {$ENDC}
            RandomSearch := -1;
            exit (RandomSearch);
        END;
        choice := GetRandom (1, numout);
    1111: ;
        numinpath := numinpath + 1;
{        maxvisits[choice] := maxvisits[choice] - 1;}
        path[numinpath] := out[choice];
        AddNodeToState (state, out[choice]);
        score := score + DeltaScore (state, out[choice]);
        {$IFC VERBOSE THEN}
            writeln ('Selected Node ', out[choice]:2, ' ', score:4, ' ',
                DeltaScore (state, out[choice]):3);
        {$ENDC}
        if (out[choice] = FINISHNODE) then BEGIN
            {$IFC VERBOSE THEN}
                writeln ;
                writeln ('Found a Solution, score ', score:4);
                PrintPath (Randpath, output);
            {$ENDC}
            RandomSearch := score;
            exit (RandomSearch);
        END;
    END;
END;

{FUNCTION LosePoints (state : statetype; node : integer) : integer;
BEGIN
    LosePoints := 0;
    if (LAnd (colorofnode[node], YELLOW+GREEN+RED) > 0) then 
        if (LAND (state.lightson, colorofnode[node]) = 0) then
            LosePoints := ValOfNode[node];
    if ((node = 18) or (node = 23)) then
        LosePoints := (4-numbumpers) * (21 - state.numflags);
    if (node = 35) then
        LosePoints := (3-numlightson[state.lightson])*25;
    if (node = 37) then
        LosePoints := (3-numlightson[state.lightson])*50;
END;}

FUNCTION FasterLosePoints (node : integer) : integer;
BEGIN
    FasterLosePoints := 0;
    if (LAnd (colorofnode[node], YELLOW+GREEN+RED) > 0) then 
        if (LAND (globlightson[curdepth], colorofnode[node]) = 0) then
            FasterLosePoints := ValOfNode[node];
    if ((node = 18) or (node = 23)) then
{        FasterLosePoints := (4-numbumpers) * (21 - globnumflags[curdepth]);}
        FasterLosePoints := 10 * (sgmaxflags - globnumflags[curdepth]);
    if (node = 35) then
        FasterLosePoints := (3-numlightson[globlightson[curdepth]])*25;
    if (node = 37) then
        FasterLosePoints := (3-numlightson[globlightson[curdepth]])*50;
END;

PROCEDURE CompleteSearch ;
LABEL
    2222, 3333;
CONST
    VERBOSE = FALSE;
VAR
    i, j, tempnext, newnode, bestscore, lastuse : integer;
    upperlimit : integer;
    thisdepth, otherdepth : integer;
    isbadnews : boolean;
    nodecount : long;
    ch : char;
BEGIN
    writeln ('Doing a New Complete Search');
    bestscore := 0;
    nodecount := 0;
    upperlimit := InUpperBound (stdsubgraph);
    {$IFC VERBOSE THEN}
        writeln ('Threshold That is to be used is ', upperlimit:1);
    {$ENDC}
    
    { inits }
    for i := LOWNODES to HIGHNODES do nodenumbackup[i] := 0;
    nodelastuse[0] := 1;
    nodenumbackup[0] := 1;
    bndepth := 0;

    { init from the subgraph stdsubgraph }
    curdepth := 2;
    globlightson[1] := NONE;
    globscore[1] := 0;
    globnumflags[1] := 0;
    globcurnode[1] := STARTNODE;
    for i := LOWLINKS to HIGHLINKS do globlinks[i] := stdsubgraph[i];

    nextnode[1] := 1; { for completeness }
    linkused[1] := 1;
    lostpoints[1] := 0;
    flagstoget[1] := 21;
    numbumpers := 0;
    totlostpoints := 0;

    { start by going deeper }
    nextnode[curdepth] := 0;
    goto 2222;
    
  2222: ; { try next node }
    nodecount := nodecount + 1;
    if (curdepth <= 1) then begin
        writeln ('Threshold was ', pointThreshold:1);
        writeln ('Num Nodes was ', nodecount:1);
        exit (completesearch);
    end;

    {$IFC VERBOSE THEN}
        writeln ;
        writeln ('S T A T E');
        writeln ('CD L SCOR FL CN NN FG LU LPs');
        for i := 1 to curdepth-1 do begin
            write (i:2, ' ',
                globlightson[i]:1, ' ',
                globscore[i]:4, ' ',
                globnumflags[i]:2, ' ',
                globcurnode[i]:2, ' ',
                nextnode[i]:2, ' ', 
                flagstoget[i]:2, ' ',
                linkused[i]:2, ' ',
                lostpoints[i]:3, ' ');
            writeln ;
        end;
        writeln ;
        writeln ('NextN NumB TotPts');
        writeln (nextnode[curdepth]:5, ' ', 
            numbumpers:4, ' ',
            Totlostpoints:6);
        for j := LOWLINKS to HIGHLINKS do
          if (not globlinks[j]) then
            write (j:1, ' ');
        writeln ;
        for j := 1 to curdepth-1 do
            write (linkused[j]:1, ' ');
        writeln ;
        writeln ;
    {$ENDC}

  {$IFC FALSE THEN}
    writeln ;
    writeln ('NUKE THIS PATH??? [No]');
    if (eoln ) then readln 
    else begin
        readln (ch);
        if (ch = 'y') then goto 3333;
    end;
  {$ENDC}

    if (upperlimit-totlostpoints < pointThreshold) then begin
        { truncate this path because of threshold }
        {$IFC VERBOSE THEN}
            writeln ('THRESHOLD ', upperlimit-totlostpoints);
        {$ENDC}
        goto 3333;
    end;
    tempnext := nextnode[curdepth]+1;
    nextnode[curdepth] := tempnext;
    if (tempnext>nlinksfrom[globcurnode[curdepth-1]]) then begin
        { go up }
        {$IFC VERBOSE THEN}
            writeln (' No more, go up');
        {$ENDC}
      3333: ;
        if ((globcurnode[curdepth-1] = 18)or(globcurnode[curdepth-1]=23)) then 
                numbumpers := numbumpers - 1;
        totlostpoints := totlostpoints - lostpoints[curdepth-1];
        globlinks[linkused[curdepth-1]] := TRUE;
        curdepth := curdepth - 1;
        if (bndepth > 0) then if (badnews[bndepth] >= curdepth) then
            bndepth := bndepth-1;
        nodelastuse[globcurnode[curdepth]] := 
            nodesbackup[globcurnode[curdepth],
              nodenumbackup[globcurnode[curdepth]] ];
        nodenumbackup[globcurnode[curdepth]] := 
            nodenumbackup[globcurnode[curdepth]] - 1;
        goto 2222;
    end;
    {$IFC VERBOSE THEN}
        write (' Trying son ', tonode[globcurnode[curdepth-1],tempnext]:1);
    {$ENDC}
    newnode := tonode[globcurnode[curdepth-1],tempnext];

    if (not globlinks[linksfrom[globcurnode[curdepth-1], tempnext]]) then begin
        { goto next son }
        {$IFC VERBOSE THEN}
            writeln (' Bad Node, skip son');
        {$ENDC}
        goto 2222;
    end;

    if (newnode = FINISHNODE) then begin
        { report score, then go up }
        {$IFC VERBOSE THEN}
            writeln (' Made it',
                ' score ', globscore[curdepth-1]:4);
        {$ENDC}
        if (globscore[curdepth-1] > bestscore) then begin
            writeln ('NEWBEST ', globscore[curdepth-1]:4);
            bestscore := globscore[curdepth-1];
            for i := 1 to curdepth-1 do compath.path[i] := globcurnode[i];
            compath.numinpath := curdepth-1;
            printpath (compath, output);
        end;
        if (globscore[curdepth-1] < pointThreshold) then goto 2222;
        Writeln ('GOT A GREAT SOLUTION!!!!!, score ', globscore[curdepth-1]:1);


        { going up... }
        goto 2222;
    end;

    { go down }
{    if (Lon[newnode] <> NONE) then
        globlightson[curdepth] := LOR (globLightsOn[curdepth-1], Lon[newnode]);
    if (Loff[newnode] <> ALL) then
        GlobLightsOn[curdepth] :=
            LAnd (GlobLightsOn[curdepth-1], Loff[newnode]);}
    globlightson[curdepth] := 
        LAND (Loff[newnode], LOR (Lon[newnode], globlightson[curdepth-1]) );
    globcurnode[curdepth] := newnode;
    linkused[curdepth] := linksfrom[globcurnode[curdepth-1], tempnext];
    globnumflags[curdepth] := 
        globnumflags[curdepth-1] + hasflag[linkused[curdepth]];
    globscore[curdepth] := globscore[curdepth-1] + FasterDeltaScore (newnode);
    globlinks[linkused[curdepth]] := FALSE;
    lostpoints[curdepth] := FasterLosePoints (newnode);
    if ((newnode = 18) or (newnode = 23)) then numbumpers := numbumpers+1;
    totlostpoints := totlostpoints + lostpoints[curdepth];
    {$IFC VERBOSE THEN}
        writeln (' OK Go Down, lost ', lostpoints[curdepth]:3);
    {$ENDC}
    curdepth := curdepth + 1;
    nextnode[curdepth] := 0;
    case newnode of
      18,23,35,37,2,3,4,24,31:
        begin
            bndepth := bndepth + 1;
            badnews[bndepth] := curdepth-1;
        end;
    end; {case}
    nodenumbackup[newnode] := nodenumbackup[newnode] + 1;
    nodesbackup[newnode, nodenumbackup[newnode]] := nodelastuse[newnode];
    nodelastuse[newnode] := curdepth-1;
    flagstoget[curdepth-1] := flagstoget[curdepth-2];
                   
  {$IFC TRUE THEN}
    if (nodenumbackup[globcurnode[curdepth-1]] > 1) then begin
        { consider zapping this path as having a redundant loop }
        {$IFC VERBOSE THEN}
            writeln ('Considering zapping because of loop');
        {$ENDC}
        thisdepth := curdepth-1;
        otherdepth := nodesbackup[globcurnode[curdepth-1], 
            nodenumbackup[globcurnode[curdepth-1]] ];
        if (globcurnode[thisdepth-1] > globcurnode[otherdepth+1]) then begin
            { first step nodes are not in order, if no bad news then
              zap path. }
            isbadnews := FALSE;
            for i := bndepth downto 1 do begin
                if ((badnews[i] > otherdepth) and (badnews[i] < thisdepth))then
                    isbadnews := TRUE;
            end;
            if (NOT isbadnews) then begin
                {$IFC VERBOSE THEN}
                    writeln ('zapped');
                {$ENDC}
                goto 3333;
            end;
        end;
    end;
  {$ENDC}

    goto 2222;
END;

procedure UpperBound ;
VAR
    totYellow, totGreen, totRed, totPurple : integer;
    i, subtotal, grandtotal, weight :integer;
    flagweight, b25weight, b50weight : integer;
    flags : integer;
BEGIN
    flags := 0;
    for i := LOWLINKS to HIGHLINKS do if (hasflag[i]>0)then flags:=flags+1;
    
    totYellow := 0;
    totGreen := 0;
    totRed := 0;
    totPurple := 0;
    for i := LOWNODES to HIGHNODES do begin
        weight := nlinksfrom[i] DIV 2;
        case colorofnode[i] of
            YELLOW: totYellow := totYellow + valofnode[i] * weight;
            GREEN: totGreen := totGreen + valofnode[i] * weight;
            RED: totRed := totRed + valofnode[i] * weight;
            PURPLE: totPurple := TotPurple + valofnode[i] * weight;
            NONE: ;
            otherwise: writeln ('Bad color');
        end;
    end;
    flagweight := (nlinksfrom[18] DIV 2) + (nlinksfrom[23] DIV 2);
    b25weight := nlinksfrom[35] DIV 2;
    b50weight := nlinksfrom[37] DIV 2;
    
    writeln ('Numflags is ', flags:2);
    writeln ('tots: YGRP: ', totyellow:5, totgreen:5, totred:5, totpurple:5);
    SubTotal := totPurple + 2*(totyellow+totgreen+totred) +
        flags*10*flagweight + 
        3 * 25 * b25weight +
        3 * 50 * b50weight;
    writeln ('Subtotal is ', subtotal:5);
    GrandTotal := Subtotal - 125 - 100;
    writeln ('GrandTotal is ', grandtotal:5);
END;

FUNCTION InUpperBound (sg : subgraph) : integer;
CONST
    VERBOSE = TRUE;
VAR
    totYellow, totGreen, totRed, totPurple : integer;
    i, subtotal, weight :integer;
    flagweight, b25weight, b50weight : integer;
    flags : integer;
BEGIN
    { it is assumed that nlinksfrom represents sg }
    
    flags := 0;
    for i := LOWLINKS to HIGHLINKS do
      if (sg[i]) then
        if (hasflag[i]>0) then
          flags:=flags+1;
    
    totYellow := 0;
    totGreen := 0;
    totRed := 0;
    totPurple := 0;
    for i := LOWNODES to HIGHNODES do begin
        weight := nlinksfrom[i] DIV 2;
        case colorofnode[i] of
            YELLOW: totYellow := totYellow + valofnode[i] * weight;
            GREEN: totGreen := totGreen + valofnode[i] * weight;
            RED: totRed := totRed + valofnode[i] * weight;
            PURPLE: totPurple := TotPurple + valofnode[i] * weight;
            NONE: ;
            otherwise: writeln ('Bad color');
        end;
    end;
    flagweight := (nlinksfrom[18] DIV 2) + (nlinksfrom[23] DIV 2);
    b25weight := nlinksfrom[35] DIV 2;
    b50weight := nlinksfrom[37] DIV 2;
    
    SubTotal := totPurple + 2*(totyellow+totgreen+totred) +
        flags*10*flagweight + 
        3 * 25 * b25weight +
        3 * 50 * b50weight;
    InUpperBound := SubTotal;

    {$IFC VERBOSE THEN}
        writeln ('UPPER BOUND');
        writeln ('TotYellow ', totYellow:1);
        writeln ('TotGreen  ', totGreen:1);
        writeln ('TotRed    ', totRed:1);
        writeln ('TotPurple ', totPurple:1);
        writeln ('Flags     ', flags:1);
        writeln ('FlagWeight  ', flagweight:1);
        writeln ('B25Weight   ', b25weight:1);
        writeln ('B50Weight   ', b50weight:1);
        writeln ('Total     ', SubTotal:1);
    {$ENDC}

END;

PROCEDURE NewEdgeSearch (numedges : integer);
LABEL
    1111, 2222;
CONST
    VERBOSE = FALSE;
BEGIN
    { inits }
    if ((numedges < 1) or (numedges > NEWMAXEDGES)) then begin
        writeln ('Bad number of edges in NewEdgeSearch, returning');
        exit (NewEdgeSearch);
    end;
    numsolutions := 0;
    for i := LOWLINKS to HIGHLINKS do badlinks[i] := 0;
    for i := LOWNODES to HIGHNODES do
        oddnodes[i] := ((nlinksfrom[i] MOD 2) = 1);
    
    for i := LOWLINKS to HIGHLINKS do if (not stdsubgraph[i]) then BEGIN
        badlinks[i] := 10000;
{        oddnodes[smallend[i]] := not oddnodes[smallend[i]];
        oddnodes[bigend[i]] := not oddnodes[bigend[i]];
}
    END;


    { force begining and end nodes to even}
    oddnodes[STARTNODE] := FALSE;
    oddnodes[FINISHNODE] := FALSE;

    { chatter }
    {$IFC TRUE THEN}
        writeln ('The (non start/finish) odd nodes are: ');
        for i := LOWNODES to HIGHNODES do begin
            if (oddnodes[i]) then write (i:1, ' ');
        end;
        writeln ;
        writeln ;
    {$ENDC}

    { main loop, try an odd node, try an edge from it,
     if all go then go deeper.  Any solutions are printed. }
    {startup}
    curdepth := 1;
    numodd := 0;
    for i := LOWNODES to HIGHNODES do if (oddnodes[i]) then numodd := numodd+1;
    writeln ('There are ', numodd:1, ' odd nodes.');
    firsttime := TRUE;

  1111: ;
    { check if we are done}
    if (curdepth <= 0) then begin
        writeln ('Done with edge search');
        writeln ('badlinks:');
        for i := LOWLINKS to HIGHLINKS do BEGIN
            write (i mod 10:1);
        END;
        writeln ;
        for i := LOWLINKS to HIGHLINKS do begin
            if (badlinks[i] < 0) then write ('-')
            else if (badlinks[i] > 9) then write ('+')
            else write (badlinks[i]:1);
        end;
        writeln ;
        exit (NewEdgeSearch);
    end;

    { if not the first time at this depth then kill the current link }
    if (not firsttime) then begin
{        badlinks[curlinks[curdepth]] := badlinks[curlinks[curdepth]] + 1;}
        oddnodes[smallend[curlinks[curdepth]]] :=
            NOT oddnodes[smallend[curlinks[curdepth]]];
        oddnodes[bigend[curlinks[curdepth]]] :=
            NOT oddnodes[bigend[curlinks[curdepth]]];
        if (oddnodes[smallend[curlinks[curdepth]]]) then numodd := numodd + 1
        else numodd := numodd - 1;
        if (oddnodes[bigend[curlinks[curdepth]]]) then numodd := numodd + 1
        else numodd := numodd - 1;
    end;

    {$IFC VERBOSE THEN}
        writeln ;
        writeln ('S T A T E');
        writeln ('CD CL');
        for i := 1 to curdepth-1 do begin
            writeln (i:2,
                ' ', curlinks[i]:2);
        end;
        if (firsttime) then writeln (curdepth:2, '  -')
        else writeln (curdepth:2, ' ', curlinks[curdepth]:2);
        writeln ('NumOdd FirstTime');
        write (numodd:6, ' ');
        if (firsttime) then write ('     TRUE')
        else                write ('    FALSE');
        writeln ;
        for i := LOWNODES TO HIGHNODES do begin
            if (oddnodes[i]) then write ('O')
            else write ('-');
        end;
        writeln ;
        for i := LOWLINKS to HIGHLINKS do BEGIN
            write (i mod 10:1);
        END;
        writeln ;
        for i := LOWLINKS to HIGHLINKS do begin
            if (badlinks[i] < 0) then write ('-')
            else if (badlinks[i] > 9) then write ('+')
            else write (badlinks[i]:1);
        end;
        writeln ;
        
    {$ENDC}
    
    { At this point, the state is the number of edges in the current list,
      oddnodes is the oddness of nodes,
      badlinks is the number of times each link is bad,
      curlinks is the current links,
      curdepth is the current depth,
      numodd is the number of odd nodes,
      firsttime is true ifof this is the first time at this depth.
    }
    { are we done now? }
    if (numodd = 0) then begin
        numsolutions := numsolutions + 1;
        writeln ('Solution Found, # ', numsolutions:1);
        for i := 1 to curdepth - 1 do begin
            write (curlinks[i]:2, ' ');
        end;
        writeln ;
        curdepth := curdepth - 1;
        firsttime := FALSE;
        goto 1111;
    end;
    if (curdepth-1 > numedges - SHIFT (numodd, -1)) then begin
        curdepth := curdepth - 1;
        firsttime := FALSE;
        goto 1111;
    end;

    { find next edge to go down }
    if (firsttime) then startlink := LOWLINKS
    else startlink := curlinks[curdepth] + 1;
    foundone := FALSE;
    for i := startlink to HIGHLINKS do begin
        if ((oddnodes[bigend[i]]) or (oddnodes[smallend[i]])) then begin
            if (0 >= badlinks[i]) then begin
                linkis := i;
                foundone := TRUE;
                goto 2222;
            end
            else begin
                badlinks[i] := badlinks[i] + 1;
            end;
        end;
    end;
  2222: ;

    { if no next edge then go up }
    if (not foundone) then begin
        for i := LOWLINKS TO HIGHLINK do begin
            if (oddnodes[bigend[i]] or oddnodes[smallend[i]]) then
                badlinks[i] := badlinks[i] - 1;
        end;
        curdepth := curdepth - 1;
        firsttime := FALSE;
        goto 1111;
    end;
    
    { if edge found, then go down }
    curlinks[curdepth] := linkis;
    oddnodes[smallend[linkis]] := 
        NOT oddnodes[smallend[linkis]];
    oddnodes[bigend[linkis]] := 
        NOT oddnodes[bigend[linkis]];
    if (oddnodes[smallend[linkis]]) then numodd := numodd + 1
    else numodd := numodd - 1;
    if (oddnodes[bigend[linkis]]) then numodd := numodd + 1
    else numodd := numodd - 1;
    badlinks[linkis] := badlinks[linkis] + 1;
    curdepth := curdepth + 1;
    firsttime := TRUE;
    goto 1111;
        
END;

PROCEDURE EdgeSearch (numedges : integer);
LABEL
    1111, 2222;
CONST
    VERBOSE = FALSE;
    MAXEDGES = 30;
VAR
    i : integer;
    badlinks : array [LOWLINKS..HIGHLINKS] of integer;
        { TRUE IFOF link is not to be used in further searching}
    oddnodes : array [LOWNODES..HIGHNODES] of boolean;
        { TRUE if node currently has odd number of links }
    curlinks : array [1..MAXEDGES] of integer;
    linktried : array [1..MAXEDGES] of integer;
    curdepth : integer;
    numodd :integer;
    firsttime : boolean;
    foundone : boolean;
    linkis : integer;
    startlink : integer;
    numsolutions : integer;
BEGIN
    { inits }
    numsolutions := 0;
    if ((numedges < 1) or (numedges > MAXEDGES)) then begin
        writeln ('Bad number of edges in EdgeSearch, returning');
        exit (EdgeSearch);
    end;
    for i := LOWLINKS to HIGHLINKS do badlinks[i] := 0;
    for i := LOWNODES to HIGHNODES do
        oddnodes[i] := ((nlinksfrom[i] MOD 2) = 1);
    { force begining and end nodes to even}
    oddnodes[STARTNODE] := FALSE;
    oddnodes[FINISHNODE] := FALSE;
    {ignore these nodes for now }    
    oddnodes[2] := FALSE;
    oddnodes[3] := FALSE;
    oddnodes[4] := FALSE;
    
    { special inits }
    badlinks[1] := badlinks[1] + 1;
    badlinks[69] := badlinks[69] + 1;
    badlinks[0] := badlinks[0] + 1;

    badlinks[6] := badlinks[6] + 1;;
    oddnodes[smallend[6]] := NOT oddnodes[smallend[6]];
    oddnodes[bigend[6]] := NOT oddnodes[bigend[6]];
    badlinks[3] := badlinks[3] + 1;
    badlinks[9] := badlinks[9] + 1;
    oddnodes[smallend[9]] := NOT oddnodes[smallend[9]];
    oddnodes[bigend[9]] := NOT oddnodes[bigend[9]];
    oddnodes[2] := FALSE;
    oddnodes[3] := FALSE;
    oddnodes[4] := FALSE;
    oddnodes[0] := FALSE;

    badlinks[55] := badlinks[55] + 1;
    oddnodes[smallend[55]] := NOT oddnodes[smallend[55]];
    oddnodes[bigend[55]] := NOT oddnodes[bigend[55]];
    badlinks[56] := badlinks[56] + 1;
    oddnodes[smallend[56]] := NOT oddnodes[smallend[56]];
    oddnodes[bigend[56]] := NOT oddnodes[bigend[56]];
    badlinks[58] := badlinks[58] + 1;
    oddnodes[smallend[58]] := NOT oddnodes[smallend[58]];
    oddnodes[bigend[58]] := NOT oddnodes[bigend[58]];
    oddnodes[27] := FALSE;
    oddnodes[33] := FALSE;
    oddnodes[34] := FALSE;
    
    badlinks[71] := badlinks[71] + 1;
    oddnodes[smallend[71]] := NOT oddnodes[smallend[71]];
    oddnodes[bigend[71]] := NOT oddnodes[bigend[71]];
    oddnodes[40] := FALSE;

    { chatter }
    {$IFC VERBOSE THEN}
        for i := LOWNODES to HIGHNODES do begin
            if (oddnodes[i]) then write (i:1, ' ');
        end;
        writeln ;
        writeln ;
    {$ENDC}

    { main loop, try an odd node, try an edge from it,
     if all go then go deeper.  Any solutions are printed. }
    {startup}
    curdepth := 1;
    numodd := 0;
    for i := LOWNODES to HIGHNODES do if (oddnodes[i]) then numodd := numodd+1;
    firsttime := TRUE;

  1111: ;
    { check if we are done}
    if (curdepth <= 0) then begin
        writeln ('Done with edge search');
        exit (EdgeSearch);
    end;

    { if not the first time at this depth then kill the current link }
    if (not firsttime) then begin
        badlinks[curlinks[curdepth]] := badlinks[curlinks[curdepth]] + 1;
        oddnodes[smallend[curlinks[curdepth]]] :=
            NOT oddnodes[smallend[curlinks[curdepth]]];
        oddnodes[bigend[curlinks[curdepth]]] :=
            NOT oddnodes[bigend[curlinks[curdepth]]];
        if (oddnodes[smallend[curlinks[curdepth]]]) then numodd := numodd + 1
        else numodd := numodd - 1;
        if (oddnodes[bigend[curlinks[curdepth]]]) then numodd := numodd + 1
        else numodd := numodd - 1;
    end;

    {$IFC VERBOSE THEN}
        writeln ;
        writeln ('S T A T E');
        writeln ('CD CL');
        for i := 1 to curdepth-1 do begin
            writeln (i:2,
                ' ', curlinks[i]:2);
        end;
        if (firsttime) then writeln (curdepth:2, '  -')
        else writeln (curdepth:2, ' ', curlinks[curdepth]:2);
        writeln ('NumOdd FirstTime');
        write (numodd:6, ' ');
        if (firsttime) then write ('     TRUE')
        else                write ('    FALSE');
        writeln ;
        for i := LOWNODES TO HIGHNODES do begin
            if (oddnodes[i]) then write ('O')
            else write ('-');
        end;
        writeln ;
        for i := LOWLINKS to HIGHLINKS do BEGIN
            write (i mod 10:1);
        END;
        writeln ;
        for i := LOWLINKS to HIGHLINKS do begin
            if (badlinks[i] < 0) then write ('-')
            else if (badlinks[i] > 9) then write ('+')
            else write (badlinks[i]:1);
        end;
        writeln ;
        
    {$ENDC}
    
    { At this point, the state is the number of edges in the current list,
      oddnodes is the oddness of nodes,
      badlinks is the number of times each link is bad,
      curlinks is the current links,
      curdepth is the current depth,
      numodd is the number of odd nodes,
      firsttime is true ifof this is the first time at this depth.
    }
    { are we done now? }
    if (numodd = 0) then begin
        numsolutions := numsolutions + 1;
        writeln ('Solution Found, # ', numsolutions:1);
        for i := 1 to curdepth - 1 do begin
            write (curlinks[i]:2, ' ');
        end;
        writeln ;
        curdepth := curdepth - 1;
        firsttime := FALSE;
        goto 1111;
    end;
    if (curdepth-1 > numedges - SHIFT (numodd, -1)) then begin
        curdepth := curdepth - 1;
        firsttime := FALSE;
        goto 1111;
    end;

    { find next edge to go down }
    if (firsttime) then startlink := LOWLINKS
    else startlink := curlinks[curdepth] + 1;
    foundone := FALSE;
    for i := startlink to HIGHLINKS do begin
        if ((oddnodes[bigend[i]]) or (oddnodes[smallend[i]])) then begin
            if (0 >= badlinks[i]) then begin
                linkis := i;
                foundone := TRUE;
                goto 2222;
            end
            else begin
                badlinks[i] := badlinks[i] + 1;
            end;
        end;
    end;
  2222: ;

    { if no next edge then go up }
    if (not foundone) then begin
        for i := LOWLINKS TO HIGHLINK do begin
            if (oddnodes[bigend[i]] or oddnodes[smallend[i]]) then
                badlinks[i] := badlinks[i] - 1;
        end;
        curdepth := curdepth - 1;
        firsttime := FALSE;
        goto 1111;
    end;
    
    { if edge found, then go down }
    curlinks[curdepth] := linkis;
    oddnodes[smallend[linkis]] := 
        NOT oddnodes[smallend[linkis]];
    oddnodes[bigend[linkis]] := 
        NOT oddnodes[bigend[linkis]];
    if (oddnodes[smallend[linkis]]) then numodd := numodd + 1
    else numodd := numodd - 1;
    if (oddnodes[bigend[linkis]]) then numodd := numodd + 1
    else numodd := numodd - 1;
    curdepth := curdepth + 1;
    firsttime := TRUE;
    goto 1111;
        
END;



PROCEDURE InitSubGraph (stdsubgraph : SubGraph);
CONST
    VERBOSE = TRUE;
VAR
    i, j, k : integer;
BEGIN
    for i := LOWNODES to HIGHNODES do nlinksfrom[i] := 0;
    for i := LOWNODES to HIGHNODES do BEGIN
        for j := LOWLINKS to HIGHLINKS do if (stdsubgraph[j]) then BEGIN
            if ((smallend[j] = i) or (bigend[j] = i)) then BEGIN
                nlinksfrom[i] := nlinksfrom[i] + 1;
                linksfrom[i, nlinksfrom[i]] := j;
                if (smallend[j] = i) then
                    tonode[i, nlinksfrom[i]] := bigend[j]
                else tonode[i, nlinksfrom[i]] := smallend[j];
            END;
        END;
    END;

    for i := LOWNODES to HIGHNODES do BEGIN
        maxvisits[i] := SHIFT (nlinksfrom[i], -1);
    END;

    for i := LOWNODES to HIGHNODES do for j := LOWNODES to HIGHNODES do BEGIN
        GetThereFromHere[i, j] := BOGUSLINK;
    END;
    for k := LOWLINKS to HIGHLINKS do if (stdsubgraph[k]) then BEGIN
        GetThereFromHere[smallend[k], bigend[k]] := k;
        GetThereFromHere[bigend[k], smallend[k]] := k;
    END;
    
    sgmaxflags := 0;
    for i := LOWLINKS to HIGHLINKS do if (stdsubgraph[i]) then
        if (hasflag[i] > 0) then sgmaxflags := sgmaxflags + 1;
    {$IFC VERBOSE THEN}
        writeln ('InitSubGraph, sgmaxflags is ', sgmaxflags:1);
    {$ENDC}
END;


procedure Do_Command (commandstring : string;
                      var inchan : text;
                      prompt : string);
VAR
    i, num, link : integer;
    a, b, c : integer;
    longnum, longi : long;
    thisscore, bestscore : integer;
    ch : char;
    outchan, inchan2 : text;
    instr, outstr : string;
    count : integer;
begin
    if (length (commandstring) <> 0) then ch := commandstring[1]
    else ch := 'h';

    case ch of 
        'c':
            BEGIN
                Writeln ('Bound is ', InUpperBound (stdsubgraph):1);
            END;

        'f':
            BEGIN
                writeln ('Enter the name of the output file');
                readln (inchan, outstr);
                rewrite (outchan, outstr);
                If (NOT IsLegalPath (mainpath)) then BEGIN
                    writeln (outchan, 'Warning, path is not legal');
                    writeln (outchan);
                END;
                PrintPath (mainpath, outchan);
                close (outchan);
            END;

        'g':
            BEGIN
                writeln ('set up default turned-off links');
                writeln ('These links encompass the begin-end assumptions');
                for i := LOWLINKS to HIGHLINKS do if (not assumesg[i]) then
                    write (i:1, ' ');
                writeln ;
                writeln ('Enter a sequence of links to turn off');
                writeln ('End with a blank line');

                for i := HIGHLINKS downto LOWLINKS do 
                    stdsubgraph[i] := assumesg[i];
                { zap standard links }
{                stdsubgraph[2] := FALSE;
                stdsubgraph[3] := FALSE;
                stdsubgraph[4] := FALSE;
                stdsubgraph[6] := FALSE;
                stdsubgraph[9] := FALSE;
                stdsubgraph[56] := FALSE;
                stdsubgraph[69] := FALSE;
                stdsubgraph[71] := FALSE;}
                while (not eoln (inchan)) do begin
                    read (inchan, i);
                    if ((i>=LOWLINKS) and (i<=HIGHLINKS)) then
                        stdsubgraph[i] := FALSE;
                end;
                InitSubGraph (stdsubgraph);
                for i := LOWNODES to HIGHNODES do
                  if ((i <> STARTNODE) and (i <> FINISHNODE)) then
                    if ((nlinksfrom[i] MOD 2) = 1) then
                      writeln ('Warning, Odd Node ', i:1);
               if (nlinksfrom[STARTNODE] <> 1) then 
                   writeln ('Nlinksfrom STARTNODE <> 1');
               if (nlinksfrom[FINISHNODE] <> 1) then 
                   writeln ('Nlinksfrom FINISHNODE <> 1');
            END;

        'h': writeln ('No Help Yet');

        'p':
            BEGIN
                If (NOT IsLegalPath (mainpath)) then BEGIN
                    writeln ('Warning, path is not legal');
                    writeln ;
                END;
                PrintPath (mainpath, output);
            END;
        'o':
            BEGIN
                If (NOT IsLegalPath (mainpath)) then BEGIN
                    writeln ('Warning, path is not legal');
                    writeln ;
                END;
                OtherPrintPath (mainpath, output);
            END;

        'q':
            BEGIN
                Writeln ('Quitting...');
                Exit (Tempest);
            END;

        'r':
            BEGIN
                writeln ('How many tries of a random path?, and scrambles');
                readln (inchan, longnum, i, num);
                RScramble (i, num);
                bestscore := 0;
                count := 0;
                longi := 0;
                while (longi < longnum) do BEGIN
                    longi := longi + 1;
                    count := count + 1;
                    if ((count mod 10000) = 0) then BEGIN
                         write ('.');
                         count := 0;
                    END;
                    thisscore := RandomSearch (MainPath);
                    if (thisscore > BestScore-0) then
                        write (thisscore:1, ' ');
                    if (thisscore > bestscore) then BEGIN
                        writeln ('NEWBEST ', thisscore:1, ' ');
                        bestscore := thisscore;
                        PrintPath (mainpath, output);
                        rewrite (outchan, 'random.best');
                        PrintPath (mainpath, outchan);
                        close (outchan);
                    END;
                END;
            END;

        '*':
            BEGIN
                writeln ('Setting up the begin-end assumptions');
                writeln ('enter a number 1 to 4 for the beginning');
                readln (a);
                if ((a < 1) or (a > 4)) then begin
                    writeln ('BOGUS, set to 1');
                    a := 1;
                end;
                writeln ('Enter a number 69, 71, or 0 for the ending');
                readln (b);
                if ((b <> 69) and (b <> 71) and (b <> 0)) then begin
                    writeln ('BOGUS, set to 0');
                    b := 0;
                end;
                for i := LOWLINKS to HIGHLINKS do assumesg[i] := TRUE;
                case a of
                    1:
                        BEGIN
                            assumesg[2] := FALSE; assumesg[6] := FALSE;
                            assumesg[3] := FALSE;
                            assumesg[4] := FALSE; assumesg[9] := FALSE;
                        END;
                    2:
                        BEGIN                    

                            assumesg[1] := FALSE; assumesg[5] := FALSE;
                            assumesg[3] := FALSE;
                            assumesg[4] := FALSE; assumesg[9] := FALSE;
                        END;
                    3:
                        BEGIN
                            assumesg[1] := FALSE; assumesg[5] := FALSE;
                            assumesg[2] := FALSE; assumesg[6] := FALSE;
                            assumesg[4] := FALSE; assumesg[9] := FALSE;
                        END;
                    4:
                        BEGIN
                            assumesg[1] := FALSE; assumesg[5] := FALSE;
                            assumesg[2] := FALSE; assumesg[6] := FALSE;
                            assumesg[3] := FALSE;
                        END;
                    otherwise: writeln ('ERROR');
                end;
                case b of
                    69:
                        BEGIN
                            assumesg[71] := FALSE;
                            assumesg[0] := FALSE;
                            assumesg[65] := FALSE;
                        END;
                    71:
                        BEGIN
                            assumesg[69] := FALSE;
                            assumesg[0] := FALSE;
                            assumesg[56] := FALSE;
                            assumesg[65] := FALSE;
                        END;
                    0:
                        BEGIN
                            assumesg[69] := FALSE;
                            assumesg[71] := FALSE;
                            assumesg[56] := FALSE;
                        END;
                    otherwise: writeln ('ERROR 2');
                end;
            END;

        '%':
            BEGIN
                writeln ('Enter the number of edges allowed ');
                readln (inchan, i);
{                EdgeSearch (i);}
                NewEdgeSearch (i);
            END;

        '!':
            BEGIN
                writeln ('Enter the threshold');
                readln (inchan, pointThreshold);
                TickInit ;
                CompleteSearch ;
                Tick (1);
                TickAddString (1, 'Time Taken ');
                TickReport (output);
            END;

        '>':
            BEGIN
                writeln ('Redirect output, ARE YOU SURE YOU WANT TO DO THIS');
                readln (inchan, outstr);
                if (length (outstr)>0) then if (outstr[1] = 'y') then begin
                    writeln ('Enter the name of the output file');
                    readln (inchan, outstr);
                    writeln ('Be sure to use a matching ''<'' command');
                    close (output);
                    rewrite (output, outstr);
                end;
            END;
        '@':
            BEGIN
                writeln ('Get Input from command file');
                writeln ('Enter the name of the command file');
                readln (inchan, instr);
                writeln ('taking commands from file ''', instr, '''.');
                reset (inchan2, instr);
                CommandLoop ('T>> ', inchan2);
                close (inchan2);
            END;
        '<':
            BEGIN
                close (output);
                exit (tempest);
            END;
        'z':
            BEGIN
                writeln ('Zapping Path');
                MainPath.numinpath := 0;
            END;

        '-':
            BEGIN
                if (mainpath.numinpath <= 0) then
                    writeln ('Null Path, not popping')
                else BEGIN
                    writeln ('Popping from Path');
                    mainpath.numinpath := mainpath.numinpath - 1;
                END;
            END;

        '0',
        '1',
        '2',
        '3',
        '4',
        '5',
        '6',
        '7',
        '8',
        '9':
            BEGIN
                num := ord (ch) - ord ('0');
                if (length (commandstring) > 1) then
                    if (('0'<=commandstring[2])and(commandstring[2]<='9'))then
                        num := num * 10 + ord (commandstring[2])-ord ('0');
                if (num > 40) then writeln ('Bad Node Number, must be 0..40')
                else if (mainpath.numinpath >= NUMLINKS+1) then
                    writeln ('Can''t Add node, Path is maximum length')
                else BEGIN
                    mainpath.numinpath := mainpath.numinpath + 1;
                    mainpath.path[mainpath.numinpath] := num;
                END;
                with mainpath do if (numinpath > 1) then begin
                    link := GetThereFromHere[path[numinpath-1],
                        path[numinpath]];
                    if (link = BOGUSLINK) then BEGIN
                        writeln ('WARNING,  bogus link -- hyperspace');
                    END
                end;
           END;
        otherwise: writeln ('Commands are: cfhpqz-!#');
    end;
end;

procedure CommandLoop (prompt : string; var inchan : text);
var
    continue : boolean;
    commandstring : string;
begin
    writeln ;
    write (prompt);
    while (not eof (inchan)) do begin
        readln (inchan, commandstring);
        if (length (commandstring) <> 0) then begin
            Do_Command (commandstring, inchan, prompt);
        end;
        writeln ;
        write (prompt);
    end;
end;
BEGIN
    { global inits }
    Initialize ;
    InitRandom ;

    { init sole global variable of command program }
    MainPath.numinpath := 0;

    CommandLoop ('T> ', input);
END.
{ }
