Program SpeedTest ;
{ benchmark program to compare PERQ speed with other machines }
{ COPYRIGHT (C) 1982 SIEMENS CRT }

IMPORTS Screen FROM Screen;
IMPORTS Tick FROM Tick;

CONST
    DOREALS = TRUE;
    DORANGEOFF = TRUE;
    
{$IFC DORANGEOFF THEN}
    {$RANGE-}
{$ENDC}

VAR
    i, j : integer;
{$IFC NOT DOREALS THEN}
    a : array [0..9999] of integer;
    b : array [0..9999] of integer;
{$ENDC} {$IFC DOREALS THEN}
    r : array [0..9999] of real;
    s : array [0..9] of real;
{$ENDC}
    ltime : long;


BEGIN
{$IFC NOT DOREALS THEN}
    { init arrays to avoid overflows }
    for i := 1 to 9999 do BEGIN
        a[i] := i;
        b[i] := i;
    END;

    { time for doing 9999 integer additions }
    TickResetTime ;
    for i := 1 to 9999 do BEGIN
        a[i] := a[i] + a[i];
    END;
    ltime := TickJiffies ;               
    writeln ('9999 Integer Additions take ', ltime:1, ' ticks.');

    { time for doing 9999 integer multiplications }
    TickResetTime ;
    for i := 1 to 9999 do BEGIN
        a[i] := a[i] * 2;
    END;
    ltime := TickJiffies ;               
    writeln ('9999 Integer Multiplications take ', ltime:1, ' ticks.');

    { time for doing 9999 integer divisions }
    TickResetTime ;
    for i := 1 to 9999 do BEGIN
        a[i] := a[i] DIV 2;
    END;
    ltime := TickJiffies ;               
    writeln ('9999 Integer Divisions take ', ltime:1, ' ticks.');
    
    { time for doing 9 array copies of length 9999 }
    TickResetTime ;
    for j := 1 to 9 do BEGIN
        for i := 1 to 9999 do b[i] := a[i];
    END;
    ltime := TickJiffies ;
    writeln ('9 copies of 9999 size integer array takes ', ltime:1, ' ticks.');

    { time for doing 9999 array copies of length 9 }
    TickResetTime ;
    for j := 1 to 9999 do BEGIN
        for i := 1 to 9 do b[i] := a[i];
    END;
    ltime := TickJiffies ;
    writeln ('9999 copies of 9 size integer array takes ', ltime:1, ' ticks.');

    { fast copy routine }
    TickResetTime ;
    for j := 1 to 9 do BEGIN
        RASTEROP (0, 768, 209, 0, 0, 48, SScreenP, 
                              0, 220, 48, SScreenP);
    END;
    ltime := TickJiffies ;
    writeln ('FAST 9 copies of 9999 size integer array takes ', 
        ltime:1, ' ticks.');
    
    { fast copy routine }
    TickResetTime ;
    for j := 1 to 9999 do BEGIN
        RASTEROP (0, 9, 1, 0, 0, 48, SScreenP, 
                           0, 220, 48, SScreenP);
    END;
    ltime := TickJiffies ;
    writeln ('FAST 9999 copies of 9 size integer array takes ', 
        ltime:1, ' ticks.');
    

{$ENDC} {$IFC DOREALS THEN}
    for i := 0 to 9999 do r[i] := i;

    { time for 9999 real additions }
    TickResetTime ;
    for i := 1 to 9999 do BEGIN
        r[i] := r[i] + r[i];
    END;
    ltime := TickJiffies ;               
    writeln ('9999 Real Additions take ', ltime:1, ' ticks.');
    
    { time for doing 9999 real multiplications }
    TickResetTime ;
    for i := 1 to 9999 do BEGIN
        r[i] := r[i] * 2.0;
    END;
    ltime := TickJiffies ;               
    writeln ('9999 Real Multiplications take ', ltime:1, ' ticks.');

    { time for doing 9999 real divisions }
    TickResetTime ;
    for i := 1 to 9999 do BEGIN
        r[i] := r[i] / 2.0;
    END;
    ltime := TickJiffies ;               
    writeln ('9999 Real Divisions take ', ltime:1, ' ticks.');


    { time for doing 9 array copies of length 9999 }
    TickResetTime ;
    for j := 1 to 9 do BEGIN
        for i := 1 to 9999 do r[i] := r[i];
    END;
    ltime := TickJiffies ;
    writeln ('9 copies of 9999 size real array takes ', ltime:1, ' ticks.');

    { time for doing 9999 array copies of length 9 }
    TickResetTime ;
    for j := 1 to 9999 do BEGIN
        for i := 1 to 9 do r[i] := s[i];
    END;
    ltime := TickJiffies ;
    writeln ('9999 copies of 9 size real array takes ', ltime:1, ' ticks.');

{$ENDC}
    
END.
{ }
