module PaneDefs;

(***********************************************************************
 *
 *    AUTHOR: Lee Iverson
 *    ABSTRACT:
 *      This module is the external definition module for the Pane
 *      structures.  This is imported by the pane interface module and
 *      should also be imported by all internal pane modules.
 *
 *    -----------
 *    CHANGE LOG:
 *      Jun 27 1984     Lee Iverson     ** Created **
 *
 ***********************************************************************)

exports

const
  (* The maximum number of panes allowed *)
  NullPane = 0;
  MaxPanes = 30;

  (* Pane creation coordinate constants *)
  PN_DEFAULT = -1;
  PN_ASKUSER = -2;
  
  (* Special region values *)
  PaneOutsideRegion = -1;
  PaneTitleRegion = -2;
  PaneBodyRegion = -3;

type
  (* The external look of the panes *)
  Pane = NullPane..MaxPanes;

  (* Default pane creation mechanisms *)
  Defaults = ( dfltAskUser, dfltHSplit, dfltVSplit );
  
  (* Text display adjust types *)
  AdjustFunct = ( adjLeft, adjRight, adjCenter );

  (* Data structure representing points *)
  pPnPoint = ^PnPoint;
  Coords = ( xCoord, yCoord );
  PnPoint = record
            case Integer of
              1: ( x: Integer;
                   y: Integer );
              2: ( xy: Array[Coords] of Integer );
            end;

  (* Lines *)
  pPnLine = ^PnLine;
  Ends = ( startEnd, finishEnd );
  PnLine = record
           case Integer of
             1: ( start: PnPoint;
                  finish: PnPoint );
             2: ( sf: Array[Ends] of PnPoint );
           end;

  (* Rectangular areas *)
  pPnRectangle = ^PnRectangle;
  PnRectangle = record
                case Integer of
                  1: ( left: Integer;
                       top: Integer;
                       width: Integer;
                       height: Integer );
                  2: ( topLeft: PnPoint;
                       size: PnPoint );
                end;

  (* Exception handling *)
  PaneExceptType = ( exResizePane, exExposePane, exEvent, exChangeListener );

  pPaneSize = ^PaneSizeRec;
  PaneSizeRec = record
                  width: Integer;
                  height: Integer;
                end;

  pPaneEvent = ^PaneEvent;
  PaneEvent = record
                x, y: Integer;
                ch: Char;
                cmd: Integer;
                region: Integer;
                pn: Pane;
              end;

  pChangeListen = ^ChangeListenRec;
  ChangeListenRec = record
                      oldListener: Pane;
                      newListener: Pane;
                    end;

exception
  PaneExcept(
    pn: Pane;
    typ: PaneExceptType;
    arg: Pointer
  );

private

procedure dumb;
begin
end.


