module Colors;

(***********************************************************************
 *
 *    AUTHOR: Lee Iverson
 *    ABSTRACT:
 *      This module implements an extended coloring scheme for rectangles
 *      which includes the extra colors: Gray and LightGray.  These patterns
 *      may be extended to include other shading patterns.
 *
 *    -----------
 *    CHANGE LOG:
 *      Jul 11 1984     Lee Iverson     ** Created **
 *
 ***********************************************************************)

exports

imports SapphDefs from SapphDefs;

type
  ColorFunct = (clrWhite, clrBlack, clrInvert, clrLightGray, clrGray);

procedure
  InitColors(
    vp: Viewport
  );

procedure
  ColorRectangle(
    vp: Viewport;
    color: ColorFunct;
    x: Integer;
    y: Integer;
    w: Integer;
    h: Integer
  );

private

{$include Colors.impl}.
