module pasmac3;
{++}
{ abstract: routines for synax processing
{--}

{++}
{ history in pasmac.p
{--}

EXPORTS

    imports pasmac1 from pasmac1;
    imports pasmac2 from pasmac2;

function hash (str:ident) :tabsize;
procedure printtabentry(pnt:tabpnt);
procedure inserttab(newrec:tabpnt; isglobal:boolean; var isnew:boolean);
function membertab(n:ident; isglobal:boolean; var p:tabpnt):boolean;
function arithval(b:bndpnt):integer;
function intstring(int:integer):bndpnt;
function boolval(b:bndpnt):boolean;
function boolstring(b:boolean):bndpnt;
function arithfactor:integer;
function arithterm:integer;
function aexpr:integer;
function arithexpr(c:chunkpnt):integer;
function prmequ:boolean;
function prmls:boolean;
function bfactor(var b:boolean; var int:integer):boolorint;
function bterm(var b:boolean; var int:integer):boolorint;
function bsimple(var b:boolean; var int:integer):boolorint;
function arithbool(var bool:boolean;var int:integer):boolorint;
function bexpr:boolean;
function boolexpr(c:chunkpnt):boolean;

PRIVATE

function hash (* str:ident :tabsize *);

(* this is the hashing function for the table which contains
the tabrec records (information about macros and global mvars). 
the table has tabsize buckets, and the number of the appropriate
one is returned, given the macro or mvar name str *)

var
   h:integer;  (* hash value *)
   i:1..maxidlen; (*counter*)
begin
if dotrace then writeln(output,'hash');
h := 0;
for i := 1 to maxidlen do
   h := h + ord(str[i])*i;
if dotrace then writeln(output,'hash number:',h mod maxtab);
hash := h mod maxtab;
end;


procedure printtabentry(* pnt:tabpnt *);

(* this procedure is used by the tracing mechanism to print out all
information about a macro or mvar contained in a tabrec record pointed
to by parameter pnt *)

var i:integer; (*counter*)
begin
writeln(output,'table entry:');
writeln(output,pnt^.name);
case pnt^.macflavor of
   mvar: begin
         writeln(output,'mvar of type: ');
         case pnt^.vartype of
             mstring: begin
                      writeln(output,'string boundaries:',pnt^.strval^.first,',',
                              pnt^.strval^.last);
                      writeln(output,'mstring with value:');
                      writeinfo(pnt^.strval,nil,dummychunk,body,out);
                      end;
            mboolean: writeln(output,'boolean with value:',pnt^.boolval);
            minteger: writeln(output,'integer with value:',pnt^.intval);
            end;
          end;
   macro: begin
          writeln(output,'macro with number of parameters:',pnt^.numpar);
          { dzg - had to insert a recast: numpar is a parno, not an integer }
          for i := 1  to  recast(pnt^.numpar,integer) do
             begin
             case pnt^.partype[i] of
              mstring:writeln(output,'mstring parameter: ',pnt^.parname[i]);
              minteger:writeln(output,'minteger parameter: ',pnt^.parname[i]);
              mboolean:writeln(output,'mboolean parameter: ',pnt^.parname[i]);
              end;
             end;
          writeln(output,'macro boundaries:',pnt^.macbnd^.first,',',
                  pnt^.macbnd^.last);
          end;
   end;
writeln(output);
end;


procedure inserttab(* newrec:tabpnt; isglobal:boolean; var isnew:boolean *);

(* this procedure inserts a tabrec record pointed to by newrec into
one of two places. if isglobal is true, we are inserting a macro
or global mvar into the hash table mactable. otherwise, we are inserting
a local mvar into the list of local mvars localmvar.  both the list
of local mvars and a hash table bucket are structured as linked lists
ordered on the  name of the macro or mvar name. hence this is an ordered
insert. if an entry with the same name has already been inserted, the
var parameter isnew is set to false, and the new record is not inserted*)

var
   ptr,prevptr:tabpnt; (*ptrs used for tracing down the linked list*)
   n:ident;            (*the name of the macro or mvar*)
   i:tabsize;          (*the bucket number in the hash table*)
   done:boolean;       (*indicates if we can quit searching the linked list*)
 
begin
if dotrace then writeln(output,'inserttab');
isnew := true;
done := false;
 
n := newrec^.name;
if isglobal then (*find appropriate bucket to insert into*)
   begin
   i := hash(n);
   ptr := mactable[i];
   end
else (*must be inserting a local mvar*)
   ptr := localmvar;
prevptr := nil;
 
while (ptr <> nil) and not done do
   begin
   if n > ptr^.name then
      begin
      prevptr := ptr;
      ptr := ptr^.link;
      end
   else
      begin
      done := true;
      if n = ptr^.name then isnew := false;
      end;
   end;
 


(*inserttab continued*)

if isnew then
   begin
   if prevptr = nil then (*we are inserting at head of list*)
      begin
      if isglobal then
         begin
         newrec^.link := mactable[i];
         mactable[i] := newrec;
         end
      else
         begin
         newrec^.link := localmvar;
         localmvar := newrec;
         end;
      end
   else  (*we are inserting in middle or at end of list*)
      begin
      newrec^.link := ptr;
      prevptr^.link := newrec;
      end;
   end;
if dotrace then printtabentry(newrec);
end;


function membertab(* n:ident; isglobal:boolean; var p:tabpnt :boolean*);

(* this function tests a structure of tabrec records to see if one
exists with its name field equal to n. if there is such a record, the
function returns true and sets var parameter p to point to that record.
otherwise, it returns false. the structure searched depends on the parameter
isglobal. if isglobal is true, the macro-mvar hash table mactable is 
searched. otherwise, the current list of local macro variables localmvar
is searched. note that both localmvar and a hash table bucket are sorted
lists*)

var
   ptr:tabpnt;        (*a pointer for searching down a list*)
   done,found:boolean;(*indicate whether we may quit searching, and if the
                        desired matching record was found*)
begin
if dotrace then writeln(output,'membertab');
done := false;
found := false;
if isglobal then   (*get appropriate bucket*)
   ptr := mactable[hash(n)]
else   (*search local mvar list*)
   ptr := localmvar;
 
while (ptr <> nil) and not done do
   begin
   if n>ptr^.name then
      ptr := ptr^.link
   else
      begin
      done := true;
      if n = ptr^.name then
         begin
         found := true;
         p := ptr;
         end;
      end;
   end;
 
membertab := found;
end;


function arithval(* b:bndpnt:integer *);

(*returns the integer value of the integer string pointed to by b within workarea*)

var
  int,i,i1,i2:integer;
begin
if dotrace then writeln(output,'arithval');
i1 := b^.first;
i2 := b^.last;
int := 0;
for i := i1 to i2 do
   begin
   if (int+1)> (maxint div 10) then error(1);    (*overflow*)
   int := 10*int + (ord(workarea[i]) - ord('0'));
   end;
arithval := int;
end;

 

function intstring(* int:integer :bndpnt *);

(*this function converts the integer parameter int to a string and returns   
a pointer to that string which will exist within the array intexparea*)

var
   bnd:bndpnt; (*pointer to string boundaries*)
   i,j,k,st1,st2,fin:integer;
   c:char;
begin
if dotrace then writeln(output,'intstring');
st1 := intexpend;

if int < 0 then (*print out a '-' because int is negative*)
   begin
   intexparea[intexpend] := '-';
   intexpend := intexpend+1;
   int := int*(-1);
   end;

st2 := intexpend;

repeat   (*this loop will print out the integer string in reverse*)
   begin
   i := int mod 10;
   int := int div 10;
   intexparea[intexpend] := chr(ord('0')+i);
   intexpend := intexpend+1;
   end
until int=0;

fin := intexpend-1;
j := st2; (*we must now reverse this string.the boundaries of the*)
k := fin; (*string to be reversed is [st2,fin] *)

while j < k do  (*reverse the string*)
   begin
   c := intexparea[j];
   intexparea[j] := intexparea[k];
   intexparea[k] := c;
   j := j+1;
   k := k-1;
   end;

new(bnd);
bnd^.first := st1;
bnd^.last := fin;
intstring := bnd;
end;


(* * functions boolval and boolstring * *)

function boolval(* b:bndpnt):boolean *);
(*this function returns the boolean value of the string within workarea pointed
to by the parameter b*)
var
  bool:boolean;
begin
if dotrace then writeln(output,'boolval');
if workarea[b^.first] = 't' then
   bool := true
else
   bool := false;
boolval := bool;
end;
 
 
function boolstring(* b:boolean):bndpnt *);
(*this function converts a boolean value b to a string 'true' or 'false'. these
strings are globals within the program, pointed to by trueword and falseword*)
begin
if dotrace then writeln(output,'boolstring');
if b then boolstring := trueword
     else boolstring := falseword;
end;


{++}
{ notice that the next 4 functions:
{ arithfactor,arithterm,aexpr, and arithexpr 
{ all deal with the evaluation of arithmetic (i.e. integer) expressions
{ alone. the functions following these:
{ prmequ,prmls,bfactor,bterm,bsimple,arithbool,bexpr,boolexpr
{ all deal with the evaluation of boolean expressions.
{--}

function arithfactor (*:integer *);

(*read in an arithmetic 'factor', and return its integer value. by definition
from the syntax, such a factor may be an integer or  of form (<arithmetic expr>).
since the arithmetic expression evaluater may be called by the boolean expression
evaluator, such an arithmetic 'factor' may have already been read in by the
boolean evaluator. this is indicated by the global boolean forwardint.*)

var
  int:integer; (*value of factor*)
begin
if dotrace then writeln(output,'arithfactor');
if forwardint then (*newtok already has been read in by boolean evaluator*)
   forwardint := false
else
   gettoken(dummychunk,nowhere);
if newtoktype = lparentok then (*have factor of form ( <expr> ) *)
   begin
   int := aexpr;
   if newtoktype <> rparentok then
      error(2);
   end
else
if newtoktype = inttok then
   int := arithval(newtok)
else
   error(3);
arithfactor := int;
end;


function arithterm(* :integer *);

(* this function reads in a arithmetic term and returns its integer value.
by definition, such a term is an arithmetic factor or a list of factors
delimited by one of several operators: mod,div or *.   *)

var
  int:integer;   (* value of the term *)
  contin:boolean;(* indicates whether it is possible to read in more factors *)
begin
if dotrace then writeln(output,'arithterm');
contin := true;
int := arithfactor;
while contin do
   begin
   gettoken(dummychunk,nowhere);
   if newtoktype = modtok then 
      int := int mod arithfactor
   else
   if newtoktype = divtok then 
      int := int div arithfactor
   else
   if newtoktype=multtok then
      int := int * arithfactor
   else
      contin := false;
   end;
arithterm := int;
end;


function aexpr;

(* this function reads in an arithmetic expression (simple expression) and
returns its integer value. by definition, such an expression is a list of
terms delimited by one of the two operators + or -. *)

var
  int:integer;    (* value of the expression *)
  contin:boolean; (* indicates if it is possible to keep reading in more terms *)
begin
if dotrace then writeln(output,'aexpr');
contin := true;
int := arithterm;
while contin do
   begin
   if newtoktype=plustok then
      int := int + arithterm
   else
   if newtoktype=minustok then
      int := int - arithterm
   else
      contin := false;
   end;
if dotrace then writeln(output,' aexpr=',int);
aexpr := int;
end;

function arithexpr(* c:chunkpnt :integer *);

(* this is the function called when a string of characters within a chunk-list
and pointed to by c, is to be evaluated as an integer expression. the result
of such an evaluation is returned by the function.
   the gettoken procedure will now read from c, and hence c must be assigned
to globalchunk. we must also remember where we were reading from before (which
is, by the way, always either a file or the body array) so that we may reinstate
this knowledge upon exit from the function. we then read and evaluate the
string by calling aexpr. if the string has not been exhausted upon return, the
string must not have been in correct syntactic form .
   note that this function is not called by the boolean expression evaluator.
instead, when an arithmetic expression occurs within a boolean expression, the
function aexpr is called directly *)

var
  int:integer;      (* the value of the expression *)
  rdplace:readplace;(* remembers previous reading place *)
begin
if dotrace then writeln(output,'arithexpr');
rdplace := currplace;
currplace := charray;  (* these next three statements insure correct reading from *)
globalchunk := c;      (* the globalchunk array *)
currchunkpos := 1;
havelookahead := false;
int := aexpr;
if havetok then error(4);
currplace := rdplace;
if dotrace then writeln(output,' arithexpr=',int);
arithexpr := int;
end;


function prmequ(* :boolean *);

(* this function processes an mequ statement of form mequ(<mstring>,<mstring>)
and returns  true or false depending on the equality of the two <mstring>'s.

note the following: and mequ statement is not 'expanded' (i.e. changed to true
or false) until evaluation of a boolean expression. however, the two <mstring>'s
are expanded when the boolean expression is first expanded. hence, the two
parameters are simply read in, as is, by this function, rather than using the
function readparam which is used by macro calls. this is because readparam expands
the parameters it reads. the same process of blind reading is done by the
next function, prmls. 
 
note also that this 'blind reading' implies that the counting of balanced
round or square brackets is not done. hence, insignificant commas should not
occur after expansion. *)

var
  i:integer;    (*a counter*)
  par1,par2:chunkpnt; (*pointers to the two parameters*)
  done,isequ:boolean; (*indicators of the finish and result of the comparison*)
begin
if dotrace then writeln(output,'prmequ');
par1 := nil;
par2 := nil;
isequ := true;
done := false;
i := 1;
gettoken(dummychunk,nowhere);
if newtoktype <> lparentok then error(5);

(*read in the two parameters *)
gettoken(par1,chk);
while newtoktype <> commatok do
   begin
   if haveblanks then writeinfo(blanks,nil,par1,work,chk);
   writeinfo(newtok,nil,par1,work,chk);
   gettoken(par1,chk);
   end;
if haveblanks then writeinfo(blanks,nil,par1,work,chk);
gettoken(par2,chk);
while newtoktype <> rparentok do
   begin
   if haveblanks then writeinfo(blanks,nil,par2,work,chk);
   writeinfo(newtok,nil,par2,work,chk);
   gettoken(par2,chk);
   end;
if haveblanks then writeinfo(blanks,nil,par2,work,chk);

if newtoktype <> rparentok then error(6);



(*prmequ continued*)

(*decide whether the two parameters are the same string*)
while (not done) and isequ do
   begin
   if par1^.arr[i] <> par2^.arr[i] then
      isequ := false;
   if (i=par1^.pos) and (par1^.nxt = nil) then
      begin
      if (i = par2^.pos) and (par2^.nxt = nil) then 
         done := true
      else isequ := false;
      end
   else
   if (i=par2^.pos) and (par2^.nxt = nil) then
       isequ := false
   else
   if i=par1^.pos then
      begin
      par1 := par1^.nxt;
      par2 := par2^.nxt;
      i := 0;
      end;
   i := i+1;
   end;
prmequ := isequ;
end;


function prmls(* :boolean *);

(* this function does the same things as prmls except that the boolean
value returned depends on whether the first of the two string parameters is
less than the second*)

var
  i:integer;   (*a counter*)
  par1,par2:chunkpnt; (*pointers to the two parameters*)
  done,isless:boolean;(*indicators of the finish and result of the comparison*)
begin
if dotrace then writeln(output,'prmls');
par1 := nil;
par2 := nil;
isless:= true;
done := false;
i := 1;
gettoken(dummychunk,nowhere);
if newtoktype <> lparentok then error(5);

(*read in the two parameters*)
gettoken(par1,chk);
while newtoktype <> commatok do
   begin
   if haveblanks then writeinfo(blanks,nil,par1,work,chk);
   writeinfo(newtok,nil,par1,work,chk);
   gettoken(par1,chk);
   end;
if haveblanks then writeinfo(blanks,nil,par1,work,chk);
gettoken(par2,chk);
while newtoktype <> rparentok do
   begin
   if haveblanks then writeinfo(blanks,nil,par2,work,chk);
   writeinfo(newtok,nil,par2,work,chk);
   gettoken(par2,chk);
   end;
if haveblanks then writeinfo(blanks,nil,par2,work,chk);

if newtoktype <> rparentok then error(6);



(*prmls continued*)

(*compare the two strings*)
while (not done) and isless do
   begin
   if par1^.arr[i] <> par2^.arr[i] then
      begin
      if par1^.arr[i] < par2^.arr[i] then
         done := true
      else
         isless := false;
      end;
   if (i=par2^.pos) and (par2^.nxt = nil) then
      begin
      isless := false;
      done := true;
      end
   else
   if (i=par1^.pos) and (par1^.nxt = nil) then
       done := true  
   else
   if i=par1^.pos then
      begin
      par1 := par1^.nxt;
      par2 := par2^.nxt;
      i := 0;
      end;
   i := i+1;
   end;
prmls := isless;
end;


function bfactor(* var b:boolean; var int:integer :boolorint *);

(* this function returns a boolean factor. such a factor may be either of
type integer or boolean. in either case, the appropriate var parameter (b or int)
is set to return the integer or boolean value, and the function returns an
indicator of which type (booltype or inttype) was found.
   a boolean factor may be: an integer expression, a boolean or integer 
expression enclosed in parentheses, a boolean token (true or false), the 
negation of a boolean factor, or the result of one of the operators mequ or mls.*)

var
  restype:boolorint; (* the type of the boolean factor*)
  btemp:boolean;  (*temporary variable*)
begin
gettoken(dummychunk,nowhere);
if newtoktype = lparentok then
   begin
   restype := arithbool(b,int);
   if newtoktype <> rparentok then error(2);
   end
else
if newtoktype = inttok then
   begin
   forwardint := true;
   int := aexpr;
   restype := inttype;
   end
else
if newtoktype = booltok then
   begin
   b := boolval(newtok);
   restype := booltype;
   end
else
if newtoktype = nottok then
   begin
   if bfactor(btemp,int) <> booltype then error(7);
   b := not btemp;
   restype := booltype;
   end
else
if newtoktype = mequtok then
   begin
   b := prmequ;
   restype := booltype;
   end
else
if newtoktype = mlstok then
   begin
   b := prmls;
   restype := booltype;
   end
else
   error(8);
bfactor := restype;
end;


function bterm(* var b:boolean; var int:integer :boolorint *);

(* this function returns a boolean term. such a term may be of type integer
or boolean. in either case, the boolean or integer value of the term is
assigned to  the appropriate var parameter(b or int). the function then
returns an indication of which of the two types was returned : booltype or
inttype. 
   a boolean term is defined to be a boolean factor or a list of boolean
factors, each of type boolean, and delimited by the operator and. *)

var
  restype:boolorint; (* the type of the boolean term *)
  btemp,contin:boolean;(* btemp is a temporary boolean variable, and contin
                          indicates whether we should keep looking for more
                          boolean factors *)
begin
contin := true;
if bfactor(btemp,int)=booltype then
   begin
   b := btemp;
   while contin do
      begin
      gettoken(dummychunk,nowhere);
      if newtoktype = andtok then
         begin
         if bfactor(btemp,int)<>booltype then error(9);
         b := b and btemp;
         end
      else
         contin := false;
      end;
   restype := booltype;
   end
else
   restype := inttype;
bterm := restype;
end;


function bsimple(* var b:boolean; var int:integer :boolorint *);

(* this function returns a boolean simple expression. such an expression may
be of type integer or boolean. in either case, the boolean or integer value 
of the term is assigned to  the appropriate var parameter(b or int). the 
function then returns an indication of which of the two types was returned : 
booltype or inttype. 
   a boolean simple expression may be a boolean term or a list of boolean 
terms , each of type boolean, delimited by the operator or. *)

var
  restype:boolorint;  (* the type of the boolean simple expression*)
  btemp,contin:boolean;(* btemp is a temporary variable. contin indicates whether
                          we should keep looking for more boolean terms*)
begin
contin := true;
if bterm(btemp,int)=booltype then
   begin
   b := btemp;
   while contin do
      begin
      if newtoktype = ortok then
         begin
         if bterm(btemp,int)<>booltype then error(10);
         b := b or btemp;
         end
      else
         contin := false;
      end;
   restype := booltype;
   end
else
   restype := inttype;
bsimple := restype;
end;


function arithbool;

(* this function returns one of two things. it may return the value of an
arithmetic expression in the var parameter int (in which case it returns
inttype). this may only occur when bfactor calls arithbool upon seeing
a left parenthesis. it is possible in this case that there is an arithmetic
expression enclosed by the parenthesis, in which case the corresponding
boolean factor will be of type integer.
   usually, however, this function returns a boolean value, the value
of a boolean expression : ie. a boolean simple expression of type boolean, 
or the result of comparing two boolean simple expressions separated by
a relational operator. in this case, the function will return  booltype.*)

var
  btemp:boolean; (* a temporary boolean variable*)
  itemp:integer; (* a temporaray integer variable *)
  restype:boolorint; (* the type of the value returned *)
  reltype:toktype;  (* the type of relational operator seen *)
begin
restype := bsimple(bool,int);
if newtoktype in reloperators then
   begin
   reltype := newtoktype;
   if bsimple(btemp,itemp)<>restype then error(11);
   if restype = booltype then
      begin
      case reltype of
         equaltok: bool := (bool = btemp);
         neqtok  : bool := (bool <> btemp);
         lseqtok : bool := (bool <= btemp);
         greqtok : bool := (bool >= btemp);
         lesstok : bool := (bool < btemp);
         grttok  : bool := (bool > btemp)
         end;
      end
   else
      begin
      if dotrace then writeln(output,'int = ',int,'  itemp= ',itemp);
      case reltype of
         equaltok: bool := (int = itemp);
         neqtok  : bool := (int <> itemp);
         lseqtok : bool := (int <= itemp);
         greqtok : bool := (int >= itemp);
         lesstok : bool := (int < itemp);
         grttok  : bool := (int > itemp)
         end;
      end;
   restype := booltype;
   end;
if dotrace then writeln(output,'arithbool=',bool);
arithbool := restype;
end;


function bexpr(* :boolean *);

(* this function returns the boolean value of a boolean expression *)

var
   bool:boolean; (* these are variable to be sent to arithbool as var *)
   int:integer;  (* parameters. arithbool should, in this case, return a boolean*)
begin
if arithbool(bool,int)=inttype then error(12);
bexpr := bool;
end;

function boolexpr(* c:chunkpnt :boolean *);

(* this is the function called when a string of characters within a chunk-list
and pointed to by c, is to be evaluated as a boolean  expression. the result
of such an evaluation is returned by the function.
   the gettoken procedure will now read from c, and hence c must be assigned
to globalchunk. we must also remember where we were reading from before (which
is, by the way, always either a file or the body array) so that we may reinstate
this knowledge upon exit from the function. we then read and evaluate the
string by calling bexpr. if the string has not been exhausted upon return, the
string must not have been in correct syntactic form . *)

var
  bool:boolean;   (* the boolean value found *)
  rdplace:readplace; (* where we were reading from before *)
begin
if dotrace then writeln(output,'boolexpr');
rdplace := currplace;
currplace := charray;  (* prepare to read from globalchunk *)

globalchunk := c;
currchunkpos := 1;
havelookahead := false;
bool := bexpr;
if havetok then error(13);
currplace := rdplace;
if dotrace then writeln(output,'boolexpr= ',bool);
boolexpr := bool;
end.
